<?php 

$res=0;
if (! $res && file_exists("../main.inc.php")) $res=@include("../main.inc.php");       // For root directory
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php"); // For "custom" 

global $conf;
if (!$conf->releveclient->enabled) {
  accessforbidden();
}
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture-rec.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/modules/facture/modules_facture.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/discount.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/invoice.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/accountancy/class/accountingjournal.class.php';


dol_include_once("/releveclient/class/releveclient.class.php");

$form = new Form($db);
$userstatic = new User($db);
$releveclient = new releveclient($db);
$object    = new Facture($db);
$client    = new Societe($db);
$paiement = new Paiement($db);
$extrafields = new ExtraFields($db);


$langs->loadLangs(array('bills', 'companies', 'compta', 'products', 'banks', 'main', 'withdrawals'));
$modname = $langs->trans("syntheseclient");

$facid = (GETPOST('id', 'int') ?GETPOST('id', 'int') : GETPOST('facid', 'int')); // For backward compatibility
$ref = GETPOST('ref', 'alpha');
$fk_reglement = GETPOST('fk_reglement', 'int');
$action = GETPOST('action', 'alpha');
$socid=GETPOST('socid');

$srch_qty=GETPOST('srch_qty');


$debut = dol_mktime(0, 0, 0, GETPOST('debutmonth'), GETPOST('debutday'), GETPOST('debutyear'));
$fin = dol_mktime(0, 0, 0, GETPOST('finmonth'), GETPOST('finday'), GETPOST('finyear'));
$debut = $debut ? $db->idate($debut) : '';
$fin = $fin ? $db->idate($fin) : '';


if(empty($debut) && GETPOST('debut'))
    $debut=GETPOST('debut');

if(empty($fin) && GETPOST('fin'))
    $fin=GETPOST('fin');

   
$object = new Account($db);
$fk_account = GETPOST("fk_account");
$object->fetch($fk_account); 

$srch_datec = dol_mktime(0, 0, 0, GETPOST('srch_datecmonth'), GETPOST('srch_datecday'), GETPOST('srch_datecyear'));
$limit = GETPOST('limit', 'int') ?GETPOST('limit', 'int') : $conf->liste_limit;
$sortfield = GETPOST("sortfield", 'alpha') ? GETPOST("sortfield", 'alpha') : 'f.datef';
$sortorder = GETPOST("sortorder", 'alpha') ? GETPOST("sortorder", 'alpha') : 'ASC';
$page = GETPOSTISSET('pageplusone') ? (GETPOST('pageplusone') - 1) : GETPOST("page", 'int');
if (empty($page) || $page == -1 || !empty($search_btn) || !empty($search_remove_btn) || (empty($toselect) && $massaction === '0')) { $page = 0; }     

$offset = $limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$filter='';

if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter") || $page < 0) {
    $filter = "";
    $offset = 0;
    $filter = "";
}
if($socid && $debut && $fin)
    $solde = $releveclient->SoldeDebiteur($socid,$debut,$fin);

$i=0;

$TData = array();
$sql = "SELECT s.nom, s.rowid as socid, f.ref, f.total_ttc, f.datef as df,";
$sql .= " f.paye as paye, f.fk_statut as statut, f.rowid as facid";
$sql .= " FROM ".MAIN_DB_PREFIX."societe as s, ".MAIN_DB_PREFIX."facture as f";
$sql .= " WHERE f.fk_soc = s.rowid AND s.rowid = ".$socid;
$sql .= " AND f.entity IN (".getEntity('invoice').") ";
// $sql .= " ORDER BY f.datef ASC, f.rowid ASC";

if($debut && $fin) $sql .= " AND (f.datef BETWEEN '".$debut."' AND '".$fin."')";
elseif($debut && empty($fin)) $sql .= " AND f.datef>= '".$debut."'";
elseif($fin && empty($debut)) $sql .= " AND f.datef<= '".$fin."'";
        
$sql .= $db->order($sortfield, $sortorder);

$arrpayement = [];
$resql = $db->query($sql);
if ($resql)
{
    $num = $db->num_rows($resql);

    // Boucle sur chaque facture
    for ($i = 0; $i < $num; $i++)
    {
        $objf = $db->fetch_object($resql);

        $fac = new Facture($db);
        $ret = $fac->fetch($objf->facid);


        $fac->fetch_lines();
        $lignes = $fac->lines;
        $dtlignes=[];
        if(is_array($lignes) && count($lignes)){
            if($lignes && count($lignes)>0 ){
                foreach ($lignes as $key => $ligne) {
                    if($ligne->fk_product){
                        $Prod=new Product($db);
                        $Prod->fetch($ligne->fk_product);
                        $label=$Prod->getNomUrl(1);
                    }else $label=$ligne->desc;

                    $dtlignes[$objf->rowid] = ['label' => $label, 'qty'=>$ligne->qty, 'amount'=>$ligne->total_ttc];
                }
            }
        }


        // Paiements
        $sql = "SELECT pf.rowid, p.datep as dp,p.rowid as id_p, pf.amount, p.statut";
        $sql .= " FROM  ".MAIN_DB_PREFIX."paiement as p,";
        $sql .= " ".MAIN_DB_PREFIX."paiement_facture as pf";
        $sql .= " WHERE pf.fk_paiement = p.rowid";
        $sql .= " AND p.entity = ".$conf->entity;
        $sql .= " AND pf.fk_facture = ".$fac->id;
        $sql .= " AND p.entity IN (".getEntity('invoice').")";

        if($debut && $fin) $sql .= " AND (p.datep BETWEEN '".$debut."' AND '".$fin."')";
        elseif($debut && empty($fin)) $sql .= " AND p.datep>= '".$debut."'";
        elseif($fin && empty($debut)) $sql .= " AND p.datep<= '".$fin."'";

        $sql .= " ORDER BY p.datep ASC, p.rowid ASC";

        $resqlp = $db->query($sql);
        if ($resqlp)
        {
            $nump = $db->num_rows($resqlp);
            $j = 0;
            if($nump>0){

                while ($j < $nump)
                {
                    $objp = $db->fetch_object($resqlp);

                    $paymentstatic = new Paiement($db);
                    $paymentstatic->fetch($objp->rowid);
                    $values = array(
                        'fk_paiement' => $objp->rowid,
                        'fk_paie' => $objp->id_p,
                        'fk_facture' => $objf->facid,
                        'date' => $db->jdate($objp->dp),
                        'datefieldforsort' => $db->jdate($objp->dp).'-'.$fac->ref,
                        'amount' => $objp->amount,

                    );

                    $TData[$objf->facid][] = $values;

                    $j++;
                }
            }
            else{
                $values = array(
                    'fk_paiement' => '',
                    'fk_paie' => '',
                    'fk_facture' => $objf->facid,
                    'date' => $db->jdate($objf->df),
                    'datefieldforsort' => $db->jdate($objp->df).'-'.$fac->ref,
                    'amount' => $objf->total_ttc,

                );

                $TData[$objf->facid][] = $values;
            }

            $db->free($resqlp);
        }
    }
}
$balance = $solde;


if ($limit > 0 && $limit != $conf->liste_limit) $param .= '&limit='.urlencode($limit);
if ($socid) $param .= '&socid='.urlencode($socid);
if ($debut) $param .= '&debut='.urlencode($debut);
if ($fin) $param .= '&fin='.urlencode($fin);


$nbtotalofrecords = '';
if (empty($conf->global->MAIN_DISABLE_FULL_SCANLIST))
{
    $result = $db->query($sql);
    $nbtotalofrecords = $db->num_rows($result);
    if (($page * $limit) > $nbtotalofrecords)   // if total resultset is smaller then paging size (filtering), goto and load page 0
    {
        $page = 0;
        $offset = 0;
    }
}

if(empty($action) || $action == 'generer')
    $sql .= $db->plimit($limit + 1, $offset);

$resql = $db->query($sql);
$i=0;




if (!$user->rights->releveclient->lire || !$user->rights->releveclient->export) {
    accessforbidden();
}


/*-------------PDF-----------------*/
if ($action == "pdf" && GETPOST('actionpdf')) {
    global $conf, $langs, $mysoc;
    
    $Client = new Societe($db);

    require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
    require_once dol_buildpath('/releveclient/pdf/pdf.lib.php');
    $pdf->SetMargins(7, 2, 7, false);
    $pdf->SetFooterMargin(10);
    $pdf->setPrintFooter(true);
    $pdf->SetAutoPageBreak(TRUE,10);

    $height=$pdf->getPageHeight();

    $pdf->SetFont('helvetica', '', 9, '', true);
    $pdf->AddPage('L');
    $margint = $pdf->getMargins()['top'];
    $marginb = $pdf->getMargins()['bottom'];
    $marginl = $pdf->getMargins()['left'];
    $object->fetch($id);
    $item = $object;

    $pdf->SetTextColor(0, 0, 60);

    $default_font_size = 9;
    $pdf->SetFont('', 'B', $default_font_size);
    $posy   = $margint;
    $posx   = $pdf->page_largeur-$pdf->getMargins()['right']-100;

    $pdf->SetXY($marginl, $posy);

    $pdf->SetXY($marginl, $posy);

    $heightimg = 15;
    if ($mysoc && $mysoc->logo)
    {
        $logodir = $conf->mycompany->dir_output;
        if (empty($conf->global->MAIN_PDF_USE_LARGE_LOGO))
        {
            $logo = $logodir.'/logos/thumbs/'.$mysoc->logo_small;
        }
        else {
            $logo = $logodir.'/logos/'.$mysoc->logo;
        }
        
        if (is_readable($logo))
        {
            $height = pdf_getHeightForLogo($logo);
            $pdf->Image($logo, $marginl, $posy, 0, $heightimg); // width=0 (auto)
        }
        else
        {
            $pdf->SetTextColor(200, 0, 0);
            $pdf->SetFont('', 'B', $default_font_size - 2);
            $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorLogoFileNotFound", $logo), 0, 'L');
            $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorGoToGlobalSetup"), 0, 'L');
        }
    }
    else
    {
        $heightimg = 8;
        $text = $mysoc->name;
        $pdf->MultiCell(100, 4, $langs->convToOutputCharset($text), 0, 'L');
    }

    $posy = $margint + $heightimg + 2;

    $pdf->SetTextColor(0, 0, 60);
    $currentwate    = $conf->global->PAYROLLMOD_WATERMARK_IMG;
    if($currentwate){
        $bMargin = $pdf->getBreakMargin();
        $auto_page_break = $pdf->getAutoPageBreak();
        $pdf->SetAutoPageBreak(false, 0);
        $img_file = $conf->mycompany->dir_output.'/watermark/'.$currentwate;
        $pdf->SetAlpha(0.1);
        $pdf->Image($img_file, 35, 100, 140, '', '', '', '', false, 300, '', false, false, 0);
        $pdf->SetAlpha(1);
        $pdf->SetAutoPageBreak(true, $bMargin);
        $pdf->setPageMark();
    }

    $pdf->SetFont('', '', $default_font_size);

    if($socid)
        $Client->fetch($socid);


    require_once dol_buildpath('/releveclient/pdf/pdf.lib.php');
    require_once dol_buildpath('/releveclient/pdf/synthese_pdf.php');
    $pdf->writeHTML($html, true, false, true, false, '');
    ob_start();
    $namemod=$langs->trans('releveclient');
    $pdf->Output($namemod.'.pdf', 'I');
    die();
}


$morejs  = array();
llxHeader(array(), $modname,'','','','',$morejs,0,0);

print load_fiche_titre($modname);


print '<div id="stclient" class="div-table-responsive">';
    print '<form  method="POST" action="'.$_SERVER['PHP_SELF'].'" >';

        print '<input type="hidden" name="token" value="'.newToken().'">';
        print '<table class="noborder">';
            print '<input type="hidden" name="action" value="generer">';
            print '<tr>';
                print '<td>'.$langs->trans('Period');
                    print ' &nbsp;&nbsp;&nbsp;&nbsp;'.$langs->trans("From").' '.$form->selectDate($debut, 'debut', 0, 0, 1, '', 1, 1);
                print '</td>';
                print '<td colspan="2">';
                    print $langs->trans("To").' '.$form->selectDate($fin, 'fin', 0, 0, 1, '', 1, 1);
                print '</td>';
            print '</tr>'; 
            print '<tr>';
                print '<td>'.$langs->trans('Customer');
                    print $form->select_company($socid, 'socid', '((s.client = 1 OR s.client = 3) AND s.status=1)', 'SelectThirdParty', 0, 0, null, 0, 'minwidth300');

                    // Option to reload page to retrieve customer informations. Note, this clear other input
                    if (!empty($conf->global->RELOAD_PAGE_ON_CUSTOMER_CHANGE))
                    {
                        print '<script type="text/javascript">
                            $(document).ready(function() {
                                $("#socid").change(function() {
                                    var socid = $(this).val();
                                    var fac_rec = $(\'#fac_rec\').val();
                                    // reload page
                                    window.location.href = "'.$_SERVER["PHP_SELF"].'?action=create&socid="+socid+"&fac_rec="+fac_rec;
                                });
                            });
                        </script>';
                    }
                    if (!GETPOST('fac_rec', 'int')) 
                        print ' <a href="'.DOL_URL_ROOT.'/societe/card.php?action=create&client=3&fournisseur=0&backtopage='.urlencode($_SERVER["PHP_SELF"].'?action=create').'"><span class="fa fa-plus-circle valignmiddle paddingleft" title="'.$langs->trans("AddThirdParty").'"></span></a>';
                print '</td><td>';
                    if($socid && $debut && $fin){
                        $datesd=date('d/m/Y', strtotime($debut.' - 1 DAY'));
                        $text = $langs->trans("soldedebitair").' '.$datesd.':  '.price($solde, '', $langs, 0, -1, -1, $conf->currency);
                        print $text;
                    }
                print '</td><td>';
                    print '<a href="'.dol_buildpath('/releveclient/releve.php',2).'" class="butAction" style="padding-top: 0.4em; float:right">'.$langs->trans("Reset").'</a>';
                    print '<input style="margin-top:0px; float:right" type="submit" value="'.$langs->trans("generetat").'" name="export" class="button" />';

                print '</td>';
                print '</td>';
            print '</tr>'."\n";
        print '</table>';
    print '</form>';
        
    print '<br>';

    $object = new Facture($db);
    $dt_extrafield = $extrafields->fetch_name_optionals_label($object->table_element);
    $label=$extrafields->attributes[$object->table_element]['label'];

    if(dolibarr_get_const($db, strtoupper('releveclient_fields'),$conf->entity)){
        $data_ef = dolibarr_get_const($db, strtoupper('releveclient_fields'),$conf->entity);
        $data_ef = explode(',', $data_ef);
    }

    print '<form  method="POST" action="'.$_SERVER['PHP_SELF'].'">';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        print '<input type="hidden" name="fk_account" value="'.$fk_account.'">';
        print '<input type="hidden" name="socid" value="'.$socid.'">';
        print '<input type="hidden" name="debut" value="'.$debut.'">';
        print '<input type="hidden" name="fin" value="'.$fin.'">';
        print '<input name="pagem" type="hidden" value="'.$page.'">';
        print '<input name="offsetm" type="hidden" value="'.$offset.'">';
        print '<input name="limitm" type="hidden" value="'.$limit.'">';
        print '<input name="filterm" type="hidden" value="'.$filter.'">';
        print '<input name="action" type="hidden" value="pdf">';


        $massactionbutton = '<input name="actionpdf" type="submit" id="btn_pdf" formtarget="_blank" class="button" value="'.$langs->trans('generpdf').'" >';

        print_barre_liste('', $page, $_SERVER["PHP_SELF"], $param, $sortfield, $sortorder, '', $num, $nbtotalofrecords, '', 0, $massactionbutton, '', $limit, 0, 0, 1);

        print '<table class="noborder" id="releveclient">';

            print '<tr class="liste_titre_filter">';
                print_liste_field_titre($langs->trans("Product"), $_SERVER["PHP_SELF"], "d.fk_product", '', $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("Qty"), $_SERVER["PHP_SELF"], "fd.qty", '', $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("Amount"), $_SERVER["PHP_SELF"], "d.total_ttc", "", $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("DetailsVersement"), $_SERVER["PHP_SELF"], "", "", $param, 'align="center"', $sortfield, $sortorder);
                if($data_ef && count($data_ef)>0){
                    $nbef = count($data_ef); 
                    foreach ($data_ef as $valextra) {
                        if($label && count($label)>0 && array_key_exists($valextra,$label)){
                            print '<td align="center">'.$label[$valextra].'</td>';
                            $clsp++;
                            // $td_filter = '<td align="center" colspan="'.$nbext.'"></td>';
                        }
                    }
                }
                print_liste_field_titre($langs->trans("Amount"), $_SERVER["PHP_SELF"], "", "", $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("Solde"), $_SERVER["PHP_SELF"], "", "", $param, 'align="center"', $sortfield, $sortorder);
            print '</tr>';

            
            $var = 1;
            $classes =[0=>'trnocolor', 1=>'trcolor'];
            $total=$totalpay=$totalqty=0;
            $datapay=[];
            $datafact=[];
            // print_r($TData);die();
            if($TData && count($TData)>0 && $socid){
                // foreach ($data2 as $key => $data) {
                //     $colspan=$rowspan='';
                //     $var = !$var;

                    
                //     $j=0;
                //     foreach ($data as $value) {
                //         if(!empty($value['fk_paie']))
                //             $dt_2[$value['fk_paie']]=$value;
                //         else $dt_2['fact_'.$value['fk_facture']]=$value;
                //         $j++;
                //     }
                //     $facture = new Facture($db);
                //     $facture->fetch($key);
                //     $facture->fetch_lines();
                //     $lignes = $facture->lines;
                    

                //     if(is_array($lignes) && count($lignes)){
                //         if($lignes && count($lignes)>0 ){
                //             foreach ($lignes as $key1 => $ligne) {
                //                 if($ligne->fk_product){
                //                     $prodid=$ligne->fk_product;
                //                     $Prod=new Product($db);
                //                     $Prod->fetch($ligne->fk_product);
                //                     $label=$Prod->getNomUrl(1);
                //                 }else {
                //                     $label=$ligne->desc;
                //                     $prodid=$label;
                //                 }

                //                 $dtlignes[$key] = ['label' => $label, 'qty'=>$ligne->qty, 'amount'=>$ligne->subprice];

                //                 // $remix = $remixcredit+$remixdepot;

                //                 $amount_ttc = $ligne->total_ttc;
                //                 $dt[$prodid]['qty'] += $ligne->qty; 
                //                 $dt[$prodid]['amount'] += $amount_ttc; 

                //                 $total += $amount_ttc;
                               

                //             }
                //         }
                //     }


                // }
                // $j=0;
                // foreach ($dt as $key => $value) {
                //     print '<tr>';
                //         if (is_string($key)) {
                //             print '<td align="left">'.$key.'</td>';
                //         }else{
                //             $Prod=new Product($db);
                //             $Prod->fetch($key);
                //             print '<td align="left">'.$Prod->getNomUrl(1).'</td>';
                //         }
                //         print '<td align="center">'.$value['qty'].'</td>';
                //         print '<td align="right">'.price($value['amount'], 0, $langs, 1, $aftercomma).'</td>';
                //         if($j == 0){
                //             print '<td rowspan="'.count($dt).'">';
                                
                //                 foreach ($dt_2 as $id_p => $pays) {
                //                     print '<div>';
                //                         $fact = new Facture($db);
                //                         $fact->fetch($pays['fk_facture']);
                //                         print $fact->getNomUrl(1);
                //                         if(!is_string($id_p)){
                //                             $payt = new Paiement($db);
                //                             $payt->fetch($id_p);
                //                             print ' - '.$payt->getNomUrl(1);
                //                             if($payt->num_payment)
                //                             print ' - '.$payt->num_payment;
                //                         }
                //                     print '</div>';
                //                     print '<br>';
                //                 }
                //             print '</td>';
                //             print '<td align="right" rowspan="'.count($dt).'">';
                //                 $tantremis=[];
                //                 foreach ($dt_2 as $id_p => $pays) {
                //                     print '<div>';
                //                         $montantp=0;

                //                         if($pays['fk_paie']){
                //                             $payt = new Paiement($db);
                //                             $payt->fetch($id_p);
                //                             $montantp = $pays['amount'];
                //                             $totalpay+=$montantp;

                //                             $invoic = new Facture($db);
                //                             $invoic->fetch($pays['fk_facture']);
                //                             $remixcredit = $invoic->getSumCreditNotesUsed();
                //                             // $remixdepot=$invoic->getSumDepositsUsed();
                //                             $remix = $remixcredit+$remixdepot;
                //                             if($remix && !in_array($pays['fk_facture'], $tantremis)){

                //                                 $montantp += $remix;
                //                                 $totalpay += $remix;
                //                             }
                                           
                //                             if($remix) $tantremis[]=$pays['fk_facture'];


                //                         }else{
                //                             $invoic = new Facture($db);
                //                             $invoic->fetch($pays['fk_facture']);
                //                             $remixcredit = $invoic->getSumCreditNotesUsed();
                //                             $remixdepot=$invoic->getSumDepositsUsed();
                //                             $remix = $remixcredit+$remixdepot;
                //                             $montantp = $remix;
                //                             if($remix) $totalpay+=$remix;
                //                         }
                //                         if($montantp)
                //                         print price($montantp, 0, $langs, 1, $aftercomma);
                //                     print '</div>';
                //                     print '<br>';
                //                 }
                //             print '</td>';

                //         }
                       
                //         print '<td class="width750"></td>';

                //     print '</tr>';
                //     $j++;
                // }


                foreach ($TData as $key => $data) {
                    if($key){
                        $objfac = new Facture($db);
                        $objfac->fetch($key);
                        $objfac->fetch_lines();
                        $lignes = $objfac->lines;
                        // $remixcredit = $objfac->getSumCreditNotesUsed();
                        // $remixdepot=$objfac->getSumDepositsUsed();
                        // $remix = $remixcredit+$remixdepot;

                        // if($remix) {
                        //     $totalpay += $remix;
                        // }
                    }
                  
                    if($lignes){
                        foreach ($lignes as $id_l => $ligne) {
                            $total+=$ligne->total_ttc;
                            
                            $amountp = 0;
                            // if($remix)
                            //     $amountp += $remix;


                            print '<tr>';
                                print '<td class="width25p">';
                                    if($ligne->fk_product){
                                        $Product = new Product($db);
                                        $Product->fetch($ligne->fk_product);
                                        print $Product->getNomUrl(1).' - '.$ligne->libelle;
                                    }else
                                        print $ligne->desc;
                                print '</td>';

                                print '<td class="width75" align="right">'.$ligne->qty.'</td>';
                                print '<td class="width100" align="right">'.price($ligne->total_ttc, 0, $langs, 1, $aftercomma).'</td>';
                                print '<td>'.$objfac->getNomUrl(1);

                                    if($data && count($data)>0){
                                        foreach ($data as $k => $value) {

                                            if($value['fk_paie']){
                                                $Paiement = new Paiement($db);
                                                $Paiement->fetch($value['fk_paie']);
                                                print '<div style="padding: 4px 0px;">';
                                                    print ' - '.$Paiement->getNomUrl(1);
                                                    if($Paiement->num_paiement) print ' - '.$Paiement->num_paiement;
                                                    $labeltype = $langs->trans("PaymentType".$Paiement->type_code) != ("PaymentType".$Paiement->type_code) ? $langs->trans("PaymentType".$Paiement->type_code) : $Paiement->type_label;
                                                    if($labeltype) print ' - '.$labeltype;
                                                print '</div>';
                                            }
                                        }
                                    }

                                print '</td>';

                                if($objfac->id){
                                    if($data_ef && count($data_ef)>0){
                                        foreach ($data_ef as $valextra) {

                                            if($label && count($label)>0 && array_key_exists($valextra,$label)){
                                                print '<td '.$rowspan.' align="center">';
                                                    if($objfac->id){
                                                        $msql = 'SELECT eff.*, ef.label as eflbl, ef.name as efname FROM '.MAIN_DB_PREFIX.'extrafields as ef, '.MAIN_DB_PREFIX.$objfac->table_element.'_extrafields as eff WHERE ef.elementtype = "'.$objfac->table_element.'" AND eff.fk_object ='.$objfac->id.' AND ef.list=1';
                                                                    // print_r($msql);
                                                        $mresql = $db->query($msql);
                                                        if($mresql){
                                                            while ($obj = $db->fetch_object($mresql)) {

                                                                $efname = $obj->efname;
                                                                if( $obj->eflbl && $efname==$valextra){
                                                                    print $extrafields->showOutputField($valextra, $obj->$efname, '', $objfac->table_element);
                                                                }
                                                            }
                                                        }
                                                    }
                                                print '</td>';
                                            }

                                        }
                                    }
                                }

                                print '<td class="width100" align="right">';
                                        if($data && count($data)>0){
                                            foreach ($data as $k => $value) {

                                                if($value['fk_paiement']){
                                                    $amountp += $value['amount'];
                                                    if(!in_array($value['fk_paiement'], $datapay)){
                                                        $totalpay += $value['amount'];
                                                    }
                                                        $datapay[]=$value['fk_paiement'];
                                                        // $datafact[]=$value['fk_facture'];
                                                }
                                            }
                                        }
                                        print price($amountp, 0, $langs, 1, $aftercomma);

                                print '</td>';
                                print '<td></td>';
                            print '</tr>';
                        }
                    }
                }




                $totalbalance = $solde + $total - $totalpay;
                print '<tr class="liste_total">';
                    print '<td>Total</td>';
                    print '<td align="center" ></td>';
                    print '<td align="right">'.price($total, 0, $langs, 1, $aftercomma).' '.$langs->getCurrencySymbol($conf->currency).'</td>';
                    print '<td ></td>';
                    if($clsp)
                        print '<td colspan="'.$clsp.'" ></td>';
                    print '<td align="right" >'.price($totalpay, 0, $langs, 1, $aftercomma).' '.$langs->getCurrencySymbol($conf->currency) .'</td>';
                    print '<td class="colorsold" align="right">'.price($totalbalance, 0, $langs, 1, $aftercomma).' '.$langs->getCurrencySymbol($conf->currency).'</td>';
                print '</tr>';
            }
            else{
                $colspan = 9+$clsp;
                print '<tr><td align="center" colspan="'.$colspan.'" >'.$langs->trans("NoRecordFound").'</td></tr>';
            }
        print '</table>';
    print '</form>';

    print '<br><br>';

print  '</div>';


llxFooter();
$db->close();