<?php 

$res=0;
if (! $res && file_exists("../main.inc.php")) $res=@include("../main.inc.php");       // For root directory
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php"); // For "custom" 

global $conf;
if (!$conf->releveclient->enabled) {
  accessforbidden();
}
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture-rec.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/modules/facture/modules_facture.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/discount.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/invoice.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/accountancy/class/accountingjournal.class.php';


dol_include_once("/releveclient/class/releveclient.class.php");
dol_include_once("/releveclient/lib/releveclient.lib.php");

$form = new Form($db);
$userstatic = new User($db);
$releveclient = new releveclient($db);
$object    = new Facture($db);
$client    = new Societe($db);
$paiement = new Paiement($db);
$extrafields = new ExtraFields($db);


$releveclient->upgradeModulereleveclient();

$langs->loadLangs(array('bills', 'companies', 'compta', 'products', 'banks', 'main', 'withdrawals'));
$modname = $langs->trans("releveclient");

$facid = (GETPOST('id', 'int') ?GETPOST('id', 'int') : GETPOST('facid', 'int')); // For backward compatibility
$ref = GETPOST('ref', 'alpha');
$fk_reglement = GETPOST('fk_reglement', 'int');
$action = GETPOST('action', 'alpha');
$socid=GETPOST('socid');

$srch_qty=GETPOST('srch_qty');


$debut = dol_mktime(0, 0, 0, GETPOST('debutmonth'), GETPOST('debutday'), GETPOST('debutyear'));
$fin = dol_mktime(0, 0, 0, GETPOST('finmonth'), GETPOST('finday'), GETPOST('finyear'));
$debut = $debut ? $db->idate($debut) : '';
$fin = $fin ? $db->idate($fin) : '';


$socid = 2;
if(empty($debut) && GETPOST('debut'))
    $debut=GETPOST('debut');

if(empty($fin) && GETPOST('fin'))
    $fin=GETPOST('fin');

   
$object = new Account($db);
$fk_account = GETPOST("fk_account");
$object->fetch($fk_account); 

$srch_datec = dol_mktime(0, 0, 0, GETPOST('srch_datecmonth'), GETPOST('srch_datecday'), GETPOST('srch_datecyear'));
$limit = GETPOST('limit', 'int') ?GETPOST('limit', 'int') : $conf->liste_limit;
$sortfield = GETPOST("sortfield", 'alpha') ? GETPOST("sortfield", 'alpha') : 'f.datef';
$sortorder = GETPOST("sortorder", 'alpha') ? GETPOST("sortorder", 'alpha') : 'ASC';
$page = GETPOSTISSET('pageplusone') ? (GETPOST('pageplusone') - 1) : GETPOST("page", 'int');
if (empty($page) || $page == -1 || !empty($search_btn) || !empty($search_remove_btn) || (empty($toselect) && $massaction === '0')) { $page = 0; }     

$offset = $limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$filter='';

if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter") || $page < 0) {
    $filter = "";
    $offset = 0;
    $filter = "";
}
if($socid && $debut && $fin)
    $solde = $releveclient->SoldeDebiteur($socid,$debut,$fin);

$i=0;

$TData = array();
$sql = "SELECT s.nom, s.rowid as socid, f.ref, f.total_ttc, f.datef as df,";
$sql .= " f.paye as paye, f.fk_statut as statut, f.rowid as facid";
$sql .= " FROM ".MAIN_DB_PREFIX."societe as s, ".MAIN_DB_PREFIX."facture as f";
$sql .= " WHERE f.fk_soc = s.rowid AND s.rowid = ".$socid;
$sql .= " AND f.entity IN (".getEntity('invoice').")";
// $sql .= " AND f.fk_user_valid = u.rowid";
// $sql .= " ORDER BY f.datef ASC, f.rowid ASC";

if($debut && $fin) $sql .= " AND (f.datef BETWEEN '".$debut."' AND '".$fin."')";
elseif($debut && empty($fin)) $sql .= " AND f.datef>= '".$debut."'";
elseif($fin && empty($debut)) $sql .= " AND f.datef<= '".$fin."'";

$sql .= $db->order($sortfield, $sortorder);

$nbtotalofrecords = '';
if (empty($conf->global->MAIN_DISABLE_FULL_SCANLIST))
{
    $result = $db->query($sql);
    $nbtotalofrecords = $db->num_rows($result);
    if (($page * $limit) > $nbtotalofrecords)   // if total resultset is smaller then paging size (filtering), goto and load page 0
    {
        $page = 0;
        $offset = 0;
    }
}

$sql .= $db->plimit($limit + 1, $offset);

$arrpayement = [];
$resql = $db->query($sql);
if ($resql)
{
    $num = $db->num_rows($resql);

    // Boucle sur chaque facture
    for ($i = 0; $i < $num; $i++)
    {
        $objf = $db->fetch_object($resql);

        $fac = new Facture($db);
        $ret = $fac->fetch($objf->facid);
        if ($ret < 0)
        {
            print $fac->error."<br>";
            continue;
        }
        $totalpaye = $fac->getSommePaiement();

        $userstatic->id = $objf->userid;
        $userstatic->login = $objf->login;

        $fac->fetch_lines();
        $lignes = $fac->lines;
        $dtlignes=[];
        if(is_array($lignes) && count($lignes)){
            if($lignes && count($lignes)>0 ){
                foreach ($lignes as $key => $ligne) {
                    if($ligne->fk_product){
                        $Prod=new Product($db);
                        $Prod->fetch($ligne->fk_product);
                        $label=$Prod->getNomUrl(1);
                        if($Prod->label) $label.= ' - '.$Prod->label;

                    }else $label=$ligne->desc;

                    $dtlignes[] = ['descp'=>$ligne->desc,'fk_product'=>$ligne->fk_product, 'label' => $label, 'qty'=>$ligne->qty, 'amount'=>$ligne->subprice];
                }
            }
        }

        $values = array(
            'fk_facture' => $objf->facid,
            'date' => $fac->date,
            'datefieldforsort' => $fac->date.'-'.$fac->ref,
            'link' => $fac->getNomUrl(1),
            'amount' => $fac->total_ttc,
            'lignes'=> $dtlignes,
        );

        $parameters = array('socid' => $id, 'values' => &$values, 'fac' => $fac, 'userstatic' => $userstatic);
        $reshook = $hookmanager->executeHooks('facdao', $parameters, $object); // Note that $parameters['values'] and $object may have been modified by some hooks
        if ($reshook < 0) setEventMessages($hookmanager->error, $hookmanager->errors, 'errors');

        $TData[] = $values;

        // Paiements
        $sql = "SELECT p.rowid, p.datep as dp, p.amount, p.statut";
        $sql .= " FROM  ".MAIN_DB_PREFIX."paiement as p,";
        $sql .= " ".MAIN_DB_PREFIX."paiement_facture as pf";
        $sql .= " WHERE pf.fk_paiement = p.rowid";
        $sql .= " AND p.entity = ".$conf->entity;
        $sql .= " AND pf.fk_facture = ".$fac->id;

        if($debut && $fin) $sql .= " AND (p.datep BETWEEN '".$debut."' AND '".$fin."')";
        elseif($debut && empty($fin)) $sql .= " AND p.datep>= '".$debut."'";
        elseif($fin && empty($debut)) $sql .= " AND p.datep<= '".$fin."'";

        $sql .= " ORDER BY p.datep ASC, p.rowid ASC";

        $resqlp = $db->query($sql);
        if ($resqlp)
        {
            $nump = $db->num_rows($resqlp);
            $j = 0;

            while ($j < $nump)
            {
                $objp = $db->fetch_object($resqlp);

                $paymentstatic = new Paiement($db);
                $paymentstatic->fetch($objp->rowid);

                $values = array(
                    'fk_paiement' => $objp->rowid,
                    'fk_facture' => $objf->facid,
                    'date' => $db->jdate($objp->dp),
                    'datefieldforsort' => $db->jdate($objp->dp).'-'.$fac->ref,
                    'link' => $paymentstatic->getNomUrl(1).' (Detail du Versement)' ,
                    'amount' => - $objp->amount,
                );

                if(!in_array($objp->rowid, $arrpayement)){
                    $TData[] = $values;
                    $arrpayement[]=$objp->rowid;
                }

                $j++;
            }

            $db->free($resqlp);
        }
    }
}
if(dolibarr_get_const($db, strtoupper('releveclient_fields'),$conf->entity)){

    $dataext=dolibarr_get_const($db, strtoupper('releveclient_fields'), $conf->entity);

    $dataext = explode(',', $dataext);
    $balance = $solde;
    $m=0;
    $n=0;
    if(in_array('be1', $dataext) && in_array('bl1', $dataext)){

        $TData = dol_sort_array($TData, 'datefieldforsort', $sortorder);
        foreach ($TData as $key => $value) {
            if($value['fk_facture']){
                $sql = 'SELECT be1, bl1 FROM '.MAIN_DB_PREFIX.'facture_extrafields WHERE fk_object='.$value['fk_facture'];
                $resql = $db->query($sql);
                if($resql){
                    while ($obj = $db->fetch_object($resql)) {
                        if(!empty($obj->bl1)){
                            if($TData2['bl1'])
                                $prevkey=count($TData2['bl1'])-1;
                            $TData2['bl1'][$m]=$value;

                            $amountp=0;
                            if(empty($value['fk_paiement']) && $value['fk_facture']) {
                                $fact = new Facture($db);
                                $fact->fetch($value['fk_facture']);
                                    
                            }
                            $amountp = $value['amount'];
                            if($m == 0 ){
                                $TData2['bl1'][$m]['balance'] = $balance-($amountp);
                            }else{

                                $TData2['bl1'][$m]['balance'] = $TData2['bl1'][$prevkey]['balance']-$amountp;
                            }
                            $m++;

                        }
                        $prev2key='';
                        if((empty($obj->bl1) && !empty($obj->be1)) || (empty($obj->be1) && empty($obj->bl1)) ){
                             if($TData2['be1'])
                                $prev2key=count($TData2['be1'])-1;
                            $TData2['be1'][$n]=$value;

                            $amountp=0;
                            if(empty($value['fk_paiement']) && $value['fk_facture']) {
                                $fact = new Facture($db);
                                $fact->fetch($value['fk_facture']);
                                    
                            }
                            $amountp = $value['amount'];
                            if($n ==0 ){
                                $TData2['be1'][$n]['balance'] = $balance-($amountp);
                            }else
                                $TData2['be1'][$n]['balance'] = $TData2['be1'][$prev2key]['balance']-$amountp;

                            $n++;
                        }
                    }
                }
            }
        }
    }
}
if (!empty($TData2)) {
    
    $TDataBL = dol_sort_array($TData2['bl1'], 'datefieldforsort', $sortorder);
    $TDataBE = dol_sort_array($TData2['be1'], 'datefieldforsort', $sortorder);


    print 'TDataBL:';
    print_r($TDataBL);
    print '<br>TDataBL:';
    print_r($TDataBL);
    

    $totalDebit = 0;
    $totalCredit = 0;
}

if ($limit > 0 && $limit != $conf->liste_limit) $param .= '&limit='.urlencode($limit);
if ($socid) $param .= '&socid='.urlencode($socid);
if ($debut) $param .= '&debut='.urlencode($debut);
if ($fin) $param .= '&fin='.urlencode($fin);



if (!$user->rights->releveclient->lire || !$user->rights->releveclient->export) {
    accessforbidden();
}


if(dolibarr_get_const($db, strtoupper('releveclient_fields'),$conf->entity)){
    $data_ef = dolibarr_get_const($db, strtoupper('releveclient_fields'),$conf->entity);
    $data_ef = explode(',', $data_ef);
}

/*-------------PDF-----------------*/
if ($action == "pdf" && GETPOST('actionpdf')) {
    global $conf, $langs, $mysoc;
    
    $Client = new Societe($db);

    require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
    require_once dol_buildpath('/releveclient/pdf/pdf.lib.php');
    $pdf->SetMargins(7, 2, 7, false);
    $pdf->SetFooterMargin(10);
    $pdf->setPrintFooter(true);
    $pdf->SetAutoPageBreak(TRUE,10);

    $height=$pdf->getPageHeight();

    $pdf->SetFont('helvetica', '', 9, '', true);
    $pdf->AddPage('L');
    $margint = $pdf->getMargins()['top'];
    $marginb = $pdf->getMargins()['bottom'];
    $marginl = $pdf->getMargins()['left'];
    $object->fetch($id);
    $item = $object;

    $pdf->SetTextColor(0, 0, 60);

    $default_font_size = 9;
    $pdf->SetFont('', 'B', $default_font_size);
    $posy   = $margint;
    $posx   = $pdf->page_largeur-$pdf->getMargins()['right']-100;

    $pdf->SetXY($marginl, $posy);

    $pdf->SetXY($marginl, $posy);

    $heightimg = 15;
    if ($mysoc && $mysoc->logo)
    {
        $logodir = $conf->mycompany->dir_output;
        if (empty($conf->global->MAIN_PDF_USE_LARGE_LOGO))
        {
            $logo = $logodir.'/logos/thumbs/'.$mysoc->logo_small;
        }
        else {
            $logo = $logodir.'/logos/'.$mysoc->logo;
        }
        
        if (is_readable($logo))
        {
            $height = pdf_getHeightForLogo($logo);
            $pdf->Image($logo, $marginl, $posy, 0, $heightimg); // width=0 (auto)
        }
        else
        {
            $pdf->SetTextColor(200, 0, 0);
            $pdf->SetFont('', 'B', $default_font_size - 2);
            $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorLogoFileNotFound", $logo), 0, 'L');
            $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorGoToGlobalSetup"), 0, 'L');
        }
    }
    else
    {
        $heightimg = 8;
        $text = $mysoc->name;
        $pdf->MultiCell(100, 4, $langs->convToOutputCharset($text), 0, 'L');
    }

    $posy = $margint + $heightimg + 2;

    $pdf->SetTextColor(0, 0, 60);
    $currentwate    = $conf->global->PAYROLLMOD_WATERMARK_IMG;
    if($currentwate){
        $bMargin = $pdf->getBreakMargin();
        $auto_page_break = $pdf->getAutoPageBreak();
        $pdf->SetAutoPageBreak(false, 0);
        $img_file = $conf->mycompany->dir_output.'/watermark/'.$currentwate;
        $pdf->SetAlpha(0.1);
        $pdf->Image($img_file, 35, 100, 140, '', '', '', '', false, 300, '', false, false, 0);
        $pdf->SetAlpha(1);
        $pdf->SetAutoPageBreak(true, $bMargin);
        $pdf->setPageMark();
    }

    $pdf->SetFont('', '', $default_font_size);

    if($socid)
        $Client->fetch($socid);


    require_once dol_buildpath('/releveclient/pdf/pdf.lib.php');
    require_once dol_buildpath('/releveclient/pdf/releve_pdf.php');
    $pdf->writeHTML($html, true, false, true, false, '');
    ob_start();
    $namemod=$langs->trans('releveclient');
    $pdf->Output($namemod.'.pdf', 'I');
    die();
}




if(GETPOST('exportxsl')){

    $html = '';
    $Client = new Societe($db);

    if($socid)
        $Client->fetch($socid);

    $filename="Releve_client.xls";
    require_once dol_buildpath('/releveclient/pdf/releve_xsl.php');
    header("Content-Type: application/xls");
    header("Content-Disposition: attachment; filename=".$filename."");
    echo $html;
    die(); 
}


$morejs  = array();
llxHeader(array(), $modname,'','','','',$morejs,0,0);

print load_fiche_titre($modname);

$head = releve_prepare_head();
print dol_get_fiche_head($head, 'releveclient', $langs->trans("releveclient"), -1, "invoice");


print '<div id="stclient" class="div-table-responsive">';
    print '<form  method="POST" action="'.$_SERVER['PHP_SELF'].'" >';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        print '<table class="noborder">';
            print '<input type="hidden" name="action" value="generer">';
            print '<tr>';
                print '<td>'.$langs->trans('Period');
                    print ' &nbsp;&nbsp;&nbsp;&nbsp;'.$langs->trans("From").' '.$form->selectDate($debut, 'debut', 0, 0, 1, '', 1, 1);
                print '</td>';
                print '<td colspan="2">';
                    print $langs->trans("To").' '.$form->selectDate($fin, 'fin', 0, 0, 1, '', 1, 1);
                print '</td>';
            print '</tr>'; 
            print '<tr>';
                print '<td>'.$langs->trans('Customer');
                    print $form->select_company($socid, 'socid', '((s.client = 1 OR s.client = 3) AND s.status=1)', 'SelectThirdParty', 0, 0, null, 0, 'minwidth300');

                    // Option to reload page to retrieve customer informations. Note, this clear other input
                    if (!empty($conf->global->RELOAD_PAGE_ON_CUSTOMER_CHANGE))
                    {
                        print '<script type="text/javascript">
                            $(document).ready(function() {
                                $("#socid").change(function() {
                                    var socid = $(this).val();
                                    var fac_rec = $(\'#fac_rec\').val();
                                    // reload page
                                    window.location.href = "'.$_SERVER["PHP_SELF"].'?action=create&socid="+socid+"&fac_rec="+fac_rec;
                                });
                            });
                        </script>';
                    }
                    if (!GETPOST('fac_rec', 'int')) 
                        print ' <a href="'.DOL_URL_ROOT.'/societe/card.php?action=create&client=3&fournisseur=0&backtopage='.urlencode($_SERVER["PHP_SELF"].'?action=create').'"><span class="fa fa-plus-circle valignmiddle paddingleft" title="'.$langs->trans("AddThirdParty").'"></span></a>';
                print '</td><td>';
                    if($socid && $debut && $fin){
                        $datesd=date('d/m/Y', strtotime($debut.' - 1 DAY'));
                        $text = $langs->trans("soldedebitair").' '.$datesd.':  '.rtrim(rtrim((string)number_format($solde, 2, ".", " "),"0"),".").' '.$langs->getCurrencySymbol($conf->currency);
                        print $text;
                    }
                print '</td><td>';
                    print '<a href="'.dol_buildpath('/releveclient/releve.php',2).'" class="butAction" style="padding-top: 0.4em; float:right">'.$langs->trans("Reset").'</a>';
                    print '<input style="margin-top:0px; float:right" type="submit" value="'.$langs->trans("generetat").'" name="exportpdf" class="button" />';
                print '</td>';

            print '</tr>'."\n";
        print '</table>';
    print '</form>';
        
    print '<br>';
    
    print '<form  method="POST" action="'.$_SERVER['PHP_SELF'].'">';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        print '<input type="hidden" name="fk_account" value="'.$fk_account.'">';
        print '<input type="hidden" name="socid" value="'.$socid.'">';
        print '<input type="hidden" name="debut" value="'.$debut.'">';
        print '<input type="hidden" name="fin" value="'.$fin.'">';
        print '<input name="pagem" type="hidden" value="'.$page.'">';
        print '<input name="offsetm" type="hidden" value="'.$offset.'">';
        print '<input name="limitm" type="hidden" value="'.$limit.'">';
        print '<input name="filterm" type="hidden" value="'.$filter.'">';
        print '<input name="action" type="hidden" value="pdf">';

        $object = new Facture($db);
        $dt_extrafield = $extrafields->fetch_name_optionals_label($object->table_element);
        $label=$extrafields->attributes[$object->table_element]['label'];

        if(dolibarr_get_const($db, strtoupper('releveclient_fields'),$conf->entity)){
            $data_ef = dolibarr_get_const($db, strtoupper('releveclient_fields'),$conf->entity);
            $data_ef = explode(',', $data_ef);
        }


        $massactionbutton = '<input name="actionpdf" type="submit" id="btn_pdf" formtarget="_blank" class="button" value="'.$langs->trans('generpdf').'" >';
        $massactionbutton.= '<input type="submit" value="'.$langs->trans("generxsl").'" name="exportxsl" class="button" />';

        print_barre_liste('', $page, $_SERVER["PHP_SELF"], $param, $sortfield, $sortorder, '', $num, $nbtotalofrecords, '', 0, $massactionbutton, '', $limit, 0, 0, 1);

        print '<table class="noborder" id="releveclient">';
            $clsp=0;
            print '<tr class="liste_titre_filter">';
                print_liste_field_titre($langs->trans("Date"), $_SERVER["PHP_SELF"], "f.datef", '', $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("Label"), $_SERVER["PHP_SELF"], "", '', $param, 'align="center" ', $sortfield, $sortorder);
                if($data_ef && count($data_ef)>0){
                    $nbef = count($data_ef); 
                    foreach ($data_ef as $key => $value) {
                        if($label && count($label)>0 && array_key_exists($value,$label)){
                            print '<td align="center">'.$label[$value].'</td>';
                            $clsp++;
                        }
                    }
                }
                print_liste_field_titre($langs->trans("Product"), $_SERVER["PHP_SELF"], "", '', $param, 'align="center" ', $sortfield, $sortorder);

                print_liste_field_titre($langs->trans("Quantity"), $_SERVER["PHP_SELF"], "fd.qty", '', $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("PriceU"), $_SERVER["PHP_SELF"], "", "fd.total_ttc", $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("debitreleve"), $_SERVER["PHP_SELF"], "", "", $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("creditreleve"), $_SERVER["PHP_SELF"], "", "", $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("Solde"), $_SERVER["PHP_SELF"], "", "", $param, 'align="center"', $sortfield, $sortorder);
            print '</tr>';
            $colsptotal = 3+$clsp;

            $totalgdebit=$totalgcredit=$totalgqty=0;
            if($TDataBL && count($TDataBL)>0 && $socid){
                $var = 1;
                $classes =[0=>'trnocolor', 1=>'trcolor'];
                $totalDebit=$totalCredit=$totalqty=0;
                $l = 0;
                $class = '';
                foreach ($TDataBL as $key => $data) {
                    $colspan=$rowspan=  '';
                    $var = !$var;
                    $totalp = 0;
                    $l++;
                    print '<tr class="'.$classes[$var].'">';
                        if($data['lignes'] && count($data['lignes'])>0){
                            $rowspan = 'rowspan="'.count($data['lignes']).'"';
                        }
                        print '<td align="center" '.$rowspan.'>'.dol_print_date($data['date'], 'day').'</td>';
                        if($data['fk_paiement']){
                            $colspan='colspan="'.($clsp+2).'"';
                        } 

                        print '<td align="center" '.$colspan.' '.$rowspan.'>';
                            print $data['link'];
                            if($data['fk_paiement']){
                                $objpaym = new Paiement($db);
                                $objpaym->fetch($data['fk_paiement']);
                                $labeltype = $langs->trans("PaymentType".$objpaym->type_code) != ("PaymentType".$objpaym->type_code) ? $langs->trans("PaymentType".$objpaym->type_code) : $objpaym->type_label;
                                print ' - '.$labeltype;
                            }


                        print '</td>';

                        if(empty($data['fk_paiement'])){
                            if($data['fk_facture']){
                                if($data_ef && count($data_ef)>0){
                                    foreach ($data_ef as $key => $value) {

                                        if($label && count($label)>0 && array_key_exists($value,$label)){
                                            print '<td '.$rowspan.' align="center">';
                                                if($data['fk_facture']){
                                                    $msql = 'SELECT eff.*, ef.label as eflbl, ef.name as efname FROM '.MAIN_DB_PREFIX.'extrafields as ef, '.MAIN_DB_PREFIX.$object->table_element.'_extrafields as eff WHERE ef.elementtype = "'.$object->table_element.'" AND eff.fk_object ='.$data['fk_facture'].' AND ef.list=1';
                                                    $mresql = $db->query($msql);
                                                    if($mresql){
                                                        while ($obj = $db->fetch_object($mresql)) {

                                                            $efname = $obj->efname;
                                                            if( $obj->eflbl && $efname==$value){
                                                                print $extrafields->showOutputField($value, $obj->$efname, '', $object->table_element);
                                                            }
                                                        }
                                                    }
                                                }
                                            print '</td>';
                                        }

                                    }
                                }
                            }
                        }
                        $ligne = [];
                        if($data['fk_facture'] && $data['lignes'] && count($data['lignes'])>0){
                            $ligne = $data['lignes'][0]; 
                            print '<td align="center">'.$ligne['label'].'</td>';
                            print '<td align="center" class="width50">'.$ligne['qty'].'</td>';
                            $totalqty+=$ligne['qty'];
                            print '<td align="right">'.rtrim(rtrim((string)number_format($ligne['amount'], 2, ".", " "),"0"),".").'</td>';
                        }else{
                            print '<td align="center"></td>';
                            print '<td align="center"></td>';
                        }
                        if($data['fk_facture'] && empty($data['lignes']) && empty($data['fk_paiement'])) print '<td align="center"></td>';
                        print '<td align="right" '.$rowspan.'>'.(($data['amount'] > 0) ? rtrim(rtrim((string)number_format(abs($data['amount']), 2, ".", " "),"0"),".") : '').'</td>';
                        print '<td align="right" '.$rowspan.'>';
                        
                            if($data['amount'] < 0) {
                                $totalp=$data['amount'];
                            }
                            
                            if($totalp)
                                print rtrim(rtrim((string)number_format(abs($totalp), 2, ".", " "),"0"),".");
                        print '</td>';
                        $amountsold =  (-1)*$data['balance'] ;
                        $totalsoldbl = $amountsold;
                        if($l == count($TData)) $class = 'colorsold';
                        print '<td class="colorsold" align="right" '.$rowspan.'>'.rtrim(rtrim((string)number_format($amountsold, 2, ".", " "),"0"),".").'</td>';
                    print '</tr>';
                    if($data['fk_facture'] && $data['lignes'] && count($data['lignes'])>0){
                        foreach ( $data['lignes'] as $k => $ligne) {
                            if($k>0){
                                print '<tr class="'.$classes[$var].'">';
                                    print '<td align="center">'.$ligne['label'].'</td>';
                                    print '<td align="center" class="width50">'.$ligne['qty'].'</td>';
                                    print '<td align="right">'.rtrim(rtrim((string)number_format($ligne['amount'], 2, ".", " "),"0"),".").'</td>';
                                    $totalqty+=$ligne['qty'];
                                print '</tr>';
                            }
                        }
                    }

                    $totalDebit += ($data['amount'] > 0) ? abs($data['amount']) : 0;
                    $totalCredit += ($data['amount'] > 0) ? 0 : abs($data['amount']);
                }

                $totalgdebit +=$totalDebit;
                $totalgcredit +=$totalCredit;
                $totalgqty += $totalqty;

                print '<tr class="liste_total soustotal">';
                    print '<td colspan="'.$colsptotal.'">'.$langs->trans("totalbl1").'</td>';
                    print '<td align="center" >'.$totalqty.'</td>';
                    print '<td align="center"></td>';
                    print '<td align="right">'.rtrim(rtrim((string)number_format($totalDebit, 2, ".", " "),"0"),".").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
                    print '<td align="right">'.rtrim(rtrim((string)number_format($totalCredit, 2, ".", " "),"0"),".").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
                    print '<td class="colorsold" align="right">'.rtrim(rtrim((string)number_format($amountsold, 2, ".", " "),"0"),".").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
                print '</tr>';
            }

            if($TDataBE && count($TDataBE)>0 && $socid){
                $var = 1;
                $classes =[0=>'trnocolor', 1=>'trcolor'];
                $totalDebit=$totalCredit=$totalqty=0;
                $l = 0;
                $class = '';
                foreach ($TDataBE as $key => $data) {
                    $colspan=$rowspan=  '';
                    $var = !$var;
                    $totalp = 0;
                    $l++;
                    print '<tr class="'.$classes[$var].'">';
                        if($data['lignes'] && count($data['lignes'])>0){
                            $rowspan = 'rowspan="'.count($data['lignes']).'"';
                        }
                        print '<td align="center" '.$rowspan.'>'.dol_print_date($data['date'], 'day').'</td>';
                        if($data['fk_paiement']){
                            $colspan='colspan="'.($clsp+2).'"';
                        } 

                        print '<td align="center" '.$colspan.' '.$rowspan.'>';
                            print $data['link'];
                            if($data['fk_paiement']){
                                $objpaym = new Paiement($db);
                                $objpaym->fetch($data['fk_paiement']);
                                $labeltype = $langs->trans("PaymentType".$objpaym->type_code) != ("PaymentType".$objpaym->type_code) ? $langs->trans("PaymentType".$objpaym->type_code) : $objpaym->type_label;
                                print ' - '.$labeltype;
                            }


                        print '</td>';

                        if(empty($data['fk_paiement'])){
                            if($data['fk_facture']){
                                if($data_ef && count($data_ef)>0){
                                    foreach ($data_ef as $key => $value) {

                                        if($label && count($label)>0 && array_key_exists($value,$label)){
                                            print '<td '.$rowspan.' align="center">';
                                                if($data['fk_facture']){
                                                    $msql = 'SELECT eff.*, ef.label as eflbl, ef.name as efname FROM '.MAIN_DB_PREFIX.'extrafields as ef, '.MAIN_DB_PREFIX.$object->table_element.'_extrafields as eff WHERE ef.elementtype = "'.$object->table_element.'" AND eff.fk_object ='.$data['fk_facture'].' AND ef.list=1';
                                                    $mresql = $db->query($msql);
                                                    if($mresql){
                                                        while ($obj = $db->fetch_object($mresql)) {

                                                            $efname = $obj->efname;
                                                            if( $obj->eflbl && $efname==$value){
                                                                print $extrafields->showOutputField($value, $obj->$efname, '', $object->table_element);
                                                            }
                                                        }
                                                    }
                                                }
                                            print '</td>';
                                        }

                                    }
                                }
                            }
                        }
                        $ligne = [];
                        if($data['fk_facture'] && $data['lignes'] && count($data['lignes'])>0){
                            $ligne = $data['lignes'][0]; 
                            print '<td align="center">'.$ligne['label'].'</td>';
                            print '<td align="center" class="width50">'.$ligne['qty'].'</td>';
                            $totalqty+=$ligne['qty'];
                            print '<td align="right">'.rtrim(rtrim((string)number_format($ligne['amount'], 2, ".", " "),"0"),".").'</td>';
                        }else{
                            print '<td align="center"></td>';
                            print '<td align="center"></td>';
                        }
                        if($data['fk_facture'] && empty($data['lignes']) && empty($data['fk_paiement'])) print '<td align="center"></td>';
                        print '<td align="right" '.$rowspan.'>'.(($data['amount'] > 0) ? rtrim(rtrim((string)number_format(abs($data['amount']), 2, ".", " "),"0"),".") : '').'</td>';
                        print '<td align="right" '.$rowspan.'>';
                        
                            if($data['amount'] < 0) {
                                $totalp=$data['amount'];
                            }
                          
                            if($totalp)
                                print rtrim(rtrim((string)number_format(abs($totalp), 2, ".", " "),"0"),".");
                        print '</td>';
                        $amountsold =  (-1)*$data['balance'] ;
                        $totalsoldbe = $amountsold;

                        if($l == count($TData)) $class = 'colorsold';
                        print '<td class="colorsold" align="right" '.$rowspan.'>'.rtrim(rtrim((string)number_format($amountsold, 2, ".", " "),"0"),".").'</td>';
                    print '</tr>';
                    if($data['fk_facture'] && $data['lignes'] && count($data['lignes'])>0){
                        foreach ( $data['lignes'] as $k => $ligne) {
                            if($k>0){
                                print '<tr class="'.$classes[$var].'">';
                                    print '<td align="center">'.$ligne['label'].'</td>';
                                    print '<td align="center" class="width50">'.$ligne['qty'].'</td>';
                                    print '<td align="right">'.rtrim(rtrim((string)number_format($ligne['amount'], 2, ".", " "),"0"),".").'</td>';
                                    $totalqty+=$ligne['qty'];
                                print '</tr>';
                            }
                        }
                    }

                    $totalDebit += ($data['amount'] > 0) ? abs($data['amount']) : 0;
                    $totalCredit += ($data['amount'] > 0) ? 0 : abs($data['amount']);
                }

                $totalgdebit +=$totalDebit;
                $totalgcredit +=$totalCredit;
                $totalgqty += $totalqty;
                
                print '<tr class="liste_total soustotal">';
                    print '<td colspan="'.$colsptotal.'">'.$langs->trans("totalbe1").'</td>';
                    print '<td align="center" >'.$totalqty.'</td>';
                    print '<td align="center"></td>';
                    print '<td align="right">'.rtrim(rtrim((string)number_format($totalDebit, 2, ".", " "),"0"),".").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
                    print '<td align="right">'.rtrim(rtrim((string)number_format($totalCredit, 2, ".", " "),"0"),".").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
                    print '<td class="colorsold" align="right">'.rtrim(rtrim((string)number_format($amountsold, 2, ".", " "),"0"),".").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
                print '</tr>';
            }

            if($TData){
                $totalsold = $totalsoldbl+$totalsoldbe;
                print '<tr class="liste_total totalglobal">';
                    print '<td colspan="'.$colsptotal.'">'.$langs->trans("total").'</td>';
                    print '<td align="center" >'.$totalgqty.'</td>';
                    print '<td align="center"></td>';
                    print '<td align="right">'.rtrim(rtrim((string)number_format($totalgdebit, 2, ".", " "),"0"),".").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
                    print '<td align="right">'.rtrim(rtrim((string)number_format($totalgcredit, 2, ".", " "),"0"),".").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
                    print '<td class="colorsold" align="right">'.rtrim(rtrim((string)number_format($totalsold, 2, ".", " "),"0"),".").' '.$langs->getCurrencySymbol($conf->currency).'</td>';
                print '</tr>';
            }
            else{
                $clsptotal = $colsptotal+5;
                print '<tr><td align="center" colspan="'.$clsptotal.'" >'.$langs->trans("NoRecordFound").'</td></tr>';
            }
        print '</table>';
    print '</form>';

    print '<br><br>';
print  '</div>';


dol_fiche_end();


llxFooter();
$db->close();