<?php 

$res=0;
if (! $res && file_exists("../main.inc.php")) $res=@include("../main.inc.php");       // For root directory
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php"); // For "custom" 

global $conf;
if (!$conf->releveclient->enabled) {
  accessforbidden();
}
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture-rec.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/fourn/class/paiementfourn.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/modules/facture/modules_facture.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/discount.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/invoice.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/accountancy/class/accountingjournal.class.php';


dol_include_once("/releveclient/class/releveclient.class.php");
dol_include_once("/releveclient/lib/releveclient.lib.php");

$form = new Form($db);
$userstatic = new User($db);
$releveclient = new releveclient($db);
$object    = new Facture($db);
$client    = new Societe($db);
$extrafields = new ExtraFields($db);


$releveclient->upgradeModulereleveclient();

$langs->loadLangs(array('bills', 'companies', 'compta', 'products', 'banks', 'main', 'withdrawals'));
$modname = $langs->trans("releveclient");

$facid = (GETPOST('id', 'int') ?GETPOST('id', 'int') : GETPOST('facid', 'int')); // For backward compatibility
$ref = GETPOST('ref', 'alpha');
$fk_reglement = GETPOST('fk_reglement', 'int');
$action = GETPOST('action', 'alpha');
$actionpdf = GETPOST('actionpdf', 'alpha');
$exportxsl = GETPOST('exportxsl', 'alpha');
$socid=GETPOST('socid');

$srch_qty=GETPOST('srch_qty');

$actionexport = $actionpdf ? 1 : ($exportxsl ? 1 : 0);
$debutday = GETPOST('debutday', 'int');
$debutyear = GETPOST('debutyear', 'int');
$debutmonth = GETPOST('debutmonth', 'int');

$finday = GETPOST('finday', 'int');
$finyear = GETPOST('finyear', 'int');
$finmonth = GETPOST('finmonth', 'int');

$srch_debut = dol_mktime(0, 0, 0, $debutmonth, $debutday, $debutyear);
$srch_fin = dol_mktime(0, 0, 0, $finmonth, $finday, $finyear);

$debut = $srch_debut ? $db->idate($srch_debut) : '';
$fin = $srch_fin ? $db->idate($srch_fin) : '';

   
$object = new Account($db);
$fk_account = GETPOST('fk_account');
$object->fetch($fk_account); 

$srch_datec = dol_mktime(0, 0, 0, GETPOST('srch_datecmonth'), GETPOST('srch_datecday'), GETPOST('srch_datecyear'));
// $limit = GETPOST('limit', 'int') ?GETPOST('limit', 'int') : $conf->liste_limit;
$limit = GETPOST('limit', 'int') ?GETPOST('limit', 'int') : 20;
$sortfield = GETPOST('sortfield', 'alpha') ? GETPOST('sortfield', 'alpha') : 'f.datef';
$sortorder = GETPOST('sortorder', 'alpha') ? GETPOST('sortorder', 'alpha') : 'ASC';
$page = GETPOSTISSET('pageplusone') ? (GETPOST('pageplusone') - 1) : GETPOST('page', 'int');
if (empty($page) || $page === -1 || !empty($search_btn) || !empty($search_remove_btn) || (empty($toselect) && $massaction === '0')) { $page = 0; }     

$offset = $limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$filter='';
$solde=0;
if (GETPOST('button_removefilter_x') || GETPOST('button_removefilter') || $page < 0) {
    $filter = '';
    $offset = 0;
    $filter = '';
}
if($socid && $debut && $fin) $solde = $releveclient->SoldeDebiteur($socid,$debut,$fin);

$i=0;
$qtyprod_by_tag = array();

$TData = array();
$sql = 'SELECT s.nom, s.rowid as socid, f.ref, f.total_ttc, f.datef as df,';
$sql .= ' f.paye as paye, f.fk_statut as statut, f.rowid as facid';
$sql .= ' FROM '.MAIN_DB_PREFIX.'societe as s, '.MAIN_DB_PREFIX.'facture_fourn as f';
$sql .= ' WHERE f.fk_soc = s.rowid AND s.rowid = '.$socid;
$sql .= ' AND f.entity IN ('.getEntity('invoice').')';

if($debut && $fin) $sql .= ' AND (CAST(f.datef as date) BETWEEN "'.$debut.'" AND "'.$fin.'")';
elseif($debut && empty($fin)) $sql .= ' AND CAST(f.datef as date) >= "'.$debut.'"';
elseif($fin && empty($debut)) $sql .= ' AND CAST(f.datef as date) <= "'.$fin.'"';

$sql .= $db->order($sortfield, $sortorder);

if(empty($actionexport)){
    $nbtotalofrecords = '';
    if (empty($conf->global->MAIN_DISABLE_FULL_SCANLIST))
    {
        $result = $db->query($sql);
        $nbtotalofrecords = $db->num_rows($result);
        if (($page * $limit) > $nbtotalofrecords)   // if total resultset is smaller then paging size (filtering), goto and load page 0
        {
            $page = 0;
            $offset = 0;
        }
    }

    $sql .= $db->plimit($limit + 1, $offset);
}

$arrpayement = [];
$resql = $db->query($sql);
$factsid = '';

$arrainvoics = array();

$urlpayement    = DOL_URL_ROOT.'/fourn/paiement/card.php?id='; 
$urlfacture     = DOL_URL_ROOT.'/fourn/facture/card.php?facid=';
$urlproduct     = DOL_URL_ROOT.'/product/card.php?id=';

$pictopayement = img_picto('', 'payment').' ';
$pictofacture = img_picto('', 'bill').' ';
$pictoproduct = img_picto('', 'product').' ';

if ($resql)
{
    $num = $db->num_rows($resql);

    // Boucle sur chaque facture
    for ($i = 0; $i < $num; $i++)
    {
        $objf = $db->fetch_object($resql);

        $fac = new FactureFournisseur($db);
        $ret = $fac->fetch($objf->facid);
        if($i === 0) $factsid .= $objf->facid;
        else $factsid .= ','.$objf->facid;

        if ($ret < 0) continue;

        $arrainvoics[$objf->facid] = $fac;
        // $totalpaye = $fac->getSommePaiement();

        $userstatic->id = $objf->userid;
        $userstatic->login = $objf->login;

        $fac->fetch_lines();
        $lignes = $fac->lines;
        $dtlignes=[];
        if(is_array($lignes) && count($lignes) > 0){
            foreach ($lignes as $key => $ligne) {
                if($ligne->fk_product){
                    $label = $ligne->product_label;
                    $type = $ligne->fk_product_type;
                    // $cat = new Categorie($db);
                //     $categories = $cat->containing($ligne->fk_product, Categorie::TYPE_PRODUCT);
                //     if($categories){
                //         foreach ($categories as $key => $value) {
                //             if($value->fk_parent){
                //                 $parentcat = new Categorie($db);
                //                 $parentcat->fetch($value->fk_parent);
                //                 $qtyprod_by_tag[$type][$value->fk_parent]['label'] = $parentcat->label;
                //                 $qtyprod_by_tag[$type][$value->fk_parent]['nb']+=$ligne->qty;
                //                 $qtyprod_by_tag[$type][$value->fk_parent]['totalfact']+= $ligne->total_ttc;

                //             }else{
                //                 $qtyprod_by_tag[$type][$value->id]['label']=$value->label;
                //                 $qtyprod_by_tag[$type][$value->id]['nb']+=$ligne->qty;
                //                 $qtyprod_by_tag[$type][$value->id]['totalfact']+= $ligne->total_ttc;
                //             }
                //         }
                //     }else{
                //         $qtyprod_by_tag[$type][0]['nb']+=$ligne->qty;
                //         $qtyprod_by_tag[$type][0]['totalfact']+= $ligne->total_ttc;
                //     }
                    if(empty($actionexport)){
                        $label = '<a href="'.$urlproduct.$ligne->fk_product.'">';
                        $label .= $pictoproduct.$ligne->product_label;
                        $label .= '</a>';
                    }
                }else{
                    $type = $ligne->product_type;
                    // $qtyprod_by_tag[$type][0]['nb']+=$ligne->qty;
                    // $qtyprod_by_tag[$type][0]['totalfact']+= $ligne->total_ttc;
                    $label=$ligne->description;
                }

                $dtlignes[] = ['descp'=>$ligne->description,'fk_product'=>$ligne->fk_product, 'label' => $label, 'qty'=>$ligne->qty, 'amount'=>$ligne->subprice,'type'=>$type];
            }
        }

       

        $faclink = $objf->ref;
        if(empty($actionexport)){
            $faclink = '<a href="'.$urlfacture.$objf->facid.'">';
            $faclink .= $pictofacture.$objf->ref;
            $faclink .= '</a>';
        }

        $TData[] = array(
            'fk_facture' => $objf->facid,
            'date'       => $fac->date,
            // 'link'       => $fac->getNomUrl(1),
            'link'       => $faclink,
            'amount'     => $fac->total_ttc,
            'lignes'     => $dtlignes,
            // 'datefieldforsort' => $objf->facid.'-'.$fac->date,
            // 'datefieldforsort' => $fac->date.'-'.$fac->ref,
            'datefieldforsort' => $fac->date.'-'.$fac->ref,
            // ''=>$fac->array_option
        );

        // $values = array(
        //     'fk_facture' => $objf->facid,
        //     'date'       => $fac->date,
        //     'link'       => $faclink,
        //     'amount'     => $fac->total_ttc,
        //     'lignes'     => $dtlignes,
        //     'be1'        => $fac->array_options['options_be1'],
        //     'bl1'        => $fac->array_options['options_bl1'],
        //     'datefieldforsort' => $fac->date.'-'.$fac->ref,
        //     // ''=>$fac->array_option
        // );

        // if(!empty($fac->array_options['options_bl1'])){
        //     $TData['bl1'][] = $values;
        // }
        // if((empty($fac->array_options['options_bl1']) && !empty($fac->array_options['options_be1'])) || (empty($fac->array_options['options_be1']) && empty($fac->array_options['options_bl1'])) ){
        //     $TData['be1'][] = $values;
        // }



        // if(!empty($fac->array_options['options_bl1'])){

        //     $values = array(
        //         'fk_facture' => $objf->facid,
        //         'date'       => $fac->date,
        //         'link'       => $faclink,
        //         'amount'     => $fac->total_ttc,
        //         'lignes'     => $dtlignes,
        //         'be1'        => $fac->array_options['options_be1'],
        //         'bl1'        => $fac->array_options['options_bl1'],
        //         'datefieldforsort' => $fac->date.'-'.$fac->ref,
        //         // ''=>$fac->array_option
        //     );
        //     $TData['bl1'][] = $values;
        // }
        // if((empty($fac->array_options['options_bl1']) && !empty($fac->array_options['options_be1'])) || (empty($fac->array_options['options_be1']) && empty($fac->array_options['options_bl1'])) ){

        //     $values = array(
        //         'fk_facture' => $objf->facid,
        //         'date'       => $fac->date,
        //         'link'       => $faclink,
        //         'amount'     => $fac->total_ttc,
        //         'lignes'     => $dtlignes,
        //         'be1'        => $fac->array_options['options_be1'],
        //         'bl1'        => $fac->array_options['options_bl1'],
        //         'datefieldforsort' => $fac->date.'-'.$fac->ref,
        //         // ''=>$fac->array_option
        //     );
        //     $TData['be1'][] = $values;
        // }

        // $parameters = array('socid' => $id, 'values' => &$values, 'fac' => $fac, 'userstatic' => $userstatic);
        // $reshook = $hookmanager->executeHooks('facdao', $parameters, $object); // Note that $parameters['values'] and $object may have been modified by some hooks
        // if ($reshook < 0) setEventMessages($hookmanager->error, $hookmanager->errors, 'errors');

    }

    $db->free($resql);

    // Paiements
    $sql = 'SELECT p.rowid,c.code as type_code, c.libelle as type_label, p.ref as refpayement, p.datep as dp, SUM(pf.amount) as amount, pf.fk_paiementfourn, pf.fk_facturefourn as fk_fact, p.statut';
    $sql .= ' FROM  '.MAIN_DB_PREFIX.'paiementfourn as p';
    $sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'paiementfourn_facturefourn as pf ON pf.fk_paiementfourn = p.rowid';
    $sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'c_paiement as c ON p.fk_paiement = c.id';
    // $sql .= ' WHERE pf.fk_paiement = p.rowid';
    $sql .= ' WHERE p.entity = '.$conf->entity;
    // $sql .= ' AND pf.fk_facture IN ('.$factsid.')';
    $sql .= ' AND pf.fk_facturefourn IN (SELECT f.rowid FROM '.MAIN_DB_PREFIX.'facture_fourn as f WHERE f.fk_soc = '.$socid.')';

    if($debut && $fin) $sql .= ' AND (CAST(p.datep as date) BETWEEN "'.$debut.'" AND "'.$fin.'")';
    elseif($debut && empty($fin)) $sql .= ' AND CAST(p.datep as date)>= "'.$debut.'"';
    elseif($fin && empty($debut)) $sql .= ' AND CAST(p.datep as date)<= "'.$fin.'"';

    $sql .= ' GROUP BY p.rowid';
    $sql .= ' ORDER BY p.datep ASC, p.rowid ASC';

    $resqlp = $db->query($sql);
    if ($resqlp)
    {
        $nump = $db->num_rows($resqlp);
        $j = 0;

        while ($j < $nump)
        {
            $objp = $db->fetch_object($resqlp);

            // $paymentstatic = new Paiement($db);
            // $paymentstatic->fetch($objp->rowid);

            // $fac = new Facture($db);
            // $ret = $fac->fetch($objp->fk_fact);
            $fac = $arrainvoics[$objp->fk_fact];
            $paylink = $objp->refpayement;
            if(empty($actionexport)){
                $paylink = '<a href="'.$urlpayement.$objp->rowid.'">';
                $paylink .= $pictopayement.$objp->refpayement;
                $paylink .= '</a>';
            }
            $labeltype = $langs->trans("PaymentType".$objp->type_code) != ("PaymentType".$objp->type_code) ? $langs->trans("PaymentType".$objp->type_code) : $objp->type_label;
            $TData[] = array(
                'fk_paiement' => $objp->rowid,                           
                'fk_facture' => $objp->fk_fact,
                'date' => $db->jdate($objp->dp),
                // 'datefieldforsort' => $objp->fk_fact.'-'.$db->jdate($objp->dp),
                'datefieldforsort' => $db->jdate($objp->dp).'-'.$fac->ref,
                // 'datefieldforsort' => $db->jdate($objp->dp),
                // 'link' => $paylink.' (Detail du Versement)' ,
                'link' => $paylink ,
                'labeltype' => $labeltype ,
                'amount' => (-1*$objp->amount),
            );
           


            // $values = array(
            //     'fk_paiement' => $objp->rowid,
            //     'fk_facture' => $objp->fk_fact,
            //     'date' => $db->jdate($objp->dp),
            //     'datefieldforsort' => $db->jdate($objp->dp).'-'.$fac->ref,
            //     'link' => $paylink.' (Detail du Versement)' ,
            //     'labeltype' => $labeltype ,
            //     'amount' => (-1*$objp->amount),
            // );

            // if(!empty($fac->array_options['options_bl1'])){
            //     $TData['bl1'][] = $values;
            // }
            // if((empty($fac->array_options['options_bl1']) && !empty($fac->array_options['options_be1'])) || (empty($fac->array_options['options_be1']) && empty($fac->array_options['options_bl1'])) ){
            //     $TData['be1'][] = $values;
            // }




            // if(!empty($fac->array_options['options_bl1'])){
            //     $values = array(
            //         'fk_paiement' => $objp->rowid,
            //         'fk_facture' => $objp->fk_fact,
            //         'date' => $db->jdate($objp->dp),
            //         'datefieldforsort' => $db->jdate($objp->dp).'-'.$fac->ref,
            //         'link' => $paylink.' (Detail du Versement)' ,
            //         'labeltype' => $labeltype ,
            //         'amount' => (-1*$objp->amount),
            //     );
            //     $TData['bl1'][] = $values;
            // }

            // if((empty($fac->array_options['options_bl1']) && !empty($fac->array_options['options_be1'])) || (empty($fac->array_options['options_be1']) && empty($fac->array_options['options_bl1'])) ){
            //     $values = array(
            //         'fk_paiement' => $objp->rowid,
            //         'fk_facture' => $objp->fk_fact,
            //         'date' => $db->jdate($objp->dp),
            //         'datefieldforsort' => $db->jdate($objp->dp).'-'.$fac->ref,
            //         'link' => $paylink.' (Detail du Versement)' ,
            //         'labeltype' => $labeltype ,
            //         'amount' => (-1*$objp->amount),
            //     );
            //     $TData['be1'][] = $values;
            // }
            

            $j++;
        }

        $db->free($resqlp);
    }
}

$TDataBL = array();
$TDataBE = array();
$totalqtyprod = array();
if (!empty($TData)) {
    
    $TData = dol_sort_array($TData, 'datefieldforsort', $sortorder);
    // $TDataBE = dol_sort_array($TData['be1'], 'datefieldforsort', $sortorder);

    $totalDebit = 0;
    $totalCredit = 0;
}

if ($limit > 0 && $limit != $conf->liste_limit) $param .= '&limit='.urlencode($limit);
if ($socid) $param .= '&socid='.urlencode($socid);

if ($debutday) $param .= '&debutday='.urlencode($debutday);
if ($debutmonth) $param .= '&debutmonth='.urlencode($debutmonth);
if ($debutyear) $param .= '&debutyear='.urlencode($debutyear);

if ($finday) $param .= '&finday='.urlencode($finday);
if ($finmonth) $param .= '&finmonth='.urlencode($finmonth);
if ($finyear) $param .= '&finyear='.urlencode($finyear);


if (!$user->rights->releveclient->lire || !$user->rights->releveclient->export) {
    accessforbidden();
}

$getcurrencysym = $langs->getCurrencySymbol($conf->currency);

$aftercomma = intval($conf->global->RELEVECLIENT_NUMBER_OF_DIGITS_AFTER_THE_DECIMAL_POINT);
$subtotaltext1 = ($conf->global->RELEVECLIENT_FIRST_SUB_TOTAL_TEXT) ? $conf->global->RELEVECLIENT_FIRST_SUB_TOTAL_TEXT : $langs->trans("totalbl1");
// $subtotaltext2 = ($conf->global->RELEVECLIENT_SECOND_SUB_TOTAL_TEXT) ? $conf->global->RELEVECLIENT_SECOND_SUB_TOTAL_TEXT : $langs->trans("totalbe1");

/*-------------PDF-----------------*/
// if ($action == "pdf" && GETPOST('actionpdf')) {
//     global $conf, $langs, $mysoc;
    
//     $Client = new Societe($db);

//     require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
//     require_once dol_buildpath('/releveclient/pdf/pdf.lib.php');
//     $pdf->SetMargins(7, 2, 7, false);
//     $pdf->SetFooterMargin(10);
//     $pdf->setPrintFooter(true);
//     $pdf->SetAutoPageBreak(TRUE,10);

//     $height=$pdf->getPageHeight();

//     $pdf->SetFont('helvetica', '', 9, '', true);
//     $pdf->AddPage('L');
//     $margint = $pdf->getMargins()['top'];
//     $marginb = $pdf->getMargins()['bottom'];
//     $marginl = $pdf->getMargins()['left'];
//     $object->fetch($id);
//     $item = $object;

//     $pdf->SetTextColor(0, 0, 60);

//     $default_font_size = 9;
//     $pdf->SetFont('', 'B', $default_font_size);
//     $posy   = $margint;
//     $posx   = $pdf->page_largeur-$pdf->getMargins()['right']-100;

//     $pdf->SetXY($marginl, $posy);

//     $pdf->SetXY($marginl, $posy);

//     $heightimg = 15;
//     if ($mysoc && $mysoc->logo)
//     {
//         $logodir = $conf->mycompany->dir_output;
//         if (empty($conf->global->MAIN_PDF_USE_LARGE_LOGO))
//         {
//             $logo = $logodir.'/logos/thumbs/'.$mysoc->logo_small;
//         }
//         else {
//             $logo = $logodir.'/logos/'.$mysoc->logo;
//         }
        
//         if (is_readable($logo))
//         {
//             $height = pdf_getHeightForLogo($logo);
//             $pdf->Image($logo, $marginl, $posy, 0, $heightimg); // width=0 (auto)
//         }
//         else
//         {
//             $pdf->SetTextColor(200, 0, 0);
//             $pdf->SetFont('', 'B', $default_font_size - 2);
//             $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorLogoFileNotFound", $logo), 0, 'L');
//             $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorGoToGlobalSetup"), 0, 'L');
//         }
//     }
//     else
//     {
//         $heightimg = 8;
//         $text = $mysoc->name;
//         $pdf->MultiCell(100, 4, $langs->convToOutputCharset($text), 0, 'L');
//     }

//     $posy = $margint + $heightimg + 2;

//     $pdf->SetTextColor(0, 0, 60);
//     $currentwate    = $conf->global->PAYROLLMOD_WATERMARK_IMG;
//     if($currentwate){
//         $bMargin = $pdf->getBreakMargin();
//         $auto_page_break = $pdf->getAutoPageBreak();
//         $pdf->SetAutoPageBreak(false, 0);
//         $img_file = $conf->mycompany->dir_output.'/watermark/'.$currentwate;
//         $pdf->SetAlpha(0.1);
//         $pdf->Image($img_file, 35, 100, 140, '', '', '', '', false, 300, '', false, false, 0);
//         $pdf->SetAlpha(1);
//         $pdf->SetAutoPageBreak(true, $bMargin);
//         $pdf->setPageMark();
//     }

//     $pdf->SetFont('', '', $default_font_size);

//     if($socid)
//         $Client->fetch($socid);


//     require_once dol_buildpath('/releveclient/pdf/pdf.lib.php');
//     require_once dol_buildpath('/releveclient/pdf/relevefourn_pdf.php');
//     $pdf->writeHTML($html, true, false, true, false, '');
//     ob_start();
//     $namemod=$langs->trans('releveclient');
//     $pdf->Output($namemod.'.pdf', 'I');
//     die();
// }

if ($actionpdf) {
    
    $client = new Societe($db);
    $client->fetch($socid);

    require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
    require_once dol_buildpath('/releveclient/pdf/pdf.lib.php');
    // $pdf->SetMargins(7, 2, 7, false);
    // $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetMargins(7, PDF_MARGIN_TOP, 7);
    $pdf->SetFooterMargin(15);
    $pdf->setPrintFooter(true);
    $pdf->SetAutoPageBreak(TRUE,15);

    $height=$pdf->getPageHeight();

    $pdf->SetFont('helvetica', '', 9, '', true);
    $pdf->AddPage('P');
    $margint = $pdf->getMargins()['top'];
    $marginb = $pdf->getMargins()['bottom'];
    $marginl = $pdf->getMargins()['left'];

    $pdf->SetTextColor(0, 0, 60);
    $emetteur = $mysoc;

    $default_font_size = 9;
    $pdf->SetFont('', 'B', $default_font_size);
    $posy   = $margint;
    $posx   = $pdf->page_largeur-$pdf->getMargins()['right']-100;


    $marge_droite = 5;
    $marge_gauche = 5;
    $outputlangs = $langs;
    $formatarray = pdf_getFormat();
    $page_largeur = $formatarray['width'];
    $page_hauteur = $formatarray['height'];
    $border_style = array('width' => 0.1, 'cap' => 'butt', 'join' => 'miter', 'dash' => '8, 3');
    $format = array($ppage_largeur, $page_hauteur);
    $marge_gauche = isset($conf->global->MAIN_PDF_MARGIN_LEFT) ? $conf->global->MAIN_PDF_MARGIN_LEFT : 10;
    $marge_droite = isset($conf->global->MAIN_PDF_MARGIN_RIGHT) ? $conf->global->MAIN_PDF_MARGIN_RIGHT : 10;
    $marge_haute = isset($conf->global->MAIN_PDF_MARGIN_TOP) ? $conf->global->MAIN_PDF_MARGIN_TOP : 10;
    $marge_basse = isset($conf->global->MAIN_PDF_MARGIN_BOTTOM) ? $conf->global->MAIN_PDF_MARGIN_BOTTOM : 10;
    $dashdotted = 0;
    $receiptstyle = 5;
    $senderstyle  = "FD";
    $receiptstyle = "S";
    $bgcolor = array(62, 214, 208);
    $bordercolor = array(0, 63, 127);
    $opacity = 0.5;
    $roundradius = 1;
    $textcolor = array(25, 25, 25);
    $qrcodecolor = array(25, 25, 25);


    $tab_width = $page_largeur - $marge_gauche - $marge_droite;
    $pdf->SetXY($marginl, $posy);
    $ltrdirection = 'L';
    if ($outputlangs->trans("DIRECTION") == 'rtl') $ltrdirection = 'R'; 


    $heightimg = 15;
    if ($mysoc && $mysoc->logo)
    {
        $logodir = $conf->mycompany->dir_output;
        if (empty($conf->global->MAIN_PDF_USE_LARGE_LOGO)) {
            $logo = $logodir . '/logos/thumbs/' . $emetteur->logo_small;
        } else {
            $logo = $logodir . '/logos/' . $emetteur->logo;
        }
        if (is_readable($logo)) {
            $logo_height = max(pdf_getReleveHeightForLogo($logo, true), 20);
            $pdf->Image($logo, $marge_gauche, $posy, 0, $logo_height);    // width=0 (auto)
        } else {
            $pdf->SetTextColor(200, 0, 0);
            $pdf->SetFont('', 'B', $default_font_size - 2);
            $pdf->RoundedRect($marge_gauche, $marge_haute, 100, 20, $roundradius, '1111', $senderstyle, $border_style, $bgcolor);
            $pdf->MultiCell(100, 3, $outputlangs->transnoentities("ErrorLogoFileNotFound", $logo), 0, 'L');
            $pdf->MultiCell(100, 3, $outputlangs->transnoentities("ErrorGoToGlobalSetup"), 0, 'L');
        }
    }else
    {
        $heightimg = 8;
        $text = $mysoc->name;
        $pdf->MultiCell(100, 4, $langs->convToOutputCharset($text), 0, 'L');
    }

    // $contacts = $client->contact_array_objects();
    // $contact = $contacts[0];

    // $contactlist = $object->liste_contact(-1, 'external');
    // $contactobj = new stdClass();

    // foreach ($contactlist as $_key => $arrcontact) {
    //     if(isset($arrcontact['code']) && $arrcontact['code'] == 'SHIPPING') {
    //         $contactobj = new Contact($db);
    //         $contactobj->fetch($arrcontact['id']);
    //         break;
    //     }
    // }

        $posx = $marginl;
        $posy += 2;
        $pdf->SetXY($posx, $posy);
        $pdf->MultiCell($page_largeur - $marge_droite - $marge_gauche, 5, $outputlangs->transnoentities("relevefourn").' '.$client->name, 0, 'R', false);
        // $pdf->writeHTMLCell($page_largeur, 8, $posx, $posy + 2, dol_string_nohtmltag($outputlangs->transnoentities("titlemodelreleve").' '.$client->name), 0, 1, 0, true, 'R', true);

        $posy = $pdf->GetY();



        // if ($showaddress) {
            // Customer and Sender properties           
            // Sender properties
            $carac_emetteur = '';
            // Add internal contact of origin element if defined
            $arrayidcontact = array();
            // if (!empty($origin) && is_object($object->$origin)) $arrayidcontact = $object->$origin->getIdContact('internal', 'SALESREPFOLL');
            // if (count($arrayidcontact) > 0) {
            //     $object->fetch_user($arrayidcontact[0]);
            //     $labelbeforecontactname = ($outputlangs->transnoentities("FromContactName") != 'FromContactName' ? $outputlangs->transnoentities("FromContactName") : $outputlangs->transnoentities("Name"));
            //     $carac_emetteur .= ($carac_emetteur ? "\n" : '') . $labelbeforecontactname . " " . $outputlangs->convToOutputCharset($object->user->getFullName($outputlangs)) . "\n<br>" . $object->user->email . "\n<br>";
            // }
            // Sender properties
            $carac_emetteur .= pdf_element_build_address($outputlangs, $emetteur, $client, '', 0, 'source', $object);
            // $carac_emetteur = pdf_build_address($outputlangs, $emetteur, $client, '', 0, 'source', $object);


            // Show sender
            $posy = $logo_height + $marge_haute + 4;
            $posx = $marge_gauche;
            //Set $hautcadre
            if (!empty($conf->global->ULTIMATE_PDF_SHIPPING_ADDALSOTARGETDETAILS) &&($conf->global->ULTIMATE_PDF_SHIPPING_ADDALSOTARGETDETAILS == 1) || (!empty($conf->global->MAIN_INFO_SOCIETE_NOTE) && !empty($emetteur->note_private)) || (!empty($conf->global->MAIN_INFO_TVAINTRA) && !empty($emetteur->tva_intra))) {
                $hautcadre = 48;
            } else {
            }
            $hautcadre = 40;
            $widthrecbox = $conf->global->ULTIMATE_WIDTH_RECBOX - 2;
            // $posx = $page_largeur - $marge_droite - $widthrecbox;
            $widthrecbox = 110;    
            $widthrecboxrecipient = 80;

            $hreceipt = $hautcadre * 0.5;
            $wreceipt = $widthrecboxrecipient;
            $posxba = $page_largeur - $marge_droite - $widthrecboxrecipient;
            $posxbb = $posx - 4 + $wreceipt;
            $posxbc = $posxba;
            $posyba = $posy - 0.5;
            $posybc = $logo_height + $marge_haute + 4 + $hreceipt;
            $posybd = $logo_height + $marge_haute + 8 + $hreceipt;
            $textcolor=array(25, 25, 25);
            if ($roundradius == 0) {
                $roundradius = 0.1; //RoundedRect don't support $roundradius to be 0
            }
            $pdf->SetXY($posx, $posy);

            $bordercolor = array(0, 63, 127);
            $border_style = array('width' => 0.2, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => $bordercolor);
            // Show sender frame
            $pdf->SetTextColorArray($textcolor);
            $pdf->SetFillColorArray($bgcolor);
            $pdf->SetFont('', '', $default_font_size - 1);
            // $pdf->SetAlpha($opacity);
            $pdf->SetAlpha(1);
            $pdf->RoundedRect($posx-2, $posy, $widthrecbox, $hautcadre, $roundradius, '1111', $senderstyle, $border_style, $bgcolor);

            // Show sender name
            $pdf->SetXY($posx, $posy + 3);
            $pdf->SetFont('', 'B', $default_font_size - 1);
            // $pdf->SetFillColor(255, 255, 255);
            $pdf->SetTextColorArray($textcolor);
            $pdf->MultiCell($widthrecbox - 5, 4, $outputlangs->convToOutputCharset($emetteur->name), 0, 'L');

            $posy = $pdf->GetY()+2;

            // Show sender information
            $pdf->SetFont('', '', $default_font_size - 1);
            $pdf->SetXY($posx, $posy);
            $pdf->writeHTMLCell($widthrecbox - 5, 4, $posx, $posy, $carac_emetteur, 0, 2, 0, true, $ltrdirection, true);
            $posy = $pdf->GetY()+2;

            // Show private note from societe
            if (!empty($conf->global->MAIN_INFO_SOCIETE_NOTE) && !empty($emetteur->note_private)) {
                $pdf->SetFont('', '', $default_font_size - 1);
                $pdf->SetXY($posx + 2, $posy);
                $pdf->writeHTMLCell($widthrecbox - 5, 8, $posx, $posy + 2, dol_string_nohtmltag($emetteur->note_private), 0, 1, 0, true, $ltrdirection, true);
            }

            $posy = $pdf->GetY()+2;
            // If SHIPPING and BILLING contact defined, we use it
            // if ($object->getIdContact('external', 'BILLING') && $object->getIdContact('external', 'SHIPPING')) {
                // If BILLING contact defined on invoice, we use it
                $usecontact = false;
                // $arrayidcontact = $object->getIdContact('external', 'BILLING');
                // if (count($arrayidcontact) > 0); {
                //     $usecontact = true;
                //     $result = $object->fetch_contact($arrayidcontact[0]);
                // }

                // Recipient name
                // On peut utiliser le nom de la societe du contact
                // if ($usecontact && ($object->contact->fk_soc != $client->id && (!isset($conf->global->MAIN_USE_COMPANY_NAME_OF_CONTACT) || !empty($conf->global->MAIN_USE_COMPANY_NAME_OF_CONTACT)))) {
                //     $thirdparty = $object->contact;
                // } else {
                // }
                $carac_client_name = pdfBuildThirdpartyName($client, $outputlangs);

                // Recipient address
                $mode =  'target';
                // $carac_client = pdf_build_address($outputlangs, $emetteur, $client, ($usecontact ? $client->contact : ''), $usecontact, $mode, $client);
                $carac_client = pdf_element_build_address($outputlangs, $emetteur, $client, ($usecontact ? $client->contact : ''), $usecontact, $mode, $client, true);

                // Show recipient
                $posy = $logo_height + $marge_haute + 4;
                $posx = $page_largeur - $marge_droite - $widthrecboxrecipient ;
                // $posx = $marge_gauche;
                // $pdf->SetXY($posx + 2, $posy);

                // Show recipient frame
                $pdf->SetTextColorArray($textcolor);
                $pdf->SetFont('', '', $default_font_size - 2);

                // Show invoice address
                // $pdf->SetAlpha($opacity);
                $pdf->SetAlpha(1);
                $pdf->RoundedRect($posx, $posy, $wreceipt, $hautcadre, $roundradius, '1111', 'S', $style, $bgcolor);
                $pdf->SetXY($posxba, $posyba);
                // $pdf->MultiCell($widthrecboxrecipient, 4, $outputlangs->transnoentities("BillAddress"), 0, 'L');

                // Show recipient name
                $pdf->SetXY($posx + 2, $posy + 2);
                $pdf->SetFont('', 'B', $default_font_size);
                $pdf->MultiCell($wreceipt - 5, 4, $carac_client_name, 0, $ltrdirection);

                $posy = $pdf->getY();

                // Show recipient information
                $pdf->SetFont('', '', $default_font_size - 1);
                $pdf->SetXY($posx + 2, $posy);
                $pdf->writeHTMLCell($wreceipt - 5, 4, $posx + 2, $posy, $carac_client, 0, 2, 0, true, $ltrdirection, true);


                $posy = $pdf->GetY();
            // Other informations
            // $pdf->SetFillColor(255, 255, 255);

            // Date debut
            $width = $tab_width / 5 - 2;
            $RoundedRectHeight = $marge_haute + $logo_height + $hautcadre + 10;
            // $pdf->SetAlpha($opacity);
            $pdf->RoundedRect($marge_gauche, $RoundedRectHeight, $width, 6, $roundradius, '1001', 'FD', $style, $bgcolor);
            $pdf->SetAlpha(1);
            $pdf->SetFont('', 'B', $default_font_size - 2);
            $pdf->SetXY($marge_gauche, $RoundedRectHeight+1);
            // $pdf->SetTextColorArray($textcolor);
            $pdf->MultiCell($width, 5, $outputlangs->transnoentities("DateStart"), 0, 'C', false);

            $pdf->SetFont('', '', $default_font_size - 2);
            $pdf->SetXY($marge_gauche, $RoundedRectHeight+7);
            $pdf->SetTextColorArray($textcolor);
            $pdf->MultiCell($width, 4, dol_print_date($debut, "day"), '0', 'C');

            // Date fin
            // $pdf->SetAlpha($opacity);
            $pdf->RoundedRect($marge_gauche + $width + 2, $RoundedRectHeight, $width, 6, $roundradius, '1001', 'FD', $style, $bgcolor);
            $pdf->SetAlpha(1);
            $pdf->SetFont('', 'B', $default_font_size - 2);
            $pdf->SetXY($marge_gauche + $width + 2, $RoundedRectHeight+1);
            $pdf->SetTextColorArray($textcolor);
            $pdf->MultiCell($width, 5, $outputlangs->transnoentities("DateEnd"), 0, 'C', false);

            $pdf->SetFont('', '', $default_font_size - 2);
            $pdf->SetXY($marge_gauche + $width + 2, $RoundedRectHeight+7);
            $pdf->SetTextColorArray($textcolor);
            $pdf->MultiCell($width, 6, dol_print_date($fin, "day"), '0', 'C');

            // Genrer par
            $width = $tab_width / 5 - 1.5;

            // $pdf->SetAlpha($opacity);
            $pdf->RoundedRect($marge_gauche + $width*2 + 4, $RoundedRectHeight, $tab_width / 4, 6, $roundradius, '1001', 'FD', $style, $bgcolor);
            $pdf->SetAlpha(1);
            $pdf->SetFont('', 'B', $default_font_size - 2);
            $pdf->SetXY($marge_gauche + $width*2 + 8, $RoundedRectHeight+1);
            $pdf->SetTextColorArray($textcolor);
            $pdf->MultiCell($width, 5, $outputlangs->transnoentities("genererby"), 0, 'C', false);

            $pdf->SetFont('', '', $default_font_size - 2);
            $pdf->SetXY($marge_gauche + $width*2 + 8, $RoundedRectHeight+7);
            $pdf->SetTextColorArray($textcolor);
            $pdf->MultiCell($width, 6, $user->getFullname($langs), '0', 'C');
            if($user->office_phone){
                $pdf->SetXY($marge_gauche + $width*2 + 8, $RoundedRectHeight + 10);
                $pdf->MultiCell($width, 6, $user->office_phone, '0', 'C');
            }

            // Date Expedition
            // $pdf->SetAlpha($opacity);
            $pdf->RoundedRect($marge_gauche + $width*3 + 18, $RoundedRectHeight, $width, 6, $roundradius, '1001', 'FD', $style, $bgcolor);
            $pdf->SetAlpha(1);
            $pdf->SetFont('', 'B', $default_font_size - 2);
            $pdf->SetXY($marge_gauche + $marge_gauche + $width*3 + 6, $RoundedRectHeight+1);
            $pdf->SetTextColorArray($textcolor);
            $pdf->MultiCell($width, 5, $outputlangs->transnoentities("SupplierCode"), 0, 'C', false);

            $pdf->SetFont('', '', $default_font_size - 2);
            $pdf->SetXY($marge_gauche + $width*3 + 18, $RoundedRectHeight+7);
            $pdf->SetTextColorArray($textcolor);
            $pdf->MultiCell($width, 6, $client->code_fournisseur, '0', 'C');

         

    $posy = $pdf->GetY()+2;
    $pdf->SetFont('', '', $default_font_size - 2);

    if($socid && $debut && $fin) $posy=$pdf->GetY()+2;
    $pdf->SetXY($marginl, $posy);


    $pdf->SetTextColor(0, 0, 60);


    require_once dol_buildpath('/releveclient/pdf/pdf.lib.php');
    // require_once dol_buildpath('/releveclient/pdf/releve_pdf.php');
    require_once dol_buildpath('/releveclient/pdf/relevefourn_xsl.php');

    // die($html);

    $pdf->writeHTML($html, true, false, true, false, '');
    ob_start();
    $db->close();
    $pdf->Output($filename.'.pdf', 'I');
    die();
}



if(GETPOST('exportxsl')){

    $html = '';
    $Client = new Societe($db);

    if($socid)
        $Client->fetch($socid);

    $filename="Releve_Fournisseur.xls";
    require_once dol_buildpath('/releveclient/pdf/relevefourn_xsl.php');
    header("Content-Type: application/xls");
    header("Content-Disposition: attachment; filename=".$filename."");
    echo $html;
    die(); 
}
// if(dolibarr_get_const($db, strtoupper('releveclient_fields'),$conf->entity)){
//     $data_ef = dolibarr_get_const($db, strtoupper('releveclient_fields'),$conf->entity);
//     $data_ef = explode(',', $data_ef);
// }

// if(GETPOST('exportxsl')){

//     $html = '';
//     $Client = new Societe($db);

//     if($socid)
//         $Client->fetch($socid);

//     $filename='Releve_client.xls';
//     require_once dol_buildpath('/releveclient/pdf/releve_pdf.php');
//     header('Content-Type: application/xls');
//     header('Content-Disposition: attachment; filename='.$filename);
//     echo $html;
//     die(); 
// }


$morejs  = array();
llxHeader(array(), $modname,'','','','',$morejs,0,0);

echo load_fiche_titre($modname);

$head = releve_prepare_head();
echo dol_get_fiche_head($head, 'relevefourn', $langs->trans('relevefourn'), -1, 'invoice');

echo '<div id="stclient" class="div-table-responsive">';
    echo '<form  method="POST" action="'.$_SERVER['PHP_SELF'].'" >';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        echo '<table class="noborder">';
            echo '<input type="hidden" name="action" value="generer">';
            echo '<tr>';
                echo '<td colspan="3">'.$langs->trans('Period');
                    echo ' &nbsp;&nbsp;&nbsp;&nbsp;'.$langs->trans("From").' '.$form->selectDate($srch_debut, 'debut', 0, 0, 1, '', 1, 1);
                // echo '</td>';
                // echo '<td colspan="2">';
                    echo '&nbsp;&nbsp;';
                    echo $langs->trans("To").' '.$form->selectDate($srch_fin, 'fin', 0, 0, 1, '', 1, 1);
                echo '</td>';
            echo '</tr>'; 
            echo '<tr>';
                echo '<td>'.$langs->trans('Customer');
                    // echo $form->select_company($socid, 'socid', '((s.client = 1 OR s.client = 3) AND s.status=1)', 'SelectThirdParty', 0, 0, null, 0, 'minwidth300');
                    print $form->select_company($socid, 'socid', '(s.fournisseur=1 AND s.status=1)', 'SelectThirdParty', 0, 0, null, 0, 'minwidth300');

                    // Option to reload page to retrieve customer informations. Note, this clear other input
                    if (!empty($conf->global->RELOAD_PAGE_ON_CUSTOMER_CHANGE))
                    {
                        echo '<script type="text/javascript">
                            $(document).ready(function() {
                                $("#socid").change(function() {
                                    var socid = $(this).val();
                                    var fac_rec = $(\'#fac_rec\').val();
                                    // reload page
                                    window.location.href = "'.$_SERVER["PHP_SELF"].'?action=create&socid="+socid+"&fac_rec="+fac_rec;
                                });
                            });
                        </script>';
                    }
                    if (!GETPOST('fac_rec', 'int')) 
                        echo ' <a href="'.DOL_URL_ROOT.'/societe/card.php?action=create&client=3&fournisseur=0&backtopage='.urlencode($_SERVER["PHP_SELF"].'?action=create').'"><span class="fa fa-plus-circle valignmiddle paddingleft" title="'.$langs->trans("AddThirdParty").'"></span></a>';
                echo '</td><td>';
                    if($socid && $debut && $fin){
                        $datesd=date('d/m/Y', strtotime($debut.' - 1 DAY'));
                        $text = $langs->trans("soldedebitair").' '.$datesd.':  '.price($solde, 0, $langs, 1, $aftercomma).' '.$getcurrencysym;
                        echo $text;
                    }
                echo '</td><td>';
                    echo '<a href="'.dol_buildpath('/releveclient/releve_fourn.php',2).'" class="butAction" style="padding-top: 0.4em; float:right">'.$langs->trans("Reset").'</a>';
                    echo '<input style="margin-top:0px; float:right" type="submit" value="'.$langs->trans("generetat").'" name="exportpdf" class="button" />';
                echo '</td>';

            echo '</tr>'."\n";
        echo '</table>';
    echo '</form>';
        
    echo '<br>';
    
    echo '<form  method="POST" action="'.$_SERVER['PHP_SELF'].'">';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        echo '<input type="hidden" name="fk_account" value="'.$fk_account.'">';
        echo '<input type="hidden" name="socid" value="'.$socid.'">';
        echo '<input type="hidden" name="debut" value="'.$debut.'">';
        echo '<input type="hidden" name="fin" value="'.$fin.'">';
        echo '<input name="pagem" type="hidden" value="'.$page.'">';
        echo '<input name="offsetm" type="hidden" value="'.$offset.'">';
        echo '<input name="limitm" type="hidden" value="'.$limit.'">';
        echo '<input name="filterm" type="hidden" value="'.$filter.'">';
        echo '<input name="action" type="hidden" value="pdf">';

        echo '<input type="hidden" name="finday" value="'.$finday.'">';
        echo '<input type="hidden" name="finyear" value="'.$finyear.'">';
        echo '<input type="hidden" name="finmonth" value="'.$finmonth.'">';

        echo '<input type="hidden" name="debutday" value="'.$debutday.'">';
        echo '<input type="hidden" name="debutyear" value="'.$debutyear.'">';
        echo '<input type="hidden" name="debutmonth" value="'.$debutmonth.'">';

        $object = new FactureFournisseur($db);
        $dt_extrafield = $extrafields->fetch_name_optionals_label($object->table_element);
        $label=$extrafields->attributes[$object->table_element]['label'];

        if(dolibarr_get_const($db, strtoupper('relevefourn_fields'),$conf->entity)){
            $data_ef = dolibarr_get_const($db, strtoupper('relevefourn_fields'),$conf->entity);
            $data_ef = explode(',', $data_ef);
        }

        $massactionbutton = '';
        $massactionbutton .= '<input name="actionpdf" type="submit" id="btn_pdf" formtarget="_blank" class="butAction" value="'.$langs->trans('generpdf').'" >';
        $massactionbutton.= '<input type="submit" value="'.$langs->trans("generxsl").'" name="exportxsl" class="butAction" />';

        print_barre_liste('', $page, $_SERVER["PHP_SELF"], $param, $sortfield, $sortorder, '', $num, $nbtotalofrecords, '', 0, $massactionbutton, '', $limit, 0, 0, 1);

        echo '<table class="noborder" id="releveclient">';
            $clsp=0;
            echo '<tr class="liste_titre_filter">';
                print_liste_field_titre($langs->trans("Date"), $_SERVER["PHP_SELF"], "f.datef", '', $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("Label"), $_SERVER["PHP_SELF"], "", '', $param, 'align="left" ', $sortfield, $sortorder);
                if($data_ef && count($data_ef)>0){
                    $nbef = count($data_ef); 
                    foreach ($data_ef as $key => $value) {
                        // if($label && count($label)>0 && array_key_exists($value,$label)){
                        if($label && count($label)>0 && isset($label[$value])){
                            echo '<td align="left">'.$label[$value].'</td>';
                            $clsp++;
                        }
                    }
                }

                echo '<th class="lines_fact">';
                    echo '<table class="border">';
                        echo '<tr class="liste_titre_filter">';
                            echo '<th class="wrapcolumntitle liste_titre tdlabeltable">'.$langs->trans("product").'</th>';
                            echo '<th class="wrapcolumntitle liste_titre tdqtytable">'.$langs->trans("Quantity").'</th>';
                            echo '<th class="wrapcolumntitle liste_titre tdamounttable">'.$langs->trans("PriceUHT").'</th>';
                        echo '</tr>';
                    echo '</table>';
                echo '</th>';

                print_liste_field_titre($langs->trans("debitreleve"), $_SERVER["PHP_SELF"], "", "", $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("creditreleve"), $_SERVER["PHP_SELF"], "", "", $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("Solde"), $_SERVER["PHP_SELF"], "", "", $param, 'align="center"', $sortfield, $sortorder);
            echo '</tr>';
            $colsptotal = 2+$clsp;

            $totalgdebit    = 0;
            $totalgcredit   = 0;
            $totalgqty      = 0;
            $lastbalance    = $solde;

            if($TData && count($TData)>0 && $socid){
                $var = 1;
                $classes =[0=>'trnocolor', 1=>'trcolor'];
                $totalDebit     = 0;
                $totalCredit    = 0;
                $totalqty       = 0;

                $l = 0;
                $class = '';
                foreach ($TData as $key => $data) {
                    $colspan = '';
                    $rowspan = '';
                    $var = !$var;
                    $totalp = 0;
                    
                    if($key === 0)
                        $balance = $solde-$data['amount'];
                    else
                        $balance = $lastbalance - $data['amount'];

                    $lastbalance = $balance;
                    $l++;

                    $boldcls = '';
                    if(empty($data['fk_paiement']) && $data['fk_facture']) {
                        $boldcls = 'boldtext';
                        // $fact = new Facture($db);
                        // $fact->fetch($data['fk_facture']);
                        $fact = $arrainvoics[$data['fk_facture']];
                    }

                    echo '<tr class="'.$classes[$var].'">';

                        echo '<td align="center" class="'.$boldcls.'" >'.dol_print_date($data['date'], 'day').'</td>';
                        if($data['fk_paiement']){
                            $colspan='colspan="'.($clsp+2).'"';
                        } 
                        echo '<td align="left" '.$colspan.' >';
                            echo $data['link'];
                            if($data['fk_paiement']){
                                // $objpaym = new Paiement($db);
                                // $objpaym->fetch($data['fk_paiement']);
                                // $labeltype = $langs->trans("PaymentType".$objpaym->type_code) != ("PaymentType".$objpaym->type_code) ? $langs->trans("PaymentType".$objpaym->type_code) : $objpaym->type_label;
                                $labeltype = $data['labeltype'];
                                echo ' - '.$labeltype;
                            }
                        echo '</td>';

                        if(empty($data['fk_paiement'])){
                            if($data['fk_facture']){
                                // $fact = new Facture($db);
                                // $fact->fetch($data['fk_facture']);
                                if($data_ef && count($data_ef)>0){
                                    foreach ($data_ef as $key => $value) {
                                        echo '<td align="left">';
                                            echo $extrafields->showOutputField($value, $fact->array_options['options_'.$value], '', $object->table_element);
                                            // echo $fact->array_options['options_'.$value];
                                        echo '</td>';
                                    }
                                }
                            }
                        }
                        if($data['lignes'] && count($data['lignes'])>0){
                            echo '<td class="lines_fact">';
                                foreach ($data['lignes'] as $key => $value) {
                                    $totalqtyprod[$value['type']] += $value['qty'];
                                    echo '<table class="border" >';
                                        echo '<tr>';
                                            if($data['fk_facture'] && $data['lignes'] && count($data['lignes'])>0){
                                                // $ligne = $data['lignes'][0]; 
                                                $ligne = $value; 
                                                echo '<td align="left" class="tdlabeltable">'.$ligne['label'].'</td>';
                                                echo '<td align="center" class="tdqtytable" >'.$ligne['qty'].'</td>';
                                                $totalqty+=$ligne['qty'];
                                                echo '<td align="right" class="tdamounttable amount">'.price($ligne['amount'], 0, $langs, 1, $aftercomma).'</td>';
                                            }else{
                                                echo '<td align="center"></td>';
                                                echo '<td align="center"></td>';
                                            }
                                            // if($data['fk_facture'] && empty($data['lignes']) && empty($data['fk_paiement'])) echo '<td align="center"></td>';
                                        echo '</tr>';
                                    echo '</table>';
                                }
                            echo '</td>';
                        }elseif(empty($data['fk_paiement'])) {
                            echo '<td></td>';   
                        }
                        // else echo '<td></td>';

                        echo '<td class="right amount">'.(($data['amount'] > 0) ? price($data['amount'], 0, $langs, 1, $aftercomma) : '').'</td>';
                        echo '<td class="right amount">';
                        
                            if($data['amount'] < 0) {
                                $totalp= (-1)*$data['amount'];
                            }
                            if($totalp)
                                echo price($totalp, 0, $langs, 1, $aftercomma);
                            
                        echo '</td>';
                        $amountsold = ($balance < 0) ? (-1)*$balance : $balance;
                        $totalsoldbl = $amountsold;
                        if($l == count($TData)) $class = 'colorsold';
                        echo '<td class="colorsold" align="right" >'.price($amountsold, 0, $langs, 1, $aftercomma).'</td>';
                    echo '</tr>';

                    $totalDebit += ($data['amount'] > 0) ? abs($data['amount']) : 0;
                    $totalCredit += ($data['amount'] > 0) ? 0 : abs($data['amount']);
                }

                $totalgdebit    += $totalDebit;
                $totalgcredit   += $totalCredit;
                $totalgqty      += $totalqty;

                // echo '<tr class="liste_total soustotal">';
                //     echo '<td colspan="'.$colsptotal.'">'.$subtotaltext1.'</td>';
                //     echo '<td class="lines_fact">';
                //         echo '<table class="border" >';
                //             echo '<tr class="liste_total soustotal">';
                //                 echo '<td class="tdlabeltable"></td>';
                //                 echo '<td class="tdqtytable" align="right">'.$totalqty.'</td>';
                //                 echo '<td class="tdamounttable"></td>';
                //             echo '</tr>';
                //         echo '</table>';
                //     echo '</td>';
                //     echo '<td align="right">'.price($totalDebit, 0, $langs, 1, $aftercomma).' '.$getcurrencysym.'</td>';
                //     echo '<td align="right">'.price($totalCredit, 0, $langs, 1, $aftercomma).' '.$getcurrencysym.'</td>';
                //     $minustoadd = ($totalgdebit-$totalgcredit) < 0 ? '-' : '';
                //     echo '<td class="colorsold" align="right">'.price($amountsold, 0, $langs, 1, $aftercomma).' '.$getcurrencysym.'</td>';
                // echo '</tr>';
            }

            if($TData){
                $totalsold = $totalsoldbl+$totalsoldbe;
                echo '<tr class="liste_total totalglobal">';
                    echo '<td colspan="'.$colsptotal.'">'.$langs->trans("Total").'</td>';

                     echo '<td class="lines_fact">';
                        echo '<table class="border" >';
                            echo '<tr class="liste_total totalglobal">';
                                echo '<td class="tdlabeltable"></td>';
                                echo '<td class="tdqtytable" align="right">'.$totalgqty.'</td>';
                                echo '<td class="tdamounttable"></td>';
                            echo '</tr>';
                        echo '</table>';
                    echo '</td>';

                    echo '<td align="right">'.price($totalgdebit, 0, $langs, 1, $aftercomma).' '.$getcurrencysym.'</td>';
                    echo '<td align="right">'.price($totalgcredit, 0, $langs, 1, $aftercomma).' '.$getcurrencysym.'</td>';
                    $minustoadd = ($totalgdebit-$totalgcredit) < 0 ? '-' : '';
                    echo '<td class="colorsold" align="right">'.$minustoadd.price($amountsold, 0, $langs, 1, $aftercomma).' '.$getcurrencysym.'</td>';
                echo '</tr>';
            }
            else{
                $clsptotal = $colsptotal+5;
                echo '<tr><td align="center" colspan="'.$clsptotal.'" >'.$langs->trans("NoRecordFound").'</td></tr>';
            }
        echo '</table>';
    echo '</form>';

    echo '<br><br>';
echo  '</div>';

dol_fiche_end();

llxFooter();
$db->close();
