<?php
/* Copyright (C) 2006-2015	Laurent Destailleur	<eldy@users.sourceforge.net>
 * Copyright (C) 2015-2016	Alexandre Spangaro	<aspangaro@open-dsi.fr>
 * Copyright (C) 2015		Raphaël Doursenaud	<rdoursenaud@gpcsolutions.fr>
 * Copyright (C) 2017		Regis Houssin		<regis.houssin@inodbox.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 * or see https://www.gnu.org/
 */

/**
 *	    \file       htdocs/core/lib/member.lib.php
 *		\brief      Functions for module members
 */

/**
 *  Return array head with list of tabs to view object informations
 *
 *  @param	Adherent	$object		Member
 *  @return array					head
 */

function releve_prepare_head()
{
	global $langs, $conf, $user;


	$h = 0;
	$head = array();
    $langs->load('releveclient@releveclient');

	$head[$h][0] = dol_buildpath('/releveclient/releve.php', 2);
	$head[$h][1] = $langs->trans("releveclient");
	$head[$h][2] = 'releveclient';
	$h++;

	$head[$h][0] = dol_buildpath('/releveclient/releve_fourn.php', 2);
	$head[$h][1] = $langs->trans('relevefourn');
	$head[$h][2] = 'relevefourn';
	$h++;


	if (!empty($conf->global->RELEVE_ASSOCIE_DEBITCREDIT)) {
		$head[$h][0] = dol_buildpath('/releveclient/releve_assoc.php', 2);
		$head[$h][1] = $langs->trans('assoc_debit');
		$head[$h][2] = 'assoc_debit';
		$h++;
	}

	return $head;
}
function relevesetup_prepare_head()
{
	global $langs, $conf, $user;


	$h = 0;
	$head = array();
    $langs->load('releveclient@releveclient');

	$head[$h][0] = dol_buildpath('/releveclient/admin/releveclient_setup.php?tab=client', 2);
	$head[$h][1] = $langs->trans("releveclient");
	$head[$h][2] = 'releveclient';
	$h++;

	$head[$h][0] = dol_buildpath('/releveclient/admin/releveclient_setup.php?tab=fourn', 2);
	$head[$h][1] = $langs->trans('relevefourn');
	$head[$h][2] = 'relevefourn';
	$h++;

	$head[$h][0] = dol_buildpath('/releveclient/admin/releveclient_setup.php?tab=assoc_debit', 2);
	$head[$h][1] = $langs->trans('assoc_debit');
	$head[$h][2] = 'releveassoc_debit';
	$h++;

	return $head;
}

function pdf_getRelveHeightForLogo($logo, $url = false, $maxwidth=100)
{
	global $conf;

	include_once DOL_DOCUMENT_ROOT . "/core/lib/pdf.lib.php";
	
	$logo_height = $conf->global->MAIN_DOCUMENTS_LOGO_HEIGHT ? $conf->global->MAIN_DOCUMENTS_LOGO_HEIGHT : 30;

	include_once DOL_DOCUMENT_ROOT . '/core/lib/images.lib.php';
	$tmp = dol_getImageSize($logo, $url);
	if ($tmp['height']) {
		$width = round($logo_height * $tmp['width'] / $tmp['height']);
		if ($width > $maxwidth) $logo_height = $logo_height * $maxwidth / $width;
	}
	//print $tmp['width'].' '.$tmp['height'].' '.$width; exit;
	if ($logo_height > 40) $logo_height = 40;
	return $logo_height;
}

function pdf_getReleveHeightForLogo($logo, $url = false)
{
	global $conf;

	include_once DOL_DOCUMENT_ROOT . "/core/lib/pdf.lib.php";
	$formatarray = pdf_getFormat();
	$page_largeur = $formatarray['width'];
	$marge_gauche = isset($conf->global->ULTIMATE_PDF_MARGIN_LEFT) ? $conf->global->ULTIMATE_PDF_MARGIN_LEFT : 10;
	$marge_droite = isset($conf->global->ULTIMATE_PDF_MARGIN_RIGHT) ? $conf->global->ULTIMATE_PDF_MARGIN_RIGHT : 10;
	$logo_height = isset($conf->global->ULTIMATE_LOGO_HEIGHT) ? $conf->global->ULTIMATE_LOGO_HEIGHT : 30;
	$maxwidth = ($page_largeur - $marge_gauche - $marge_droite) / 2;

	include_once DOL_DOCUMENT_ROOT . '/core/lib/images.lib.php';
	$tmp = dol_getImageSize($logo, $url);
	if ($tmp['height']) {
		$width = round($logo_height * $tmp['width'] / $tmp['height']);
		if ($width > $maxwidth) $logo_height = $logo_height * $maxwidth / $width;
	}
	//print $tmp['width'].' '.$tmp['height'].' '.$width; exit;
	if ($logo_height > 40) $logo_height = 40;
	return $logo_height;
}

/**
 * Return height to use for OtherLogo onto PDF
 *
 * @param	string		$logo		Full path to logo file to use
 * @param	bool		$url		Image with url (true or false)
 * @return	number
 */
function pdf_getReleveHeightForOtherLogo($otherlogo, $url = false)
{
	global $conf;

	include_once DOL_DOCUMENT_ROOT . "/core/lib/pdf.lib.php";
	$formatarray = pdf_getFormat();
	$page_largeur = $formatarray['width'];
	$marge_gauche = isset($conf->global->ULTIMATE_PDF_MARGIN_LEFT) ? $conf->global->ULTIMATE_PDF_MARGIN_LEFT : 10;
	$marge_droite = isset($conf->global->ULTIMATE_PDF_MARGIN_RIGHT) ? $conf->global->ULTIMATE_PDF_MARGIN_RIGHT : 10;
	$logo_height = isset($conf->global->ULTIMATE_OTHERLOGO_HEIGHT) ? $conf->global->ULTIMATE_OTHERLOGO_HEIGHT : 30;
	$maxwidth = ($page_largeur - $marge_gauche - $marge_droite) / 2;

	include_once DOL_DOCUMENT_ROOT . '/core/lib/images.lib.php';
	$tmp = dol_getImageSize($otherlogo, $url);
	if ($tmp['height']) {
		$width = round($logo_height * $tmp['width'] / $tmp['height']);
		if ($width > $maxwidth) $logo_height = $logo_height * $maxwidth / $width;
	}
	if ($logo_height > 40) $logo_height = 40;
	return $logo_height;
}


function pdf_element_build_address($outputlangs, $sourcecompany, $targetcompany = '', $targetcontact = '', $usecontact = 0, $mode = 'source', $object = null, $modeconcat = false)
{
	global $conf, $hookmanager;

	$elementAddress = array(
		'facture' => array(
			'lowerconst' => 'invoice',
			'upperconst' => 'INVOICE'
		),
		'commande' => array(
			'lowerconst' => 'order',
			'upperconst' => 'ORDER'
		),
		'propal' => array(
			'lowerconst' => 'propal',
			'upperconst' => 'PROPAL'
		),
		'order_supplier' => array(
			'lowerconst' => 'supplierorder',
			'upperconst' => 'SUPPLIERORDER'
		),
		'invoice_supplier' => array(
			'lowerconst' => 'supplierinvoice',
			'upperconst' => 'SUPPLIERINVOICE'
		),
		'supplier_proposal' => array(
			'lowerconst' => 'supplierproposal',
			'upperconst' => 'SUPPLIERPROPOSAL'
		),
		'contrat' => array(
			'lowerconst' => 'contract',
			'upperconst' => 'CONTRACT'
		),
		'shipping' => array(
			'lowerconst' => 'shipping',
			'upperconst' => 'SHIPPING'
		),
		'expensereport' => array(
			'lowerconst' => 'expensereport',
			'upperconst' => 'EXPENSEREPORT'
		),
		'fichinter' => array(
			'lowerconst' => 'fichinter',
			'upperconst' => 'FICHINTER'
		),
		'delivery' => array(
			'lowerconst' => 'delivery',
			'upperconst' => 'DELIVERY'
		),
		'project' => array(
			'lowerconst' => 'project',
			'upperconst' => 'PROJECT'
		)
	);

	if ($mode == 'source' && !is_object($sourcecompany)) return -1;
	if ($mode == 'target' && !is_object($targetcompany)) return -1;
	if (!empty($sourcecompany->state_id) && empty($sourcecompany->state))       $sourcecompany->state = getState($sourcecompany->state_id);
	if (!empty($targetcompany->state_id) && empty($targetcompany->state))       $targetcompany->state = getState($targetcompany->state_id);

	$reshook = 0;
	$stringaddress = '';
	$upperConst = $elementAddress[$object->element]['upperconst'];
	$ultimateDisablesourcedetails = 'ULTIMATE_PDF_' . $upperConst . '_DISABLESOURCEDETAILS';
	$ultimateAddalsotargetdetails = 'ULTIMATE_PDF_' . $upperConst . '_ADDALSOTARGETDETAILS';
	$ultimateAddalsoclientdetails = 'ULTIMATE_PDF_' . $upperConst . '_ADDALSOCLIENTDETAILS';
	$ultimateTvaintranotinaddress = 'ULTIMATE_TVAINTRA_NOT_IN_' . $upperConst . '_ADDRESS';

	if (is_object($hookmanager)) {
		$parameters = array('sourcecompany' => &$sourcecompany, 'targetcompany' => &$targetcompany, 'targetcontact' => $targetcontact, 'outputlangs' => $outputlangs, 'mode' => $mode, 'usecontact' => $usecontact);
		$action = '';
		$reshook = $hookmanager->executeHooks('pdf_element_build_address', $parameters, $object, $action);    // Note that $action and $object may have been modified by some hooks
		$stringaddress .= $hookmanager->resPrint;
	}
	if (empty($reshook)) {
		if ($mode == 'source') {
			$withCountry = 0;

			if (!empty($conf->global->ULTIMATE_PDF_ALIAS_COUNTRY_EMETTEUR) && $conf->global->ULTIMATE_PDF_ALIAS_COUNTRY_EMETTEUR == '::') {
				$tmp = explode(':', $conf->global->MAIN_INFO_SOCIETE_COUNTRY);
				$country_code = $tmp[1] ? $tmp[1] : $tmp[0];
				$sourcecompany->country_code = $country_code;
			} else {
				if (isset($conf->global->ULTIMATE_PDF_ALIAS_COUNTRY_EMETTEUR)) {
					$tmp = explode(':', $conf->global->ULTIMATE_PDF_ALIAS_COUNTRY_EMETTEUR);
				}
				if (isset($tmp)) {
					$country_code = $tmp[1] ? $tmp[1] : $tmp[0];
					$sourcecompany->country_code = $country_code;
				}
			}
			if (!empty($sourcecompany->country_code) && ($targetcompany->country_code != $sourcecompany->country_code)) $withCountry = 1;

			if (!empty($conf->global->ULTIMATE_PDF_ALIAS_ADDRESS_EMETTEUR)) {
				$sourcecompany->address = $conf->global->ULTIMATE_PDF_ALIAS_ADDRESS_EMETTEUR;
			}
			if (!empty($conf->global->ULTIMATE_PDF_ALIAS_ZIP_EMETTEUR)) {
				$sourcecompany->zip = $conf->global->ULTIMATE_PDF_ALIAS_ZIP_EMETTEUR;
			}
			if (!empty($conf->global->ULTIMATE_PDF_ALIAS_TOWN_EMETTEUR)) {
				$sourcecompany->town = $conf->global->ULTIMATE_PDF_ALIAS_TOWN_EMETTEUR;
			}
			$stringaddress .= ($stringaddress ? "\n" : '') . $outputlangs->convToOutputCharset(dol_format_address($sourcecompany, $withCountry, "\n", $outputlangs)) . "\n";
			$stringaddress = nl2br($stringaddress);
			if (empty($conf->global->$ultimateDisablesourcedetails)) {
				// Phone
				$htmlphone = '<img src="' . DOL_URL_ROOT . '/theme/eldy/img/object_phoning.png' . '" width="10" height="10" />';
				if (!empty($conf->global->ULTIMATE_PDF_ALIAS_PHONE_EMETTEUR)) {
					$sourcecompany->phone = $conf->global->ULTIMATE_PDF_ALIAS_PHONE_EMETTEUR;
				}
				if ($sourcecompany->phone) $stringaddress .= ($stringaddress ? "\n<br>" : '') . $htmlphone . "&nbsp;" . $outputlangs->convToOutputCharset($sourcecompany->phone);
				// Fax 
				$htmlfax = '<img src="' . DOL_URL_ROOT . '/theme/eldy/img/object_phoning_fax.png' . '" width="10" height="10" />';
				if (!empty($conf->global->ULTIMATE_PDF_ALIAS_FAX_EMETTEUR)) {
					$sourcecompany->fax = $conf->global->ULTIMATE_PDF_ALIAS_FAX_EMETTEUR;
				}
				if ($sourcecompany->fax) $stringaddress .= ($stringaddress ? ($sourcecompany->phone ? " - " : "\n<br>") : '') . $htmlfax . "&nbsp;" . $outputlangs->convToOutputCharset($sourcecompany->fax);
				// EMail
				$htmlemail = '<img src="' . DOL_URL_ROOT . '/theme/eldy/img/object_email.png' . '" width="10" height="10" />';
				if (!empty($conf->global->ULTIMATE_PDF_ALIAS_EMAIL_EMETTEUR)) {
					$sourcecompany->email = $conf->global->ULTIMATE_PDF_ALIAS_EMAIL_EMETTEUR;
				}
				if ($sourcecompany->email) $stringaddress .= ($stringaddress ? "\n<br>" : '') . $htmlemail . "&nbsp;" . $outputlangs->convToOutputCharset($sourcecompany->email);
				// Web
				$htmlurl = '<img src="' . DOL_URL_ROOT . '/theme/eldy/img/object_website.png' . '" width="10" height="10" />';
				if (!empty($conf->global->ULTIMATE_PDF_ALIAS_URL_EMETTEUR)) {
					$sourcecompany->url = $conf->global->ULTIMATE_PDF_ALIAS_URL_EMETTEUR;
				}
				if ($sourcecompany->url) $stringaddress .= ($stringaddress ? "\n" : '') . $htmlurl . "&nbsp;" . $outputlangs->convToOutputCharset($sourcecompany->url);

				// Professionnal Ids
				$reg = array();
				if (!empty($conf->global->MAIN_PROFID1_IN_SOURCE_ADDRESS) && !empty($sourcecompany->idprof1)) {
					$tmp = $outputlangs->transcountrynoentities("ProfId1", $sourcecompany->country_code);
					if (preg_match('/\((.+)\)/', $tmp, $reg)) $tmp = $reg[1];
					$stringaddress .= "\n<br>" . $tmp . ': ' . $outputlangs->convToOutputCharset($sourcecompany->idprof1);
				}
				if (!empty($conf->global->MAIN_PROFID2_IN_SOURCE_ADDRESS) && !empty($sourcecompany->idprof2)) {
					$tmp = $outputlangs->transcountrynoentities("ProfId2", $sourcecompany->country_code);
					if (preg_match('/\((.+)\)/', $tmp, $reg)) $tmp = $reg[1];
					$stringaddress .= "\n<br>" . $tmp . ': ' . $outputlangs->convToOutputCharset($sourcecompany->idprof2);
				}
				if (!empty($conf->global->MAIN_PROFID3_IN_SOURCE_ADDRESS) && !empty($sourcecompany->idprof3)) {
					$tmp = $outputlangs->transcountrynoentities("ProfId3", $sourcecompany->country_code);
					if (preg_match('/\((.+)\)/', $tmp, $reg)) $tmp = $reg[1];
					$stringaddress .= "\n<br>" . $tmp . ': ' . $outputlangs->convToOutputCharset($sourcecompany->idprof3);
				}
				if (!empty($conf->global->MAIN_PROFID4_IN_SOURCE_ADDRESS) && !empty($sourcecompany->idprof4)) {
					$tmp = $outputlangs->transcountrynoentities("ProfId4", $sourcecompany->country_code);
					if (preg_match('/\((.+)\)/', $tmp, $reg)) $tmp = $reg[1];
					$stringaddress .= "\n<br>" . $tmp . ': ' . $outputlangs->convToOutputCharset($sourcecompany->idprof4);
				}
				if (!empty($conf->global->MAIN_PROFID5_IN_SOURCE_ADDRESS) && !empty($sourcecompany->idprof5)) {
					$tmp = $outputlangs->transcountrynoentities("ProfId5", $sourcecompany->country_code);
					if (preg_match('/\((.+)\)/', $tmp, $reg)) $tmp = $reg[1];
					$stringaddress .= ($stringaddress ? "\n<br>" : '') . $tmp . ': ' . $outputlangs->convToOutputCharset($sourcecompany->idprof5);
				}
				if (!empty($conf->global->MAIN_INFO_TVAINTRA) && !empty($sourcecompany->tva_intra)) {
					$tmp = $outputlangs->transcountrynoentities("VATIntra", $sourcecompany->country_code);
					if (preg_match('/\((.+)\)/', $tmp, $reg)) $tmp = $reg[1];
					$stringaddress .= "\n<br>" . $tmp . ': ' . $outputlangs->convToOutputCharset($sourcecompany->tva_intra);
				}
				if (!empty($conf->global->MAIN_PROFID6_IN_SOURCE_ADDRESS) && !empty($sourcecompany->idprof6)) {
					$tmp = $outputlangs->transcountrynoentities("ProfId6", $sourcecompany->country_code);
					if (preg_match('/\((.+)\)/', $tmp, $reg)) $tmp = $reg[1];
					$stringaddress .= "\n<br>" . $tmp . ': ' . $outputlangs->convToOutputCharset($sourcecompany->idprof6);
				}
				if (!empty($conf->global->PDF_ADD_MORE_AFTER_SOURCE_ADDRESS)) {
					$stringaddress .= ($stringaddress ? "\n<br>" : '') . $conf->global->PDF_ADD_MORE_AFTER_SOURCE_ADDRESS;
				}
			}
		}

		if ($mode == 'target' || preg_match('/targetwithdetails/', $mode)) {
			if ($usecontact) {
				if ($conf->global->ULTIMATE_CONTACT_ADDRESS_BLOCKS_OVER == 1) {
					$stringaddress .= $outputlangs->convToOutputCharset($targetcontact->getFullName($outputlangs, 1));
				} else {
					$stringaddress .= ($stringaddress ? "\n<br>" : '') . $outputlangs->convToOutputCharset($targetcontact->getFullName($outputlangs, 1));
				}
				
				if (!empty($targetcontact->address)) {
					if ($conf->global->ULTIMATE_CONTACT_ADDRESS_BLOCKS_OVER == 1 && $modeconcat) {
						$stringaddress .= ' : ' . $outputlangs->convToOutputCharset(dol_format_address($targetcontact, 1, "\n", $outputlangs));
					} else {
						$stringaddress .= ($stringaddress ? "\n<br>" : '') . $outputlangs->convToOutputCharset(dol_format_address($targetcontact, 1, "\n", $outputlangs));
						$stringaddress = nl2br($stringaddress);
					}
				} else {
					$companytouseforaddress = $targetcompany;

					// Contact on a thirdparty that is a different thirdparty than the thirdparty of object
					if ($targetcontact->socid > 0 && $targetcontact->socid != $targetcompany->id) {
						$targetcontact->fetch_thirdparty();
						$companytouseforaddress = $targetcontact->thirdparty;
					}
					if ($conf->global->ULTIMATE_CONTACT_ADDRESS_BLOCKS_OVER == 1 && $modeconcat) {
						$stringaddress .=  ' : ' . $outputlangs->convToOutputCharset(dol_format_address($companytouseforaddress));
					} else {
						$stringaddress .= ($stringaddress ? "\n<br>" : '') . $outputlangs->convToOutputCharset(dol_format_address($companytouseforaddress));
						$stringaddress = nl2br($stringaddress);
					}
				}
				// Country
				/*if (!empty($targetcontact->country_code) && $targetcontact->country_code != $sourcecompany->country_code) {
					$stringaddress .= ($stringaddress ? "\n<br>" : '') . $outputlangs->convToOutputCharset($outputlangs->transnoentitiesnoconv("Country" . $targetcontact->country_code));
				} else if (empty($targetcontact->country_code) && !empty($targetcompany->country_code) && ($targetcompany->country_code != $sourcecompany->country_code)) {
					$stringaddress .= ($stringaddress ? "\n<br>" : '') . $outputlangs->convToOutputCharset($outputlangs->transnoentitiesnoconv("Country" . $targetcompany->country_code));
				}*/

				if (!empty($conf->global->$ultimateAddalsotargetdetails) || preg_match('/targetwithdetails/', $mode)) {
					// Phone
					if (!empty($conf->global->$ultimateAddalsotargetdetails) || $mode == 'targetwithdetails' || preg_match('/targetwithdetails_phone/', $mode)) {
						$htmlphone = '<img src="' . DOL_URL_ROOT . '/theme/eldy/img/object_phoning.png' . '" width="10" height="10" />';
						$htmlmobile = '<img src="' . DOL_URL_ROOT . '/theme/eldy/img/object_phoning_mobile.png' . '" width="10" height="10" />';
						if (!empty($targetcontact->phone_pro) || !empty($targetcontact->phone_mobile)) $stringaddress .= ($stringaddress ? "\n<br>" : '');
						if (!empty($targetcontact->phone_pro)) $stringaddress .= $htmlphone . "&nbsp;" . $outputlangs->convToOutputCharset($targetcontact->phone_pro);
						if (!empty($targetcontact->phone_pro) && !empty($targetcontact->phone_mobile)) $stringaddress .= " / ";
						if (!empty($targetcontact->phone_mobile)) $stringaddress .= $htmlmobile . "&nbsp;" . $outputlangs->convToOutputCharset($targetcontact->phone_mobile);
					}
					// Fax
					$htmlfax = '<img src="' . DOL_URL_ROOT . '/theme/eldy/img/object_phoning_fax.png' . '" width="10" height="10" />';
					if (!empty($conf->global->$ultimateAddalsotargetdetails) || $mode == 'targetwithdetails' || preg_match('/targetwithdetails_fax/', $mode)) {
						if ($targetcontact->fax) $stringaddress .= ($stringaddress ? "\n<br>" : '') . $htmlfax . "&nbsp;" . $outputlangs->convToOutputCharset($targetcontact->fax);
					}
					// EMail
					$htmlemail = '<img src="' . DOL_URL_ROOT . '/theme/eldy/img/object_email.png' . '" width="10" height="10" />';
					if (!empty($conf->global->$ultimateAddalsotargetdetails) || $mode == 'targetwithdetails' || preg_match('/targetwithdetails_email/', $mode)) {
						if ($targetcontact->email) $stringaddress .= ($stringaddress ? "\n<br>" : '') . $htmlemail . "&nbsp;" . $outputlangs->convToOutputCharset($targetcontact->email);
					}
					// Web
					$htmlurl = '<img src="' . DOL_URL_ROOT . '/theme/eldy/img/object_website.png' . '" width="10" height="10" />';
					if (!empty($conf->global->$ultimateAddalsotargetdetails) || $mode == 'targetwithdetails' || preg_match('/targetwithdetails_url/', $mode)) {
						if ($targetcontact->url) $stringaddress .= ($stringaddress ? "\n<br>" : '') . $htmlurl . "&nbsp;" . $outputlangs->convToOutputCharset($targetcontact->url);
					}
				}
			} else {
				$stringaddress .= dol_nl2br(($stringaddress ? "\n" : '') . $outputlangs->convToOutputCharset(dol_format_address($targetcompany, isset($withCountry), "\n", $outputlangs)), 1, true);
				// Country
				if (!empty($targetcompany->country_code) && $targetcompany->country_code != $sourcecompany->country_code) $stringaddress .= ($stringaddress ? "\n<br>" : '') . $outputlangs->convToOutputCharset($outputlangs->transnoentitiesnoconv("Country" . $targetcompany->country_code)) . "\n<br>";

				if (!empty($conf->global->$ultimateAddalsoclientdetails) || preg_match('/targetwithdetails/', $mode)) {
					// Phone
					$htmlphone = '<img src="' . DOL_URL_ROOT . '/theme/eldy/img/object_phoning.png' . '" width="10" height="10" />';
					$htmlmobile = '<img src="' . DOL_URL_ROOT . '/theme/eldy/img/object_phoning_mobile.png' . '" width="10" height="10" />';
					if (!empty($conf->global->$ultimateAddalsoclientdetails) || $mode == 'targetwithdetails' || preg_match('/targetwithdetails_phone/', $mode)) {
						if (!empty($targetcompany->phone) || !empty($targetcompany->phone_mobile)) $stringaddress .= ($stringaddress ? "\n<br>" : '');
						if (!empty($targetcompany->phone)) $stringaddress .= $htmlphone . "&nbsp;" . $outputlangs->convToOutputCharset($targetcompany->phone);
						if (!empty($targetcompany->phone) && !empty($targetcompany->phone_mobile)) $stringaddress .= " / ";
						if (!empty($targetcompany->phone_mobile)) $stringaddress .= $htmlmobile . "&nbsp;" . $outputlangs->convToOutputCharset($targetcompany->phone_mobile);
					}
					// Fax
					$htmlfax = '<img src="' . DOL_URL_ROOT . '/theme/eldy/img/object_phoning_fax.png' . '" width="10" height="10" />';
					if (!empty($conf->global->$ultimateAddalsoclientdetails) || $mode == 'targetwithdetails' || preg_match('/targetwithdetails_fax/', $mode)) {
						if ($targetcompany->fax) $stringaddress .= ($stringaddress ? "\n<br>" : '') . $htmlfax . "&nbsp;" . $outputlangs->convToOutputCharset($targetcompany->fax);
					}
					// EMail
					$htmlemail = '<img src="' . DOL_URL_ROOT . '/theme/eldy/img/object_email.png' . '" width="10" height="10" />';
					if (!empty($conf->global->$ultimateAddalsoclientdetails) || $mode == 'targetwithdetails' || preg_match('/targetwithdetails_email/', $mode)) {
						if ($targetcompany->email) $stringaddress .= ($stringaddress ? "\n<br>" : '') . $htmlemail . "&nbsp;" . $outputlangs->convToOutputCharset($targetcompany->email);
					}
					// Web
					$htmlurl = '<img src="' . DOL_URL_ROOT . '/theme/eldy/img/object_website.png' . '" width="10" height="10" />';
					if (!empty($conf->global->$ultimateAddalsoclientdetails) || $mode == 'targetwithdetails' || preg_match('/targetwithdetails_url/', $mode)) {
						if ($targetcompany->url) $stringaddress .= ($stringaddress ? "\n<br>" : '') . $htmlurl . "&nbsp;" . $outputlangs->convToOutputCharset($targetcompany->url);
					}
				}
			}

			if (empty($conf->global->$ultimateTvaintranotinaddress) && $conf->global->$ultimateTvaintranotinaddress == 0) {
				if ($targetcompany->tva_intra) {
					$stringaddress .= ($stringaddress ? "\n<br>" : '') . $outputlangs->transnoentities("VATIntra") . ': ' . $outputlangs->convToOutputCharset($targetcompany->tva_intra);
				}
			}

			// Professionnal Ids
			if (!empty($conf->global->MAIN_PROFID1_IN_ADDRESS) && !empty($targetcompany->idprof1)) {
				$tmp = $outputlangs->transcountrynoentities("ProfId1", $targetcompany->country_code);
				if (preg_match('/\((.+)\)/', $tmp, $reg)) $tmp = $reg[1];
				$stringaddress .= ($stringaddress ? "\n<br>" : '') . $tmp . ': ' . $outputlangs->convToOutputCharset($targetcompany->idprof1);
			}
			if (!empty($conf->global->MAIN_PROFID2_IN_ADDRESS) && !empty($targetcompany->idprof2)) {
				$tmp = $outputlangs->transcountrynoentities("ProfId2", $targetcompany->country_code);
				if (preg_match('/\((.+)\)/', $tmp, $reg)) $tmp = $reg[1];
				$stringaddress .= ($stringaddress ? "\n<br>" : '') . $tmp . ': ' . $outputlangs->convToOutputCharset($targetcompany->idprof2);
			}
			if (!empty($conf->global->MAIN_PROFID3_IN_ADDRESS) && !empty($targetcompany->idprof3)) {
				$tmp = $outputlangs->transcountrynoentities("ProfId3", $targetcompany->country_code);
				if (preg_match('/\((.+)\)/', $tmp, $reg)) $tmp = $reg[1];
				$stringaddress .= ($stringaddress ? "\n<br>" : '') . $tmp . ': ' . $outputlangs->convToOutputCharset($targetcompany->idprof3);
			}
			if (!empty($conf->global->MAIN_PROFID4_IN_ADDRESS) && !empty($targetcompany->idprof4)) {
				$tmp = $outputlangs->transcountrynoentities("ProfId4", $targetcompany->country_code);
				if (preg_match('/\((.+)\)/', $tmp, $reg)) $tmp = $reg[1];
				$stringaddress .= ($stringaddress ? "\n<br>" : '') . $tmp . ': ' . $outputlangs->convToOutputCharset($targetcompany->idprof4);
			}
			if (!empty($conf->global->MAIN_PROFID5_IN_ADDRESS) && !empty($targetcompany->idprof5)) {
				$tmp = $outputlangs->transcountrynoentities("ProfId5", $targetcompany->country_code);
				if (preg_match('/\((.+)\)/', $tmp, $reg)) $tmp = $reg[1];
				$stringaddress .= ($stringaddress ? "\n<br>" : '') . $tmp . ': ' . $outputlangs->convToOutputCharset($targetcompany->idprof5);
			}
			if (!empty($conf->global->MAIN_PROFID6_IN_ADDRESS) && !empty($targetcompany->idprof6)) {
				$tmp = $outputlangs->transcountrynoentities("ProfId6", $targetcompany->country_code);
				if (preg_match('/\((.+)\)/', $tmp, $reg)) $tmp = $reg[1];
				$stringaddress .= ($stringaddress ? "\n<br>" : '') . $tmp . ': ' . $outputlangs->convToOutputCharset($targetcompany->idprof6);
			}

			// Public note
			if (!empty($conf->global->MAIN_PUBLIC_NOTE_IN_ADDRESS)) {
				if ($mode == 'source' && !empty($sourcecompany->note_public)) {
					$stringaddress .= "\n<br>" . dol_string_nohtmltag($sourcecompany->note_public);
				}
				if (($mode == 'target' || preg_match('/targetwithdetails/', $mode)) && !empty($targetcompany->note_public)) {
					$stringaddress .= "\n<br>" . dol_string_nohtmltag($targetcompany->note_public);
				}
			}
		}
	}
	return $stringaddress;
}