<?php
/* Copyright (C) 2005-2009  Laurent Destailleur <eldy@users.sourceforge.net>
 * Copyright (C) 2009-2017  Regis Houssin       <regis.houssin@inodbox.com>
 * Copyright (C) 2014       Marcos García       <marcosgdf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *  \file       htdocs/core/triggers/interface_20_all_Glpitodolibarr.class.php
 *  \ingroup    core
 *  \brief      Trigger file for
 */

require_once DOL_DOCUMENT_ROOT.'/core/triggers/dolibarrtriggers.class.php';
require_once DOL_DOCUMENT_ROOT.'/fourn/class/paiementfourn.class.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
require_once DOL_DOCUMENT_ROOT.'/contact/class/contact.class.php';
require_once DOL_DOCUMENT_ROOT.'/adherents/class/adherent.class.php';
require_once DOL_DOCUMENT_ROOT.'/adherents/class/subscription.class.php';

dol_include_once('/releveclient/class/releveclient.class.php');
dol_include_once('/releveclient/class/carburants.class.php');

/**
 *  Class of triggers 
 */
class Interfacereleveclienttrigger extends DolibarrTriggers
{
    protected $db;

    /**
     * Constructor
     *
     *  @param      DoliDB      $db     Database handler
     */
    public function __construct($db)
    {
        $this->db = $db;
        $this->name = preg_replace('/^Interface/i', '', get_class($this));
        $this->family = "NextConcept";
        $this->description = "Triggers of this module are empty functions.";
        $this->version   = 'development';
        $this->picto = 'glpitodolibarr@glpitodolibarr';
    }

    /**
     * Function called when a Dolibarrr security audit event is done.
     * All functions "runTrigger" are triggered if file is inside directory htdocs/core/triggers or htdocs/module/code/triggers (and declared)
     *
     * @param string        $action     Event action code
     * @param Object        $object     Object
     * @param User          $user       Object user
     * @param Translate     $langs      Object langs
     * @param conf          $conf       Object conf
     * @return int                      <0 if KO, 0 if no triggered ran, >0 if OK
     */
    public function runTrigger($action, $object, User $user, Translate $langs, Conf $conf)
    {
        global $conf, $db;

        if($action == "PAYMENT_VARIOUS_CREATE" && $object->id_tierassoc){
            $resultat = $this->db->query("UPDATE ".MAIN_DB_PREFIX."payment_various SET id_tierassoc=".$object->id_tierassoc." WHERE rowid=".$object->id);
        }
        
    }



}
