<?php
require_once DOL_DOCUMENT_ROOT . '/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/accounting.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';
require_once DOL_DOCUMENT_ROOT.'/fourn/class/fournisseur.facture.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 



class releveclient extends Commonobject{

	/**
	* @var string Error code (or message)
	* @deprecated
	* @see test::errors
	*/
	public $error;
	/**
	* @var string[] Error codes (or messages)
	*/
	public $errors = array();
	/**
	* @var string Id to identify managed objects
	*/
	// public $element = 'salle';
	/**
	* @var string Name of table without prefix where object is stored
	*/
	
    public $id;
	public $fk_user;
	public $rows = array();
	

	public function __construct($db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		return 1;
	}

  	public function PayementFacture($facid='', $fk_reglement=0)
  	{
  		// Payments already done (from payment on this invoice)
  		$html .= '<select name="fk_reglement" id="fk_reglement" >';
		$sql = 'SELECT p.datep as dp, p.ref, p.num_paiement as num_payment, p.rowid, p.fk_bank,';
		$sql .= ' c.code as payment_code, c.libelle as payment_label,';
		$sql .= ' pf.amount,';
		$sql .= ' ba.rowid as baid, ba.ref as baref, ba.label, ba.number as banumber, ba.account_number, ba.fk_accountancy_journal';
		$sql .= ' FROM '.MAIN_DB_PREFIX.'paiement_facture as pf, '.MAIN_DB_PREFIX.'paiement as p';
		$sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'c_paiement as c ON p.fk_paiement = c.id';
		$sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'bank as b ON p.fk_bank = b.rowid';
		$sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'bank_account as ba ON b.fk_account = ba.rowid';
		$sql .= ' WHERE pf.fk_facture = '.$facid.' AND pf.fk_paiement = p.rowid';
		$sql .= ' AND p.entity IN ('.getEntity('invoice').')';
		$sql .= ' ORDER BY p.datep, p.tms';

		$result = $this->db->query($sql);
		if ($result) {
			$num = $this->db->num_rows($result);
			$i = 0;

			if ($num > 0) {
				while ($i < $num) {
					$objp = $this->db->fetch_object($result);
					$html .='<option value="'.$objp->rowid.'"';
					if($fk_reglement == $objp->rowid) $html .= 'selected';
					$html .= '>'.$objp->ref.'</option>';
					$i++;
				}
			}
	  	}
	  	$html .= '</select>';
	  	return $html;
  	}

  	public function TotalReglment($socid='', $filter='')
  	{
  		$sql = "SELECT SUM(pf.amount) as totalrglm FROM ".MAIN_DB_PREFIX."paiement_facture as pf LEFT JOIN ".MAIN_DB_PREFIX."facture as f ON pf.fk_facture = f.rowid WHERE f.fk_soc=".$socid;
		$sql .= ' AND p.entity IN ('.getEntity('invoice').')';
  		

  		if($filter) $sql .= ' '.$filter;
  		$result = $this->db->query($sql);
		if ($result) {
			while ($obj = $this->db->fetch_object($result)){
				$total += $obj->totalrglm;
			}
	  	}
	  	return $total;
  	}

  	public function TotalReglmentCreanc($socid='', $filter='')
  	{
  		$sql = "SELECT SUM(pf.amount) as totalrglm FROM ".MAIN_DB_PREFIX."paiement as p LEFT JOIN ".MAIN_DB_PREFIX."paiement_facture as pf ON p.rowid=pf.fk_paiement LEFT JOIN ".MAIN_DB_PREFIX."facture as f ON pf.fk_facture = f.rowid WHERE f.fk_soc=".$socid;
		$sql .= ' AND p.entity IN ('.getEntity('invoice').')';
  		if($filter) $sql .= ' '.$filter;
  		$result = $this->db->query($sql);
		if ($result) {
			while ($obj = $this->db->fetch_object($result)){
				$total += $obj->totalrglm;
			}
	  	}
	  	return $total;
  	}
  // 	public function TotalRemisSoc($socid='', $filter='')
  // 	{
  // 		$sql = "SELECT re.rowid, SUM(re.amount_ht) as sum, re.amount_tva, re.amount_ttc,";
		// $sql .= " re.description, re.fk_facture_source";
		// $sql .= " FROM ".MAIN_DB_PREFIX."societe_remise_except as re";
		// $sql .= " WHERE fk_facture IN (SELECT rowid FROM ".MAIN_DB_PREFIX."facture WHERE fk_soc= ".$socid;
		// if($filter) $sql .= ' '.$filter;
		// $sql .= ")";

  // 		$result = $this->db->query($sql);
		// if ($result) {
		// 	while ($obj = $this->db->fetch_object($result)){
		// 		$total = $obj->sum;
		// 	}
	 //  	}
	 //  	return $total;
  // 	}

  	public function TotalFactureClient($socid='', $filter='')
  	{
  		$sql = "SELECT f.rowid, f.total_ttc as ttc FROM ".MAIN_DB_PREFIX."facture as f";
		$sql .= " WHERE fk_soc= ".$socid;
		$sql .= ' AND f.entity IN ('.getEntity('invoice').')';
		if($filter) $sql .= ' '.$filter;
		$Total=0;
  		$resql = $this->db->query($sql);
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)){
				// $total = $obj->sum;
				$objecttmp = new Facture($this->db);
				$result = $objecttmp->fetch($obj->rowid);
				if ($result > 0)
				{
					$Total+=$obj->ttc;
				}
			}
	  	}
	  	return $Total;
  	}

  	public function TotalFactureFourn($socid='', $filter='')
  	{
  		$sql = "SELECT f.rowid, f.total_ttc as ttc FROM ".MAIN_DB_PREFIX."facture_fourn as f";
		$sql .= " WHERE fk_soc= ".$socid;
		$sql .= ' AND f.entity IN ('.getEntity('supplier_invoice').')';
		if($filter) $sql .= ' '.$filter;
		$Total=0;
  		$resql = $this->db->query($sql);
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)){
				// $total = $obj->sum;
				$factfourn = new FactureFournisseur($this->db);
				$result = $factfourn->fetch($obj->rowid);

				if ($result > 0)
				{
					$Total+=$obj->ttc;
				}
			}
	  	}
	  	return $Total;
  	}

  	public function TotalRemisClient($socid='', $filter='')
  	{
  		$sql = "SELECT f.rowid, f.total_ttc as ttc FROM ".MAIN_DB_PREFIX."facture as f";
		$sql .= " WHERE fk_soc= ".$socid;
		$sql .= ' AND f.entity IN ('.getEntity('invoice').')';
		if($filter) $sql .= ' '.$filter;
		$Total=0;
		$totalcreditnotes=$totaldeposits=0;
		
  		$resql = $this->db->query($sql);
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)){
				// $total = $obj->sum;
				$objecttmp = new Facture($this->db);
				$result = $objecttmp->fetch($obj->rowid);
				if ($result > 0)
				{
					$totalpaye = $objecttmp->getSommePaiement();
					// $totalcreditnotes = $objecttmp->getSumCreditNotesUsed();
					// $totaldeposits = $objecttmp->getSumDepositsUsed();


					$Total += ($totalpaye + $totalcreditnotes + $totaldeposits);

					// echo "totalpaye:".$totalpaye;;
					// echo "totalcreditnotes:".$totalcreditnotes;;
					// echo "totaldeposits:".$totaldeposits;;
					// echo $Total;
				}
			}
	  	}
	  	// die();
	  	return $Total;
  	}



  	public function TotalRemisFourn($socid='', $filter='')
  	{
  		$sql = "SELECT f.rowid, f.total_ttc as ttc FROM ".MAIN_DB_PREFIX."facture_fourn as f";
		$sql .= " WHERE fk_soc= ".$socid;
		$sql .= ' AND f.entity IN ('.getEntity('supplier_invoice').')';
		if($filter) $sql .= ' '.$filter;
		$totalcreditnotes=$totaldeposits=0;
		$Total=0;
  		$resql = $this->db->query($sql);
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)){
				// $total = $obj->sum;
				$factfourn = new FactureFournisseur($this->db);
				$result = $factfourn->fetch($obj->rowid);
				if ($result > 0)
				{

			        $totalpaye = $factfourn->getSommePaiement();
		            // $totalcreditnotes = $factfourn->getSumCreditNotesUsed();
		            // $totaldeposits = $factfourn->getSumDepositsUsed();

					$totalpay += ($totalpaye + $totalcreditnotes + $totaldeposits);

					
				}
			}
	  	}
	  	return $totalpay;
  	}




  	public function Dt_facture($facid, $fk_paiement)
  	{
  		$sql ="SELECT f.rowid as doc_id, f.ref as doc_number, f.type as doc_type, r.datep as dateprint, f.fk_statut as status, f.paye as paid, d.description as description, d.label as label, d.fk_product as product_id, d.qty as prod_qty, d.total_ht as total_ht, p.ref as ref, p.rowid as prod_id, p.fk_product_type as prod_type,  p.entity as pentity, p.ref as prod_ref, p.label as product_label, pf.amount, d.product_type as type,  p.tva_tx as tva FROM llx_paiement_facture as pf, llx_paiement as r, llx_facture as f,llx_facturedet as d LEFT JOIN llx_product as p ON d.fk_product = p.rowid WHERE f.rowid = pf.fk_facture AND pf.fk_paiement = r.rowid AND r.rowid = ".$fk_paiement." AND d.fk_facture = f.rowid AND f.rowid=".$facid." AND f.entity IN (".getEntity('facture').")";
		$sql .= ' AND p.entity IN ('.getEntity('product').')';
  		$result = $this->db->query($sql);
		if ($result) {
			$num = $this->db->num_rows($result);
			$i = 0;

			if ($num > 0) {
				while ($i < $num) {
					$data[$i] = $this->db->fetch_object($result);
					$i++;
				}
			}
	  	}

	  	return $data;
  	}

  	public function SoldeDebiteur($socid, $debut, $fin, $societe)
  	{	

  		$element = ($societe->fournisseur && $societe->client != Societe::CUSTOMER) ? 'facture_fourn' : 'facture';
  		$elementpaiement = ($societe->fournisseur && $societe->client != Societe::CUSTOMER) ? 'paiementfourn' : 'paiement';
  		$elementpaiement_fact = ($societe->fournisseur && $societe->client != Societe::CUSTOMER) ? 'paiementfourn_facturefourn' : 'paiement_facture';


  		$sql = "SELECT f.rowid as facid, f.datef as datef, f.total_ttc as amount FROM ".MAIN_DB_PREFIX.$element." as f WHERE fk_soc=".$socid." AND CAST(f.datef as date) < '".$debut."'";
  		$sql .= " AND f.entity IN (".getEntity('facture').")";
  		$result = $this->db->query($sql);
		$arrpayement = [];

		if ($result)
		{
		    $num = $this->db->num_rows($result);

		    // Boucle sur chaque facture
		    for ($i = 0; $i < $num; $i++)
		    {
		        $objf = $this->db->fetch_object($result);
		        $fac = new Facture($this->db);
		        $ret = $fac->fetch($objf->facid);

		        $values = array(
		            'fk_facture' => $objf->facid,
                    'datefieldforsort' => $this->db->jdate($obj->datef).'-'.$fac->ref,
		            'amount' => $fac->total_ttc,
		        );

		        $TData[] = $values;

		  	}
	  	}

  		$sql ="SELECT pf.rowid, p.datep as datep, pf.amount as pamount FROM ".MAIN_DB_PREFIX.$elementpaiement_fact." as pf";

  		if($societe->fournisseur && $societe->client != Societe::CUSTOMER){
	  		$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."paiementfourn as p ON pf.fk_paiement = p.rowid ";
	  		$sql .= " WHERE pf.fk_facturefourn IN (SELECT f.rowid FROM ".MAIN_DB_PREFIX."facture_fourn as f WHERE f.fk_soc=".$socid.")";
  		}else{
  			$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."paiement as p ON pf.fk_paiement = p.rowid ";
	  		$sql .= " WHERE pf.fk_facture IN (SELECT f.rowid FROM ".MAIN_DB_PREFIX."facture as f WHERE f.fk_soc=".$socid.")";
  		}

  		$sql .= " AND CAST(p.datep as date) < '".$debut."' AND p.entity IN (".getEntity('facture').")";
        $resqlp = $this->db->query($sql);
        if ($resqlp)
        {
            $nump = $this->db->num_rows($resqlp);
            $j = 0;

            while ($j < $nump)
            {
                $objp = $this->db->fetch_object($resqlp);


                $values = array(
                    'fk_paiement' => $objp->rowid,
                    'datefieldforsort' => $this->db->jdate($objp->datep).'-'.$fac->ref,
                    'amount' => -$objp->pamount,
                );

                $TData[] = $values;

                $j++;
            }

            $this->db->free($resqlp);
        }
        
		if (!empty($TData)) {
		    // Sort array by date ASC to calucalte balance
		    $TData = dol_sort_array($TData, 'datefieldforsort', 'ASC');
		    $balance = 0;
		    $totalDebit = 0;
		    $totalCredit = 0;
		    foreach ($TData as &$data) {
				$totalDebit += ($data['amount'] > 0) ? abs($data['amount']) : 0;
				$totalCredit += ($data['amount'] > 0) ? 0 : abs($data['amount']);
		    }
		    $balance = $totalDebit-$totalCredit;
		    
		    return $balance;
		}
	}	



  	public function getInvoiceRAN($socid, $debut, $fin, $societe)
  	{

  		$element = ($societe->fournisseur && $societe->client != Societe::CUSTOMER) ? 'facture_fourn' : 'facture';
  		$elementpaiement = ($societe->fournisseur && $societe->client != Societe::CUSTOMER) ? 'paiementfourn' : 'paiement';
  		$elementpaiement_fact = ($societe->fournisseur && $societe->client != Societe::CUSTOMER) ? 'paiementfourn_facturefourn' : 'paiement_facture';


  		$sql = "SELECT f.rowid as facid, f.ref, f.datef as datef, f.total_ttc as amount FROM ".MAIN_DB_PREFIX.$element." as f WHERE fk_soc=".$socid." AND CAST(f.datef as date) < '".$debut."'";
  		$sql .= " AND f.entity IN (".getEntity('facture').")";
  		$result = $this->db->query($sql);

		$TData = [];
		$returned = [];

		if ($result)
		{
		    $num = $this->db->num_rows($result);

		    // Boucle sur chaque facture
		    for ($i = 0; $i < $num; $i++)
		    {
		        $objf = $this->db->fetch_object($result);
		        // $fac = new Facture($this->db);
		        // $ret = $fac->fetch($objf->facid);
		        $pictofacture = img_picto('', 'bill').' ';

	    		$faclink = '<a href="'.DOL_URL_ROOT.'/compta/facture/card.php?facid='.$objf->facid.'">'.$pictofacture.$objf->ref.'</a>';

		        $TData[$objf->facid]['amount'] = $objf->amount;
		        $TData[$objf->facid]['date']   = $this->db->jdate($objf->datef);
		        $TData[$objf->facid]['link']   = $faclink;
		        $TData[$objf->facid]['ref']   = $objf->ref;
		        $TData[$objf->facid]['sort']   = $objf->datef.'-'.$objf->ref;
		  	}
	  	}

  		$sql ="SELECT pf.rowid, p.datep as datep, pf.amount as pamount FROM ".MAIN_DB_PREFIX.$elementpaiement_fact." as pf";

  		if($societe->fournisseur && $societe->client != Societe::CUSTOMER){
	  		$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."paiementfourn as p ON pf.fk_paiement = p.rowid ";
	  		$sql .= " WHERE pf.fk_facturefourn IN (SELECT f.rowid FROM ".MAIN_DB_PREFIX."facture_fourn as f WHERE f.fk_soc=".$socid.")";
  		}else{
  			$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."paiement as p ON pf.fk_paiement = p.rowid ";
	  		$sql .= " WHERE pf.fk_facture IN (SELECT f.rowid FROM ".MAIN_DB_PREFIX."facture as f WHERE f.fk_soc=".$socid.")";
  		}

  		$sql .= " AND CAST(p.datep as date) < '".$debut."' AND p.entity IN (".getEntity('facture').")";
        $resqlp = $this->db->query($sql);
        if ($resqlp)
        {
            $nump = $this->db->num_rows($resqlp);
            $j = 0;

            while ($j < $nump)
            {
                $objp = $this->db->fetch_object($resqlp);

                $TData[$objp->fk_facture]['amountp'] += $objp->pamount;

                $j++;
            }

            $this->db->free($resqlp);
        }

		if (!empty($TData)) {
		    foreach ($TData as $key => $data) {

		    // 	$totalpay = $paiement + $totalcreditnotes + $totaldeposits;
			// 	$remaintopay = price2num($facturestatic->total_ttc - $totalpay);

		    	$resteapayer = (($data['amount'] > $data['amountp']) ? (float) ($data['amount'] - $data['amountp']) : 0); 

		    	if($resteapayer){
		    		$returned[$key] = $data;
		    		$returned[$key]['charge'] = $resteapayer;
		    	}
		    }
		    return $returned;
		}
	}	




  	public function TotalClient($socid='', $filter='')
  	{
  		$sql = "SELECT f.rowid FROM ".MAIN_DB_PREFIX."facture as f";
		$sql .= " WHERE f.fk_soc= ".$socid;
  		$sql .= " AND f.entity IN (".getEntity('facture').")";
		if($filter) $sql .= ' '.$filter;
		// echo $sql;
		$totalcreditnotes=$totaldeposits=0;
		$resteapayer=0;
  		$resql = $this->db->query($sql);
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)){
				// $total = $obj->sum;
				$objecttmp = new Facture($this->db);
				$result = $objecttmp->fetch($obj->rowid);
				$totalachat += $objecttmp->total_ttc;
				if ($result > 0)
				{
					$totalpaye = $objecttmp->getSommePaiement();
					// $totalcreditnotes = $objecttmp->getSumCreditNotesUsed();
					// $totaldeposits = $objecttmp->getSumDepositsUsed();
					$resteapayer += ($totalpaye + $totalcreditnotes + $totaldeposits);

				}	
			}
	  	}
	  	$data=['totalachat'=>$totalachat, 'totalreglement'=>$resteapayer];
	  	return $data;
  	}


	public function upgradeModulereleveclient()
    {
        global $conf, $langs;

        dol_include_once('/releveclient/core/modules/modreleveclient.class.php');
        $modcore = new modReleveClient($this->db);
        
        $lastversion    = $modcore->version;
        $currentversion = dolibarr_get_const($this->db, 'RELEVECLIENT_LAST_VERSION_OF_MODULE', $conf->entity);
        if (!$currentversion || ($currentversion && $lastversion != $currentversion)){
            $res = $this->InitReleveClient();
            if($res)
                dolibarr_set_const($this->db, 'RELEVECLIENT_LAST_VERSION_OF_MODULE', $lastversion, 'chaine', 0, '', $conf->entity);
            return 1;
        }
        return 0;
    }


  	public function InitReleveClient()
  	{
  		global $conf, $langs;

        $langs->load("releveclient@releveclient");

		require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
		$extrafields=new ExtraFields($this->db);

        $extrafields->addExtraField('n_devis', $langs->trans("n_devis"), "varchar", "1000", '355', "expedition",  0, 0, '', $params, 1, '', 1, '', '', '','', '1');
        	
        dolibarr_set_const($this->db, 'PRODUCT_CAN_EDIT_WAP', 1, 'int', 1, '', $conf->entity);

        $params = serialize(array('options' => array('bank_account:label:rowid::account_number IN (47,47000,46,46000,471100,4711)' => null)));
        $extrafields->addExtraField('account_bank', $langs->trans("account_bank"), "sellist", "1000", '', "societe",  0, 0, '', $params, 1, '', 1, '', '', '','', '1');

        $ret = addDocumentModel('wolcim', 'stock', 'Wolcim');
        dolibarr_set_const($this->db,'STOCK_ADDON_PDF','wolcim','chaine');
		
        // $params = serialize(array('options' => array('bank_account:label:rowid::extra.account_bank IN (47,47000,46,46000)' => null)));
        // $extrafields->addExtraField('societe', $langs->trans("account_bank"), "sellist", "1000", '', "payment_various",  1, 0, '', $params, 1, '', 1, '', '', '','', '1');

        $sql = 'INSERT INTO `'.MAIN_DB_PREFIX.'c_typent` (`id`, `code`, `libelle`, `active`) VALUES 
         (46000, "TE_ASSOCIE", "Associé", 1)
        ,(47000, "TE_DEBITCREDIT", "Débiteur/Créditeur", 1)';
        $resql = $this->db->query($sql);

		$sql1 = 'ALTER TABLE `llx_payment_various` ADD `id_tierassoc` int(11) NULL DEFAULT NULL';
		$resql = $this->db->query($sql1);

  		$this->db->query('UPDATE '.MAIN_DB_PREFIX.'const SET entity=1 WHERE name="RELEVECLIENT_FIELDS"');

		$sql = "INSERT INTO `".MAIN_DB_PREFIX."extrafields` (`name`, `entity`, `elementtype`, `tms`, `label`, `type`, `size`, `fieldunique`, `fieldrequired`, `perms`, `pos`, `alwayseditable`, `param`, `list`) VALUES ('be1', ".$conf->entity.", 'facture', '".$tms."', 'N° BE CIM IVOIRE', 'int', '10', 1, 0, NULL, 100, 1, '', 1);";
		$resql = $this->db->query($sql);

		$sql1 = 'ALTER TABLE `llx_facture_extrafields` ADD `be1` int(10) NULL DEFAULT NULL';
		$resql = $this->db->query($sql1);

		$sql = "ALTER TABLE `".MAIN_DB_PREFIX."facture_extrafields` ADD UNIQUE INDEX uk_facture_extrafields_be1 (be1)";
		$resql = $this->db->query($sql, 1, 'dml');

		$sql1 = 'ALTER TABLE `llx_facture_extrafields` ADD `bl1` varchar(100) NULL DEFAULT NULL';
		$resql = $this->db->query($sql1);

		$sql = "ALTER TABLE `".MAIN_DB_PREFIX."facture_extrafields` ADD UNIQUE INDEX uk_facture_extrafields_bl1 (bl1)";
		$resql = $this->db->query($sql, 1, 'dml');

		$sql2 = "INSERT INTO `".MAIN_DB_PREFIX."extrafields` (`name`, `entity`, `elementtype`, `tms`, `label`, `type`, `size`, `fieldunique`, `fieldrequired`, `perms`, `pos`, `alwayseditable`, `param`, `list`) VALUES ('bl1', ".$conf->entity.", 'facture', '".$tms."', 'N° BL CIM IVOIRE', 'varchar', '355', 1, 0, NULL, 100, 1, '', 1);";
		$resql = $this->db->query($sql2);

		return 1;

  	}

  	// Select Company Associers - Débiteur

  	public function selectCompanyAssoc($socid='', $name="socid", $id_account="")
  	{
  		global $langs;

  		$select = '';
  		include_once DOL_DOCUMENT_ROOT.'/core/lib/ajax.lib.php';
		$select .= ajax_combobox($name, $events, $conf->global->COMPANY_USE_SEARCH_TO_SELECT);
  		$select .= '<select class="minwidth300" name="'.$name.'" id="'.$name.'">';
			$select .= '<option value="-1" data-html="'.dol_escape_htmltag('<span class="opacitymedium">'.$langs->trans("SelectThirdParty").'</span>').'">'.$langs->trans('SelectThirdParty').'</option>'."\n";
	  		$sql = 'SELECT s.*, sf.account_bank FROM '.MAIN_DB_PREFIX.'societe as s';
	  		$sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'societe_extrafields as sf ON s.rowid = sf.fk_object';
	  		$sql .= ' WHERE s.entity IN ('.getEntity('societe').')';
	  		$sql .= ' AND sf.account_bank >0';
	  		$sql .= ' AND s.client = 0 AND s.fournisseur = 0 AND s.fk_typent IN (46000, 47000)';
	  		$sql .= $id_accounrt ? ' AND sf.account_bank = '.$id_account : '';
	  		$resql = $this->db->query($sql);
	  		if($resql){
	  			while ($obj=$this->db->fetch_object($resql)) {
	  				$selected = ($obj->rowid == $socid || $obj->account_bank == $id_account) ? 'selected' : ''; 
	  				$select .= '<option value="'.$obj->rowid.'" '.$selected.'>'.$obj->nom.'</option>';
	  			}
	  		}
  		$select .= '</select>';

  		return $select;
  	}

  	public function selectCompteComptabl($value=[])
  	{
  		global $conf;

		$trunclength = empty($conf->global->ACCOUNTING_LENGTH_DESCRIPTION_ACCOUNT) ? 50 : $conf->global->ACCOUNTING_LENGTH_DESCRIPTION_ACCOUNT;

  			
		$sql = "SELECT DISTINCT aa.account_number, aa.label, aa.labelshort, aa.rowid, aa.fk_pcg_version";
		$sql .= " FROM ".MAIN_DB_PREFIX."accounting_account as aa";
		$sql .= " INNER JOIN ".MAIN_DB_PREFIX."accounting_system as asy ON aa.fk_pcg_version = asy.pcg_version";
		$sql .= " AND asy.rowid = ".((int) $conf->global->CHARTOFACCOUNTS);
		$sql .= " AND aa.active = 1";
		$sql .= " AND aa.entity=".$conf->entity;
		$sql .= " ORDER BY aa.account_number";

  		$select .= '<select class="minwidth300" name="accountnumbr[]" id="multi_account" multiple>';

		$resql = $this->db->query($sql);
	  		if($resql){
	  			while ($obj=$this->db->fetch_object($resql)) {
	  				if (empty($obj->labelshort)) {
						$labeltoshow = $obj->label;
					} else {
						$labeltoshow = $obj->labelshort;
					}

					$label = length_accountg($obj->account_number).' - '.$labeltoshow;
					$label = dol_trunc($label, $trunclength);
	  				$selected = (isset($value) && in_array($obj->rowid, $value)) ? 'selected' : ''; 
	  				$select .= '<option value="'.$obj->rowid.'" '.$selected.'>'.$label.'</option>';
	  			}
	  		}
  		$select .= '</select>';
  		$select .= '<script>$(document).ready(function(){$("#multi_account").select2()})</script>';
  		return $select;
  	}
}
