<?php 
require_once DOL_DOCUMENT_ROOT.'/core/class/commonobject.class.php'; 

require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/payments.lib.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';

class recuversement extends Commonobject{ 

	public $errors = array();

	public $element='recuversement';
	public $table_element='recuversement';
	
    public $picto = 'barcode';
    
    public $typespayments;

	public function __construct($db){ 
		global $langs;

		$this->db = $db;

		return 1;
    }


    public function generateRecuVersementDocument($object)
    {
        global $langs, $mysoc, $conf, $user, $db, $nb;

        $nb=0;
        $langs->loadLangs(array('bills', 'banks', 'companies'));

        require_once dol_buildpath('/recuversement/pdf/pdf.lib.php');

        $objectref = dol_sanitizeFileName($object->ref);
        if ($conf->recuversement->dir_output) {
            $dir = $conf->recuversement->dir_output."/".$objectref;
            if (file_exists($dir)) {
                $res = @dol_delete_dir_recursive($dir);
            }
        }


        $pdf = new NCPDF('P', 'mm', 'A4', true, 'UTF-8', false, false);
        // set document information
        $pdf->SetTitle((isset($title) ? $title : ''));
        $pdf->SetSubject((isset($title) ? $title : ''));
        $pdf->SetKeywords('');
        // set default header data
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        // $pdf->setFooterData(array(0,64,0), array(0,64,128));

        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

        // set default monospaced font
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        $pdf->SetMargins(13, PDF_MARGIN_TOP, 13);
        $pdf->SetHeaderMargin(2); // PDF_MARGIN_HEADER
        // $pdf->SetFooterMargin(0);

        // set auto page breaks


        // set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

        // set some language-dependent strings (optional)
        if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
            require_once(dirname(__FILE__).'/lang/eng.php');
            $pdf->setLanguageArray($l);
        }

        // set default font subsetting mode
        $pdf->setFontSubsetting(true);

        // $pdf->SetFooterMargin(60);
        // $pdf->setPrintFooter(true);
        // $pdf->SetAutoPageBreak(TRUE,35);

        $pdf->last_page = $nb;

        $pdf->SetFooterMargin(20);
        $pdf->setPrintFooter(true);
        $pdf->SetAutoPageBreak(TRUE,25);
        
        $pdf->writeHTML('<span>'.'getNumPages: '.$pdf->getNumPages().' - '.$pdf->getNumPages().'</span>', true, false, true, false, '');

        $pdf->SetFont('times', '', 9, '', true);
        $pdf->AddPage('P');

        $array_format = pdf_getFormat();
        $marge_haute =isset($conf->global->MAIN_PDF_MARGIN_TOP)?$conf->global->MAIN_PDF_MARGIN_TOP:10;
        $marge_basse =isset($conf->global->MAIN_PDF_MARGIN_BOTTOM)?$conf->global->MAIN_PDF_MARGIN_BOTTOM:10;
        $margin = $marge_haute+$marge_basse+45;

        $page_largeur = $array_format['width'];
        $page_hauteur = $array_format['height'];
        $format = array($page_largeur,$page_hauteur);

        $marge_gauche=isset($conf->global->MAIN_PDF_MARGIN_LEFT)?$conf->global->MAIN_PDF_MARGIN_LEFT:10;
        $marge_droite=isset($conf->global->MAIN_PDF_MARGIN_RIGHT)?$conf->global->MAIN_PDF_MARGIN_RIGHT:10;
        $marge_haute =isset($conf->global->MAIN_PDF_MARGIN_TOP)?$conf->global->MAIN_PDF_MARGIN_TOP:6;
        $marge_basse =isset($conf->global->MAIN_PDF_MARGIN_BOTTOM)?$conf->global->MAIN_PDF_MARGIN_BOTTOM:10;
        $emetteur = $mysoc;



        $default_font_size = pdf_getPDFFontSize($langs);

        pdf_pagehead($pdf,$langs,$page_hauteur);


        // // Show Draft Watermark
        // if($object->statut==0 && (! empty($conf->global->COMMANDE_DRAFT_WATERMARK)) )
        // {
        //     pdf_watermark($pdf,$langs,$page_hauteur,$page_largeur,'mm',$conf->global->COMMANDE_DRAFT_WATERMARK);
        // }

        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont('helvetica','B', $default_font_size + 2);

        $posy=$marge_haute;
        $posx=$page_largeur-$marge_droite-100;

        $pdf->SetXY($marge_gauche,$posy);

        // Logo
        $logo=$conf->mycompany->dir_output.'/logos/'.$emetteur->logo;

        if ($emetteur->logo)
        {
            if (is_readable($logo))
            {
                $height=pdf_getHeightForLogo($logo);
                $pdf->Image($logo, $marge_gauche, $posy, 0, $height); // width=0 (auto)
            }
            else
            {
                $pdf->SetTextColor(200,0,0);
                $pdf->SetFont('helvetica','B', $default_font_size -2);
                $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorLogoFileNotFound",$logo), 0, 'L');
                $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorGoToGlobalSetup"), 0, 'L');
            }
        }
        else
        {
            $text=$emetteur->name;
            $pdf->MultiCell(40, 2, $langs->convToOutputCharset($text), 0, 'L');
        }

        // $posx = $page_largeur

        $pdf->SetFont('helvetica','B', $default_font_size );
        $pdf->SetXY($posx, $posy);
        $pdf->SetTextColor(0,0,0);
        $pdf->MultiCell(100, 3, $langs->transnoentities('recu_versement'), '', 'L');

        $posx=$page_largeur-$marge_droite-100;
        
        $pdf->SetFont('helvetica','B', $default_font_size );
        $pdf->SetXY($posx,$posy);
        $pdf->SetTextColor(0,0,0);
        $pdf->MultiCell(100, 3, date("d/m/Y"), '', 'R');

        $posyy = $height ? $height : $posy+10;
        $posx3 = $page_largeur/3;
        $posx = $posx3+10;
        $pdf->SetFont('helvetica','B', $default_font_size );
        $pdf->SetXY($posx, $posyy);
        $pdf->SetTextColor(0,0,0);
        $pdf->MultiCell(100, 3, $langs->transnoentities('Ref').': '.$langs->transnoentities('Reglement').' '.$object->ref, '', 'L');
        
        $client = new Societe($db);

        $object->fetch_thirdparty();
        if(isset($object->thirdparty) && $object->thirdparty->id>0){
            $client->fetch($object->thirdparty->id);
        }

        $carac_emetteur='';
       
        if(isset($object->thirdparty))
        $carac_emetteur .= pdf_build_address($langs, $emetteur, $object->thirdparty, '', 0, 'source', $object);

        // Show Customer

        $border_style = array('width' => 0.2, 'cap' => 'butt', 'join' => 'miter', 'dash' => '', 'color' => array(70, 70, 70));
        $bgcolor = array('170', '212', '255');

        $posx = 50;
        $posyrect = $pdf->GetY()+10;
        $posy = $posyrect;
        $widthrect = $page_largeur - 100;


        $pdf->SetFont('helvetica','B', $default_font_size-1 );
        $pdf->SetXY($posx+30, $posy+2);
        $pdf->SetTextColor(0,0,0);
        $pdf->MultiCell(100, 3, $client->nom, '', 'L');

        $posy = $pdf->GetY();
        $pdf->SetFont('helvetica','', $default_font_size-1 );
        $pdf->SetXY($posx+30, $posy+2);
        $pdf->SetTextColor(0,0,0);
        $pdf->MultiCell($widthrect-50, 3, $client->getFullAddress(1), '', 'L');


        $pdf->SetTextColor(0, 0, 0);
        $heightrect = ($pdf->GetY()-$posyrect)+2;
        $pdf->RoundedRect($posx, $posyrect, $widthrect, $heightrect, '4', '1111', '', $border_style, $bgcolor);

        $pdf->SetFont('helvetica','B', $default_font_size-1 );
        $pdf->SetXY($posx+2, ($pdf->GetY()-($heightrect/2)));
        $pdf->SetTextColor(0,0,0);
        $pdf->MultiCell(100, 3, $langs->transnoentities('Customer'), '', 'L');
        // $posx=40;
        // $posy=$pdf->getY()+3;

        // // Date de paiement
        // $pdf->SetFont('helvetica','B', $default_font_size-1 );
        // $pdf->SetXY($posx+2, $posy);
        // $pdf->SetTextColor(0,0,0);
        // $pdf->MultiCell(100, 3, $langs->transnoentities('Date'), '', 'L');

        // $pdf->SetFont('helvetica','B', $default_font_size-1 );
        // $pdf->SetXY($posx+50, $posy);
        // $pdf->SetTextColor(0,0,0);
        // $pdf->MultiCell(100, 3, dol_print_date($object->date, 'dayhour'), '', 'L');

        // // Mode de reglement
        // $posy=$pdf->getY()+3;
        // $pdf->SetFont('helvetica','B', $default_font_size-1 );
        // $pdf->SetXY($posx+2, $posy);
        // $pdf->SetTextColor(0,0,0);
        // $pdf->MultiCell(100, 3, $langs->transnoentities('PaymentMode'), '', 'L');

        // $labeltype = $langs->trans("PaymentType".$object->type_code) != ("PaymentType".$object->type_code) ? $langs->trans("PaymentType".$object->type_code) : $object->type_label;

        // $pdf->SetFont('helvetica','B', $default_font_size-1 );
        // $pdf->SetXY($posx+50, $posy);
        // $pdf->SetTextColor(0,0,0);
        // $pdf->MultiCell(100, 3, $labeltype, '', 'L');
        
        // // Amount total
        // $posy=$pdf->getY()+3;
        // $pdf->SetFont('helvetica','B', $default_font_size-1 );
        // $pdf->SetXY($posx+2, $posy);
        // $pdf->SetTextColor(0,0,0);
        // $pdf->MultiCell(100, 3, $langs->transnoentities('Amount'), '', 'L');

        // $pdf->SetFont('helvetica','B', $default_font_size-1 );
        // $pdf->SetXY($posx+50, $posy);
        // $pdf->SetTextColor(0,0,0);
        // $pdf->MultiCell(100, 3, price($object->amount, '', $langs, 0, -1, -1, $conf->currency), '', 'L');
        

        // // Bank account
        // if (isModEnabled("banque")) {

        //     if ($object->fk_account > 0) {
        //         $posy=$pdf->getY()+3;

        //         $pdf->SetFont('helvetica','B', $default_font_size-1 );
        //         $pdf->SetXY($posx+2, $posy);
        //         $pdf->SetTextColor(0,0,0);
        //         $pdf->MultiCell(100, 3, $langs->transnoentities('BankAccount'), '', 'L');

        //         $bankline = new AccountLine($db);
        //         $accountstatic = new Account($db);
        //         $bankline->fetch($object->bank_line);
        //         $accountstatic->fetch($bankline->fk_account);

        //         $pdf->SetFont('helvetica','B', $default_font_size-1 );
        //         $pdf->SetXY($posx+50, $posy);
        //         $pdf->SetTextColor(0,0,0);
        //         $pdf->MultiCell(100, 3, $accountstatic->label, '', 'L');
        //     }
        // }

        // if($object->num_payment){

        //     $posy=$pdf->getY()+3;
        //     $pdf->SetFont('helvetica','B', $default_font_size-1 );
        //     $pdf->SetXY($posx+2, $posy);
        //     $pdf->SetTextColor(0,0,0);
        //     $pdf->MultiCell(100, 3, $langs->transnoentities('ChequeOrTransferNumber'), '', 'L');

        //     $pdf->SetFont('helvetica','B', $default_font_size-1 );
        //     $pdf->SetXY($posx+50, $posy);
        //     $pdf->SetTextColor(0,0,0);
        //     $pdf->MultiCell(100, 3, $object->num_payment, '', 'L');
        // }

        $posy=$pdf->GetY()+20;
        $posx=$marge_gauche+5;

        if (! empty($conf->global->MAIN_INVERT_SENDER_RECIPIENT)) $posx=$page_largeur-$marge_droite;
        $hautcadre=10;

        // Show sender frame
        $pdf->SetFont('helvetica','', $default_font_size-2 );
        
        $pdf->SetXY($posx,$posy);
        $pdf->SetFillColor(230,230,230);
        $pdf->SetTextColor(0,0,60);
        

        $html='';
        // require template
        require_once dol_buildpath('/recuversement/tpl/paiement.tpl.php');
        
        $pdf->writeHTML($html, true, false, true, false, '');

        $posy = $pdf->GetY()+5;
        $largcurrent = (($page_largeur+40)-$posy);

        if($largcurrent < 30){
            $pdf->AddPage('P');
        }

        $posy = $page_largeur+30;
        $pdf->RoundedRect($marge_gauche+4, $posy, 85, 30, '4', '1111', '', $border_style, $bgcolor);

        $pdf->SetFont('helvetica','B', $default_font_size-1 );
        $pdf->SetXY($marge_gauche+8, $posy+5);
        $pdf->SetTextColor(0,0,0);
        $pdf->MultiCell(100, 3, $langs->trans('LeClient'), '', 'L');
        
        $pdf->RoundedRect(110, $posy, 85, 30, '4', '1111', '', $border_style, $bgcolor);
        $pdf->SetFont('helvetica','B', $default_font_size-1 );
        $pdf->SetXY(114, $posy+5);
        $pdf->SetTextColor(0,0,0);
        $pdf->MultiCell(100, 3, $langs->trans('LaCaisse'), '', 'L');
        
        $pdf->Close();
        // ob_start();

        $ref = $object->ref ? dol_sanitizeFileName($object->ref) : $object->id; 
        $dir = $conf->recuversement->dir_output."/".$ref;
        
        $filename = $ref.'.pdf';
        // if($signe) $filename = $ref."_signature.pdf";

        $file = $dir."/".$filename;
        if (!file_exists($dir)) {
            if (dol_mkdir($dir) < 0) {
            }
        }


        if(file_exists($file)){
            $ret = dol_delete_file($file);
        }

        $res = $pdf->Output($file, 'F');

        // $pdf->Output($file, 'I');
        if (!empty($conf->global->MAIN_UMASK)) {
            @chmod($file, octdec($conf->global->MAIN_UMASK));
        }

        include_once DOL_DOCUMENT_ROOT.'/ecm/class/ecmfiles.class.php';
        require_once DOL_DOCUMENT_ROOT.'/core/lib/security2.lib.php';

        $ecmfile = new EcmFiles($this->db);
        $ecmfile->filepath = 'recuversement/'.$ref;
        $ecmfile->filename = $filename;
        $ecmfile->label = md5_file(dol_osencode($file)); // $destfile is a full path to file
        $ecmfile->fullpath_orig = $file;
        $ecmfile->gen_or_uploaded = 'unknown';
        $ecmfile->description = ''; // indexed content
        $ecmfile->keywords = ''; // keyword content
        $ecmfile->share = $share = getRandomPassword(true);
        $result = $ecmfile->create($user);

        $res = file_exists($file);
        return $res;
    }


    public function Initrecuversement()
    {
        global $conf;
        
        
    }
} 
	

	
?>