<?php

require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
require_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';


dol_include_once('/recuversement/class/recuversement.class.php');

/**
 * Class Actionsrecuversement
 */
class Actionsrecuversement
{
	/**
	 * @var array Hook results. Propagated to $hookmanager->resArray for later reuse
	 */
	public $results = array();

	/**
	 * @var string String displayed by executeHook() immediately after return
	 */
	public $resprints;

	/**
	 * @var array Errors
	 */
	public $errors = array();

	public $pagetohooks;

	/**
	 * Constructor
	 */
	public function __construct()
	{
	}

	public function doActions($parameters, &$object, &$action, $hookmanager)
	{
		global $conf, $langs, $db, $user, $selectedfields, $pdf;

		require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
		require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
		require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';

		require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
		require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
		require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
		require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';

		dol_include_once('/recuversement/class/recuversement.class.php');

		$form = new Form($db);
		if( $parameters['currentcontext'] == 'paymentlist'){

			$massaction = GETPOST('massaction');
			$toselect = GETPOST('toselect', 'array');

			$nblines=0;
			$nblineserror=0;

			if($massaction && count($toselect)>0){
				$versement = new recuversement($db);
				$paiement = new Paiement($db);

				foreach ($toselect as $key => $objid) {
					if($objid>0){
						$paiement->fetch($objid);
					    $res = $versement->generateRecuVersementDocument($paiement);  
					    if($res>0) $nblines++;
					    else $nblineserror++;     
					}
				}

				if($nblines>0)
					setEventMessages($langs->trans('RecuVersementsGenerated', $nblines), null, 'mesgs');
				if($nblineserror>0)
					setEventMessages($langs->trans('EchecRecuVersementGenerated', $nblineserror), null, 'errors');

			    header('Location: '. DOL_URL_ROOT.'/compta/paiement/list.php');
			    exit();

			}
		}

	}


	public function printFieldListOption($parameters, &$object, &$action, $hookmanager)
	{
		global $conf, $langs, $element_exepensereport, $selectedfields;

		if($parameters['currentcontext'] == 'paymentlist'){
			$name = 'massaction';
			$alwaysvisible=0;
			$cssclass='checkforselect';

			$langs->load('recuversement@recuversement');

			require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
			$form = new Form($this->db);

			$selectedfields .= $form->showCheckAddButtons('checkforselect', 1);

			$disabled = 0;
			$ret = '<div class="centpercent center">';
				$ret .= '<select class="flat'.(empty($conf->use_javascript_ajax) ? '' : ' hideobject').' '.$name.' '.$name.'select valignmiddle alignstart" id="'.$name.'" name="'.$name.'"'.($disabled ? ' disabled="disabled"' : '').'>';

					$ret .= '<option value="0"'.($disabled ? ' disabled="disabled"' : '').'>-- '.$langs->trans("SelectAction").' --</option>';
					$label = img_picto('', 'paiement', 'class="pictofixedwidth"').$langs->trans("regenererrecuversement");
					$ret .= '<option value="genererrecuversement" data-html="'.dol_escape_htmltag($label).'">'.$label.'</option>';

				$ret .= '</select>';

				

			// Warning: if you set submit button to disabled, post using 'Enter' will no more work if there is no another input submit. So we add a hidden button
				$ret .= '<input type="submit" name="confirmmassactioninvisible" style="display: none" tabindex="-1">'; // Hidden button BEFORE so it is the one used when we submit with ENTER.
				$ret .= '<input type="submit" disabled name="confirmmassaction"'.(empty($conf->use_javascript_ajax) ? '' : ' style="display: none"').' class="button smallpaddingimp'.(empty($conf->use_javascript_ajax) ? '' : ' hideobject').' '.$name.' '.$name.'confirmed" value="'.dol_escape_htmltag($langs->trans("Confirm")).'">';
			$ret .= '</div>';


			$html = '';
			$html .= '<script>
                function initCheckForSelect(mode, name, cssclass)	/* mode is 0 during init of page or click all, 1 when we click on 1 checkboxi, "name" refers to the class of the massaction button, "cssclass" to the class of the checkfor select boxes */
        		{

        			atleastoneselected=0;
                                jQuery("."+cssclass).each(function( index ) {
    	  				/* console.log( index + ": " + $( this ).text() ); */
    	  				if ($(this).is(\':checked\')) atleastoneselected++;
    	  			});

					console.log("initCheckForSelect mode="+mode+" name="+name+" cssclass="+cssclass+" atleastoneselected="+atleastoneselected);


    	  			if (atleastoneselected || '.$alwaysvisible.')
    	  			{
                        jQuery("."+name).show();
        			    '.($selected ? 'if (atleastoneselected) { jQuery("."+name+"select").val("'.$selected.'").trigger(\'change\'); jQuery("."+name+"confirmed").prop(\'disabled\', false); }' : '').'
        			    '.($selected ? 'if (! atleastoneselected) { jQuery("."+name+"select").val("0").trigger(\'change\'); jQuery("."+name+"confirmed").prop(\'disabled\', true); } ' : '').'
    	  			}
    	  			else
    	  			{
                        jQuery("."+name).hide();
                        jQuery("."+name+"other").hide();
    	            }
        		}

        		$(window).on("load", function(){
					 $("input.' . $cssclass.'").change(function() {
                        initCheckForSelect(1, "'.$name.'", "'.$cssclass.'");
                    });
                });
	        	
        		$(document).ready(function () {
					$("td.col-title").after("<td class=\'nobordernopadding center valignmiddle col-center\'>'.dol_escape_js($ret).'</td>");	
                });
            </script>';

			if (empty($conf->dol_optimize_smallscreen)) {
				$html .= ajax_combobox('.'.$name.'select');
			}

			$html .= '<script>
	        	jQuery(document).ready(function () {
                    
                    initCheckForSelect(0, "' . $name.'", "'.$cssclass.'");

                    jQuery("input.' . $cssclass.'").change(function() {
                        initCheckForSelect(1, "'.$name.'", "'.$cssclass.'");
                    });
					
				
                    jQuery(".' . $name.'select").change(function() {

	        			var massaction = $( this ).val();
	        			console.log("massaction: "+massaction);
	        			var urlform = $( this ).closest("form").attr("action").replace("#show_files","");

	        			if (massaction == "builddoc")
	                    {
	                        urlform = urlform + "#show_files";
	    	            }

	        			$( this ).closest("form").attr("action", urlform);
	                    
	                    console.log("we select a mass action name='.$name.' massaction="+massaction+" - "+urlform);
	        	        
	        	        /* Warning: if you set submit button to disabled, post using Enter will no more work if there is no other button */
	        			
	        			if ($(this).val() != \'0\')
	    	  			{
                            jQuery(".' . $name.'confirmed").prop(\'disabled\', false);
							jQuery(".' . $name.'other").hide();	/* To disable if another div was open */
                            jQuery(".' . $name.'"+massaction).show();
	    	  			}
	    	  			else
	    	  			{
                            jQuery(".' . $name.'confirmed").prop(\'disabled\', true);
							jQuery(".' . $name.'other").hide();	/* To disable any div open */
	    	  			}
	    	        });
	        	});
			</script>';
			

			// $html = '<td class="liste_titre"></td>';
			// $html .= '<td class="liste_titre"></td>';
			// if(GETPOST('action') == 'saisierestapaye'){
			// 	$html .= '<td class="liste_titre"></td>';
			// }
			
			$this->resprints = $html;
		}
		
		return 0;
	}

	public function getNomUrl($parameters, &$object, &$action, $hookmanager)
	{
		global $conf, $db;


		$context = explode(':', $parameters['context']);
		if(($parameters['currentcontext'] == 'invoicecard' || $parameters['currentcontext'] == 'paymentlist') && $object->element == "payment"){
			
			// $filename = dol_sanitizeFileName($object->ref);
			// $filedir = $conf->facture->dir_output.'/'.dol_sanitizeFileName($obj->ref);
			$urlsource = $_SERVER['PHP_SELF'].'?id='.$object->id;
			$idp = $object->id;
			
			$formfile = new FormFile($db);

			$filename = dol_sanitizeFileName($object->ref);
            $fileurl = $conf->recuversement->dir_output.'/'.$filename;
            $result='';
            // Aperçu
            if(file_exists($fileurl)) {
				$result = '<span id="ng_recuversement">'.$formfile->getDocumentsLink('recuversement', $filename, $fileurl).'</span>';
            }
            
            if($parameters['currentcontext'] == 'paymentlist'){
            	$result .= '<script>
            		$(document).ready(function(){
            			$("a[href=\''.dol_buildpath("/compta/paiement/card.php?id=".$parameters['id'], 1).'\']").parents("tr").find("td:last").css("text-align", "center");
            			$("a[href=\''.dol_buildpath("/compta/paiement/card.php?id=".$parameters['id'], 1).'\']").parents("tr").find("td:last").html("<input id=\'cb'.$parameters['id'].'\' class=\'flat checkforselect\' type=\'checkbox\' name=\'toselect[]\' value=\''.$parameters['id'].'\' >");
        			});
            	</script>';
            }

            $this->resprints = $result;
		}

		return 0;
	}

	public function formDolBanner($parameters, &$object, &$action, $hookmanager)
	{
		global $conf, $db;

		$context = explode(':', $parameters['context']);
		if(($parameters['currentcontext'] == 'paymentcard') && $object->element == "payment"){
			// $filename = dol_sanitizeFileName($object->ref);
			// $filedir = $conf->facture->dir_output.'/'.dol_sanitizeFileName($obj->ref);
			$urlsource = $_SERVER['PHP_SELF'].'?id='.$object->id;
			
			$formfile = new FormFile($db);

			$filename = dol_sanitizeFileName($object->ref);
            $fileurl = $conf->recuversement->dir_output.'/'.$filename;
			$result = '<input type="hidden" name="id_paiement" id="id_paiement" value="'.$object->id.'">';
            
            // Aperçu
            if(file_exists($fileurl)) {
				$result .= '<span id="ng_recuversement">'.$formfile->getDocumentsLink('recuversement', $filename, $fileurl).'</span>';
            }

            $this->resprints = $result;
		}

		return 0;
	}



	public function addMoreActionsButtons($parameters, &$object, &$action, $hookmanager)
	{
		global $langs;


		return 0;
	}


	/**
	 * printCommonFooter
	 *
	 * @param array 		$parameters		array of parameters
	 * @param Object	 	$object			Object
	 * @param string		$action			Actions
	 * @param HookManager	$hookmanager	Hook manager
	 * @return int
	 */
	public function printCommonFooter($parameters, &$object, &$action, $hookmanager)
	{
		global $conf, $user, $langs, $extrafieldsdet;

		$langs->load('recuversement@recuversement');
		/// Entity
		if(($parameters['currentcontext'] == 'paymentcard')){
			echo '<script>
				$(document).ready(function(){
					var id_paiement = $("#id_paiement").val();
					$(".tabsAction").prepend(\'<a href="'.dol_buildpath('recuversement/card.php',1).'?id_paiement=\'+id_paiement+\'&action=genererrecuversement" class="butAction badge-status1">'.$langs->trans('regenererrecuversement').'</a>\');
				})
			</script>';
		}

		return 0;
	}

}
