<?php 
if (empty($conf) || ! is_object($conf))
{
    echo "Error, template page can't be called as URL";
    exit;
}

global $conf, $user;

require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture-rec.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/modules/facture/modules_facture.php';
require_once DOL_DOCUMENT_ROOT.'/categories/class/categorie.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/discount.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/invoice.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/accountancy/class/accountingjournal.class.php';


echo '<link rel="stylesheet" type="text/css" href="'.DOL_URL_ROOT.'/includes/jquery/plugins/select2/dist/css/select2.css">';
echo '<link rel="stylesheet" type="text/css" href="'.DOL_URL_ROOT.'/includes/jquery/plugins/select2/dist/css/select2.min.css">';
echo '<script src="'.DOL_URL_ROOT.'/includes/jquery/plugins/select2/dist/js/select2.min.js"></script>';
echo '<script src="'.DOL_URL_ROOT.'/includes/jquery/plugins/select2/dist/js/select2.js"></script>';
    

$action = GETPOST("action");


dol_include_once("/portailfactur/lib/portailfactur.lib.php");
dol_include_once("/portailfactur/class/portailfactur.class.php");

$form = new Form($db);
$userstatic = new User($db);
$object    = new Facture($db);
$client    = new Societe($db);
$paiement = new Paiement($db);
$portail = new portailfactur($db);
$extrafields = new ExtraFields($db);
$id_banq=0;

$langs->loadLangs(array('bills', 'companies', 'compta', 'products', 'banks', 'main', 'withdrawals', 'portailfactur@portailfactur'));
$modname = $langs->trans("portailfactur");

$facid = (GETPOST('id', 'int') ?GETPOST('id', 'int') : GETPOST('facid', 'int')); // For backward compatibility
$ref = GETPOST('ref', 'alpha');
$fk_reglement = GETPOST('fk_reglement', 'int');
$action = GETPOST('action', 'alpha');
$actionpdf = GETPOST('etat_pdf', 'alpha');
$exportxsl = GETPOST('exportxsl', 'alpha');

$id_fact=GETPOST('id_fact');
$srch_qty=GETPOST('srch_qty');
$exportpdf = GETPOST('exportpdf');
$exportxsl = GETPOST('exportxsl');
$actionexport = $exportpdf ? 1 : ($exportxsl ? 1 : 0);
if($action == 'downloadportailfacturpdf'){
    $actionexport = 1;
}
if($action == 'downloadportailfacturxls'){
    $exportxsl = 1;
}

$debut = dol_mktime(0, 0, 0, GETPOST('debutmonth'), GETPOST('debutday'), GETPOST('debutyear'));
$fin = dol_mktime(0, 0, 0, GETPOST('finmonth'), GETPOST('finday'), GETPOST('finyear'));
$debut = $debut ? $db->idate($debut) : '';
$fin = $fin ? $db->idate($fin) : '';

if(empty($debut) && GETPOST('debut')) $debut=GETPOST('debut');
if(empty($fin) && GETPOST('fin')) $fin=GETPOST('fin');



$srch_datec = dol_mktime(0, 0, 0, GETPOST('srch_datecmonth'), GETPOST('srch_datecday'), GETPOST('srch_datecyear'));
// $limit = GETPOST('limit', 'int') ?GETPOST('limit', 'int') : $conf->liste_limit;
$limit = GETPOST('limit', 'int') ?GETPOST('limit', 'int') : 20;
$sortfield = GETPOST('sortfield', 'alpha') ? GETPOST('sortfield', 'alpha') : 'f.datef';
$sortorder = GETPOST('sortorder', 'alpha') ? GETPOST('sortorder', 'alpha') : 'ASC';
$page = GETPOSTISSET('pageplusone') ? (GETPOST('pageplusone') - 1) : GETPOST('page', 'int');
if (empty($page) || $page === -1 || !empty($search_btn) || !empty($search_remove_btn) || (empty($toselect) && $massaction === '0')) { $page = 0; }     

$offset = $limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$filter='';
$solde=0;
if (GETPOST('button_removefilter_x') || GETPOST('button_removefilter') || $page < 0) {
    $filter = '';
    $offset = 0;
    $filter = '';
}

$sql = "SELECT f.rowid as facid, f.ref as ref, f.cas, f.mode_reglement, ff.ref as ref_fact, ff.fk_account as id_banq, s.rowid as socid, s.nom as client, fd.rowid as lignid, fd.n_bc, ef.stliv, fd.chantier, fd.fk_prod, p.rowid as prodid,  fd.qty, fd.price, fd.total_ht, fd.total_tva, fd.total_ttc, fd.tva, p.label, fd.descp FROM ".MAIN_DB_PREFIX."pf_facture as f";
$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."pf_facturedet as fd ON fd.fk_facture=f.rowid";
$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."facture as ff ON ff.rowid=fd.origine_fact";
$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."facture_extrafields as ef ON ef.fk_object=ff.rowid";
$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."societe as s ON s.rowid=f.fk_client";
$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."product as p ON p.rowid=fd.fk_prod";
// $sql .= " LEFT JOIN ".MAIN_DB_PREFIX."pf_chantiers as c ON c.rowid=f.fk_chantier";
$sql .= " WHERE f.rowid=".$id_fact." AND f.entity=".$conf->entity;
$sql .= " ORDER BY f.rowid ASC";

// echo $sql;

$resql = $db->query($sql);
if($resql){
    while($obj = $db->fetch_object($resql)){
        $data[$obj->facid]['ref']=$obj->ref;
        $data[$obj->facid]['client']=$obj->client;
        $data[$obj->facid]['socid']=$obj->socid;
        $data[$obj->facid]['mode_reglement']=$obj->mode_reglement;
        $data[$obj->facid]['cas']=$obj->cas;
        $id_banq = $obj->id_banq ? $obj->id_banq : $id_banq;
        $dataligne=array();
        if($obj->lignid){
            $dataligne['ref_fact']=$obj->ref_fact;
            $dataligne['n_bc']=$obj->n_bc;
            $dataligne['chantier']=$obj->chantier;
            $dataligne['stliv']=$obj->stliv;
            $dataligne['id_lign'] = $obj->lignid;
            $dataligne['product'] = $obj->prodid;
            $dataligne['label'] = $obj->label;
            $dataligne['descp'] = $obj->descp;
            $dataligne['qty'] = $obj->qty;
            $dataligne['price'] = $obj->price;
            $dataligne['total_ht'] = $obj->total_ht;
            $dataligne['total_tva'] = $obj->total_tva;
            $dataligne['total_ttc'] = $obj->total_ttc;
        }
        $data[$obj->facid]['lines'][]=$dataligne;
    }
}
$arrpayement = [];
$resql = $db->query($sql);
$factsid = '';
$socid = $data[$id_fact]['socid'];

$arrainvoics = array();

$urlpayement    = DOL_URL_ROOT.'/compta/paiement/card.php?id='; 
$urlfacture     = DOL_URL_ROOT.'/compta/facture/card.php?facid=';
$urlproduct     = DOL_URL_ROOT.'/product/card.php?id=';

$currency = $langs->getCurrencySymbol($conf->currency);

$client = new Societe($db);
$client->fetch($socid);
$cas = $data[$id_fact]['cas'];
// /*-------------PDF-----------------*/
if($actionexport){
    global $conf, $langs, $mysoc;


    require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
    require_once dol_buildpath('/portailfactur/pdf/pdf.lib.php');

    $html.='';
    $filename = html_entity_decode($langs->trans('portailfactur'));
    include $context->tplPath. '/portailfactur/portailfactur-pdf.php';
    $heightheader = $conf->global->PORTAILFACTUR_HEADER_PDF_HEIGHT ? $conf->global->PORTAILFACTUR_HEADER_PDF_HEIGHT : 40;
    $heightfooter = $conf->global->PORTAILFACTUR_FOOTER_PDF_HEIGHT ? $conf->global->PORTAILFACTUR_FOOTER_PDF_HEIGHT : 30;


    $pdf->SetFooterMargin(0);
    $pdf->setPrintFooter(false);
    $pdf->SetAutoPageBreak(TRUE,$heightfooter);

    $pdf->setTopMargin($heightheader);
    $pdf->setPrintHeader(false);


    $pdf->SetFont('helvetica', '', 9, '', true);
    $pdf->AddPage('P');
    $margint = $pdf->getMargins()['top'];
    $marginb = $pdf->getMargins()['bottom'];
    $marginl = $pdf->getMargins()['left'];
    $marginr = $pdf->getMargins()['right'];
    $object->fetch($id);
    $item = $object;


    $pdf->SetTextColor(0, 0, 60);

    $default_font_size = 9;
    $pdf->SetFont('', 'B', $default_font_size);
    $posy   = $margint;
    $posx   = $pdf->page_largeur-$pdf->getMargins()['right']-100;

    $pdf->SetXY($marginl, $posy);

    
    $height=$pdf->getPageHeight();
    // $img_file = dol_buildpath('/portailfactur/img/FACTURE IMPRIMER-1.png',1);
    // $pdf->Image($img_file, 0, 0, $width, $height, '', '', '', false, 300, '', false, false, 0);
   
    $pdf->SetFont('', '', $default_font_size);

    $pdf->writeHTML($html, true, false, true, false, '');
    ob_start();
    $namemod=$langs->trans('portailfactur');
    $pdf->Output($namemod.'.pdf', 'I');
    //ob_end_clean();
    die();
}
if($exportxsl){
    include $context->tplPath. '/portailfactur/portailfactur-pdf.php';
}

$arr_cas=[
    1 => $langs->trans('ttc_noairsi'),
    2 => $langs->trans("ttc_airsi"),
    3 => 'En TTC Avec transport',
    4 => $langs->trans('ttc_airsi_transp'),
    5 => $langs->trans('exoner_transp'),
    6 => 'En Exonere (HT) sans Transport'
];

echo '<div id="portailfactur" class="div-table-responsive">';
    echo '<form method="POST" action="'.$context->getRootUrl().'script/update_factur.php?id_fact='.$id_fact.'&action=update" ><br>';
        
        echo '<input type="hidden" name="debut" value="'.$debut.'">';
        echo '<input type="hidden" name="fin" value="'.$fin.'">';
        echo '<input type="hidden" name="id_fact" value="'.$id_fact.'">';
            echo '<div class="d-inline-block w-100 div-infoshow">';
                echo '<div class="float-left">';
                    echo '<div><span class="text-secondary"><b>'.$langs->trans("Ref").': </b></span><span class="text-primary">'.$data[$id_fact]['ref'].'</span></div>';
                    echo '<div><span class="text-secondary"><b>'.$langs->trans("Customer").': </b></span><span class="text-primary">'.$data[$id_fact]['client'].'</span></div>';
                echo '</div>';
                    echo '<div class="float-right" >';
                        if($action != "edit"){
                            if($cas)
                            echo '<span class="text-secondary"><b>'.$langs->trans("Cas_generation").': </b></span>'.$arr_cas[$cas];
                            echo '&nbsp;&nbsp;<a class="btn btn-primary" style="background:#007bff !important;" href="'.$context->getRootUrl('showfactur').'&action=edit&id_fact='.$id_fact.'">'.$langs->trans("Update").'</a>';
                            $dowloadUrl = $context->getRootUrl().'script/interface.php?action=downloadportailfacturpdf&id_fact='.$id_fact;
                            $dowloadUrlxls = $context->getRootUrl().'script/interface.php?action=downloadportailfacturxls&id_fact='.$id_fact;
                            echo '&nbsp;&nbsp;<a class="btn btn-primary" target="_blank" href="'.$dowloadUrl.'" >'.$langs->trans("genere_etat").'</a>';
                            echo '&nbsp;&nbsp;<a class="btn btn-primary" target="_blank" href="'.$dowloadUrlxls.'" name="exportxsl" >'.$langs->trans("genere_etat_xls").'</a>';
                        }else{
                            echo '<span class="text-secondary"><b>'.$langs->trans("casgenere").': </b></span>'.selectEtatpdf($data[$id_fact]['cas']);
                            echo '&nbsp; &nbsp;<button type="submit" class="btn btn-primary">'.$langs->trans("Valider").'</button>';
                            echo '&nbsp; &nbsp;<a class="btn btn-secondary" href="'.$context->getRootUrl("showfactur").'&id_fact='.$id_fact.'"> '.$langs->trans("Cancel").'</a>';
                        }

                    echo '</div>';
            echo '</div>';

        echo '<table id="invoice-list" class="table table-striped">';
            $clsp=0;

            echo '<tr class="liste_titre_filter">';
                echo ' <th class="text-center" >'.$langs->trans('ContactDefault_facture').'</th>';
                echo ' <th class="text-center" >'.$langs->trans('n_bc').'</th>';
                echo ' <th class="text-center" >'.$langs->trans('chantier').'</th>';
                echo ' <th class="text-center" >'.$langs->trans('N° BL').'</th>';
                
                echo '<th class="text-center" class="wrapcolumntitle liste_titre tdlabeltable">'.$langs->trans("Label").'</th>';
                echo '<th class="text-center" class="wrapcolumntitle liste_titre tdqtytable">'.$langs->trans("Qty").'</th>';
                echo '<th class="text-center" class="wrapcolumntitle liste_titre tdamounttable">'.$langs->trans("PriceUHT").'</th>';
                echo '<th class="text-center" >'.$langs->trans('AmountHT').'</th>';
                echo '<th class="text-center" >'.$langs->trans('TVA 18%').'</th>';
                echo '<th class="text-center" >'.$langs->trans('airsi').'</th>';
                echo '<th class="text-center" >'.$langs->trans('AmountTTC').'</th>';
                echo '<th class="text-center" >'.$langs->trans('Action').'</th>';

            echo '</tr>';
          
            $service = dolibarr_get_const($db, 'PORTAILFACTUR_SERVICE_TRANSPORT', $conf->entity);
            $totalqty=0;
            $total_ht=0;
            $totaltva=0;
            $total_ttc=0;
            $ht_transp=0;
            $ttc_transp=0;
            $tva_transp=0;
            $totalairsi=0;
            if($data){
                foreach ($data as $key => $value) {
                    $airsi=0;
                    $lines=$value['lines'];
                    $line0=[];
                    $rowspan = $lines ? 'rowspan="'.count($lines).'"' : '';
                    if($lines && count($lines)){

                        $line0 = $lines[0];
                        if($line0['product'] != $service){
                            $totalqty+=$line0['qty'];
                        }
                        if($cas == 3){

                            $amount_ttc = $line0['total_ttc'];
                            $amount_ht = ($amount_ttc*100)/118;
                            $tva18 = ($amount_ht*18)/100;
                            $airsi = $amount_ttc ? ($amount_ttc*0.2)/100 : 0;

                            if($line0['product'] == $service){
                                $amount_ht = $line0['total_ht'];
                                $tva18 = 0;
                                $price = $line0['price'];
                                $ht_transp += $amount_ht;
                                $ttc_transp += $amount_ttc;
                                $tva_transp += $tva18;
                                $ht_transp += $amount_ht;
                                $aisi_transp += $airsi;
                            }else{
                                $price = ($line0['price']/1.18);

                            }
                        }


                        elseif($cas == 1){

                            $amount_ttc = $line0['total_ttc'];
                            $amount_ht = ($amount_ttc*100)/118;
                            // $price = $line0['price'];
                            $price = $amount_ht/$line0['qty'];
                            $tva18 = ($amount_ht*18)/100;
                            $airsi = ($amount_ttc*0.2)/100;

                            if($line0['product'] == $service){
                                $ttc_transp += $amount_ttc;
                                $tva_transp += $tva18;
                                $ht_transp += $amount_ht;
                                $aisi_transp += $airsi;
                            }
                        }


                        elseif($cas == 6){
                            $price = $line0['price'];
                            $amount_ht = $line0['total_ht'];
                            $amount_ht = $line0['price']*$line0['qty'];
                            $amount_ttc = $amount_ht;
                            $tva18 = ($amount_ht*18)/100;
                        }

                        elseif($cas == 5){
                            $price = $line0['price'];
                            if($line0['product'] == $service){
                                $tva18 = 0;
                                $airsi=0;
                                $amount_ht = $line0['total_ht'];
                                $amount_ttc = $amount_ht;
                                $ttc_transp += $amount_ttc;
                                $tva_transp += $tva18;
                                $ht_transp += $amount_ht;
                                $aisi_transp += $airsi;
                            }else{
                                $amount_ttc = $line0['total_ttc'];
                                $amount_ht = $line0['price']*$line0['qty'];
                                $price = $line0['price'];
                                $tva18 = ($amount_ht*18)/100;
                                $airsi = ($amount_ttc*0.2)/100;
                            }
                        }

                        elseif($cas == 2 || $cas == 4){
                            $price = $line0['price'];
                            if($line0['product'] == $service){
                                $amount_ht = $line0['total_ht'];
                                $amount_ttc = $amount_ht;
                                $tva18 = 0;
                                $airsi=0;
                                $ttc_transp += $amount_ttc;
                                $tva_transp += $tva18;
                                $ht_transp += $amount_ht;
                                $aisi_transp += $airsi;
                            }else{
                                $amount_ttc = $line0['total_ttc'];
                                $amount_ttc = $line0['price']/1.002;
                                $price = ($amount_ttc/1.18);
                                $amount_ht = $price*$line0['qty'];
                                $tva18 = ($amount_ht*18)/100;
                                $amount_ttc = $amount_ht+$tva18;
                                $airsi = ($amount_ttc*0.2)/100;
                            }
                        }

                        $total_ttc+=$amount_ttc;
                        $total_ht+=$amount_ht;
                        $totaltva+=$tva18;
                        $totalairsi+=$airsi;
                        echo '<tr>';
                            // echo '<td align="left" ><span align="center">'.$line0['ref_fact'].'</span></td>';
                            echo '<td class="text-left">';
                                echo '<span align="center">'.$line0['ref_fact'].'</span>';
                            echo '</td>';
                            echo '<td align="left" ><span align="center">'.$line0['n_bc'].'</span></td>';
                            echo '<td align="center">'.$line0['chantier'].'</td>';
                            echo '<td align="left" >'.$line0['stliv'].'</td>';

                            echo '<td align="left">';
                                if($line0['label']) echo $line0['label'];
                                else echo $line0['descp'];
                            echo '</td>';

                            $format_tva18=$portail->format_amount($tva18);
                            $format_airsi=$portail->format_amount($airsi);

                            $tva_lign = (($line0['product'] != $service ) ? $format_tva18 : '');
                            $airsi_lign = (($line0['product'] != $service ) ? $format_airsi : '');

                            echo '<td align="center" class="editqty" data-val="'.$line0['qty'].'">'.$line0['qty'].'</td>';
                            echo '<td align="right" class="editprice" data-val="'.price2num($price).'">';
                                echo $portail->format_amount($price);
                             
                            echo '</td>';
                            echo '<td align="right" class="total_ht">';
                                echo $portail->format_amount($amount_ht);
                            echo '</td>';
                            echo '<td align="right" class="tva18">'.(($cas != 1) ? $tva_lign : $format_tva18).'</td>';
                            echo '<td align="right" class="airsi">'.(($cas != 1) ? $airsi_lign : $format_airsi).'</td>';
                            echo '<td align="right" class="total_ttc">';
                                echo $portail->format_amount($amount_ttc);
                            echo '</td>';
                            echo '<td align="center" class="action"><a class="text-success" onclick="editline(this)" data-id="'.$line0['id_lign'].'"><i class="fa fa-edit"></i></a>  <a class="text-danger" onclick="removeline(this)" data-ligne="'.$line0['id_lign'].'" href="'.$context->getRootUrl().'script/update_factur.php?action=&id_fact='.$id_fact.'&id_lign='.$line0['id_lign'].'&action=deletelign"><i class="fa fa-trash"></i></a></td>';

                        echo '</tr>';
                        // }
                        // else
                        //     $linetransp[]=$lines[0];
                        foreach ($lines as $key => $line) {
                            if($key>0){
                                if($line['product'] != $service){
                                    $totalqty+=$line['qty'];
                                }
                                if($cas == 3){

                                    $amount_ttc = $line['total_ttc'];
                                    $amount_ht = ($amount_ttc*100)/118;
                                    $tva18 = ($amount_ht*18)/100;
                                    $airsi = $amount_ttc ? ($amount_ttc*0.2)/100 : 0;
                                    
                                    if($line['product'] == $service){
                                        $amount_ht = $line['total_ht'];
                                        $tva18 = 0;
                                        $ht_transp += $amount_ht;
                                        $price = $line['price'];
                                        $ttc_transp += $amount_ttc;
                                        $tva_transp += $tva18;
                                        $ht_transp += $amount_ht;
                                        $aisi_transp += $airsi;
                                    }else{
                                        $price = ($line['price']/1.18);
                                    }
                                }
                                elseif($cas == 1){

                                    $amount_ttc = $line['total_ttc'];
                                    $amount_ht = ($amount_ttc*100)/118;
                                    // $price = $line['price'];
                                    $price = $amount_ht/$line['qty'];

                                    $tva18 = ($amount_ht*18)/100;
                                    $airsi = ($amount_ttc*0.2)/100;
                                    if($line['product'] == $service){
                                        $ttc_transp += $amount_ttc;
                                        $tva_transp += $tva18;
                                        $ht_transp += $amount_ht;
                                        $aisi_transp += $airsi;
                                    }
                                }
                                elseif($cas == 6){
                                    $price = $line['price'];
                                    $amount_ht = $line['price']*$line['qty'];
                                    $amount_ttc = $amount_ht;
                                    $tva18 = ($amount_ht*18)/100;
                                }
                                elseif($cas == 5){
                                    $price = $line['price'];
                                    if($line['product'] == $service){
                                        $amount_ht = $line['total_ht'];
                                        $amount_ttc = $amount_ht;
                                        $tva18 = 0;
                                        $airsi=0;
                                        $ttc_transp += $amount_ttc;
                                        $tva_transp += $tva18;
                                        $ht_transp += $amount_ht;
                                        $aisi_transp += $airsi;
                                    }else{
                                        $amount_ttc = $line['total_ttc'];
                                        $amount_ht = $line['price']*$line['qty'];
                                        $price = $line['price'];
                                        $tva18 = ($amount_ht*18)/100;
                                        $airsi = ($amount_ttc*0.2)/100;
                                    }
                                }
                                elseif($cas == 2 || $cas == 4){
                                    $price = $line['price'];
                                    if($line['product'] == $service){
                                        $amount_ht = $line['total_ht'];
                                        $amount_ttc = $amount_ht;
                                        $tva18 = 0;
                                        $airsi=0;
                                        $ttc_transp += $amount_ttc;
                                        $tva_transp += $tva18;
                                        $ht_transp += $amount_ht;
                                        $aisi_transp += $airsi;
                                    }else{
                                        $amount_ttc = $line['total_ttc'];

                                        $amount_ttc = $line['price']/1.002;
                                        $price = ($amount_ttc/1.18);
                                        $amount_ht = $price*$line['qty'];
                                        $tva18 = ($amount_ht*18)/100;
                                        $amount_ttc = $amount_ht+$tva18;
                                        $airsi = ($amount_ttc*0.2)/100;
                                    }
                                }

                                $total_ttc+=$amount_ttc;
                                $total_ht+=$amount_ht;
                                $totaltva+=$tva18;
                                $totalairsi += $airsi;

                                echo '<tr>';
                                    echo '<td>';
                                        // echo '<a class="text-danger" onclick="removeline(this)" data-ligne="'.$line0['id_lign'].'" href="'.$context->getRootUrl().'script/update_factur.php?action=&id_fact='.$id_fact.'&id_lign='.$line0['id_lign'].'&action=deletelign"><i class="fa fa-trash"></i></a>';
                                        echo '<span align="center">'.$line['ref_fact'].'</span>';
                                    echo '</td>';
                                    echo '<td align="left" ><span align="center">'.$line['n_bc'].'</span></td>';
                                    echo '<td align="left" ><span align="center">'.$line['chantier'].'</span></td>';
                                    echo '<td align="left" ><span align="center">'.$line['stliv'].'</span></td>';
                                    echo '<td align="left">';
                                        if($line['label']) echo $line['label'];
                                        else echo $line['descp'];
                                    echo '</td>';
                                    echo '<td align="center" class="editqty" data-id="'.$line['id_lign'].'" data-val="'.$line['qty'].'">'.$line['qty'].'</td>';
                                    echo '<td align="right" class="editprice" data-val="'.price2num($price).'">';
                                        echo $portail->format_amount($price);
                                    echo '</td>';
                                    echo '<td align="right" class="total_ht">';
                                        echo $portail->format_amount($amount_ht);
                                    echo '</td>';

                                  
                                    $format_tva18=$portail->format_amount($tva18);
                                    $format_airsi=$portail->format_amount($airsi);

                                    $tva_lign = (($line['product'] != $service ) ? $format_tva18 : '');
                                    $airsi_lign = (($line['product'] != $service ) ? $format_airsi : '');

                                    echo '<td align="right" class="tva18">'.(($cas != 1) ? $tva_lign : $format_tva18).'</td>';
                                    echo '<td align="right" class="airsi">'.(($cas != 1) ? $airsi_lign : $format_airsi).'</td>';
                                    echo '<td align="right" class="total_ttc">';
                                        echo $portail->format_amount($amount_ttc);
                                    echo '</td>';
                                    echo '<td align="center" class="action"><a class="text-success" onclick="editline(this)" data-id="'.$line['id_lign'].'"><i class="fa fa-edit"></i></a>  <a class="text-danger" onclick="removeline(this)" data-ligne="'.$line['id_lign'].'" href="'.$context->getRootUrl().'script/update_factur.php?action=&id_fact='.$id_fact.'&id_lign='.$line['id_lign'].'&action=deletelign"><i class="fa fa-trash"></i></a></td>';
                                echo '</tr>';
                            }
                        }
                    }
                }
                $new_total_ttc = ($cas == 4) ? $total_ttc-$ttc_transp : $total_ttc;
                echo '<tr class="total" style="background:#f2f2f2 !important;">';
                    echo '<td colspan="5" align="right"><b>'.$langs->trans("Total").'</b></td>';
                    echo '<td align="center"><b>'.$totalqty.'</b></td>';
                    echo '<td></td>';
                    echo '<td align="right"><b>';
                        echo $portail->format_amount($total_ht);
                    echo ' '.$currency.'</b></td>';
                    echo '<td align="right"><b>';
                        echo $portail->format_amount($totaltva);
                    echo ' '.$currency.'</b></td>';
                    echo '<td align="right"><b>';
                        echo $portail->format_amount($totalairsi);
                    echo ' '.$currency.'</b></td>';
                    echo '<td align="right"><b>';
                        echo $portail->format_amount($new_total_ttc);
                    echo ' '.$currency.'</b></td>';
                    echo '<td></td>';
                echo '</tr>';
            }
            else{
                echo '<tr><td align="center" colspan="11" >'.$langs->trans("NoRecordFound").'</td></tr>';
            }
        echo '</table>';
        if(!$action){
            $ht = $total_ht-$ht_transp;
            $ttc = $total_ttc-$ttc_transp;
            $tva = $totaltva - $tva_transp;
            $airsi = $totalairsi - $aisi_transp;
            echo '<div class="figure returnlist" style="width:100%">';
                echo '<div class="col-md-7 float-left">';
                    echo '<div class="tab_rib">';
                        echo '<b><u>'.$langs->trans("mod_payment").'</u>: </b>';
                        $mode_reglement = $data[$id_fact]['mode_reglement'];
                        if($mode_reglement){
                            $form->load_cache_types_paiements();
                            print $form->cache_types_paiements[$mode_reglement]['label'];
                        }
                    echo '</div>';
                    echo '<div class="tab_rib">';
                        if($cas==4 || $cas==2) $_ttc = $ttc;
                        if($cas==5) $_ttc = $ttc+$ht_transp;
                        if($cas==6) $_ttc = $ht;
                        if($cas==1 || $cas==3) $_ttc = $ttc+$ttc_transp;
                        echo '<b><u>'.$langs->trans("amount_lettre").'</u>: </b>';
                        echo $portail->numberToWordsFunction(abs($_ttc));
                    echo '</div>';
                    echo '<div class="tab_rib">';
                        echo 'à l\'ordre de <b>'.$mysoc->name.'</b> Compte ci-dessout: ';
                        if($id_banq){
                            require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
                            $bankstatic = new Account($db);
                            $result = $bankstatic->fetch($id_banq);
                            $paramsbank=$portail->getParamsRib($bankstatic->iban);
                            echo '<table class="table table_rib" style="width:70%; border:1px solid #ddd">';
                                echo '<tr>';
                                    echo '<td>'.$langs->trans("codeB").'</td>';
                                    echo '<td>'.$langs->trans("codeG").'</td>';
                                    echo '<td>'.$langs->trans("codeC").'</td>';
                                    echo '<td>'.$langs->trans("clerib").'</td>';
                                echo '</tr>';
                                echo '<tr>';
                                    echo '<td>'.$paramsbank['codeB'].'</td>';
                                    echo '<td>'.$paramsbank['codeG'].'</td>';
                                    echo '<td>'.$paramsbank['codeC'].'</td>';
                                    echo '<td>'.$paramsbank['clerib'].'</td>';
                                echo '</tr>';
                            echo '</table>';
                        }
                    echo '</div>';
                    
                echo '</div>';

                echo '<div class="col-md-5 float-right">';
                    echo '<table class="table table-striped border float-right" id="tabl-recap">';
                        echo '<tr>';
                            echo '<td rowspan="7" style="vertical-align: inherit;"><b>'.$langs->trans("RECAP").': </b></td>';
                        echo '</tr>';
                        
                        echo '<tr>';
                            echo '<td align="left">'.$langs->trans("AmountHT").'</td>';
                            if($cas == 1) $ht = $ht+$ht_transp;
                            echo '<td align="right">';
                                echo $portail->format_amount($ht);
                            echo ' '.$currency.'</td>';
                        echo '</tr>';
                        echo '<tr>';
                            echo '<td align="left">';
                                if($cas==5 || $cas==6)
                                    echo $langs->trans("tva_exoner").' (18%)';
                                else
                                echo $langs->trans("TAV 18%");
                            echo '</td>';
                            if($cas==1) $tva = $tva;

                            echo '<td align="right">';
                                echo $portail->format_amount($tva);
                            echo ' '.$currency.'</td>';
                        echo '</tr>';
                        if($cas!=5 && $cas!=6){
                            echo '<tr>';
                                echo '<td align="left">'.$langs->trans("AmountTTC").'</td>';
                                // $ttc_ = $ttc-$ttc_transp;
                                echo '<td align="right">';
                                    echo $portail->format_amount($ttc).' '.$currency;
                                echo '</td>';
                            echo '</tr>';
                        }
                        if($cas==2 || $cas==4){
                            echo '<tr>';
                                echo '<td align="left">'.$langs->trans("airsi").' 0,2% (Mt TTC)</td>';
                                echo '<td align="right">';
                                    echo $portail->format_amount($airsi);
                                echo ' '.$currency.'</td>';
                            echo '</tr>';
                        }
                        if($cas==3 || $cas==5 || $cas==4){
                            echo '<tr>';
                                echo '<td align="left">'.$langs->trans("transport").'</td>';
                                echo '<td align="right">';
                                    echo $portail->format_amount($ttc_transp);
                                    echo ' '.$currency.'</td>';
                            echo '</tr>';
                        }
                        echo '<tr>';
                            echo '<td align="left">'.$langs->trans("netapay").'</td>';
                            if($cas==4 || $cas==2) $ttc = $ttc+$ttc_transp+$airsi;
                            if($cas==5) $ttc = $ttc+$ht_transp;
                            if($cas==6) $ttc = $ht;
                            if($cas==1 || $cas==3) $ttc = $ttc+$ttc_transp;
                            echo '<td align="right">';
                                echo $portail->format_amount($ttc);
                                echo ' '.$currency.'</td>';
                        echo '</tr>';
                    echo '</table>';
                    echo '<div class=" float-right">';
                        echo '<a class="btn btn-secondary" href="'.$context->getRootUrl("portailfactur").'"> <i class="fa fa-list"></i> '.$langs->trans("return_list_global").'</a>';
                        echo '&nbsp;&nbsp;<a class="btn btn-danger" href="'.$context->getRootUrl().'script/update_factur.php?id_fact='.$id_fact.'&action=delete"> <i class="fa fa-trash"></i> '.$langs->trans("Delete").'</a>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        }else{
            echo '<div class="float-right">';
            echo '<a href="#" class="btn btn-info" data-toggle="modal" data-target="#facturmodal"><i class="fa fa-plus"></i>  '.$langs->trans("addfactur").'</a>';
            echo '&nbsp;&nbsp;<a href="#" class="btn btn-info" data-toggle="modal" data-target="#factlignemodal"><i class="fa fa-plus"></i>  '.$langs->trans("addlign").'</a>';
            echo '</div>';
        }
    echo '</form>';

    echo '<form method="POST" action="'.$context->getRootUrl().'script/add_factur.php" id="formmodal">';
        echo '<div class="modal fade" id="facturmodal" tabindex="-1" role="dialog" aria-labelledby="ea_errors_title" aria-hidden="true">';
            echo '<div class="modal-dialog modal-lg">';
                echo '<div class="modal-content">';
                        // <!-- Modal Header -->
                        echo '<input type="hidden" name="action" value="newfactur">';
                        echo '<input type="hidden" name="soc_id" value="'.$socid.'">';
                        echo '<input type="hidden" name="facid" value="'.$id_fact.'">';
                        echo '<div class="modal-header">';
                           echo '<h6 class="modal-title"><b>'.$langs->trans("Fusionnez_factures").'</b></h6>';
                           echo '<button type="button" class="close btn_close" data-dismiss="modal">&times;</button>';
                        echo '</div>';

                        // <!-- Modal body -->
                        echo '<div class="modal-body">';
                            echo '<div>';
                                echo '<table class="table table-bordered">';
                                    echo '<thead>';
                                        echo '<tr>';
                                            echo '<td class="col-md-2">'.$langs->trans("n_bc").'</td>';
                                            echo '<td class="col-md-2">'.$langs->trans("chantier").'</td>';
                                            echo '<td class="col-md-4">'.$langs->trans("etat_livr").'</td>';
                                            echo '<td class="col-md-4 selectfact">'.$langs->trans("Invoice").'</td>';
                                            echo '<td class="col-md-1"></td>';
                                        echo '</tr>';
                                    echo '</thead>';
                                    echo '<tbody id="linesfactg">';
                                        echo '<tr>';
                                            echo '<td><input name="datafact[0][n_bc]" class="n_bc" required></td>';
                                            echo '<td><input type="text" name="datafact[0][chantier]" class="chantier" ></td>';
                                            echo '<td><select name="datafact[0][stliv]" onchange="getFactur(this)" class="select_stliv" required >'.selectEtatlivr($socid, $id_fact).'</select></td>';
                                            echo '<td class="selectfact"><select name="datafact[0][idfact]" class="select_facture" required></select></td><td class="col-md-1"></td>';
                                        echo '</tr>';
                                    echo '</tbody>';
                                echo '</table>';
                            echo '</div>';
                            echo '<a id="newfactur" class="float-right"><span class="fa fa-plus"></span></a>';
                        echo '</div>';
                        
                        // <!-- Modal footer -->
                        echo '<div class="modal-footer">';
                            echo '<button type="button" class="btn btn-secondary" id="btn_close" data-dismiss="modal">'.$langs->trans("close").'</button>';
                            echo '<button type="submit" class="btn btn-primary">'.$langs->trans("Valider").'</button>';
                        echo '</div>';
                    
                echo '</div>';
            echo '</div>';
        echo '</div>';
    echo '</form>';

    echo '<form method="POST" action="'.$context->getRootUrl().'script/update_factur.php" id="formmodal">';
        echo '<div class="modal fade" id="factlignemodal" tabindex="-1" role="dialog" aria-labelledby="ea_errors_title" aria-hidden="true">';
            echo '<div class="modal-dialog modal-lg">';
                echo '<div class="modal-content">';
                        // <!-- Modal Header -->
                        echo '<input type="hidden" name="action" value="addlign">';
                        echo '<input type="hidden" name="soc_id" value="'.$socid.'">';
                        echo '<input type="hidden" name="id_fact" value="'.$id_fact.'">';
                        echo '<div class="modal-header">';
                           echo '<h6 class="modal-title"><b>'.$langs->trans("Fusionnez_factures").'</b></h6>';
                           echo '<button type="button" class="close" data-dismiss="modal">&times;</button>';
                        echo '</div>';

                        // <!-- Modal body -->
                        echo '<div class="modal-body">';
                            echo '<div>';
                                echo '<table class="table table-bordered">';
                                    echo '<thead>';
                                        echo '<tr>';
                                            echo '<td class="col-md-4">'.$langs->trans("Invoice").'</td>';
                                            echo '<td class="col-md-8 selectfact">'.selectFacture2($socid, $id_fact).'</td>';
                                        echo '</tr>';
                                    echo '</thead>';
                                    echo '<tbody >';
                                        echo '<tr>';
                                            echo '<td class="col-md-4">'.$langs->trans("lignes").'</td>';
                                            echo '<td class="col-md-8"><select name="lignes[]" class="selectligne" multiple></select></td>';
                                        echo '</tr>';
                                    echo '</tbody>';
                                echo '</table>';
                            echo '</div>';
                        echo '</div>';
                        
                        // <!-- Modal footer -->
                        echo '<div class="modal-footer">';
                            echo '<button type="button" class="btn btn-secondary" id="btn_close" data-dismiss="modal">'.$langs->trans("close").'</button>';
                            echo '<button type="submit" class="btn btn-primary">'.$langs->trans("Valider").'</button>';
                        echo '</div>';
                    
                echo '</div>';
            echo '</div>';
        echo '</div>';
    echo '</form>';

echo  '</div>';

?>
<script>
    $(document).ready(function(){
        $('.select_etat').select2();
        $('.select_fact').select2({
            dropdownParent: $('#factlignemodal')
        });
        $('.selectligne').select2({
            dropdownParent: $('#factlignemodal')
        });
        $('select#socid').change(function(){
            $('#generate').trigger("click");
        });

        $('.select_stliv').select2({
          dropdownParent: $('#facturmodal')
        });
        
        $('td.selectfact .select_facture').select2({
          dropdownParent: $('#facturmodal')
        });
        
        $('#btn_close').click(function(){
            $("#formmodal").trigger('reset');
            $("#formmodal").find('select').select2('destroy');
            $("#formmodal").find('select option[value=""]').attr('seleted');
            $("#facturmodal").find('select').select2({
              dropdownParent: $('#facturmodal')
            });
            $("#formmodal").find('tr.new').remove();
            $("#formmodal").find('.select_facture').html("");
        })
        var arr=[];

        $('#newfactur').click(function(){
            var id =$('#linesfactg tr').length+1;
            $('.select_stliv').each(function(e, v) {
                arr[e]=$(v).find(":selected").val();
            })
            $('tbody#linesfactg').append('<tr class="new"><td><input name="datafact['+id+'][n_bc]" required class="n_bc"></td><td><select name="datafact['+id+'][chantier]" required class="listchantier" ><?php echo selectChantier($socid)?></select></td><td><select required name="datafact['+id+'][stliv]" onchange="getFactur(this)" class="select_stliv" ><?php echo selectEtatlivr($socid, $id_fact); ?></select></td><td class="selectfact"><select name="datafact['+id+'][idfact]" required class="select_facture"></select></td><td><a onclick="removeligne(this)"><span class="btn-danger fa fa-times"></span></td></tr>');
            $('.select_facture').select2({
                dropdownParent: $('#facturmodal')
            });
            $('.select_stliv').select2({
                dropdownParent: $('#facturmodal')
            });
            // $('.listchantier').select2();
            $.each(arr, function(e, v) {
                $('tbody#linesfactg tr:last-child').find('.select_stliv option[value='+v+']').remove();
            })
        })
    })
    
    function removeligne(that) {
        $(that).parents('tr').remove();
    }

    function editline(that) {
        var qty=$(that).parents('tr').find('.editqty').data('val');
        var price=$(that).parents('tr').find('.editprice').data('val');
        var id=$(that).data('id');
        $(that).parents('tr').find('.editqty').html('<input name="editqty" style="width:100%" value="'+qty+'" >');
        $(that).parents('tr').find('.editprice').html('<input name="editprice" style="width:100%" value="'+price+'" >');
        $(that).parents('tr').find('.action').find('a').hide();
        $(that).parents('tr').find('.action').append('<a class="btn-valid" data-id="'+id+'" id="submitligne" onclick="updateligne(this)"><?php echo $langs->trans("valider") ?></a> &nbsp;&nbsp;<a class="btn-cancel" href="<?php echo $context->getRootUrl("showfactur");?>&action=edit&id_fact=<?php echo $id_fact; ?>"><?php echo $langs->trans("Cancel"); ?></a>');
    }

    function getFactur(that) {
        var val = $(that).val();
            
        $.ajax({
            url:'<?php echo dol_buildpath('/portailfactur/www/script/getFacture.php',2) ?>',
            type:'POST',
            data:{'stliv':val, 'socid':<?php echo $socid ?>, 'facid':<?php echo $id_fact; ?>, },
            success:function(data){

                $(that).parents('tr').find('.select_facture').html(data);
                $(that).parents('tr').find('.select_facture').select2({
                    dropdownParent: $('#facturmodal')
                });
            }
        })
    }
    function getLignes(that) {
        var val = $(that).val();
            
        $.ajax({
            url:'<?php echo dol_buildpath('/portailfactur/www/script/getFacture.php?action=getligne',2) ?>',
            type:'POST',
            data:{'facid':val, },
            success:function(data){

                $('.selectligne').html(data);
                $('.selectligne').select2({
                    dropdownParent: $('#factlignemodal')
                });
            }
        })
    }
    function updateligne(that) {
        var val = $(that).val();
        var id = $(that).data('id');
        var qty = $(that).parents('tr').find('input[name="editqty"]').val();
        var prix = $(that).parents('tr').find('input[name="editprice"]').val();
        $.ajax({
            url:'<?php echo dol_buildpath('/portailfactur/www/script/update_factur.php?action=updateajax',2) ?>',
            type:'POST',
            data:{'id_lign':id, 'qty':qty, 'price':prix },
            success:function(data){
                location.reload();
            }
        })
    }
</script>
<?php

dol_fiche_end();

// llxFooter();
// $db->close();
