<?php 

$res=0;
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php"); // For "custom" 
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/comm/action/class/actioncomm.class.php';

require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
include_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';

dol_include_once('/portailfactur/class/chantiers.class.php');
dol_include_once('/portailfactur/lib/portailfactur.lib.php');


$langs->load('portailfactur@portailfactur');

$modname = 'chantier';
$modname = $langs->trans($modname);
// Get parameters
$extrafields = new ExtraFields($db);

$chantier = new chantiers($db);
$societe   = new Societe($db);

$request_method = $_SERVER['REQUEST_METHOD'];
$action  = GETPOST('action', 'alpha');
$page  = GETPOST('page');
$id      = (int) ( (!empty($_GET['id'])) ? $_GET['id'] : GETPOST('id') ) ;
$form   = new Form($db);


if(!empty($id)){
    $object = new chantiers($db);
    $object->fetch($id);
    if (!($object->rowid > 0))
    {
        $langs->load("errors");
        print($langs->trans('ErrorRecordNotFound'));
        exit;
    }
} 


if(in_array($action, ["add","edit"])) {
    if (!$user->rights->portailfactur->lire) {
      accessforbidden();
    }
}

// if($action == "delete") {
//     if (!$user->rights->portailfactur->supprimer) {
//       accessforbidden();
//     }
// }

$debut = dol_mktime(GETPOST('debuthour'), GETPOST('debutmin'), 0, GETPOST('debutmonth'), GETPOST('debutday'), GETPOST('debutyear'));
$fin = dol_mktime(GETPOST('finhour'), GETPOST('finmin'), 0, GETPOST('finmonth'), GETPOST('finday'), GETPOST('finyear'));

if ($action == 'create' && $request_method === 'POST') {
    $page  = GETPOST('page');

    $insert = array(
        'label'     =>  GETPOST('label'),
        'fk_client' =>  GETPOST('client'),
        'debut'     =>  $db->idate($debut),
        'fin'       =>  $db->idate($fin),
        'entity'    =>  $conf->entity
    );

    $object = new chantiers($db);

    $avance = $object->create(1, $insert);

    //If no SQL error we redirect to the request card
    if ($avance > 0) {
        header('Location: ./card.php?id='. $avance);
        exit;
    } else {
        // Otherwise we display the request form with the SQL error message
        header('Location: card.php?action=request&error=SQL_Create&msg='.$suivisav->error);
        exit;
    }
}

if ($action == 'update' && $request_method === 'POST') {

    $page  = GETPOST('page');

    
    $data =  array( 
        'label'     =>  GETPOST('label'),
        'fk_client' =>  GETPOST('client'),
        'debut'     =>  $db->idate($debut),
        'fin'       =>  $db->idate($fin)
    );

    $oldobj = new chantiers($db);
    $oldobj->fetch($id);

    $isvalid = $object->update($id, $data);


    if($isvalid > 0 && $id){  

        header('Location: ./card.php?id='.$id);
        exit;
    }else {
        header('Location: ./card.php?id='. $id .'&update=0');
        exit;
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
    
    if (!$id || $id <= 0) {
        header('Location: ./card.php?action=request&error=dalete_failed&id='.$id);
        exit;
    }

    $chantier->fetch($id);
    $error = $chantier->delete();

    // echo 
    if ($error == 1) {
        header('Location: list.php?delete='.$id.'&page='.$page);
        exit;
    }
    else {      
        header('Location: card.php?delete=1&page='.$page);
        exit;
    }
}

/* ------------------------ View ------------------------------ */


llxHeader(array(), $modname);
print_fiche_titre($modname);    // TITLE

// methode ajouter un element
if($action == "add"){
    print '<form method="post" action="'.$_SERVER["PHP_SELF"].'" class="card_chantier">';
        print '<input type="hidden" name="action" value="create" />';
        print '<input type="hidden" name="page" value="'.$page.'" />';

        print '<table class="border" width="100%">';
       
            print '<tbody>';
                print '<tr>';
                    print '<td class="width150">'.$langs->trans('Label').'</td>';
                    print '<td > <input type="text" name="label"> </td>';
                print '</tr>';
                print '<tr>';
                    print '<td class="width150">'.$langs->trans('Customer').'</td>';
                    print '<td >'.$form->select_company(0,'client', '(s.client = 1 OR s.client = 2 OR s.client = 3) AND status=1').'</td>';
                print '</tr><tr>';
                    print '<td >'.$langs->trans('DateStart').'</td>';
                    print '<td >';
                        print $form->selectDate('', 'debut', 0, 0, 1);
                    print '</td>';
                print '</tr><tr>';
                    print '<td >'.$langs->trans('DateEnd').'</td>';
                    print '<td >';
                        print $form->selectDate('', 'fin', 0, 0, 1);
                    print '</td>';
                print '</tr>';

            print '</tbody>';
        print '</table>';
        print '<br><br>';

        // Actions
        print '<table class="" width="100%">';
            print '<tr>';
                print '<td colspan="2">';
                print '<br><center><input type="submit" value="'.$langs->trans('Validate').'" name="bouton" class="button" />';
                print '  <input type="button" class="button" value="'.$langs->trans("Cancel").'" onclick="javascript:history.go(-1)"></center>';
                print '</td>';
            print '</tr>';
        print '</table>';
    print '</form>';

    //include_once DOL_DOCUMENT_ROOT.'/core/tpl/document_actions_pre_headers.tpl.php';
    //include_once DOL_DOCUMENT_ROOT . '/core/tpl/document_actions_post_headers.tpl.php';
}

// methode modifier un element
if($action == "edit"){


    $object = new chantiers($db);
    $object->fetch($id);
    $item = $object;

    print '<form method="post" action="'.$_SERVER["PHP_SELF"].'" enctype="multipart/form-data" class="card_suivi_sav">';
    print '<input type="hidden" name="action" value="update" />';
    print '<input type="hidden" name="id" value="'.$id.'" />';
    print '<input type="hidden" name="page" value="'.$page.'" />';

    print '<table class="border" width="100%">';
        print '<tbody>';
            print '<tr>';
                print '<td class="width150">'.$langs->trans('Label').'</td>';
                print '<td > <input type="text" name="label" value="'.$item->label.'"> </td>';
            print '</tr>';
            print '<tr>';
                print '<td class="width150">'.$langs->trans('Customer').'</td>';
                print '<td >'.$form->select_company($item->fk_client,'client', '(s.client = 1 OR s.client = 2 OR s.client = 3) AND status=1').'</td>';
            print '</tr><tr>';
                print '<td >'.$langs->trans('Start').'</td>';
                print '<td >';
                    print $form->selectDate($item->debut, 'debut', 0, 0, 1);
                print '</td>';
            print '</tr><tr>';
                print '<td >'.$langs->trans('End').'</td>';
                print '<td >';
                    print $form->selectDate($item->fin, 'fin', 0, 0, 1);
                print '</td>';
            print '</tr>';

        print '</tbody>';
    print '</table>';

    // Actions

    print '<table class="" width="100%">';
    print '<tr>';
        print '<td colspan="2">';
        print '<br><center><input type="submit" value="'.$langs->trans('Validate').'" name="bouton" class="button" />';
        print ' <input type="button" class="button" value="'.$langs->trans("Cancel").'" onclick="javascript:history.go(-1)"></center>';
        print '</td>';
    print '</tr>';
    print '</table>';

    print '</form>';
}


// methode afficher / delete
if(($id && empty($action)) || $action == "delete"){

    if($action == "delete"){
        print $form->formconfirm("card.php?id=".$id,$langs->trans('confirm') , $langs->trans('msg_confirm'),"confirm_delete", 'list.php', 0, 1);
    }

    print '<form method="post" action="'.$_SERVER["PHP_SELF"].'"  class="card_suivi_sav">';
        print '<input type="hidden" name="confirm" value="no" id="confirm" />';
        print '<input type="hidden" name="id" value="'.$id.'" />';
        print '<input type="hidden" name="page" value="'.$page.'" />';
        print '<table class="border" width="100%">';
            
            $object = new chantiers($db);
            $object->fetch($id);

            print '<tbody>';
                print '<tr>';
                    print '<td class="width150">'.$langs->trans('Label').'</td>';
                    print '<td >'.$object->label.'</td>';
                print '</tr>';
                
                print '<tr>';
                    print '<td >'.$langs->trans('Client').'</td>';
                    print '<td >';
                        if($object->fk_client){
                            $societe->fetch($object->fk_client);
                            print $societe->getNomUrl(1);
                        }
                        print '</td>';
                print '</tr>';

                print '<tr>';
                    print '<td >'.$langs->trans('Start').'</td>';
                    print '<td >'.dol_print_date($object->debut, 'day').'</td>';
                print '</tr>';

                print '<tr>';
                    print '<td >'.$langs->trans('End').'</td>';
                    print '<td >'.dol_print_date($object->fin, 'day').'</td>';
                print '</tr>';

            print '</tbody>';
        print '</table>';
        print '<br><br>';

        // Actions
        print '<table class="" width="100%">';

            print '<tr>';
                print '<td colspan="2">';
                    print '<br><center><a class="butAction relative_div_" href="./card.php?id='.$object->rowid.'&action=edit">'.$langs->trans('Modify').'</a>';
                    print '<a class="butActionDelete  relative_div_" href="./card.php?id='.$object->rowid.'&action=delete">'.$langs->trans('Delete').'</a>';
                    print '<a style=" " href="./list.php" class="butAction">'.$langs->trans("Cancel").'</a></center>';
                print '</td>';
            print '</tr>';

        print '</table>';
    print '</form>';
}

print '<div id="lightbox" style="display:none;"><p>X</p><div id="content"><img src="" /></div></div>';
llxFooter();

if (is_object($db)) $db->close();

?>