<?php 

$res=0;
if (! $res && file_exists("../main.inc.php")) $res=@include("../main.inc.php");       // For root directory
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php"); // For "custom" 


require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/geturl.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
require_once DOL_DOCUMENT_ROOT.'/categories/class/categorie.class.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/dolgraph.class.php';

dol_include_once('/inforderlivraison/lib/inforderlivraison.lib.php');
dol_include_once('/inforderlivraison/class/inforderlivraison.class.php');


global $langs;

$langs->load('inforderlivraison@inforderlivraison');

$form      = new Form($db);
$object    = new Facture($db);
$inforder  = new inforderlivraison($db);
$formother = new FormOther($db);


$modlname = $langs->trans('balance_agee_dette');
$currency = $langs->getCurrencySymbol($conf->currency);

$id 			= (GETPOST('id', 'int') ? GETPOST('id', 'int') : GETPOST('facid', 'int')); // For backward compatibility
$ref 			= GETPOST('ref', 'alpha');
$action         = GETPOST('action');

$srch_year  = GETPOST('srch_year');
$srch_start = GETPOST('srch_start');
$srch_end   = GETPOST('srch_end');

$mstart = $srch_start ? $srch_start : 1;
$mend = $srch_end ? $srch_end : 12;
$srch_year = $srch_year ? $srch_year : date('Y');
// Load variable for pagination
$limit = GETPOST('limit', 'int') ?GETPOST('limit', 'int') : $conf->liste_limit;

$sortfield = GETPOST("sortfield", 'alpha');
$sortorder = GETPOST("sortorder", 'alpha');

$page = GETPOSTISSET('pageplusone') ? (GETPOST('pageplusone') - 1) : GETPOST("page", 'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$offset = $limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;

if (!$sortfield) $sortfield = 's.rowid';
if (!$sortorder) $sortorder = 'DESC';

$param='';


if (GETPOST("button_removefilter_x")) {
	$srch_year =''; 
	$srch_start =''; 
	$srch_end =''; 
}

if ($srch_year)	$param .= '&srch_year='.urlencode($srch_year);
if ($srch_start)	$param .= '&srch_start='.urlencode($srch_start);
if ($srch_end)	$param .= '&srch_end='.urlencode($srch_end);
if ($sortfield)	$param .= '&sortfield='.urlencode($sortfield);
if ($sortorder)	$param .= '&sortorder='.urlencode($sortorder);
if ($limit > 0 && $limit != $conf->liste_limit) {
	$param .= '&limit='.urlencode($limit);
}
$monthArray = monthArray($langs, 0);

$sql = 'SELECT rowid FROM '.MAIN_DB_PREFIX.'societe as s WHERE s.entity IN ('.getEntity("societe").')';
$sql .= ' AND s.fournisseur = 1 AND s.status=1';
$sql .= $db->order($sortfield, $sortorder);
// Count total nb of records
$nbtotalofrecords = '';
if (empty($conf->global->MAIN_DISABLE_FULL_SCANLIST))
{
	$result = $db->query($sql);
	$nbtotalofrecords = $db->num_rows($result);

	if (($page * $limit) > $nbtotalofrecords)	// if total resultset is smaller then paging size (filtering), goto and load page 0
	{
		$page = 0;
		$offset = 0;
	}
}
$sql .= $db->plimit($limit + 1, $offset);

$resql = $db->query($sql);
if ($resql)
{
	$num = $db->num_rows($resql);
}


/*-------------Excel-----------------*/
if($action == 'xls'){
    require_once dol_buildpath('/inforderlivraison/pdf/dette_pdf.php');
}

/*-------------PDF-----------------*/
if ($action == "pdf") {
    global $conf, $langs, $mysoc;
    
    $Client = new Societe($db);

    require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
    require_once dol_buildpath('/inforderlivraison/pdf/pdf.lib.php');
    $pdf->SetMargins(7, 2, 7, false);
    $pdf->SetFooterMargin(10);
    $pdf->setPrintFooter(true);
    $pdf->SetAutoPageBreak(TRUE,10);

    $height=$pdf->getPageHeight();

    $pdf->SetFont('helvetica', '', 9, '', true);
    $pdf->AddPage('L');
    $margint = $pdf->getMargins()['top'];
    $marginb = $pdf->getMargins()['bottom'];
    $marginl = $pdf->getMargins()['left'];

    $pdf->SetTextColor(0, 0, 60);

    $default_font_size = 9;
    $pdf->SetFont('', 'B', $default_font_size);
    $posy   = $margint;
    $posx   = $pdf->page_largeur-$pdf->getMargins()['right']-100;

    $pdf->SetXY($marginl, $posy);

    $pdf->SetXY($marginl, $posy);

    $heightimg = 15;
    if ($mysoc && $mysoc->logo)
    {
        $logodir = $conf->mycompany->dir_output;
        if (empty($conf->global->MAIN_PDF_USE_LARGE_LOGO))
        {
            $logo = $logodir.'/logos/thumbs/'.$mysoc->logo_small;
        }
        else {
            $logo = $logodir.'/logos/'.$mysoc->logo;
        }
        
        if (is_readable($logo))
        {
            $height = pdf_getHeightForLogo($logo);
            $pdf->Image($logo, $marginl, $posy, 0, $heightimg); // width=0 (auto)
        }
        else
        {
            $pdf->SetTextColor(200, 0, 0);
            $pdf->SetFont('', 'B', $default_font_size - 2);
            $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorLogoFileNotFound", $logo), 0, 'L');
            $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorGoToGlobalSetup"), 0, 'L');
        }
    }
    else
    {
        $heightimg = 8;
        $text = $mysoc->name;
        $pdf->MultiCell(100, 4, $langs->convToOutputCharset($text), 0, 'L');
    }

    $posy = $margint + $heightimg + 2;
    $pdf->SetFont('', '', $default_font_size);

    require_once dol_buildpath('/inforderlivraison/pdf/dette_pdf.php');
    // echo $html;
    // die();
    $pdf->writeHTML($html, true, false, true, false, '');
    ob_start();
    $pdf->Output($modlname.'.pdf', 'I');
    //ob_end_clean();
    die();
}


llxHeader('', $modlname);

$i=0;

echo '<form action="'.$_SERVER["PHP_SELF"].'" method="post" name="formulaire" id="etatventencaiss">';
	
	print_barre_liste($modlname, $page, $_SERVER["PHP_SELF"], $param, $sortfield, $sortorder, '', $num, $nbtotalofrecords, 'order', 0, $newcardbutton, '', $limit, 0, 0, 1);

	echo '<input type="hidden" name="token" value="'.newToken().'">';
	echo '<input type="hidden" name="sortfield" value="'.$sortfield.'">';
	echo '<input type="hidden" name="sortorder" value="'.$sortorder.'">';
	echo '<input type="hidden" name="page" value="'.$page.'">';	
	echo '<input type="hidden" name="page" value="'.$page.'">';	
	echo '<input name="limitm" type="hidden" value="'.$limit.'">';
	echo '<input name="offsetm" type="hidden" value="'.$offset.'">';
	echo '<input name="filterm" type="hidden" value="'.$filter.'">';


	// echo '<div class="liste_titre liste_titre_bydiv centpercent">';
	// 	echo '&nbsp;&nbsp;<div class="divsearchfield">'.$langs->trans("Date").': '.$form->selectDate($debut, 'debut', 0, 0, 1).'</div>';
	// echo '</div>';
	echo '<div class="div-table-responsive">';
		echo '<div class="tablfiltervents">';
			echo '<table class="tagtable" width="100%">';
				echo '<tr>';
					echo '<td class="width20p filteryear"><b><u>'.$langs->trans("Year").'</u>: </b>';
						$formother->select_year($srch_year, 'srch_year');
						echo '<button type="submit" class="liste_titre button_search" name="button_search_x" value="x"><span class="fa fa-search"></span></button>';
					echo '</td>';
					echo '<td class="width50p center filtermonth"><b><u>'.$langs->trans("Month").'</u>: </b>';
						echo '&nbsp;&nbsp;'.$langs->trans('From').': '.$formother->select_month($mstart, 'srch_start', 0, 1);
						echo '&nbsp;&nbsp;'.$langs->trans("To").': '.$formother->select_month($mend, 'srch_end', 0, 1);
						echo '<button type="submit" class="liste_titre button_search" name="button_search_x" value="x"><span class="fa fa-search"></span></button>';
					echo '</td>';
					echo '<td class="width25p right btnexport">';
						echo '<a href="'.dol_buildpath("/inforderlivraison/etatdettes.php?action=pdf".$param,2).'" target="_blank" class="butAction">'.$langs->trans("export_pdf").'</a>';
						echo '<a href="'.dol_buildpath("/inforderlivraison/etatdettes.php?action=xls".$param,2).'" target="_blank" class="butAction">'.$langs->trans("export_xls").'</a>';
					echo '</td>';
				echo '</tr>';
			echo '</table>';
		echo '</div>';
		
		echo '<table class="tagtable liste tablventencaiss">'."\n";
			echo '<tr class="liste_titre">';
				print_liste_field_titre($langs->trans("Customer"), $_SERVER['PHP_SELF'], 's.rowid', '', $param, 'align="center "', $sortfield, $sortorder);
				$start =$mstart;
				$end =$mend;
				for ($i=$start; $i <= $end; $i++) { 
					print_liste_field_titre($monthArray[$i], $_SERVER['PHP_SELF'], '', '', $param, 'align="center "', $sortfield, $sortorder);
				}
				print_liste_field_titre($langs->trans("Total"), $_SERVER['PHP_SELF'], '', '', $param, 'align="center "', $sortfield, $sortorder);
			echo '</tr>';
			$i=0;
			$totalvente=0;
			$totalencaiss=0;
			$totals=[];
			if($num){
				while ($i < min($num, $limit)) {
					$obj = $db->fetch_object($resql);
					$client = new Societe($db);
					$client->fetch($obj->rowid);
					echo '<tr>';
						echo '<td class="minwidth150">'.$client->getNomUrl(1).'</td>';
						$start =$mstart;
						$totalcre=0;
						$end =$mend;
						for ($k=$start; $k <= $end; $k++) { 
							$encaissmnt = $inforder->TotalReglmentBalanceDette($obj->rowid, ' AND MONTH(f.datef)='.$k.' AND YEAR(f.datef)='.$srch_year);
							$ventes = $inforder->TotalAchatBalanceDette($obj->rowid, ' AND MONTH(f.datef)='.$k.' AND YEAR(f.datef)='.$srch_year);
							$creance = $ventes - $encaissmnt;
							$totalcre += $creance;
							$totals[$k] += $creance;

							echo '<td class="td_amount center">'.number_format($creance, 2, ",", " ").'</td>';
						}
						echo '<td class="td_amount center">'.number_format($totalcre, 2, ",", " ").'</td>';
					echo '</tr>';
					$i++;
				}
				echo '<tr class="liste_total">';
					echo '<td>'.$langs->trans("Total").'</td>';
					for ($k=$start; $k <= $end; $k++) { 
						$total += $totals[$k];
						echo '<td class="td_amount center">'.number_format($totals[$k], 2, ",", " ").'</td>';
					}	
					echo '<td class="td_amount center">'.number_format($total, 2, ",", " ").'</td>';
				echo '</tr>';
			}

		echo '</table>';
	echo '</div>';
	



echo '</form>';

echo '<br>';

// End of page
llxFooter();
$db->close();