<?php 

$res=0;
if (! $res && file_exists("../main.inc.php")) $res=@include("../main.inc.php");       // For root directory
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php"); // For "custom" 

global $conf;
if (!$conf->releveclient->enabled || !$conf->global->RELEVE_ASSOCIE_DEBITCREDIT) {
  accessforbidden();
}


require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
require_once DOL_DOCUMENT_ROOT.'/categories/class/categorie.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture-rec.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/modules/facture/modules_facture.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/discount.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/invoice.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formaccounting.class.php';
require_once DOL_DOCUMENT_ROOT.'/accountancy/class/accountingjournal.class.php';

require_once DOL_DOCUMENT_ROOT.'/adherents/class/adherent.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/sociales/class/chargesociales.class.php';
if(class_exists('PaymentVAT'))
    require_once DOL_DOCUMENT_ROOT.'/compta/tva/class/paymentvat.class.php';
elseif(class_exists('Tva'))
    require_once DOL_DOCUMENT_ROOT.'/compta/tva/class/tva.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/sociales/class/paymentsocialcontribution.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/tva/class/tva.class.php';
require_once DOL_DOCUMENT_ROOT.'/salaries/class/paymentsalary.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/paymentvarious.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/prelevement/class/bonprelevement.class.php';
require_once DOL_DOCUMENT_ROOT.'/don/class/don.class.php';
require_once DOL_DOCUMENT_ROOT.'/don/class/paymentdonation.class.php';
require_once DOL_DOCUMENT_ROOT.'/expensereport/class/paymentexpensereport.class.php';
require_once DOL_DOCUMENT_ROOT.'/loan/class/loan.class.php';
require_once DOL_DOCUMENT_ROOT.'/fourn/class/paiementfourn.class.php';

dol_include_once("/releveclient/class/releveclient.class.php");
dol_include_once("/releveclient/lib/releveclient.lib.php");


$form = new Form($db);
$formaccounting = new FormAccounting($db);

$userstatic = new User($db);
$releveclient = new releveclient($db);
$object    = new Facture($db);
$client    = new Societe($db);
$paiement = new Paiement($db);
$extrafields = new ExtraFields($db);


$companystatic = new Societe($db);
$bankaccountstatic = new Account($db);
$userstatic= new User($db);

$banktransferstatic = new BonPrelevement($db);
$societestatic = new Societe($db);
$userstatic = new User($db);
$chargestatic = new ChargeSociales($db);
$loanstatic = new Loan($db);
$memberstatic = new Adherent($db);
$donstatic = new Don($db);
$paymentstatic = new Paiement($db);
$paymentsupplierstatic = new PaiementFourn($db);
$paymentscstatic = new PaymentSocialContribution($db);
if(class_exists('PaymentVAT'))
    $paymentvatstatic = new PaymentVAT($db);
if(class_exists('Tva'))
    $paymentvatstatic = new Tva($db);
$paymentsalstatic = new PaymentSalary($db);
$paymentdonationstatic = new PaymentDonation($db);
$paymentvariousstatic = new PaymentVarious($db);
$paymentexpensereportstatic = new PaymentExpenseReport($db);
$bankstatic = new Account($db);
$banklinestatic = new AccountLine($db);

$debut = dol_mktime(0, 0, 0, GETPOST('debutmonth'), GETPOST('debutday'), GETPOST('debutyear'));
$fin = dol_mktime(0, 0, 0, GETPOST('finmonth'), GETPOST('finday'), GETPOST('finyear'));
$debut = $debut ? $db->idate($debut) : '';
$fin = $fin ? $db->idate($fin) : '';
$typesoc = GETPOST('typesoc');
$socid = GETPOST('socid');

$srch_datep = dol_mktime(0, 0, 0, GETPOST("srch_datepmonth", 'int'), GETPOST("srch_datepday", 'int'), GETPOST("srch_datepyear", 'int'));
$srch_label = GETPOST('srch_label');
$srch_soc = GETPOST('srch_soc');
$srch_bank = GETPOST('srch_bank');
$srch_typep = GETPOST('srch_typep');
$srch_num = GETPOST('srch_num');
$srch_emetteur = GETPOST('srch_emetteur');
$srch_account_numbre = GETPOST('srch_account_numbre');

$modname = $langs->trans('assoc_debit');
$langs->loadLangs(array("other", "bills", "banks", "accountancy", "compta", "releveclient@releveclient"));

$limit = GETPOST('limit', 'int') ? GETPOST('limit', 'int') : $conf->liste_limit;
$sortfield = GETPOST('sortfield', 'alpha') ? GETPOST('sortfield', 'alpha') : 'b.dateo,b.rowid';
$sortorder = GETPOST('sortorder', 'alpha') ? GETPOST('sortorder', 'alpha') : 'ASC';
$page = GETPOSTISSET('pageplusone') ? (GETPOST('pageplusone') - 1) : GETPOST('page', 'int');

if (empty($page) || $page == -1) {
    $page = 0; // If $page is not defined, or '' or -1
}
$offset = $limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;

if ($sortfield == 'b.dateo' || $sortfield == 'b.rowid' || $sortfield == 'b.dateo,b.rowid' || !$sortfield) {
    $sortorder = $sortorder.",".$sortorder;
    $sortfield = "b.dateo,b.rowid";
}


if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter") || $page < 0) {
    $srch_datep = "";
    $offset = 0;
    $srch_datep = "";
    $srch_bank = "";
    $srch_soc = "";
    $srch_typep = "";
    $srch_num = "";
    $srch_emetteur = "";
    $srch_account_numbre = "";
    $typesoc = "";
    $socid = "";
    $debut = "";
    $fin = "";
    $dsolde = "";
}



$sql = "SELECT b.rowid, b.dateo as do, b.datev as dv, b.amount, b.label, b.rappro as conciliated, b.num_releve, b.num_chq,";
$sql .= " b.fk_account, b.fk_type, b.emetteur, ";
$sql .= " ba.rowid as bankid, ba.ref as bankref, ba.label as banklabel, ba.account_number,";
$sql .= " ef.fk_object as id_soc, s.nom as nomsoc";
$sql .= " FROM ";
$sql .= " ".MAIN_DB_PREFIX."bank_account as ba";
$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."societe_extrafields as ef on (ba.rowid = ef.account_bank)";
$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."societe as s on (s.rowid = ef.fk_object)";
$sql .= ", ".MAIN_DB_PREFIX."bank as b";
$sql .= " WHERE b.fk_account = ba.rowid";
$sql .= " AND ef.account_bank > 0 ";
if($typesoc){
    $sql .= " AND s.fk_typent = ".$typesoc;
}else
    $sql .= " AND s.fk_typent IN (47000, 46000) ";
$sql .= " AND ba.entity IN (".getEntity('bank_account').")";
$sql .= " AND ba.account_number IN ('47','47000','46','46000','471100','4711')";

if ($socid > 0) {
    $sql .= " AND ef.fk_object = ".(int) $socid;
}
if ($srch_soc) {
    $sql .= " AND s.nom LIKE '%".$srch_soc."%'";
}

if ($srch_bank) {
    $sql .= " AND ba.ref LIKE '%".$srch_bank."%'";
}

if ($srch_typep) {
    $sql .= " AND b.fk_type = '".$db->escape($srch_typep)."'";
}

if ($srch_num) {
    $sql .= natural_search("b.num_chq", $srch_num);
}

if ($srch_emetteur) {
    $sql .= " AND b.emetteur LIKE '%".$db->escape($srch_emetteur)."%'";
}

if ($srch_account_numbre && $srch_account_numbre>0) {
    $sql .= " AND ba.account_number ='".$db->escape($srch_account_numbre)."'";
}

if ($srch_label) {
    // $srch_description_to_use = $srch_label;
    $arrayoffixedlabels = array(
        'payment_salary',
        'CustomerInvoicePayment', 'CustomerInvoicePaymentBack',
        'SupplierInvoicePayment', 'SupplierInvoicePaymentBack',
        'DonationPayment',
        'ExpenseReportPayment',
        'SocialContributionPayment',
        'SubscriptionPayment',
        'WithdrawalPayment'
    );
    foreach ($arrayoffixedlabels as $keyforlabel) {
        if($keyforlabel == 'payment_salary') $keyforlabel = 'SalaryPayment';
        $translatedlabel = $langs->transnoentitiesnoconv($keyforlabel);
        if (preg_match('/'.$srch_label.'/i', $translatedlabel)) {
            $srch_description_to_use = $keyforlabel;
        }
    }
    $sql .= " AND b.label like '%".$srch_description_to_use."%'"; // Warning some text are just translation keys, not translated strings
}

if (dol_strlen($srch_datep) > 0) {
    $sql .= " AND CAST(b.dateo as date) = '".$db->idate($srch_datep)."'";
}


if (!empty($srch_label)) {
    $param .= '&srch_label='.urlencode($srch_label);
}
if (!empty($srch_bank)) {
    $param .= '&srch_bank='.urlencode($srch_bank);
}
if (!empty($srch_typep)) {
    $param .= '&type='.urlencode($srch_typep);
}
if (!empty($srch_soc)) {
    $param .= '&search_thirdparty='.urlencode($srch_soc);
}
if ($search_bid > 0) {
    $param .= '&search_bid='.urlencode($search_bid);
}

if (dol_strlen($srch_datep) > 0) {
    $param .= '&srch_datepmonth='.GETPOST('srch_datepmonth', 'int').'&srch_datepday='.GETPOST('srch_datepday', 'int').'&srch_datepyear='.GETPOST('srch_datepyear', 'int');
}

if (dol_strlen($srch_datep) > 0) {
    $param .= '&srch_datepmonth='.GETPOST('srch_datepmonth', 'int').'&srch_datepday='.GETPOST('srch_datepday', 'int').'&srch_datepyear='.GETPOST('srch_datepyear', 'int');
}

if (dol_strlen($srch_datep) > 0) {
    $param .= '&srch_datepmonth='.GETPOST('srch_datepmonth', 'int').'&srch_datepday='.GETPOST('srch_datepday', 'int').'&srch_datepyear='.GETPOST('srch_datepyear', 'int');
}

if($debut && $fin) $sql .= ' AND (CAST(b.dateo as date) BETWEEN "'.$debut.'" AND "'.$fin.'")';
elseif($debut && empty($fin)) $sql .= ' AND CAST(b.dateo as date)>= "'.$debut.'"';
elseif($fin && empty($debut)) $sql .= ' AND CAST(b.dateo as date)<= "'.$fin.'"';

$param .= $socid ? '&socid='.$socid : '';
$param .= $limit ? '&limit='.$limit : '';


// // Search criteria amount
// if ($search_debit) {
//     $sql .= natural_search('ABS(b.amount)', $search_debit, 1);
//     $sql .= ' AND b.amount <= 0';
// }

// if ($search_credit) {
//     $sql .= natural_search('b.amount', $search_credit, 1);
//     $sql .= ' AND b.amount >= 0';
// }

$sql .= $db->order($sortfield, $sortorder);

// Count total nb of records
$nbtotalofrecords = '';
if (empty($conf->global->MAIN_DISABLE_FULL_SCANLIST)) {
    $result = $db->query($sql);
    $nbtotalofrecords = $db->num_rows($result);
    if (($page * $limit) > $nbtotalofrecords) { // if total resultset is smaller then paging size (filtering), goto and load page 0
        $page = 0;
        $offset = 0;
    }
}
$sql .= $db->plimit($limit + 1, $offset);

$resql = $db->query($sql);
if (!$resql) {
    dol_print_error($db);
    exit;
}

if($socid){
    $societe = new Societe($db);
    $societe->fetch($socid);
    $id_account=$societe->array_options['options_account_bank'];
}

if(GETPOST('exportxsl')){
    $html = '';
    $filename="Releve_Associes-Debit/Credit.xls";
    require_once dol_buildpath('/releveclient/pdf/releve_assoc.php');
    header("Content-Type: application/xls");
    header("Content-Disposition: attachment; filename=".$filename."");
    echo $html;
    die(); 
}

$num = $db->num_rows($resql);

$morejs  = array();
llxHeader(array(), $modname,'','','','',$morejs,0,0);

echo load_fiche_titre($modname);
$head = releve_prepare_head();
echo dol_get_fiche_head($head, 'assoc_debit', $langs->trans('assoc_debit'), -1, 'invoice');

$morfilter = $typesoc ? 'AND s.fk_typent='.$typesoc : 'AND s.fk_typent IN(47000, 46000)';

echo '<div id="stclient" class="div-table-responsive">';
    echo '<form  method="POST" action="'.$_SERVER['PHP_SELF'].'" >';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        echo '<table class="noborder tableforfield centpercent" width="100%">';
            echo '<input type="hidden" name="action" value="generer">';
            echo '<tr>';
                echo '<td>'.$langs->trans('Period');
                    echo ' &nbsp;&nbsp;&nbsp;&nbsp;'.$langs->trans("From").' '.$form->selectDate($debut, 'debut', 0, 0, 1, '', 1, 1);
                // echo '</td>';
                // echo '<td colspan="2">';
                    echo '&nbsp;&nbsp;';
                    echo $langs->trans("To").' '.$form->selectDate($fin, 'fin', 0, 0, 1, '', 1, 1);
                echo '</td>';
                echo '<td class="right">';
                    print '<input type="radio" id="typesoc" name="typesoc" '.($typesoc == '46000' ? 'checked' : '').' value="46000"><label for="typesoc">'.$langs->trans("associes").'</label>';
                    print '&nbsp;&nbsp;<input type="radio" id="typesoc_credit" '.($typesoc == '47000' ? 'checked' : '').' name="typesoc" value="47000"><label for="typesoc_credit">'.$langs->trans("debit-credit").'</label>';
                echo '</td>';
            echo '</tr>'; 
            echo '<tr>';
                echo '<td>'.$langs->trans('ThirdParty');
                    echo $form->select_company($socid, 'socid', '(s.client = 0 AND s.fournisseur = 0 '.$morfilter.')', 'SelectThirdParty', 0, 0, null, 0, 'minwidth300');

                    // Option to reload page to retrieve customer informations. Note, this clear other input
                    if (!empty($conf->global->RELOAD_PAGE_ON_CUSTOMER_CHANGE))
                    {
                        echo '<script type="text/javascript">
                            $(document).ready(function() {
                                $("#socid").change(function() {
                                    var socid = $(this).val();
                                    var fac_rec = $(\'#fac_rec\').val();
                                    // reload page
                                    window.location.href = "'.$_SERVER["PHP_SELF"].'?action=create&socid="+socid+"&fac_rec="+fac_rec;
                                });
                            });
                        </script>';
                    }
                    if (!GETPOST('fac_rec', 'int')) 
                        echo ' <a href="'.DOL_URL_ROOT.'/societe/card.php?action=create&client=3&fournisseur=0&backtopage='.urlencode($_SERVER["PHP_SELF"].'?action=create').'"><span class="fa fa-plus-circle valignmiddle paddingleft" title="'.$langs->trans("AddThirdParty").'"></span></a>';
                echo '</td><td>';
                    echo '<a href="'.dol_buildpath('/releveclient/releve_assoc.php',2).'" class="butAction" style="padding-top: 0.4em; float:right">'.$langs->trans("Reset").'</a>';
                    echo '<input style="margin-top:0px; float:right" type="submit" value="'.$langs->trans("generetat").'" id="submitFormAssoc" name="exportpdf" class="button" />';
                echo '</td>';

            echo '</tr>'."\n";
        echo '</table>';
    echo '</form>';
        
    echo '<br>';

    echo '<form  method="POST" action="'.$_SERVER['PHP_SELF'].'">';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        echo '<input type="hidden" name="fk_account" value="'.$fk_account.'">';
        echo '<input type="hidden" name="socid" value="'.$socid.'">';
        echo '<input type="hidden" name="debut" value="'.$debut.'">';
        echo '<input type="hidden" name="fin" value="'.$fin.'">';
        echo '<input name="pagem" type="hidden" value="'.$page.'">';
        echo '<input name="offsetm" type="hidden" value="'.$offset.'">';
        echo '<input name="limitm" type="hidden" value="'.$limit.'">';
        echo '<input name="filterm" type="hidden" value="'.$filter.'">';
        echo '<input name="action" type="hidden" value="pdf">';

        $getcurrencysym = $langs->getCurrencySymbol($conf->currency);
        $massactionbutton = '';
        // $massactionbutton .= '<input name="actionpdf" type="submit" id="btn_pdf" formtarget="_blank" class="butAction" value="'.$langs->trans('generpdf').'" >';
        $massactionbutton.= '<input type="submit" value="'.$langs->trans("generxsl").'" name="exportxsl" class="butAction" />';

        print_barre_liste('', $page, $_SERVER["PHP_SELF"], $param, $sortfield, $sortorder, '', $num, $nbtotalofrecords, '', 0, $massactionbutton, '', $limit, 0, 0, 1);

        echo '<table class="tagtable liste listwithfilterbefore" id="releveclient_assoc">';
            $clsp=0;

            echo '<tr class="liste_titre_filter">';
                echo '<td class="liste_titre">'.$form->selectDate($srch_datep, 'srch_datep', 0, 0, 1).'</td>';
                echo '<td class="liste_titre"><input name="srch_label" value="'.$srch_label.'"></td>';
                echo '<td class="liste_titre"><input name="srch_soc" value="'.$srch_soc.'"></td>';
                echo '<td class="liste_titre"><input name="srch_bank" value="'.$srch_bank.'" size="8"></td>';
                print '<td>';
                    $form->select_types_paiements(empty($srch_typep) ? '' : $srch_typep, 'srch_typep', '', 2, 1, 1, 0, 1, 'maxwidth100');
                print '</td>';
                echo '<td class="liste_titre"><input name="srch_num" value="'.$srch_num.'" size="2"></td>';
                echo '<td class="liste_titre"><input name="srch_emetteur" value="'.$srch_emetteur.'" size="4"></td>';
                echo '<td class="liste_titre">';
                    print $formaccounting->select_account($srch_account_numbre, 'srch_account_numbre', 1, array(), 1, 1, 'maxwidth200');
                echo '</td>';

                echo '<td class="liste_titre"></td>';
                echo '<td class="liste_titre"></td>';
                echo '<td class="liste_titre"></td>';
                echo '<td class="liste_titre">';
                    $searchpicto = $form->showFilterButtons();
                    print $searchpicto;
                echo '</td>';
            echo '</tr>';

            echo '<tr class="liste_titre">';
                print_liste_field_titre($langs->trans("DatePayment"), $_SERVER["PHP_SELF"], "b.dateo", '', $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("Label"), $_SERVER["PHP_SELF"], "", '', $param, 'align="center" ', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("ThirdParty"), $_SERVER["PHP_SELF"], "", '', $param, 'align="center" ', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("account_bank"), $_SERVER["PHP_SELF"], "", '', $param, 'align="center" ', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("PaymentRule"), $_SERVER["PHP_SELF"], "", '', $param, 'align="center" ', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("Numero"), $_SERVER["PHP_SELF"], "", '', $param, 'align="center" ', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("CheckTransmitter"), $_SERVER["PHP_SELF"], "", "", $param, 'align="center"', $sortfield, $sortorder);
                // print_liste_field_titre($langs->trans("Bank"), $_SERVER["PHP_SELF"], "", '', $param, 'align="center" ', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("AccountAccounting"), $_SERVER["PHP_SELF"], "", "", $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("SubledgerAccount"), $_SERVER["PHP_SELF"], "", '', $param, 'align="center" ', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("Credit"), $_SERVER["PHP_SELF"], "", "", $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("Debit"), $_SERVER["PHP_SELF"], "", "", $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("Balance"), $_SERVER["PHP_SELF"], "", "", $param, 'align="center"', $sortfield, $sortorder);
            echo '</tr>';

            $i = 0;
            $balance=0;
            $showbalanceavant = false;
            if($num>0){

                while ($i < min($num, $limit)) {

                    $obj = $db->fetch_object($resql);

                    $links = $bankaccountstatic->get_url($obj->rowid);


                    if($sortfield == 'b.dateo,b.rowid' && ($sortorder == 'asc,asc' || $sortorder == 'ASC,ASC') && $socid && $id_account){
                        $balance += $obj->amount;
                    }

                    if((($sortfield == 'b.dateo,b.rowid' && $sortorder == 'desc,desc') || $debut || $fin) && $socid && $id_account){
                        $sqlforbalance = 'SELECT SUM(b.amount) as previoustotal';
                        $sqlforbalance .= " FROM ";
                        $sqlforbalance .= " ".MAIN_DB_PREFIX."bank_account as ba,";
                        $sqlforbalance .= " ".MAIN_DB_PREFIX."bank as b";
                        $sqlforbalance .= " WHERE b.fk_account = ba.rowid";
                        $sqlforbalance .= " AND ba.entity IN (".getEntity('bank_account').")";
                        $sqlforbalance .= " AND b.fk_account = ".((int) $id_account);
                        $sqlforbalance .= " AND (b.datev < '".$db->idate($db->jdate($obj->dv))."' OR (b.datev = '".$db->idate($db->jdate($obj->dv))."' AND (b.dateo < '".$db->idate($db->jdate($obj->do))."' OR (b.dateo = '".$db->idate($db->jdate($obj->do))."' AND b.rowid < ".$obj->rowid."))))";
                        $resqlforbalance = $db->query($sqlforbalance);
                        if($resqlforbalance){
                            while ($objb = $db->fetch_object($sqlforbalance)) {
                                $balanceavant = $objb->previoustotal;
                                $balance += $obj->amount;
                            }

                            if($debut && $fin && $showbalanceavant == false){
                                $datesd=date('d/m/Y', strtotime($debut.' - 1 DAY'));
                                $text = '<span class="placeholder">'.$langs->trans("soldedebitair").' '.$datesd.':  </span><span class="amount">'.price($balanceavant, 0, $langs, 1, $aftercomma).' '.$getcurrencysym .'</span>';
                                print '<div> '.$text.'</div>';
                            }
                        }
                    }

                    $showbalanceavant = true;
                    print '<tr>';
                        print '<td>'.dol_print_date($obj->do, 'day').'</td>';
                        // Description
                        $labeltoshow = '';
                        $titletoshow = '';
                        $reg = array();
                        preg_match('/\((.+)\)/i', $obj->label, $reg); // Si texte entoure de parenthee on tente recherche de traduction
                        if (!empty($reg[1]) && $langs->trans($reg[1]) != $reg[1]) {
                            $labeltoshow = $langs->trans($reg[1]);
                        } else {
                            if ($obj->label == '(payment_salary)') {
                                $labeltoshow = dol_trunc($langs->trans("SalaryPayment", 40));
                            } else {
                                $labeltoshow = dol_escape_htmltag($obj->label);
                                $titletoshow = $obj->label;
                            }
                        }
                        print '<td>'.$labeltoshow;
                            $cachebankaccount = array();
                            foreach ($links as $key => $val) {
                                print '<!-- '.$links[$key]['type'].' -->';
                                if ($links[$key]['type'] == 'withdraw') {
                                    $banktransferstatic->id = $links[$key]['url_id'];
                                    $banktransferstatic->ref = $links[$key]['label'];
                                    print ' '.$banktransferstatic->getNomUrl(0);
                                } elseif ($links[$key]['type'] == 'payment') {
                                    $paymentstatic->id = $links[$key]['url_id'];
                                    $paymentstatic->ref = $links[$key]['url_id']; // FIXME This is id, not ref of payment
                                    $paymentstatic->date = $db->jdate($obj->do);
                                    print ' '.$paymentstatic->getNomUrl(2);
                                } elseif ($links[$key]['type'] == 'payment_supplier') {
                                    $paymentsupplierstatic->id = $links[$key]['url_id'];
                                    $paymentsupplierstatic->ref = $links[$key]['url_id']; // FIXME This is id, not ref of payment
                                    print ' '.$paymentsupplierstatic->getNomUrl(2);
                                } elseif ($links[$key]['type'] == 'payment_sc') {
                                    $paymentscstatic->id = $links[$key]['url_id'];
                                    $paymentscstatic->ref = $links[$key]['url_id'];
                                    $paymentscstatic->label = $links[$key]['label'];
                                    print ' '.$paymentscstatic->getNomUrl(2);
                                } elseif ($links[$key]['type'] == 'payment_vat') {
                                    $paymentvatstatic->id = $links[$key]['url_id'];
                                    $paymentvatstatic->ref = $links[$key]['url_id'];
                                    print ' '.$paymentvatstatic->getNomUrl(2);
                                } elseif ($links[$key]['type'] == 'payment_salary') {
                                    $paymentsalstatic->id = $links[$key]['url_id'];
                                    $paymentsalstatic->ref = $links[$key]['url_id'];
                                    $paymentsalstatic->label = $links[$key]['label'];
                                    print ' '.$paymentsalstatic->getNomUrl(2);
                                } elseif ($links[$key]['type'] == 'payment_loan') {
                                    print '<a href="'.DOL_URL_ROOT.'/loan/payment/card.php?id='.$links[$key]['url_id'].'">';
                                    print ' '.img_object($langs->trans('ShowPayment'), 'payment').' ';
                                    print '</a>';
                                } elseif ($links[$key]['type'] == 'payment_donation') {
                                    $paymentdonationstatic->id = $links[$key]['url_id'];
                                    $paymentdonationstatic->ref = $links[$key]['url_id'];
                                    print ' '.$paymentdonationstatic->getNomUrl(2);
                                } elseif ($links[$key]['type'] == 'payment_expensereport') {
                                    $paymentexpensereportstatic->id = $links[$key]['url_id'];
                                    $paymentexpensereportstatic->ref = $links[$key]['url_id'];
                                    print ' '.$paymentexpensereportstatic->getNomUrl(2);
                                } elseif ($links[$key]['type'] == 'payment_various') {
                                    $paymentvariousstatic->id = $links[$key]['url_id'];
                                    $paymentvariousstatic->ref = $links[$key]['url_id'];
                                    print ' '.$paymentvariousstatic->getNomUrl(2);
                                } elseif ($links[$key]['type'] == 'banktransfert') {
                                    // Do not show link to transfer since there is no transfer card (avoid confusion). Can already be accessed from transaction detail.
                                    if ($obj->amount > 0) {
                                        $banklinestatic->fetch($links[$key]['url_id']);
                                        $bankstatic->id = $banklinestatic->fk_account;
                                        $bankstatic->label = $banklinestatic->bank_account_ref;
                                        print ' ('.$langs->trans("TransferFrom").' ';
                                        print $bankstatic->getNomUrl(1, 'transactions');
                                        print ' '.$langs->trans("toward").' ';
                                        $bankstatic->id = $obj->bankid;
                                        $bankstatic->label = $obj->bankref;
                                        print $bankstatic->getNomUrl(1, '');
                                        print ')';
                                    } else {
                                        $bankstatic->id = $obj->bankid;
                                        $bankstatic->label = $obj->bankref;
                                        print ' ('.$langs->trans("TransferFrom").' ';
                                        print $bankstatic->getNomUrl(1, '');
                                        print ' '.$langs->trans("toward").' ';
                                        $banklinestatic->fetch($links[$key]['url_id']);
                                        $bankstatic->id = $banklinestatic->fk_account;
                                        $bankstatic->label = $banklinestatic->bank_account_ref;
                                        print $bankstatic->getNomUrl(1, 'transactions');
                                        print ')';
                                    }
                                    //var_dump($links);
                                } elseif ($links[$key]['type'] == 'company') {
                                } elseif ($links[$key]['type'] == 'user') {
                                } elseif ($links[$key]['type'] == 'member') {
                                } elseif ($links[$key]['type'] == 'sc') {
                                } elseif ($links[$key]['type'] == 'vat') {
                                } elseif ($links[$key]['type'] == 'salary') {
                                    // Information is already shown using the payment_salary link. No need of this link.
                                } else {
                                    // Show link with label $links[$key]['label']
                                    if (!empty($obj->label) && !empty($links[$key]['label'])) {
                                        print ' - ';
                                    }
                                    print '<a href="'.$links[$key]['url'].$links[$key]['url_id'].'">';
                                    if (preg_match('/^\((.*)\)$/i', $links[$key]['label'], $reg)) {
                                        // Label generique car entre parentheses. On l'affiche en le traduisant
                                        if ($reg[1] == 'paiement') {
                                            $reg[1] = 'Payment';
                                        }
                                        print ' '.$langs->trans($reg[1]);
                                    } else {
                                        print ' '.$links[$key]['label'];
                                    }
                                    print '</a>';
                                }
                            }       
                        print '</td>'; 

                        print '<td>';
                            $societe = new Societe($db);
                            $societe->fetch($obj->id_soc);
                            print $societe->getNomUrl(1);
                        print '</td>';
                        // print '<td class="nowrap right">'.price($obj->amount).'</td>'; 
                        print '<td>';
                            $banq = new Account($db);
                            $banq->fetch($obj->bankid);
                            print $banq->getNomUrl(1);
                            // $obj->banklabel.
                        print '</td>';
                        print '<td>';
                            $labeltype = ($langs->trans("PaymentTypeShort".$obj->fk_type) != "PaymentTypeShort".$obj->fk_type) ? $langs->trans("PaymentTypeShort".$obj->fk_type) : $langs->getLabelFromKey($db, $obj->fk_type, 'c_paiement', 'code', 'libelle', '', 1);
                            if ($labeltype == 'SOLD') {
                                print '&nbsp;'; //$langs->trans("InitialBankBalance");
                            } else {
                                print $labeltype;
                            }
                        print '</td>';
                        print '<td>'.$obj->num_chq.'</td>';
                        print '<td>'.$obj->emetteur.'</td>';
                        print '<td>';
                            if (!empty($conf->accounting->enabled) && !empty($obj->account_number)) {
                                $accountingaccount = new AccountingAccount($db);
                                $accountingaccount->fetch('', $obj->account_number, 1);
                                print '<span title="'.dol_escape_htmltag($accountingaccount->account_number.' - '.$accountingaccount->label).'">';
                                print $accountingaccount->getNomUrl(0, 1, 1, '', 0);
                                print '</span>';
                            } else {
                                print '<span title="'.dol_escape_htmltag($obj->account_number).'">'.$obj->account_number.'</span>';
                            }
                        print '</td>';
                        print '<td>';
                            if($paymentvariousstatic->id){
                                $paymentvariousstatic->fetch($paymentvariousstatic->id);
                                print $paymentvariousstatic->subledger_account;
                            }
                        print '</td>';
                        print '<td class="nowrap right">';
                            if ($obj->amount > 0) {
                                print '<span class="amount">'.price($obj->amount, 0, $langs, 1, $aftercomma).'</span>';
                            }
                        print '</td>';
                        print '<td class="nowrap right">';
                            if ($obj->amount < 0) {
                                $amount = $obj->amount * (-1);
                                print '<span class="amount">'.price($amount, 0, $langs, 1, $aftercomma).'</span>';
                            }
                        print '</td>';
                        if($balance){
                            $cl = ($balance<0) ? 'error' : '';
                            print '<td class="nowrap right '.$cl.'">'.price($balance, 0, $langs, 1, $aftercomma).'</td>';
                        }
                        else
                            print '<td class="center"> - </td>';

                    print '</tr>';

                    $i++;
                }
            }
            else{
                print '<tr><td colspan="12" class="center"><span class="opacitymedium">'.$langs->trans('NoResults').'</span></td></td></tr>';
            }

            $totalgdebit    = 0;
            $totalgcredit   = 0;
            $totalgqty      = 0;
            $lastbalance    = $solde;
            
        echo '</table>';
    echo '</form>';

    echo '<br><br>';
echo  '</div>';

dol_fiche_end();

llxFooter();
$db->close();
