<?php 

$res=0;
if (! $res && file_exists("../main.inc.php")) $res=@include("../main.inc.php");       // For root directory
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php"); // For "custom" 

global $conf;
if (!$conf->releveclient->enabled) {
  accessforbidden();
}
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture-rec.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/modules/facture/modules_facture.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/discount.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/invoice.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/accountancy/class/accountingjournal.class.php';


dol_include_once("/releveclient/class/releveclient.class.php");

$form = new Form($db);

$userstatic = new User($db);
$releve = new releveclient($db);
$extrafields = new ExtraFields($db);
$object = new Societe($db);

$extrafields->fetch_name_optionals_label($object->table_element);

$nb_field=0;

$langs->loadLangs(array('bills', 'companies', 'compta', 'products', 'banks', 'main', 'withdrawals'));
$modname = $langs->trans("creanceclient");

$facid = (GETPOST('id', 'int') ?GETPOST('id', 'int') : GETPOST('facid', 'int')); // For backward compatibility
$ref = GETPOST('ref', 'alpha');
$fk_reglement = GETPOST('fk_reglement', 'int');
$action = GETPOST('action', 'alpha');
$socid=GETPOST('socid');

$srch_qty=GETPOST('srch_qty');
$srch_creanc = GETPOST('srch_creanc');

$debut = dol_mktime(0, 0, 0, GETPOST('debutmonth'), GETPOST('debutday'), GETPOST('debutyear'));
$fin = dol_mktime(0, 0, 0, GETPOST('finmonth'), GETPOST('finday'), GETPOST('finyear'));
$debut = $debut ? $db->idate($debut) : '';
$fin = $fin ? $db->idate($fin) : '';
   
if(empty($debut) && GETPOST('debut'))
    $debut=GETPOST('debut');

if(empty($fin) && GETPOST('fin'))
    $fin=GETPOST('fin');

$srch_datec = dol_mktime(0, 0, 0, GETPOST('srch_datecmonth'), GETPOST('srch_datecday'), GETPOST('srch_datecyear'));
$limit = GETPOST('limit', 'int') ?GETPOST('limit', 'int') : $conf->liste_limit;
$sortfield = GETPOST("sortfield", 'alpha') ? GETPOST("sortfield", 'alpha') : 'creance';
$sortorder = GETPOST("sortorder", 'alpha') ? GETPOST("sortorder", 'alpha') : 'DESC';
$page = GETPOSTISSET('pageplusone') ? (GETPOST('pageplusone') - 1) : GETPOST("page", 'int');
if (empty($page) || $page == -1 || !empty($search_btn) || !empty($search_remove_btn) || (empty($toselect) && $massaction === '0')) { $page = 0; }     

$offset = $limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$filter='';

if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter") || $page < 0) {
    $filter = "";
    $offset = 0;
    $filter = "";
}
$datalabel = $extrafields->attributes[$object->table_element]['label'];
// Extra fields
if (is_array($extrafields->attributes[$object->table_element]['label']) && count($extrafields->attributes[$object->table_element]['label']) > 0)
{
    foreach ($extrafields->attributes[$object->table_element]['label'] as $key => $val)
    {
        if (!empty($extrafields->attributes[$object->table_element]['list'][$key]))
            $arrayfields["ef.".$key] = array('label'=>$extrafields->attributes[$object->table_element]['label'][$key], 'checked'=>(($extrafields->attributes[$object->table_element]['list'][$key] == 2 || $extrafields->attributes[$object->table_element]['list'][$key] == 1 || $extrafields->attributes[$object->table_element]['list'][$key] == 4) ? 1 : 0), 'position'=>$extrafields->attributes[$object->table_element]['pos'][$key], 'enabled'=>(abs($extrafields->attributes[$object->table_element]['list'][$key]) != 3 && $extrafields->attributes[$object->table_element]['perms'][$key]));
    }
}

$sql = 'SELECT s.rowid as id_soc, s.nom, s.phone, s.code_client, SUM(f.total_ttc) as totalachat, SUM(pf.reglements) as totalreglmnt, (COALESCE(SUM(f.total_ttc),0) - COALESCE(SUM(pf.reglements),0)) as creance FROM '.MAIN_DB_PREFIX.'societe as s';

$sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'societe_extrafields as ef on (s.rowid = ef.fk_object)';
$sql .= ' LEFT JOIN ( 
    SELECT f.fk_soc, SUM(f.total_ttc) as total_ttc, f.rowid FROM '.MAIN_DB_PREFIX.'facture as f WHERE f.entity IN (0, '.getEntity('invoice').')';
    if($debut && $fin) $sql .= " AND (CAST(f.datef as date) BETWEEN '".$debut."' AND '".$fin."')";
    elseif($debut && empty($fin)) $sql .= " AND CAST(f.datef as date ) >= '".$debut."'";
    elseif($fin && empty($debut)) $sql .= " AND CAST(f.datef as date ) <= '".$fin."'";
    $sql .= 'GROUP BY f.fk_soc 
) f ON f.fk_soc = s.rowid';
$sql .= ' LEFT JOIN ( 
    SELECT DISTINCT p.rowid, ff.fk_soc as ff_soc, SUM(pf.amount) as reglements FROM '.MAIN_DB_PREFIX.'paiement as p';
    $sql .= ' LEFT JOIN llx_paiement_facture as pf ON pf.fk_paiement=p.rowid';
    $sql .= ' LEFT JOIN llx_facture as ff ON ff.rowid=pf.fk_facture';
    $sql .= ' WHERE p.entity IN (0, '.getEntity('invoice').') ';
    if($debut && $fin) $sql .= " AND (CAST(p.datep as date)  BETWEEN '".$debut."' AND '".$fin."')";
    elseif($debut && empty($fin)) $sql .= " AND CAST(p.datep as date) >= '".$debut."'";
    elseif($fin && empty($debut)) $sql .= " AND CAST(p.datep as date) <= '".$fin."'";
    $sql .= ' GROUP BY ff.fk_soc';
$sql .= ') pf ON pf.ff_soc=s.rowid';
$sql .= ' WHERE s.entity IN (0, '.getEntity('societe').') AND s.client IN (1,3) AND (s.status IN (1))';
$sql .= ' GROUP BY s.rowid';
$sql .= $srch_creanc ? ' HAVING creance >= '.$srch_creanc : '';
$sql .= ' ORDER BY '.$sortfield.' '.$sortorder;

$i=0;

if ($limit > 0 && $limit != $conf->liste_limit) $param .= '&limit='.urlencode($limit);

if(GETPOST('debutmonth')) $param .= '&debutmonth='.GETPOST('debutmonth');
if(GETPOST('debutday')) $param .= '&debutday='.GETPOST('debutday');
if(GETPOST('debutyear')) $param .= '&debutyear='.GETPOST('debutyear');

if(GETPOST('finmonth')) $param .= '&finmonth='.GETPOST('finmonth');
if(GETPOST('finday')) $param .= '&finday='.GETPOST('finday');
if(GETPOST('finyear')) $param .= '&finyear='.GETPOST('finyear');
if ($srch_creanc) $param .= '&srch_creanc='.urlencode($srch_creanc);

$nbtotalofrecords = '';
$result = $db->query($sql);
$nbtotalofrecords = $db->num_rows($result);
if (($page * $limit) > $nbtotalofrecords)   // if total resultset is smaller then paging size (filtering), goto and load page 0
{
    $page = 0;
    $offset = 0;
}


if(empty($action) || $action == 'generer')
    $sql .= $db->plimit($limit + 1, $offset);

$resql = $db->query($sql);
$i=0;

if($resql){
    $num = $db->num_rows($resql);
   
}

if (!$user->rights->releveclient->lire || !$user->rights->releveclient->export) {
    accessforbidden();
}

/*-------------Excel-----------------*/
if (GETPOST('actionxsl')) {
    require_once dol_buildpath('/releveclient/pdf/creants_pdf.php');

    header("Content-Type: application/xls");
    header("Content-Disposition: attachment; filename=Etat_Creances_Clients.xls");
    echo($html);
    die();
}

/*-------------PDF-----------------*/
if ($action == "pdf" && GETPOST('actionpdf')) {
    global $conf, $langs, $mysoc;
    
    $Client = new Societe($db);

    require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
    require_once dol_buildpath('/releveclient/pdf/pdf.lib.php');
    $pdf->SetMargins(7, 2, 7, false);
    $pdf->SetFooterMargin(10);
    $pdf->setPrintFooter(true);
    $pdf->SetAutoPageBreak(TRUE,10);

    $height=$pdf->getPageHeight();

    $pdf->SetFont('helvetica', '', 9, '', true);
    $pdf->AddPage('L');
    $margint = $pdf->getMargins()['top'];
    $marginb = $pdf->getMargins()['bottom'];
    $marginl = $pdf->getMargins()['left'];

    $pdf->SetTextColor(0, 0, 60);

    $default_font_size = 9;
    $pdf->SetFont('', 'B', $default_font_size);
    $posy   = $margint;
    $posx   = $pdf->page_largeur-$pdf->getMargins()['right']-100;

    $pdf->SetXY($marginl, $posy);

    $pdf->SetXY($marginl, $posy);

    $heightimg = 15;
    if ($mysoc && $mysoc->logo)
    {
        $logodir = $conf->mycompany->dir_output;
        if (empty($conf->global->MAIN_PDF_USE_LARGE_LOGO))
        {
            $logo = $logodir.'/logos/thumbs/'.$mysoc->logo_small;
        }
        else {
            $logo = $logodir.'/logos/'.$mysoc->logo;
        }
        
        if (is_readable($logo))
        {
            $height = pdf_getHeightForLogo($logo);
            $pdf->Image($logo, $marginl, $posy, 0, $heightimg); // width=0 (auto)
        }
        else
        {
            $pdf->SetTextColor(200, 0, 0);
            $pdf->SetFont('', 'B', $default_font_size - 2);
            $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorLogoFileNotFound", $logo), 0, 'L');
            $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorGoToGlobalSetup"), 0, 'L');
        }
    }
    else
    {
        $heightimg = 8;
        $text = $mysoc->name;
        $pdf->MultiCell(100, 4, $langs->convToOutputCharset($text), 0, 'L');
    }

    $posy = $margint + $heightimg + 2;

    $pdf->SetTextColor(0, 0, 60);
    $currentwate    = $conf->global->PAYROLLMOD_WATERMARK_IMG;
    if($currentwate){
        $bMargin = $pdf->getBreakMargin();
        $auto_page_break = $pdf->getAutoPageBreak();
        $pdf->SetAutoPageBreak(false, 0);
        $img_file = $conf->mycompany->dir_output.'/watermark/'.$currentwate;
        $pdf->SetAlpha(0.1);
        $pdf->Image($img_file, 35, 100, 140, '', '', '', '', false, 300, '', false, false, 0);
        $pdf->SetAlpha(1);
        $pdf->SetAutoPageBreak(true, $bMargin);
        $pdf->setPageMark();
    }

    $pdf->SetFont('', '', $default_font_size);

    if($id_client)
        $Client->fetch($id_client);


    require_once dol_buildpath('/releveclient/pdf/pdf.lib.php');
    require_once dol_buildpath('/releveclient/pdf/creants_pdf.php');
    // echo $html;
    // die();
    $pdf->writeHTML($html, true, false, true, false, '');
    ob_start();
    $namemod=$langs->trans('creanceclient');
    $pdf->Output($namemod.'.pdf', 'I');
    //ob_end_clean();
    die();
}

if (!empty($conf->global->MAIN_DISABLE_FULL_SCANLIST))
{
    $nbtotalofrecords='';
}

$morejs  = array();
llxHeader(array(), $modname,'','','','',$morejs,0,0);

print load_fiche_titre($modname);

// die('Traitement est en cours ...');


print '<div class="div-table-responsive">';
    print '<form  method="POST" action="'.$_SERVER['PHP_SELF'].'" >';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        print '<table class="noborder">';
            print '<input type="hidden" name="action" value="generer">';
            print '<tr>';
                print '<td>'.$langs->trans('Period').'</td>';
                print '<td>';
                    print $langs->trans("From").' '.$form->selectDate($debut, 'debut', 0, 0, 1, '', 1, 1);
                print '</td>';
                print '<td>';
                    print $langs->trans("To").' '.$form->selectDate($fin, 'fin', 0, 0, 1, '', 1, 1);
                print '</td>';
                print '<td align="right">';
                    print '<input type="number" placeholder="0.00" name="srch_creanc" value="'.$srch_creanc.'">';
                    print '<a href="'.dol_buildpath('/releveclient/creanceclient.php',2).'" class="butAction" style="padding-top: 0.4em; float:right">'.$langs->trans("Reset").'</a>';
                    print '<input style="margin-top:0px; float:right" type="submit" value="'.$langs->trans("generetat").'" name="export" class="button" />';
                print '</td>';
            print '</tr>'; 
            
        print '</table>';
    print '</form>';
    print '<br><br>';
    print '<form  method="POST" action="'.$_SERVER['PHP_SELF'].'" id="creanceclient" >';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        print '<input name="pagem" type="hidden" value="'.$page.'">';
        print '<input name="offsetm" type="hidden" value="'.$offset.'">';
        print '<input name="limitm" type="hidden" value="'.$limit.'">';
        print '<input name="filterm" type="hidden" value="'.$filter.'">';

        // date debut
        print '<input type="hidden" name="debutmonth" value="'.GETPOST('debutmonth').'">';
        print '<input type="hidden" name="debutday" value="'.GETPOST('debutday').'">';
        print '<input type="hidden" name="debutyear" value="'.GETPOST('debutyear').'">';

        // date fin 
        print '<input type="hidden" name="finmonth" value="'.GETPOST('finmonth').'">';
        print '<input type="hidden" name="finday" value="'.GETPOST('finday').'">';
        print '<input type="hidden" name="finyear" value="'.GETPOST('finyear').'">';


        print '<input type="hidden" name="srch_year" value="'.$srch_year.'">';
        print '<input type="hidden" name="srch_creanc" value="'.$srch_creanc.'">';
        print '<input name="action" type="hidden" value="pdf">';

        $massactionbutton .= '<input name="actionpdf" type="submit" id="btn_pdf" formtarget="_blank" class="button" value="'.$langs->trans('generpdf').'" >';
        $massactionbutton .= '<input name="actionxsl" type="submit" id="btn_pdf" formtarget="_blank" class="button" value="'.$langs->trans('generxsl').'" >';
        print_barre_liste('', $page, $_SERVER["PHP_SELF"], $param, $sortfield, $sortorder, '', $num, $nbtotalofrecords, 'bill', 0, $massactionbutton, '', $limit, 0, 0, 1);
        $clsp=0;
        print '<table class="noborder">';

            print '<tr class="liste_titre_filter">';
                print_liste_field_titre($langs->trans("client"), $_SERVER["PHP_SELF"], "s.rowid", '', $param, 'align="left"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("Phone"), $_SERVER["PHP_SELF"], "s.phone", "", $param, 'align="center"', $sortfield, $sortorder);
                // include DOL_DOCUMENT_ROOT.'/core/tpl/extrafields_list_search_title.tpl.php';

                if($datalabel && count($datalabel)>0){
                    foreach ($datalabel as $key => $value) {
                        if($key != 'account_bank' && ($extrafields->attributes[$object->table_element]['list'][$key] == 2 || $extrafields->attributes[$object->table_element]['list'][$key] == 1 || $extrafields->attributes[$object->table_element]['list'][$key] == 4)){
                            print_liste_field_titre($value, $_SERVER["PHP_SELF"], "ef.".$key, "", $param, 'align="right"', $sortfield, $sortorder);
                            $clsp++;
                        }
                    }
                }

                print_liste_field_titre($langs->trans("SalesRepresentatives"), $_SERVER["PHP_SELF"], "s.code_client", "", $param, 'align="left"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("CustomerCode"), $_SERVER["PHP_SELF"], "s.code_client", "", $param, 'align="right"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("TotalAchat"), $_SERVER["PHP_SELF"], "totalachat", "", $param, 'align="right"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("TotalReglement"), $_SERVER["PHP_SELF"], "totalreglmnt", "", $param, 'align="right"', $sortfield, $sortorder);

                print_liste_field_titre($langs->trans("Creance"), $_SERVER["PHP_SELF"], "creance", "", $param, 'align="right"', $sortfield, $sortorder);
            print '</tr>';

            if($num){
                $i=0;
                $data=[];
                $totalcreance =0;
                $totalachat = 0;
                $totalreglement = 0;
                while ($i < min($num,$limit)) {
                    $obj=$db->fetch_object($resql);
                    $socid=$obj->id_soc;

                    print '<tr>';
                        $totalcreance += $obj->creance;
                        $totalreglement += $obj->totalreglmnt;
                        $totalachat += $obj->totalachat;

                        $object = new Societe($db);
                        $object->fetch($obj->id_soc);

                        $commerc = $object->getSalesRepresentatives($user);
                        
                        print '<td class="" align="left">'.$object->getNomUrl(1).' </td>';
                        print '<td align="center">'.dol_print_phone($object->phone, $object->country_code, 0, $object->rowid, 'AC_TEL').'</td>';

                        if($datalabel && count($datalabel)>0){
                            foreach ($datalabel as $key => $value) {
                                if($key != 'account_bank' && ($extrafields->attributes[$object->table_element]['list'][$key] == 2 || $extrafields->attributes[$object->table_element]['list'][$key] == 1 || $extrafields->attributes[$object->table_element]['list'][$key] == 4)){
                                    echo '<td align="center">'.$object->array_options['options_'.$key].'</td>';
                                }
                            }
                        }

                        print '<td align="left">';
                            if($commerc && isset($commerc[0])){
                                $objcomerc = $commerc[0];
                                // d($objcomerc, false);
                                print '<a href="'.DOL_URL_ROOT.'/user/card.php?id='.$objcomerc['id'].'">'.$objcomerc['firstname'].' '.$objcomerc['lastname'].'</a>';
                            }
                        print '</td>';
                        print '<td align="right">'.$object->code_client.'</td>';
                        print '<td align="right">'.price($obj->totalachat, 0, $langs, 1, $aftercomma).'</td>';
                        print '<td align="right">'.price($obj->totalreglmnt, 0, $langs, 1, $aftercomma).'</td>';
                        // Extra fields

                        print '<td align="right">'.price($obj->creance, 0, $langs, 1, $aftercomma).'</td>';
                    print '</tr>';
                    $i++;
                }

                print '<tr class="liste_total">';
                    $nbtd = 4+$clsp;
                    print '<td colspan="'.$nbtd.'">Total</td>';
                    print '<td align="right">'.price($totalachat, 0, $langs, 1, $aftercomma).' '.$langs->getCurrencySymbol($conf->currency).'</td>';
                    print '<td align="right">'.price($totalreglement, 0, $langs, 1, $aftercomma).' '.$langs->getCurrencySymbol($conf->currency).'</td>';
                    print '<td align="right"><b>'.price($totalcreance, 0, $langs, 1, $aftercomma).' '.$langs->getCurrencySymbol($conf->currency).'</b></td>';
                print '</tr>';

            }else{
                $nbtd = 8+$clsp;
                print '<tr class=""><td align="center" colspan="'.$nbtd.'" >'.$langs->trans("NoRecordFound").'</td></tr>';
            }
            
        print '</table>';

    print '</form>';

    print '<br><br>';

print  '</div>';


llxFooter();
$db->close();