<?php

require_once DOL_DOCUMENT_ROOT.'/core/triggers/dolibarrtriggers.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';

dol_include_once('/recuversement/class/recuversement.class.php');

/**
 *  Class of triggers 
 */
class InterfaceRecuversementtrigger extends DolibarrTriggers
{

    /**
     * Constructor
     *
     *  @param      DoliDB      $db     Database handler
     */
    public function __construct($db)
    {
        $this->db = $db;
        $this->name = preg_replace('/^Interface/i', '', get_class($this));
        $this->family = "NextConcept";
        $this->description = "Triggers of this module are empty functions.";
        $this->version   = 'development';
        $this->picto = 'glpitodolibarr@glpitodolibarr';
    }

    /**
     * Function called when a Dolibarrr security audit event is done.
     * All functions "runTrigger" are triggered if file is inside directory htdocs/core/triggers or htdocs/module/code/triggers (and declared)
     *
     * @param string        $action     Event action code
     * @param Object        $object     Object
     * @param User          $user       Object user
     * @param Translate     $langs      Object langs
     * @param conf          $conf       Object conf
     * @return int                      <0 if KO, 0 if no triggered ran, >0 if OK
     */
    public function runTrigger($action, $object, User $user, Translate $langs, Conf $conf)
    {
        global $conf;

        $versement = new recuversement($this->db);

        if($action == 'PAYMENT_CUSTOMER_CREATE'){
            $versement->generateRecuVersementDocument($object);            
        }
        
        return 1;
            
    }

}
