<?php // Protection to avoid direct call of template
if (empty($context) || ! is_object($context))
{
	print "Error, template page can't be called as URL";
	exit;
}

$langs->load('portailfactur@portailfactur');

global $conf,$user;

$Tmenu=array();


if($context->userIsLog())
{
   
	if($conf->global->RIGHTS_ACTIVATE_PORTAILFACTUR && !empty($user->rights->portailfactur->view_facture))
	{
		$Tmenu['portailfactur'] = array(
			'id' => 'portailfactur',
			'rank' => 20,
			'url' => $context->getRootUrl('portailfactur'),
			'name' => $langs->trans('namelink_portailfactur'),
		);
	}

    if($conf->global->RIGHTS_ACTIVATE_EXPEDITIONS && !empty($user->rights->portailfactur->view_expeditions))
    {
        $Tmenu['expeditions'] = array(
            'id' => 'expeditions',
            'rank' => 20,
            'url' => $context->getRootUrl('expeditions'),
            'name' => $langs->trans('namelink_expeditions'),
        );
    }
    
    
    
    $Tmenu['user'] = array(
        'id' => 'user',
        'rank' => 100,
        'url' => '',
        'name' => '<i class="fa fa-user"></i> ' . $user->login,
    );
    
    $Tmenu['user']['children']['personalinformations'] = array(
        'id' => 'personalinformations',
        'rank' => 10,
        'url' => $context->getRootUrl('personalinformations'),
        'name' => '<i class="fa fa-user"></i> '.$langs->trans('PersonalInformations'),
    );
    
    $Tmenu['user']['children']['logout'] = array(
        'id' => 'logout',
        'separator' => 1,
        'rank' => 100,
        'url' => $context->getRootUrl().'logout.php',
        'name' => '<i class="fa fa-sign-out"></i> '.$langs->trans('Logout'),
    );
    
}


// if(!empty($conf->global->RIGHTS_GOBACK_URL)){
//     $Tmenu['gobackurl'] = array(
//         'id' => 'gobackurl',
//         'rank' => 90,
//         'url' => $conf->global->RIGHTS_GOBACK_URL,
//         'name' => '<i class="fa fa-external-link"></i> '.$langs->trans('namelink_gobackurl'),
//     );
// }




$parameters=array(
    'controller' => $context->controller,
    'Tmenu' =>& $Tmenu,
);
$reshook=$hookmanager->executeHooks('PrintTopMenu',$parameters,$context, $context->action);    // Note that $action and $object may have been modified by hook
if ($reshook < 0) $context->setEventMessages($hookmanager->error,$hookmanager->errors,'errors');

if(empty($reshook)){
    if(!empty($hookmanager->resArray)){
        $Tmenu = array_replace($Tmenu,$hookmanager->resArray);
    }
    
    if(!empty($Tmenu)){
        
        
    // Sorting
    uasort ( $Tmenu,'menuSortInv');
?>
<!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light fixed-top <?php print !empty($context->topMenu->shrink)?'navbar-shrink':''; ?>" id="mainNav" <?php print !empty($context->topMenu->shrink)?'data-defaultshrink="1"':''; ?> >
      <div class="container">
        <a class="navbar-brand js-scroll-trigger" href="<?php print $context->getRootUrl();  ?>"><?php print !empty($conf->global->RIGHTS_TITLE)?$conf->global->RIGHTS_TITLE:$conf->global->MAIN_INFO_SOCIETE_NOM;  ?></a>
        <div class="collapse navbar-collapse" id="navbarResponsive">
          <ul class="navbar-nav ml-auto">
            <?php 
                print printNav($Tmenu);
            ?>
          </ul>
        </div>
        <?php 
        if(!empty($conf->global->RIGHTS_GOBACK_URL)){?>
            <a class="navbar-brand gobackurl" href="<?php print $context->getRootUrl();  ?>"> <i class="fa fa-external-link"></i> <?php print $langs->trans('namelink_gobackurl')  ?></a>
        <?php }?>

        <button class="navbar-toggler navbar-toggler-right" type="button" data-toggle="collapse" data-target="#navbarResponsive" aria-controls="navbarResponsive" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"></span>
        </button>
      </div>
    </nav>
    
<?php 
    }
}    