<?php 
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT .'/product/stock/class/mouvementstock.class.php';
 
class portailfactur extends Commonobject{ 

	public $errors = array();
	public $rowid;
	public $label;
	

	public $element='pf_facture';
	public $table_element='pf_facture';
	public $table_element_ligne='pf_facturedet';
	
	public function __construct($db){ 
		$this->db = $db;
		return 1;
    }

	public function create($echo_sql=0,$insert)
	{

		$sql  = "INSERT INTO " . MAIN_DB_PREFIX .$this->table_element." ( ";
		print_r($insert);
		foreach ($insert as $column => $value) {
			$alias = (is_numeric($value)) ? "" : "'";
			if($value != ""){
				$sql_column .= " , `".$column."`";
				$sql_value .= " , ".$alias.$value.$alias;
			}
		}
		$sql .= substr($sql_column, 2)." ) VALUES ( ".substr($sql_value, 2)." )";
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.$this->table_element.' '. $this->db->lasterror();
			print_r($this->errors);die();

			return 0;
		} 
		// return $this->db->db->insert_id;
		return $this->db->last_insert_id(MAIN_DB_PREFIX.'pf_chantiers');
	}

	public function update($id, array $data,$echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

        $sql = 'UPDATE ' . MAIN_DB_PREFIX .$this->table_element. ' SET ';

        if (count($data) && is_array($data))
            foreach ($data as $key => $val) {
                $val = is_numeric($val) ? $val : '"'. $val .'"';
                $val = ($val == '') ? 'NULL' : $val ;
                $sql .= '`'. $key. '` = '. $val .',';
            }

        $sql  = substr($sql, 0, -1);
        $sql .= ' WHERE rowid = ' . $id;
        // die($sql);

        $resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.$this->table_element.' : '. $this->db->lasterror();
			print_r($this->errors);die();
			
			return -1;
		} 
		return 1;
	}

	public function delete($echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX .$this->table_element.' WHERE rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.$this->table_element.' : '.$this->db->lasterror();
			return -1;
		} 

		return 1;
	}

    
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX .$this->table_element;
		$sql .= ' WHERE entity='.$conf->entity;

		if (!empty($filter)) {
			$sql .= " ".$filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}
		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
                $line->id    	  =  $obj->rowid;
				$line->rowid 	  =  $obj->rowid;
				$line->ref 	  =  $obj->ref;
				$line->fk_client  =  $obj->fk_client;
				$line->debut 	  =  $obj->debut;
				$line->fin 		  =  $obj->fin;
				$line->entity 	  =  $obj->entity;
                // ....

				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	public function fetch($id)
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .$this->table_element. ' WHERE rowid = ' . $id;
		// $sql .= ' AND entity='.$conf->entity;
		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 		       = $this->db->fetch_object($resql);
                $this->id          = $obj->rowid;
                $this->rowid       = $obj->rowid;
                $this->ref         = $obj->ref;
                $this->fk_client   = $obj->fk_client;
				$this->datef 	   = $obj->datef;
				$this->cas 	       = $obj->cas;
				$this->amount_ht   = $obj->amount_ht;
				$this->amount_tva  = $obj->amount_tva;
				$this->amount_ttc  = $obj->amount_ttc;
                $this->entity      = $obj->entity;
                // ....
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			return -1;
		}
	}


	public function fetchAllLigne($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX .$this->table_element_ligne;
		$sql .= ' WHERE 1>0';

		if (!empty($filter)) {
			$sql .= " ".$filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}
		$this->rowsligne = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
                $line->id    	  =  $obj->rowid;
				$line->rowid 	  =  $obj->rowid;
				$line->label       = $obj->label;
                $line->fk_prod     = $obj->fk_prod;
                $line->type        = $obj->type;
                $line->n_bc        = $obj->n_bc;
                $line->stlivr      = $obj->stlivr;
				$line->fk_facture  = $obj->fk_facture;
				$line->origin_lign = $obj->origin_lign;
				$line->origin_fact = $obj->origin_fact;
				$line->chantier    = $obj->chantier;
				$line->descp       = $obj->descp;
				$line->qty         = $obj->qty;
				$line->tva         = $obj->tva;
				$line->price   	   = $obj->price;
				$line->unit        = $obj->unit;
				$line->total_ht    = $obj->total_ht;
				$line->total_tva   = $obj->total_tva;
				$line->total_ttc   = $obj->total_ttc;

				$this->rowsligne[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function fetchLigne($id)
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .$this->table_element_ligne.' WHERE rowid = ' . $id;
		// $sql .= ' AND entity='.$conf->entity;
		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			$line = new stdClass;
			
			if ($numrows) {
				$obj 		       = $this->db->fetch_object($resql);
                $line->id          = $obj->rowid;
                $line->rowid       = $obj->rowid;
                $line->label       = $obj->label;
                $line->fk_prod     = $obj->fk_prod;
                $line->type        = $obj->type;
                $line->n_bc        = $obj->n_bc;
                $line->stlivr      = $obj->stlivr;
				$line->fk_facture  = $obj->fk_facture;
				$line->origin_lign = $obj->origin_lign;
				$line->origin_fact = $obj->origin_fact;
				$line->chantier    = $obj->chantier;
				$line->descp       = $obj->descp;
				$line->qty         = $obj->qty;
				$line->tva         = $obj->tva;
				$line->price   	   = $obj->price;
				$line->unit        = $obj->unit;
				$line->total_ht    = $obj->total_ht;
				$line->total_tva   = $obj->total_tva;
				$line->total_ttc   = $obj->total_ttc;
			}

			$this->db->free($resql);

			if ($numrows) {
				return $line ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			return -1;
		}
	}

	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id='',$attr=''){

	    global $conf;

	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;

	    $moreforfilter.='<select width="100%" '.$attr.' class="flat" id="select_'.$id.'" name="'.$name.'">';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX.$this->table_element;
		$sql .= ' WHERE entity='.$conf->entity;
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

    function getNomUrl($withpicto=0, $option='', $get_params='', $notooltip=0, $save_lastsearch_value=-1)
    {
        global $langs, $conf, $user;

        if (! empty($conf->dol_no_mouse_hover)) $notooltip=1;   // Force disable tooltips

        $result='';
        $label='';
        $url='';

        // if ($user->rights->propal->lire){}

        $linkclose='';
        if (empty($notooltip))
        {
            $linkclose.= ' title="'.dol_escape_htmltag($label, 1).'"';
            $linkclose.=' class="classfortooltip"';
        }
        $linkstart = "";
        $linkend = "";
        $result = "";
        if(!empty($this->ref)){
        	$ref=$this->ref;
        }else
        	$ref=$this->rowid;
        if ($ref) {
            $linkstart = '<a href="'.$url.'"';
            $linkstart.=$linkclose.'>';
            $linkend='</a>';

            $result .= $linkstart;
            if ($withpicto) 
                $result.= '<img height="16" src="'.DOL_URL_ROOT.'/postes/img/object_postes.png" >&nbsp;';
            if ($withpicto != 2) $result.= $ref;
        }

        $result .= $linkend;

        return $result;
    }

	public function addline(
		$price,
		$qty,
		$fk_product = 0,
		$txlocaltax1 = 0,
		$txlocaltax2 = 0,
		$remise_percent = 0,
		$info_bits = 0,
		$total_ht = 0,
		$total_tva = 0,
		$total_ttc = 0,
		$fk_facture = '',
		$origin_fact = '',
		$origin_lign = 0,
		$n_bc = '',
		$chantier = '',
		$tva = 0,
		$label = '',
		$descp,
		$type = 0,
		$unit = null
	) {
		echo 'fk_facture:'.$fk_facture;

		global $mysoc, $conf, $langs;


		$remise_percent = price2num($remise_percent);
		$qty = price2num($qty);
		$price = price2num($price);
		$pu_ttc = price2num($price);
		if (!preg_match('/\((.*)\)/', $txtva)) {
			$txtva = price2num($txtva); // $txtva can have format '5.0(XXX)' or '5'
		}
		
		$product_type = $type;
		if (!empty($fk_product) && $fk_product > 0) {
			$product = new Product($this->db);
			$result = $product->fetch($fk_product);
			$product_type = $product->type;

			// if (!empty($conf->global->STOCK_MUST_BE_ENOUGH_FOR_INVOICE) && $product_type == 0 && $product->stock_reel < $qty) {
			// 	$langs->load("errors");
			// 	$this->error = $langs->trans('ErrorStockIsNotEnoughToAddProductOnInvoice', $product->ref);
			// 	$this->db->rollback();
			// 	return -3;
			// }
		}


		// Clean vat code
		$reg = array();
		$vat_src_code = '';
		if (preg_match('/\((.*)\)/', $txtva, $reg)) {
			$vat_src_code = $reg[1];
			$txtva = preg_replace('/\s*\(.*\)/', '', $txtva); // Remove code into vatrate.
		}


		// Insert line
		
		$sql = 'INSERT INTO '.MAIN_DB_PREFIX.'pf_facturedet';
		$sql .= ' (fk_facture, origine_fact, origine_lign, n_bc, chantier, label, descp, qty,';
		$sql .= ' price, tva, unit, fk_prod, remise_percent, type,';
		$sql .= ' total_ht, total_tva, total_ttc';
		// $sql .= ' fk_multicurrency, multicurrency_code, multicurrency_subprice, multicurrency_total_ht, multicurrency_total_tva, multicurrency_total_ttc';
		$sql .= ')';
		$sql .= " VALUES (".$fk_facture.",";
		$sql .= " ".($origin_fact > 0 ? $origin_fact : "null").",";
		$sql .= " ".($origin_lign > 0 ? $origin_lign : "null").",";
		$sql .= " ".(!empty($n_bc) ? "'".$this->db->escape($n_bc)."'" : "null").",";
		$sql .= " ".(!empty($chantier) ? "'".$this->db->escape($chantier)."'" : "null").",";
		$sql .= " ".(!empty($label) ? "'".$this->db->escape($label)."'" : "null").",";
		$sql .= " '".$this->db->escape($descp)."',";
		$sql .= " ".price2num($qty).",";
		$sql .= " ".price2num($price).",";
		$sql .= " ".price2num($tva).",";
		$sql .= " ".(!$fk_unit ? 'NULL' : $fk_unit).",";
		$sql .= " ".((!empty($fk_product) && $fk_product > 0) ? $fk_product : "null").',';
		$sql .= " ".price2num($remise_percent).",";
		$sql .= " ".((int) $product_type).",";
		$sql .= " ".price2num($total_ht).",";
		$sql .= " ".price2num($total_tva).",";
		$sql .= " ".price2num($total_ttc);
		$sql .= ' )';
		$resql = $this->db->query($sql);

		if ($resql) {
        	$id_line = $this->db->last_insert_id(MAIN_DB_PREFIX.'pf_facturedet');
        	return $id_line;

		} else {
			
			return 0;
		}
	}
	
	public function updateTotal($id,$total_ht=0,$total_tva=0,$total_ttc=0, $movent="+")
	{
		if($id){
			$this->fetch($id);
			if($movent == "+"){
				$total_ht += $this->amount_ht;
				$total_tva += $this->amount_tva;
				$total_ttc += $this->amount_ttc;
			}else{
				$total_ht = $this->amount_ht-$total_ht;
				$total_tva = $this->amount_tva-$total_tva;
				$total_ttc = $this->amount_ttc-$total_ttc;
			}

	        $sql = "UPDATE ".MAIN_DB_PREFIX."pf_facture SET amount_ht=".$total_ht.", amount_tva=".$total_tva.", amount_ttc=".$total_ttc;
			$sql.= " WHERE rowid=".$id;
			$resql = $this->db->query($sql);

			if ($resql) return 1;
		}

		return 0;
	}

	// public function getNextValue($objsoc, $object)
	// {
	// 	global $db, $conf;

	// 	// First, we get the max value
	// 	$posindice = strlen($this->prefix) + 6;
	// 	$sql = "SELECT MAX(CAST(SUBSTRING(ref FROM ".$posindice.") AS SIGNED)) as max";
	// 	$sql .= " FROM ".MAIN_DB_PREFIX."pf_facture";
	// 	$sql .= " WHERE ref LIKE '".$db->escape($this->prefix)."____-%'";
	// 	$sql .= " AND entity=".$conf->entity;

	// 	$resql = $db->query($sql);
	// 	if ($resql) {
	// 		$obj = $db->fetch_object($resql);
	// 		if ($obj) {
	// 			$max = intval($obj->max);
	// 		} else {
	// 			$max = 0;
	// 		}
	// 	} else {
	// 		dol_syslog("mod_commande_marbre::getNextValue", LOG_DEBUG);
	// 		return -1;
	// 	}

	// 	//$date=time();
	// 	$date = $object->date;
	// 	$yymm = strftime("%y%m", $date);

	// 	if ($max >= (pow(10, 4) - 1)) {
	// 		$num = $max + 1; // If counter > 9999, we do not format on 4 chars, we take number as it is
	// 	} else {
	// 		$num = sprintf("%04s", $max + 1);
	// 	}

	// 	dol_syslog("mod_commande_marbre::getNextValue return ".$this->prefix.$yymm."-".$num);
	// 	return $this->prefix.$yymm."-".$num;
	// }



	/**
	 * 	Return next free value
	 *
	 *  @param  Object		$object		Object we need next value for
	 *  @return string      			Value if KO, <0 if KO
	 */
	// public function getNextValue($object)
	// {
	// 	global $db, $conf;

	// 	require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';

	// 	// We get cursor rule
	// 	$mask = $conf->global->PARTNERSHIP_ADVANCED_MASK;

	// 	if (!$mask) {
	// 		$this->error = 'NotConfigured';
	// 		return 0;
	// 	}

	// 	$date = $object->date;
	// 	$modul = new modportailfactur($db);
	// 	$mask = 'FA-{}{dd}-{yyyy}';
		
	// 	$numFinal = $modul->get_next_value($db, $mask, 'partnership', 'ref', '', null, $date);

	// 	return  $numFinal;
	// }


	public function numberToWordsFunction($number, $currency1='', $currency2='' )
	{	


	    $hyphen = '-';
	    $conjunction = ' ';
	    $separator = ' ';
	    $negative = 'negative ';
	    $decimal = ' et ';
	    $dictionary = array(
	        0 => 'zero',
	        1 => 'un',
	        2 => 'deux',
	        3 => 'trois',
	        4 => 'quatre',
	        5 => 'cinq',
	        6 => 'six',
	        7 => 'sept',
	        8 => 'huit ',
	        9 => 'neuf',
	        10 => 'dix',
	        11 => 'onze',
	        12 => 'douze',
	        13 => 'treize',
	        14 => 'quatorze',
	        15 => 'quinze',
	        16 => 'seize',
	        17 => 'dix-sept',
	        18 => 'dix-huit',
	        19 => 'dix-neuf',
	        20 => 'vingt',
			21 => 'vingt et un',
			22 => 'vingt-deux',
			23 => 'vingt-trois',
			24 => 'vingt-quatre',
			25 => 'vingt-cinq',
			26 => 'vingt-six',
			27 => 'vingt-sept',
			28 => 'vingt-huit',
			29 => 'vingt-neuf',
			30 => 'trente',
			31 => 'trente et un',
			32 => 'trente-deux',
			33 => 'trente-trois',
			34 => 'trente-quatre',
			35 => 'trente-cinq',
			36 => 'trente-six',
			37 => 'trente-sept',
			38 => 'trente-huit',
			39 => 'trente-neuf',
			40 => 'quarante',
			41 => 'quarante et un',
			42 => 'quarante-deux',
			43 => 'quarante-trois',
			44 => 'quarante-quatre',
			45 => 'quarante-cinq',
			46 => 'quarante-six',
			47 => 'quarante-sept',
			48 => 'quarante-huit',
			49 => 'quarante-neuf',
			50 => 'cinquante',
			51 => 'cinquante et un',
			52 => 'cinquante-deux',
			53 => 'cinquante-trois',
			54 => 'cinquante-quatre',
			55 => 'cinquante-cinq',
			56 => 'cinquante-six',
			57 => 'cinquante-sept',
			58 => 'cinquante-huit',
			59 => 'cinquante-neuf',
			60 => 'soixante',
			61 => 'soixante et un',
			62 => 'soixante-deux',
			63 => 'soixante-trois',
			64 => 'soixante-quatre',
			65 => 'soixante-cinq',
			66 => 'soixante-six',
			67 => 'soixante-sept',
			68 => 'soixante-huit',
			69 => 'soixante-neuf',
			70 => 'soixante-dix',
			71 => 'soixante et onze',
			72 => 'soixante-douze',
			73 => 'soixante-treize',
			74 => 'soixante-quatorze',
			75 => 'soixante-quinze',
			76 => 'soixante-seize',
			77 => 'soixante-dix-sept',
			78 => 'soixante-dix-huit',
			79 => 'soixante-dix-neuf',
			80 => 'quatre-vingts',
			81 => 'quatre-vingt-un',
			82 => 'quatre-vingt-deux',
			83 => 'quatre-vingt-trois',
			84 => 'quatre-vingt-quatre',
			85 => 'quatre-vingt-cinq',
			86 => 'quatre-vingt-six',
			87 => 'quatre-vingt-sept',
			88 => 'quatre-vingt-huit',
			89 => 'quatre-vingt-neuf',
			90 => 'quatre-vingt-dix',
			91 => 'quatre-vingt-onze',
			92 => 'quatre-vingt-douze',
			93 => 'quatre-vingt-treize',
			94 => 'quatre-vingt-quatorze',
			95 => 'quatre-vingt-quinze',
			96 => 'quatre-vingt-seize',
			97 => 'quatre-vingt-dix-sept',
			98 => 'quatre-vingt-dix-huit',
			99 => 'quatre-vingt-dix-neuf',
	        100 => 'cent',
	        1000 => 'mille',
	        1000000 => 'million',
	        1000000000 => 'milliard',
	        1000000000000 => 'trillion',
	        1000000000000000 => 'quadrillion',
	        1000000000000000000 => 'quintillion'
	    );

	    if (!is_numeric($number)) {
	        return false;
	    }

	    if (($number >= 0 && (int)$number < 0) || (int)$number < 0 - PHP_INT_MAX) {
	        // overflow
	        trigger_error(
	            'numberToWords only accepts numbers between -' . PHP_INT_MAX . ' and ' . PHP_INT_MAX,
	            E_USER_WARNING
	        );
	        return false;
	    }

	    if ($number < 0) {
	        return $negative . $this->numberToWordsFunction(abs($number));
	    }

	    $string = $fraction = null;

	    // $string  = '<b>';
	    // $string = '<b>';
	    if (strpos($number, '.') !== false) {
	        list($number, $fraction) = explode('.', $number);
	    }
	    // echo "number : ".$number.'<br>';
	    switch (true) {
	        case $number < 21:
	            $string = $dictionary[$number];
	            break;
	        case $number < 100:
	            $tens = ((int)($number / 10)) * 10;
	            $units = $number % 10;
	            $string = $dictionary[$number];
	            if ($units) {
	                // $string .= $hyphen . $dictionary[$units];
	            }
	            break;
	        case $number < 1000:
	            $hundreds = $number / 100;
	            $remainder = $number % 100;
	            if ((int)$hundreds == 1) {
	                $string = $dictionary[100];
	            }else{
	                $string = $dictionary[$hundreds] . ' ' . $dictionary[100];
	            }
	            if ($remainder) {
	                $string .= $conjunction . $this->numberToWordsFunction($remainder);
	            }
	            break;
	        default:
	            $baseUnit = pow(1000, floor(log($number, 1000)));
	            $numBaseUnits = (int)($number / $baseUnit);
	            $remainder = $number % $baseUnit;
	            $string = $this->numberToWordsFunction($numBaseUnits) . ' ' . $dictionary[$baseUnit];
	            if ($remainder) {
	                $string .= $remainder < 100 ? $conjunction : $separator;
	                $string .= $this->numberToWordsFunction($remainder);
	            }
	            break;
	        }
	       
	    if (null !== $fraction && is_numeric($fraction)) {
	        /* -----------  for number to words behind commat -----------*/
	            // $string .= $decimal;
	            // $words = array();
	            // foreach (str_split((string)$fraction) as $number) {
	            //     $words[] = $dictionary[$number];
	            // }
	            // $string .= implode(' ', $words);
	        /* -----------  for number to words behind commat -----------*/
	        $string .= ' '.trim($currency1).' ';
	        $fraction4 = $fraction + 0;
	        if($fraction > 0){
		        $string .= $decimal;
		        // $string .= mb_substr($fraction, 0, 2);
		        
		        if($fraction4 > 9)
	         		$string .= ''.$this->numberToWordsFunction(mb_substr($fraction, 0, 2)).'';
	         	else
	         		$string .= mb_substr($fraction, 0, 2);

		        $string .= ' '.trim($currency2).'';
	        }
	    }else{
	    	$string .= ' '.trim($currency1).' ';
	    }

	    return ($string);
	}
    

    public function getParamsRib($code)
    {
		$rib = preg_replace('/\s/', '', $code);
		$data['codeB']=substr($rib, 0, 5);
		$data['codeG']=substr($rib, 0, 4);
		$data['codeC']=substr($rib, 0, 9);
		$data['clerib']=substr($rib, 0, 2);
		return $data;
    }

	public function getNextValue()
	{
		global $conf;
		$prefix='FA';
		// first we get the max value
		$posindice = strlen($prefix) + 6;
		$sql = "SELECT MAX(CAST(SUBSTRING(ref FROM ".$posindice.") AS SIGNED)) as max";
		$sql .= " FROM ".MAIN_DB_PREFIX."pf_facture";
		$sql .= " WHERE ref LIKE '".$prefix."____-%'";
		$sql .= " AND entity = ".$conf->entity;

		$resql = $this->db->query($sql);
		if ($resql) {
			$obj = $this->db->fetch_object($resql);
			if ($obj) {
				$max = intval($obj->max);
			} else {
				$max = 0;
			}
		}

		//$date=time();
		$dmy = strftime("%d-%m-%Y", dol_now());
		// $dmy = dol_print_date(dol_now(),"d-m-Y");

		if ($max >= (pow(10, 4) - 1)) {
			$num = $max + 1; // If counter > 9999, we do not format on 4 chars, we take number as it is
		} else {
			$num = sprintf("%04s", $max + 1);
		}

		dol_syslog("mod_partnership_standard::getNextValue return ".$prefix.$yymm."-".$num);
		return 'FA'.$num.'-'.$dmy;
	}


	public function format_amount($amount='')
	{
		$result=0;
		if(is_numeric($amount) && floor($amount) == $amount){
            $result = number_format($amount, 0, ",", " ");
		}else
            $result = number_format($amount, 4, ",", " ");

        return $result;
	}

} 


?>