<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2015 ATM Consulting <support@atm-consulting.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file    class/actions_portailfactur.class.php
 * \ingroup portailfactur
 * \brief   This file is an example hook overload class file
 *          Put some comments here
 */

/**
 * Class Actionsportailfactur
 */
class Actionsportailfactur
{
	/**
	 * @var array Hook results. Propagated to $hookmanager->resArray for later reuse
	 */
	public $results = array();

	/**
	 * @var string String displayed by executeHook() immediately after return
	 */
	public $resprints;

	/**
	 * @var array Errors
	 */
	public $errors = array();

	/**
	 * Constructor
	 */
	public function __construct()
	{
	}

	/**
	 * Overloading the doActions function : replacing the parent's function with the one below
	 *
	 * @param   array()         $parameters     Hook metadatas (context, etc...)
	 * @param   CommonObject    &$object        The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
	 * @param   string          &$action        Current action (if set). Generally create or edit or null
	 * @param   HookManager     $hookmanager    Hook manager propagated to allow calling another hook
	 * @return  int                             < 0 on error, 0 on success, 1 to replace standard code
	 */
	public function doActions($parameters, &$object, &$action, $hookmanager)
	{
		$error = 0; // Error counter
		global $langs;

		$currentcontext = explode(':', $parameters['context']);

		if (is_array($currentcontext) && in_array('portailfacturpage', $currentcontext))
		{
		    $context = Context::getInstance();

		    if($context->controller == 'portailfactur')
		    {
		        $context->title = $langs->trans('Viewportailfactur');
		        $context->desc = $langs->trans('ViewportailfacturDesc');
		        $context->menu_active[] = 'portailfactur';
		    } 
		    elseif($context->controller == 'orders')
		    {
		        $context->title = $langs->trans('ViewOrders');
		        $context->desc = $langs->trans('ViewOrdersDesc');
		        $context->menu_active[] = 'orders';
		    }
			elseif($context->controller == 'neworder')
			{
			    $context->title = $langs->trans('neworders');
			    $context->desc = $langs->trans('newordersDesc');
			    $context->menu_active[] = 'orders';
			}
			// elseif($context->controller == 'propals')
			// {
			//     $context->title = $langs->trans('ViewPropals');
			//     $context->desc = $langs->trans('ViewPropalsDesc');
			//     $context->menu_active[] = 'propals';
			// }
			// elseif($context->controller == 'expeditions')
			// {
			// 	$context->title = $langs->trans('ViewExpeditions');
			// 	$context->desc = $langs->trans('ViewExpeditionsDesc');
			// 	$context->menu_active[] = 'expeditions';
			// }
			// elseif($context->controller == 'interventions')
			// {
			// 	$context->title = $langs->trans('ViewInterventions');
			// 	$context->desc = $langs->trans('ViewInterventionsDesc');
			// 	$context->menu_active[] = 'interventions';
			// }
            // elseif($context->controller == 'tickets')
            // {
            //     $context->title = $langs->trans('ViewTickets');
            //     $context->desc = $langs->trans('ViewTicketsDesc');
            //     $context->menu_active[] = 'tickets';
            // }
			elseif($context->controller == 'default')
			{
                $langs->load('portailfactur@portailfactur');
				$context->title = $langs->trans('Welcome');
				$context->desc = $langs->trans('WelcomeDesc');
				//$context->topMenu->shrink = 1; // no transparency menu
				$context->doNotDisplayHeaderBar=1;// hide default header
			}
		    elseif($context->controller == 'personalinformations')
		    {
		        global $user;
		        $context->title = $langs->trans('UserInfosDesc') ; //$user->firstname .' '. $user->lastname;
		        $context->desc = $user->firstname .' '. $user->lastname;; //$langs->trans('UserInfosDesc');
		        $context->meta_title = $user->firstname .' '. $user->lastname .' - '. $langs->trans('UserInfosDesc');
		        //$context->doNotDisplayHeaderBar=1;// hide default header

		        if($context->action == 'save'){
		            // TODO: need to check all send informations to prevent and verbose errors
		            $user->firstname = GETPOST('firstname');
		            $user->lastname = GETPOST('lastname');
		            $user->address = GETPOST('address');
		            $user->zip = GETPOST('addresszip');
		            $user->town = GETPOST('town');
		            $user->user_mobile = GETPOST('user_mobile');
		            $user->office_phone = GETPOST('office_phone');
		            $user->office_fax = GETPOST('office_fax');
		            $user->email = GETPOST('email');
		            if (GETPOST('password')) {
						$user->setPassword($user, GETPOST('password'));
					}
				
		            if($user->update($user)>0)
		            {
		                header('Location: '.$context->getRootUrl('personalinformations').'&action=saved');
		            }
		            else {
		                $context->action == 'saveError';
		            }
		        }
		    }
		}


		if (is_array($currentcontext) && in_array('thirdpartylist', $currentcontext))
		{
			require_once DOL_DOCUMENT_ROOT.'/societe/class/societe.class.php';
			require_once DOL_DOCUMENT_ROOT.'/contact/class/contact.class.php';

			if (GETPOST('confirmmassaction') && GETPOST('massaction') == 'createportailuser')
			{
				$i = 0;
				foreach ($_POST['toselect'] as $key => $socid) {
					// $totresult = $this->CreateUserForContactIfNotExist($socid);
					// if($this->errors) {
					// 	setEventMessages('', $this->errors, 'errors');
					// }
					if($totresult > 0) $i = $i + $totresult;
				}

				// if($i > 0) {
					setEventMessages($langs->trans("RecordsModified", $i), null, 'mesgs');
				// }
			}
		}

	}

	public function CreateUserForContactIfNotExist()
	{
		global $langs, $db, $conf, $user;

		$societe = new Societe($db);
		$societe->fetch($socid);

		if($societe->array_options && isset($societe->array_options['options_portailfacturuser']) && $societe->array_options['options_portailfacturuser'] > 0) {
			// $nuser = new User($db);
			// $result = $nuser->fetch($societe->array_options['options_portailfacturuser']);
			// if($result > 0) 
			return -1;
		}

		$object 		= new Contact($db);
		$extrafields 	= new ExtraFields($db);

		$extrafields->fetch_name_optionals_label($object->table_element);

		$useredded = 0;
		$contactid = 0;
		$error = 0;
		$errors = '';

		$sql = "SELECT c.rowid, c.fk_soc, c.lastname";
		$sql .= " FROM ".MAIN_DB_PREFIX."socpeople as c";
		$sql .= " WHERE c.fk_soc = '".$db->escape($socid)."'";
		// $sql .= " AND c.lastname = '".$db->escape($societe->name)."'";
		$sql .= " limit 1";

		$resql = $db->query($sql);

		if ($resql) {
			$num = $db->num_rows($resql);
			if ($num) {
				$obj = $db->fetch_object($resql);
				$contactid = $obj->rowid;
			}
		}

		$db->begin();

		if(!$contactid) {

			$object->entity = $conf->entity;
			$object->socid = $socid;
			$object->lastname = $societe->name;
			$object->firstname = '';
			// $object->civility_code = $civility_code;
			$object->poste = $societe->poste;
			$object->address = $societe->address;
			$object->zip = $societe->zip;
			$object->town = $societe->town;
			$object->country_id = $societe->country_id;
			$object->state_id = $societe->state_id;
			//$object->jabberid		= GETPOST("jabberid", 'alpha');
			//$object->skype		= GETPOST("skype", 'alpha');
			//$object->twitter		= GETPOST("twitter", 'alpha');
			//$object->facebook		= GETPOST("facebook", 'alpha');
			//$object->linkedin		= GETPOST("linkedin", 'alpha');
			$object->socialnetworks = array();
			if (!empty($conf->socialnetworks->enabled)) {
				foreach ($societe->socialnetworks as $key => $value) {
					if (GETPOSTISSET($key) && GETPOST($key, 'alphanohtml') != '') {
						$object->socialnetworks[$key] = (string) GETPOST($key, 'alphanohtml');
					}
				}
			}
			$object->email = $societe->email;
			// $object->no_email = GETPOST("no_email", "int");
			$object->phone_pro = $societe->phone;
			$object->phone_perso = $societe->phone;
			$object->phone_mobile = $societe->phone;
			$object->fax = $societe->fax;
			// $object->priv = $societe->priv;
			// $object->note_public = $societe->note_public;
			// $object->note_private = $societe->note_private;
			$object->roles = array();

			$object->statut = 1; //Default status to Actif

			$ret = $extrafields->setOptionalsFromPost(null, $object);
			if ($ret < 0) $error++;

			if (!$error) $contactid = $object->create($user);

			if (!$error && $contactid > 0) $db->commit();
			else $db->rollback();
		}

		$nuserid = 0;

		/*
		------------------------------------------------------------------------------
		----------- Créer un compte utilisateur
		------------------------------------------------------------------------------
		*/

		if (!$error)
		{
			$object = new Contact($db);
			$result = $object->fetch($contactid);
			$nuserid = $object->user_id;

			if(!$nuserid){

				// $login = $object->lastname;
				// $password = $object->lastname;
				$login = $societe->name;
				$password = $societe->name;

				if ($result > 0)
				{
					// Creation user
					$nuser = new User($db);
					$result = $nuser->create_from_contact($object, $login); // Do not use GETPOST(alpha)

					if ($result > 0)
					{
						$nuserid = $nuser->id;
						$result2 = $nuser->setPassword($user, $password, 0, 0, 1); // Do not use GETPOST(alpha)
						$resright = $nuser->addrights(0, 'portailfactur', '', $conf->entity);
						if ($result2)
						{
							$db->commit();
						} else {
							$error = $nuser->error; $this->errors[] = $nuser->errors;
							$db->rollback();
						}
					} else {
						$error = $nuser->error; $this->errors[] = $nuser->errors;
						$db->rollback();
					}
				} else {
					$error = $object->error; $this->errors[] = $object->errors;
				}

			}
		}
		if(!$societe->array_options['options_portailfacturuser']) $useredded = 1;

		$societe->array_options['options_portailfacturuser'] = $nuserid;
		$societe->update($socid, $user);

		$db->commit();

		// echo '<pre>';
		// print_r($error);
		// echo '</pre>';

		return $useredded;
	}

	/**
	 * Overloading the interface function : replacing the parent's function with the one below
	 *
	 * @param   array()         $parameters     Hook metadatas (context, etc...)
	 * @param   CommonObject    &$object        The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
	 * @param   string          &$action        Current action (if set). Generally create or edit or null
	 * @param   HookManager     $hookmanager    Hook manager propagated to allow calling another hook
	 * @return  int                             < 0 on error, 0 on success, 1 to replace standard code
	 */
	public function doActionInterface($parameters, &$object, &$action, $hookmanager)
	{
	    $error = 0; // Error counter
	    global $langs, $db, $conf, $user;
	    if (in_array('portailfacturinterface', explode(':', $parameters['context'])))
	    {
	        if($action === 'downloadportailfacturpdf')
	        {
	            $this->_downloadportailfactur('pdf');
	        }
	        if($action === 'downloadportailfacturxls')
	        {
	            $this->_downloadportailfactur('pdf');
	        }
			
	        elseif ($action === 'getFactureList')
	        {
	            if($conf->global->RIGHTS_ACTIVATE_ORDERS && !empty($user->rights->portailfactur->view_orders))
	            {
	                print json_invoiceList($user->societe_id,99999, GETPOST('offset','int'));
	                exit();
	            }
	        }
	        

	    }
	}


	/**
	 *
	 * @return number
	 */
	public function addMoreMassActions($parameters=false)
	{
		global $conf, $user, $langs;
		global $mc;

		if (empty($conf->portailfactur->enabled)) return 0;

		if (is_array($parameters) && ! empty($parameters))
		{
			foreach($parameters as $key=>$value)
			{
				$$key=$value;
			}
		}

		$currentcontext = explode(':', $parameters['context']);

		
		if (is_array($currentcontext) && in_array('thirdpartylist', $currentcontext))
		{
			$langs->load('portailfactur@portailfactur');
			$this->resprints = '<option value="createportailuser">'.$langs->trans('createportailuser').'</option>';
		}

		return 0;
	}


	/**
	 * Overloading the PrintPageView function : replacing the parent's function with the one below
	 *
	 * @param   array()         $parameters     Hook metadatas (context, etc...)
	 * @param   CommonObject    &$object        The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
	 * @param   string          &$action        Current action (if set). Generally create or edit or null
	 * @param   HookManager     $hookmanager    Hook manager propagated to allow calling another hook
	 * @return  int                             < 0 on error, 0 on success, 1 to replace standard code
	 */
	public function PrintPageView($parameters, &$object, &$action, $hookmanager)
	{
	    global $conf, $user, $langs;
	    $error = 0; // Error counter

		if(empty($user->socid)){
			$user->socid = $user->societe_id; // For compatibility support
		}

	    if (in_array('portailfacturpage', explode(':', $parameters['context'])))
	    {
	        $context = Context::getInstance();
	        if($context->controller == 'default')
	        {
				$context->setControllerFound();
	            include $context->tplPath .'/headbar_full.tpl.php';
	            include $context->tplPath .'/services.tpl.php';
	            return 1;
	        }
	        elseif($context->controller == 'portailfactur')
	        {
				$context->setControllerFound();
	            if($conf->global->RIGHTS_ACTIVATE_PORTAILFACTUR && !empty($user->rights->portailfactur->view_facture))
	            {
	                $this->print_invoiceList($user->socid);
	            }
	            return 1;
	        }
	        elseif($context->controller == 'showfactur')
	        {
				$context->setControllerFound();
	            if($conf->global->RIGHTS_ACTIVATE_PORTAILFACTUR && !empty($user->rights->portailfactur->view_facture))
	            {	
	            	$id=GETPOST('id_fact');

	                $this->print_facturShow($id);
	            }
	            return 1;
	        }
	  
	        elseif($context->controller == 'personalinformations')
	        {
				$context->setControllerFound();
	            if($context->userIslog())
	            {
	                $this->print_personalinformations();
	            }
	            return 1;
	        }
	    }

		return 0;
	}

	public function print_invoiceList($socId = 0)
	{
	    print '<section id="section-invoice"><div class="container">';
	    print_invoiceTable($socId);
	    print '</div></section>';
	}

	

	public function print_facturShow($id)
	{
	    print '<section id="section-showorder"><div class="container">';
	    print_facturShow($id);
    	print '</div></section>';
	}

	
	
	public function print_personalinformations()
	{
	    global $langs,$db,$user;
	    $context = Context::getInstance();

	    include $context->tplPath.'/userinfos.tpl.php';
	}

	private function _downloadportailfactur($action_export="pdf"){

	    global $langs, $db, $conf, $user;
	    $filename=false;
	    $context = Context::getInstance();
	    $id_fact = GETPOST('id_fact','int');
	    $forceDownload = GETPOST('forcedownload','int');
	    // die('id_fact:'.$id_fact);
		if($conf->global->RIGHTS_ACTIVATE_PORTAILFACTUR && !empty($user->rights->portailfactur->view_facture))
		{
		    if($id_fact){
				include $context->tplPath. '/portailfactur/showfactur.tpl.php';
		    }else
				include $context->tplPath. '/portailfactur/listfactur.tpl.php';
			// include $context->tplPath. '/portailfactur/portailfactur-pdf.php';
		}

	}


}
