<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2015 ATM Consulting <support@atm-consulting.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\file		admin/portailfactur.php
 * 	\ingroup	portailfactur
 * 	\brief		This file is an example module setup page
 * 				Put some comments here
 */
// Dolibarr environment
$res = @include("../../main.inc.php"); // From htdocs directory
if (! $res) {
    $res = @include("../../../main.inc.php"); // From "custom" directory
}

// Libraries
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";
require_once '../lib/portailfactur.lib.php';

// Translations
$langs->load("portailfactur@portailfactur");

// Access control
if (! $user->admin) {
    accessforbidden();
}

$limit  = $conf->liste_limit+1;
$action = GETPOST('action', 'alpha');
$sortfield = GETPOST('sortfield') ? GETPOST('sortfield') : 'rowid';
$sortorder = GETPOST('sortorder') ? GETPOST('sortorder') : 'desc';

$page   = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$offset = $limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;

if ($limit > 0 && $limit != $conf->liste_limit) $param.='&limit='.$limit;

if($action == "add"){
    $resql = $db->query("INSERT INTO `".MAIN_DB_PREFIX."destnorder` (`label`) VALUES ('".GETPOST('label')."')");
    header('location: ./destinations.php');
}

if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter") || $page < 0) {
    $sql = "";
    $offset = 0;
    $sql = "";
    $srch_rowid = "";
    $srch_label = "";
}
$param .= $srch_label?'&srch_label='.$srch_label:'';

// Parameters

$page_name = "Destinations";
llxHeader('', $langs->trans($page_name));

// Subheader


// Setup page goes here
$form=new Form($db);
$sql = "SELECT * FROM ".MAIN_DB_PREFIX."destnorder";
$sql .= " WHERE 1>0";
$sql .= $srch_label ? " AND label LIKE '%".$srch_label."%'" : "";
$sql .= $db->order($sortfield, $sortorder);
$nbtotalofrecords = '';
if (empty($conf->global->MAIN_DISABLE_FULL_SCANLIST)) {
    $result = $db->query($sql);
    $nbtotalofrecords = $db->num_rows($result);

    if (($page * $limit) > $nbtotalofrecords) { // if total resultset is smaller then paging size (filtering), goto and load page 0
        $page = 0;
        $offset = 0;
    }
}

$sql .= $db->plimit($limit + 1, $offset);
$resql = $db->query($sql);

if ($resql) {
    $num = $db->num_rows($resql);
}
$i=0;
$var=false;
print '<form method="POST" id="searchFormList" action="'.$_SERVER["PHP_SELF"].'">';
    if($action == "create") print '<input type="hidden" name="action" value="add">';
    $newcardbutton = dolGetButtonTitle($langs->trans('NewOrder'), '', 'fa fa-plus-circle', './destinations.php?action=create', '');
    print_barre_liste($page_name, $page, $_SERVER["PHP_SELF"], $param, $sortfield, $sortorder, '', $num, $nbtotalofrecords, 'order', 0, $newcardbutton, '', $limit, 0, 0, 1);
    $head = portailfacturAdminPrepareHead();

    dol_fiche_head(
        $head,
        'destination',
        $langs->trans("Destinations"),
        1,
        "portailfactur@portailfactur"
    );

    print '<table class="noborder" width="100%">';
        print '<tr class="liste_titre">';
            print_liste_field_titre($langs->trans("Ref"), $_SERVER["PHP_SELF"], "rowid", "", $param, '', $sortfield, $sortorder, 'center nowrap ');
            print_liste_field_titre($langs->trans("Label"), $_SERVER["PHP_SELF"], "rowid", "", $param, 'center', $sortfield, $sortorder, 'center nowrap ');
            print_liste_field_titre("", $_SERVER["PHP_SELF"], "", "", $param, '', $sortfield, $sortorder, 'center nowrap ');
        print '</tr>';
        print '<tr class="liste_titre nc_filtrage_tr">';
            print '<td></td>';
            print '<td class="center"><input class="width400" type="text" name="srch_label"></td>';
            print '<td></td>';
        print '</tr>';
        if($action == "create"){
            print '<tr>';
                print '<td></td>';
                print '<td class="center"><input type="text" name="label" class="width500"></td>';
                print '<td><input type="submit" class="button"><a href="./destinations.php" class="butActionDelete">'.$langs->trans("cancel").'</a></td>';
            print '</tr>';
        }
        if($num>0){
            while ($i < min($num, $limit)) {
                $obj = $db->fetch_object($resql);

                print '<tr>';
                    print '<td class="center">'.$obj->rowid.'</td>';
                    print '<td class="center">'.$obj->label.'</td>';
                    print '<td></td>';
                print '</tr>';
                $i++;
            }
        }elseif(empty($action) ){
            print '<tr><td class="opacitymedium center" colspan="3">'.$langs->trans('NoRecordFound').'</td></tr>';
        }
    print '</table>';

dol_fiche_end(1);

llxFooter();

$db->close();
