<?php
/* Copyright (C) 2003      Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2012 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@capnetworks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup   inforderlivraison     Module inforderlivraison
 *  \brief      Example of a module descriptor.
 *				Such a file must be copied into htdocs/inforderlivraison/core/modules directory.
 *  \file       htdocs/inforderlivraison/core/modules/modinforderlivraison.class.php
 *  \ingroup    inforderlivraison
 *  \brief      Description and activation file for module inforderlivraison
 */
include_once DOL_DOCUMENT_ROOT .'/core/modules/DolibarrModules.class.php';

/**
 *  Description and activation class for module inforderlivraison
 */
class modinforderlivraison extends DolibarrModules
{
	/**
	 *   Constructor. Define names, constants, directories, boxes, permissions
	 *
	 *   @param      DoliDB		$db      Database handler
	 */
	function __construct($db)
	{
        global $langs,$conf;

        $this->db = $db;

        $this->editor_name = 'NextGestion';
		$this->editor_url = 'https://www.nextgestion.com';

		$this->numero = 1909641920;
		$this->rights_class = 'inforderlivraison';

		$this->family = "NextGestion";
		$this->name = preg_replace('/^mod/i','',get_class($this));
		$this->description = "Module1909641920Desc";
		$this->version = '8.7';
		$this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
		$this->special = 0;
		// $this->picto='inforderlivraison@inforderlivraison';
		$this->picto = 'order';
		$this->module_parts = array(
			'css' 	=> array('/inforderlivraison/css/inforderlivraison.css'),
			'js' 	=> array('/inforderlivraison/js/inforderlivraison.js.php'),
		);

		$this->dirs = array();

		$this->config_page_url = array('inforderlivraison_setup.php@inforderlivraison');

		// Dependencies
		$this->hidden = false;			// A condition to hide module
		$this->depends = array();		// List of modules id that must be enabled if this module is enabled
		$this->requiredby = array();	// List of modules id to disable if this one is disabled
		$this->conflictwith = array();	// List of modules id this module is in conflict with
		$this->phpmin = array(5,0);					// Minimum version of PHP required by module
		$this->need_dolibarr_version = array(3,0);	// Minimum version of Dolibarr required by module
		$this->langfiles = array("inforderlivraison@inforderlivraison");

		// Constants
		$this->const = array();

        $this->tabs = array();

        // Dictionaries
	    if (! isset($conf->inforderlivraison->enabled))
        {
        	$conf->inforderlivraison=new stdClass();
        	$conf->inforderlivraison->enabled=0;
        }
		$this->dictionaries=array();
       

        // Boxes
        $this->boxes = array();			// List of boxes
		// Example:

		// Permissions
		$this->rights = array();		// Permission array used by this module
		$r=0;

			// Permission Gestion Avancée des Ressources Humains
		$this->rights[$r][0] = $this->numero + $r;
		$this->rights[$r][1] = 'Consulter';
		$this->rights[$r][2] = 'r';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'lire';
		$r++;
		$this->rights[$r][0] = $this->numero + $r;
		$this->rights[$r][1] = 'Ajouter / Modifier';
		$this->rights[$r][2] = 'w';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'creer';
		$r++;
		$this->rights[$r][0] = $this->numero + $r;
		$this->rights[$r][1] = 'Supprimer';
		$this->rights[$r][2] = 'd';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'supprimer';
		$r++;
		
		// Main menu entries
		$this->menu = array();			// List of menus to add
		$r=0;


		$this->menu[$r]=array(	'fk_menu'=>0,
			'type'=>'top',
			'titre'=>'inforderlivraison',
			'mainmenu'=>'inforderlivraison',
			'leftmenu'=>'inforderlivraison',
			'url'=>'/inforderlivraison/dashbord.php',
			'langs'=>'inforderlivraison@inforderlivraison',
			'position'=>100,
			'enabled'=>'1',
			'perms'=>'$user->rights->inforderlivraison->lire',
			'target'=>'',
			'user'=>2);
		$r++;
		
			$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=inforderlivraison',
				'type'=>'left',
				'titre'=>'dashbord_inforder',
	            'leftmenu'=>'inforderlivraison1',
				'url'=>'/inforderlivraison/dashbord.php',
				'langs'=>'inforderlivraison@inforderlivraison',
				'position'=>1,
				'enabled'=>'1',
				'perms'=>'$user->rights->inforderlivraison->lire',
				'target'=>'',
				'user'=>2);
			$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=inforderlivraison',
				'type'=>'left',
				'titre'=>'list_infoder',
	            'leftmenu'=>'inforderlivraison1',
				'url'=>'/inforderlivraison/index.php',
				'langs'=>'inforderlivraison@inforderlivraison',
				'position'=>2,
				'enabled'=>'1',
				'perms'=>'$user->rights->inforderlivraison->lire',
				'target'=>'',
				'user'=>2);		
			$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=inforderlivraison',
				'type'=>'left',
				'titre'=>'statisticprod',
	            'leftmenu'=>'inforderlivraison2',
				'url'=>'/inforderlivraison/statisticprod.php',
				'langs'=>'inforderlivraison@inforderlivraison',
				'position'=>3,
				'enabled'=>'1',
				'perms'=>'$user->rights->inforderlivraison->lire',
				'target'=>'',
				'user'=>2);		
			$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=inforderlivraison',
				'type'=>'left',
				'titre'=>'etat_ventes_journl',
	            'leftmenu'=>'inforderlivraison2',
				'url'=>'/inforderlivraison/statistiq_prodday.php',
				'langs'=>'inforderlivraison@inforderlivraison',
				'position'=>4,
				'enabled'=>'1',
				'perms'=>'$user->rights->inforderlivraison->lire',
				'target'=>'',
				'user'=>2);		
			$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=inforderlivraison',
				'type'=>'left',
				'titre'=>'etat_ventes_encaiss',
	            'leftmenu'=>'inforderlivraison2',
				'url'=>'/inforderlivraison/etatventes.php',
				'langs'=>'inforderlivraison@inforderlivraison',
				'position'=>5,
				'enabled'=>'1',
				'perms'=>'$user->rights->inforderlivraison->lire',
				'target'=>'',
				'user'=>2);		
			$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=inforderlivraison',
				'type'=>'left',
				'titre'=>'etat_balance_ag',
	            'leftmenu'=>'etat_balance',
				'url'=>'/inforderlivraison/etatcreance.php',
				'langs'=>'inforderlivraison@inforderlivraison',
				'position'=>6,
				'enabled'=>'1',
				'perms'=>'$user->rights->inforderlivraison->lire',
				'target'=>'',
				'user'=>2);		
			$r++;

				$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=inforderlivraison,fk_leftmenu=etat_balance',
					'type'=>'left',
					'titre'=>'etat_balance_creance',
					'url'=>'/inforderlivraison/etatcreance.php',
					'langs'=>'inforderlivraison@inforderlivraison',
					'position'=>7,
					'enabled'=>'1',
					'perms'=>'$user->rights->inforderlivraison->lire',
					'target'=>'',
					'user'=>2);		
				$r++;

				$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=inforderlivraison,fk_leftmenu=etat_balance',
					'type'=>'left',
					'titre'=>'etat_balance_dette',
					'url'=>'/inforderlivraison/etatdettes.php',
					'langs'=>'inforderlivraison@inforderlivraison',
					'position'=>8,
					'enabled'=>'1',
					'perms'=>'$user->rights->inforderlivraison->lire',
					'target'=>'',
					'user'=>2);		
				$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=inforderlivraison',
				'type'=>'left',
				'titre'=>'Setup',
	            'leftmenu'=>'inforderlivraison3',
				'url'=>'/inforderlivraison/admin/inforderlivraison_setup.php',
				'langs'=>'inforderlivraison@inforderlivraison',
				'position'=>60,
				'enabled'=>'1',
				'perms'=>'$user->rights->inforderlivraison->lire',
				'target'=>'',
				'user'=>2);		
			$r++;

		// Add here entries to declare new menus

	}

	/**
	 *		Function called when module is enabled.
	 *		The init function add constants, boxes, permissions and menus (defined in constructor) into Dolibarr database.
	 *		It also creates data directories
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	function init($options='')
	{
		global $conf;
		$sqlm = array();

		dol_include_once('/inforderlivraison/class/inforderlivraison.class.php');

		$object = new inforderlivraison($this->db);
		$object->Initinforderlivraison();

		return $this->_init($sqlm, $options);
	}

	/**
	 *		Function called when module is disabled.
	 *      Remove from database constants, boxes and permissions from Dolibarr database.
	 *		Data directories are not deleted
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	function remove($options='')
	{
		$sql = array();
		return $this->_remove($sql, $options);
	}

}
