<?php
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/commonobject.class.php'; 



class inforderlivraison extends Commonobject{

	/**
	* @var string Error code (or message)
	* @deprecated
	* @see test::errors
	*/
	public $error;
	/**
	* @var string[] Error codes (or messages)
	*/
	public $errors = array();
	/**
	* @var string Id to identify managed objects
	*/
	// public $element = 'salle';
	/**
	* @var string Name of table without prefix where object is stored
	*/
	public $table_element = 'inforderlivraison';

	
    public $id;
	public $fk_user;
	public $rows = array();
	

	public function __construct($db)
	{
		$this->db 		 = $db;
		return 1;
	}

	public function fetch_users_accepter_holiday()
	{
		// phpcs:enable
		$users_validator = array();

		$sql = "SELECT DISTINCT ur.fk_user";
		$sql .= " FROM ".MAIN_DB_PREFIX."user_rights as ur, ".MAIN_DB_PREFIX."rights_def as rd";
		$sql .= " WHERE ur.fk_id = rd.id and rd.module = 'holiday' AND rd.perms = 'accept'"; // Permission 'accept';
		$sql .= "UNION";
		$sql .= " SELECT DISTINCT ugu.fk_user";
		$sql .= " FROM ".MAIN_DB_PREFIX."usergroup_user as ugu, ".MAIN_DB_PREFIX."usergroup_rights as ur, ".MAIN_DB_PREFIX."rights_def as rd";
		$sql .= " WHERE ugu.fk_usergroup = ur.fk_usergroup AND ur.fk_id = rd.id and rd.module = 'holiday' AND rd.perms = 'accept'"; // Permission 'Accepte';
		//print $sql;

		dol_syslog(get_class($this)."::fetch_users_accepter_holiday sql=".$sql);
		$result = $this->db->query($sql);
		if ($result)
		{
			$num_rows = $this->db->num_rows($result); $i = 0;
			while ($i < $num_rows)
			{
				$objp = $this->db->fetch_object($result);
				array_push($users_validator, $objp->fk_user);
				$i++;
			}
			return $users_validator;
		} else {
			$this->error = $this->db->lasterror();
			dol_syslog(get_class($this)."::fetch_users_accepter_holiday  Error ".$this->error, LOG_ERR);
			return -1;
		}
	}

	public function select_acceptors($fk_acceptor='',$name='',$data)
	{
		$html = '<select class="minwidth200" name="'.$name.'" id="'.$name.'">';
			$html .= '<option value="0"></option>';
			if($data && count($data)>0){
				foreach ($data as $key => $value) {
					$selected = '';
					$User = new User($this->db);
					$User->fetch($value);
					if($fk_acceptor == $value) $selected = 'selected';
					$html .= '<option value="'.$value.'" '.$selected.'>'.$User->firstname.' '.$User->lastname.'</option>';
				}
			}	
		$html .= '</select>';
		return $html;
	}


	public function upgradeModuleinforderlivraison()
    {
        global $conf, $langs;

        dol_include_once('/inforderlivraison/core/modules/modinforderlivraison.class.php');
        $modcore = new modinforderlivraison($this->db);
        
        $lastversion    = $modcore->version;
        $currentversion = dolibarr_get_const($this->db, 'INFORDERLIVRAISON_LAST_VERSION_OF_MODULE', $conf->entity);
        if (!$currentversion || ($currentversion && $lastversion != $currentversion)){
            $res = $this->Initinforderlivraison();
            if($res)
                dolibarr_set_const($this->db, 'INFORDERLIVRAISON_LAST_VERSION_OF_MODULE', $lastversion, 'chaine', 0, '', $conf->entity);
            return 1;
        }
        return 0;
    }

	public function Initinforderlivraison()
	{
		global $conf, $langs;
		$langs->load('inforderlivraison@inforderlivraison');

		return 1;
	}

	public function selectMonthMultipl($month=[], $empty=0)
	{
		global $langs;
		$montharray = monthArray($langs, 0);

		$select .= '<select class="minwidth250imp" name="srch_month[]" id="srch_month" multiple>';
			if($empty) $select .= '<option value="0"></option>';

			foreach ($montharray as $key => $value) {
				$selected='';
				if($month && in_array($key, $month)) $selected = 'selected';
				$select .= '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
			}
		$select .= '</select>';

		return $select;
	}




  	public function TotalReglmentCreanc($socid='', $filter='')
  	{
  		$sql = "SELECT SUM(pf.amount) as totalrglm FROM ".MAIN_DB_PREFIX."paiement as p LEFT JOIN ".MAIN_DB_PREFIX."paiement_facture as pf ON p.rowid=pf.fk_paiement LEFT JOIN ".MAIN_DB_PREFIX."facture as f ON pf.fk_facture = f.rowid WHERE f.fk_soc=".$socid;
		$sql .= ' AND p.entity IN ('.getEntity('invoice').')';
  		if($filter) $sql .= ' '.$filter;
  		$result = $this->db->query($sql);
		if ($result) {
			while ($obj = $this->db->fetch_object($result)){
				$total += $obj->totalrglm;
			}
	  	}
	  	return $total;
  	}

  	public function TotalFactureClient($socid='', $filter='')
  	{
  		$sql = "SELECT fd.rowid, fd.qty as qty, fd.total_ttc as ttc FROM ".MAIN_DB_PREFIX."facturedet as fd";
  		$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."facture as f ON f.rowid = fd.fk_facture";
		$sql .= " WHERE fd.product_type= 0";
		$sql .= " AND f.fk_soc= ".$socid;
		$sql .= ' AND f.entity IN ('.getEntity('invoice').')';
		if($filter) $sql .= ' '.$filter;
		$sql .= ' GROUP BY fd.rowid';
		$Total=0;
		$Totalqty=0;
  		$resql = $this->db->query($sql);
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)){
				$Total+=$obj->ttc;
				$Totalqty+=$obj->qty;
			}
	  	}
	  	return ['total'=>$Total, 'qty'=>$Totalqty];
  	}

  	// Etat de balance Agee
  		// Creances	 

  	public function TotalReglmentBalance($socid='', $filter='')
  	{
  		$sql = "SELECT SUM(pf.amount) as totalrglm FROM ".MAIN_DB_PREFIX."paiement_facture as pf LEFT JOIN ".MAIN_DB_PREFIX."facture as f ON pf.fk_facture = f.rowid WHERE f.fk_soc=".$socid;
		$sql .= ' AND f.entity IN ('.getEntity('invoice').')';
  		if($filter) $sql .= ' '.$filter;
  		$result = $this->db->query($sql);
		if ($result) {
			while ($obj = $this->db->fetch_object($result)){
				$total += $obj->totalrglm;
			}
	  	}
	  	return $total;
  	}


  	public function TotalAchatBalance($socid='', $filter='')
  	{
  		$sql = "SELECT SUM(f.total_ttc) as ttc FROM ".MAIN_DB_PREFIX."facture as f";
		$sql .= " WHERE f.fk_soc= ".$socid;
		$sql .= ' AND f.entity IN ('.getEntity('invoice').')';
		if($filter) $sql .= ' '.$filter;
		$Total=0;
		$Totalqty=0;
  		$resql = $this->db->query($sql);
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)){
				$Total+=$obj->ttc;
			}
	  	}
	  	return $Total;
  	}


  	// Dettes	 

  	public function TotalReglmentBalanceDette($socid='', $filter='')
  	{
  		$sql = "SELECT SUM(pf.amount) as totalrglm FROM ".MAIN_DB_PREFIX."paiementfourn_facturefourn as pf LEFT JOIN ".MAIN_DB_PREFIX."facture_fourn as f ON pf.fk_facturefourn = f.rowid WHERE f.fk_soc=".$socid;
		$sql .= ' AND f.entity IN ('.getEntity('invoice').')';
  		if($filter) $sql .= ' '.$filter;

  		$result = $this->db->query($sql);
		if ($result) {
			while ($obj = $this->db->fetch_object($result)){
				$total += $obj->totalrglm;
			}
	  	}
	  	return $total;
  	}


  	public function TotalAchatBalanceDette($socid='', $filter='')
  	{
  		$sql = "SELECT SUM(f.total_ttc) as ttc FROM ".MAIN_DB_PREFIX."facture_fourn as f";
		$sql .= " WHERE f.fk_soc= ".$socid;
		$sql .= ' AND f.entity IN ('.getEntity('invoice').')';
		if($filter) $sql .= ' '.$filter;
		$Total=0;
		$Totalqty=0;
  		$resql = $this->db->query($sql);
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)){
				$Total+=$obj->ttc;
			}
	  	}
	  	return $Total;
  	}


}

