<?php // BEGIN PHP
$websitekey=basename(__DIR__); if (empty($websitepagefile)) $websitepagefile=__FILE__;
if (! defined('USEDOLIBARRSERVER') && ! defined('USEDOLIBARREDITOR')) {
	$pathdepth = count(explode('/', $_SERVER['SCRIPT_NAME'])) - 2;
	require_once ($pathdepth ? str_repeat('../', $pathdepth) : './').'master.inc.php';
} // Not already loaded
require_once DOL_DOCUMENT_ROOT.'/core/lib/website.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/website.inc.php';
ob_start();
// END PHP ?>
<html lang="en">
<head>
<title>Privacy Policies</title>
<meta charset="utf-8">
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<meta name="robots" content="index, follow" />
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta name="keywords" content="Privacy policies, GDPR" />
<meta name="title" content="Privacy Policies" />
<meta name="description" content="Privacy Policies" />
<meta name="generator" content="Dolibarr 17.0.0-alpha (https://www.dolibarr.org)" />
<meta name="dolibarr:pageid" content="193" />
<?php if ($website->use_manifest) { print '<link rel="manifest" href="/manifest.json.php" />'."\n"; } ?>
<!-- Include link to CSS file -->
<link rel="stylesheet" href="/styles.css.php?website=<?php echo $websitekey; ?>" type="text/css" />
<!-- Include link to JS file -->
<script async src="/javascript.js.php"></script>
<!-- Include HTML header from common file -->
<?php if (file_exists(DOL_DATA_ROOT."/website/".$websitekey."/htmlheader.html")) include DOL_DATA_ROOT."/website/".$websitekey."/htmlheader.html"; ?>
<!-- Include HTML header from page header block -->

</head>
<!-- File generated by Dolibarr website module editor -->
<body id="bodywebsite" class="bodywebsite bodywebpage-privacy-policies">
<div class="page">
          
    
        <?php includeContainer('header'); ?>


      <section id="sectionimage" contenteditable="true">
        <div class="">
          <div class="swiper-wrapper text-center" style="transform: translate3d(0px, 0px, 0px); transition-duration: 0ms;">
            <div class="swiper-slide swiper-slide-active" style="height: 200px; background-image: url('medias/image/template-corporate/background_sunset.webp'); background-size: cover;">
              <div class="swiper-slide-caption">
                <div class="container">
                  <div class="row justify-content-sm-center">
                    <div class="col-md-11 col-lg-10">
                      <div class="text-white text-uppercase jumbotron-custom border-modern fadeInUp animated" data-caption-animate="fadeInUp" data-caption-delay="0s">Privacy Policy</span>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
        </div>
      </section>

<br><br><br>

        <section id="sectionfooterdolibarr" contenteditable="true" class="footerdolibarr" style="margin-top: 50px">
            <div class="container">
<p style = "text-align: justify;"> <h2> Information collected and used </h2> <br> </p>
<p style = "text-align: justify;"> * Your customer information (email, phone, business name, first and last name of contact, address, postal code, country and VAT number) are stored when you become a customer. This information allows us to bill you. </ P>
<p style = "text-align: justify;"> * If you paid using our online service, we also store the last 4 digits of your card. The full details of your credit card is stored by our payment provider Stripe (the world leader in online payment).</p>
<p style = "text-align: justify;"> * You have the option to request the deletion of your data and the above information at any time (except data required y fiscal tracking rules, like your invoices). </p>
<p style = "text-align: justify;"> * The Privacy Policies and GDPR referral contact for our services is: <?php echo $conf->global->MAIN_INFO_GDPR; ?> </p>
<p style = "text-align: justify;"> <br> </p>
<p style = "text-align: justify;"> <h2> Data Storage and Backups </h2> <br> </p>
<p style = "text-align: justify;"> * The storage of collected data (see 'Information collected and used') is done in a database. </p>
<p style = "text-align: justify;"> * We made one backup every week. Only 4 weeks are kept. <br> </p>
<p style = "text-align: justify;"> <br> </p>
<p style = "text-align: justify;"> <h2> Subcontractor </h2> <br> </p>
<p style = "text-align: justify;"> * Our services relies on the following subcontractors and service: <br>
** The host of computer servers, which is ABC company. These servers are hosted in US. No customer information is communicated to this subcontractor who only provides the hardware and network layer, the installation and operation being carried out by us directly. <br>
** The online payment service <a href="https://www.stripe.com">Stripe</a>, which is used, to ensure regular payment of subscription or your invoices paid online. </p>
<p style = "text-align: justify;"> <br> </p>
<p style = "text-align: justify;"> <h2> Software Protection </h2> <br> </p>
<p style = "text-align: justify;"> * Our services runs on Linux Ubuntu systems and software. They benefit from regular security updates when the operating system editor (Ubuntu Canonical) publishes them. <br> </p>
<p style = "text-align: justify;"> * Our services are accessible in HTTPS (HTTP encrypted) only, encrypted with SHA256 certificates.<br> </p>
<p style = "text-align: justify;"> * Our technical platform are protected by various solutions. <br> </p>
<p style = "text-align: justify;"> <br> </p>
<p style = "text-align: justify;"> <h2> Data theft </h2> <br> </p>
<p style = "text-align: justify;"> * In case of suspicion of a theft of the data we have collected (see first point 'Information collected and used'), customers will be informed by email, at email corresponding to their customer account <br> </p>
<p style="text-align: justify;"> </p>
            </div>
        </section>


      <?php includeContainer('footer'); ?>
      
      
</div>
    

</body>
</html>
<?php // BEGIN PHP
$tmp = ob_get_contents(); ob_end_clean(); dolWebsiteOutput($tmp, "html", 193);
// END PHP ?>
