<?php 

$res=0;
if (! $res && file_exists("../main.inc.php")) $res=@include("../main.inc.php");       // For root directory
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php"); // For "custom" 

global $conf;
if (!$conf->releveclient->enabled) {
  accessforbidden();
}
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
require_once DOL_DOCUMENT_ROOT.'/categories/class/categorie.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture-rec.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/modules/facture/modules_facture.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/discount.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/invoice.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/accountancy/class/accountingjournal.class.php';


dol_include_once("/releveclient/class/releveclient.class.php");
dol_include_once("/releveclient/lib/releveclient.lib.php");

$form = new Form($db);
$userstatic = new User($db);
$releveclient = new releveclient($db);
$object    = new Facture($db);
$client    = new Societe($db);
$paiement = new Paiement($db);
$extrafields = new ExtraFields($db);


$releveclient->upgradeModulereleveclient();

$langs->loadLangs(array('bills', 'companies', 'compta', 'products', 'banks', 'main', 'withdrawals'));
$modname = $langs->trans("releveclient");

$facid = (GETPOST('id', 'int') ?GETPOST('id', 'int') : GETPOST('facid', 'int')); // For backward compatibility
$ref = GETPOST('ref', 'alpha');
$fk_reglement = GETPOST('fk_reglement', 'int');
$action = GETPOST('action', 'alpha');
$actionpdf = GETPOST('actionpdf', 'alpha');
$exportxsl = GETPOST('exportxsl', 'alpha');
$socid=GETPOST('socid');

$srch_qty=GETPOST('srch_qty');

$actionexport = $actionpdf ? 1 : ($exportxsl ? 1 : 0);
$debut = dol_mktime(0, 0, 0, GETPOST('debutmonth'), GETPOST('debutday'), GETPOST('debutyear'));
$fin = dol_mktime(0, 0, 0, GETPOST('finmonth'), GETPOST('finday'), GETPOST('finyear'));
$debut = $debut ? $db->idate($debut) : '';
$fin = $fin ? $db->idate($fin) : '';


if(empty($debut) && GETPOST('debut')) $debut=GETPOST('debut');

if(empty($fin) && GETPOST('fin')) $fin=GETPOST('fin');

   
$object = new Account($db);
$fk_account = GETPOST('fk_account');
$object->fetch($fk_account); 

$srch_datec = dol_mktime(0, 0, 0, GETPOST('srch_datecmonth'), GETPOST('srch_datecday'), GETPOST('srch_datecyear'));
// $limit = GETPOST('limit', 'int') ?GETPOST('limit', 'int') : $conf->liste_limit;
$limit = GETPOST('limit', 'int') ?GETPOST('limit', 'int') : 20;
$sortfield = GETPOST('sortfield', 'alpha') ? GETPOST('sortfield', 'alpha') : 'f.datef';
$sortorder = GETPOST('sortorder', 'alpha') ? GETPOST('sortorder', 'alpha') : 'ASC';
$page = GETPOSTISSET('pageplusone') ? (GETPOST('pageplusone') - 1) : GETPOST('page', 'int');
if (empty($page) || $page === -1 || !empty($search_btn) || !empty($search_remove_btn) || (empty($toselect) && $massaction === '0')) { $page = 0; }     

$offset = $limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$filter='';
$solde=0;
if (GETPOST('button_removefilter_x') || GETPOST('button_removefilter') || $page < 0) {
    $filter = '';
    $offset = 0;
    $filter = '';
}
if($socid && $debut && $fin) $solde = $releveclient->SoldeDebiteur($socid,$debut,$fin);

$i=0;
$qtyprod_by_tag = array();

$TData = array();
$sql = 'SELECT s.nom, s.rowid as socid, f.ref, f.total_ttc, f.datef as df,';
$sql .= ' f.paye as paye, f.fk_statut as statut, f.rowid as facid';
$sql .= ' FROM '.MAIN_DB_PREFIX.'societe as s, '.MAIN_DB_PREFIX.'facture as f';
$sql .= ' WHERE f.fk_soc = s.rowid AND s.rowid = '.$socid;
$sql .= ' AND f.entity IN ('.getEntity('invoice').')';

if($debut && $fin) $sql .= ' AND (CAST(f.datef as date) BETWEEN "'.$debut.'" AND "'.$fin.'")';
elseif($debut && empty($fin)) $sql .= ' AND CAST(f.datef as date) >= "'.$debut.'"';
elseif($fin && empty($debut)) $sql .= ' AND CAST(f.datef as date) <= "'.$fin.'"';

$sql .= $db->order($sortfield, $sortorder);

if(empty($actionexport)){
    $nbtotalofrecords = '';
    if (empty($conf->global->MAIN_DISABLE_FULL_SCANLIST))
    {
        $result = $db->query($sql);
        $nbtotalofrecords = $db->num_rows($result);
        if (($page * $limit) > $nbtotalofrecords)   // if total resultset is smaller then paging size (filtering), goto and load page 0
        {
            $page = 0;
            $offset = 0;
        }
    }

    $sql .= $db->plimit($limit + 1, $offset);
}

$arrpayement = [];
$resql = $db->query($sql);
$factsid = '';

$arrainvoics = array();

$urlpayement    = DOL_URL_ROOT.'/compta/paiement/card.php?id='; 
$urlfacture     = DOL_URL_ROOT.'/compta/facture/card.php?facid=';
$urlproduct     = DOL_URL_ROOT.'/product/card.php?id=';

$pictopayement = img_picto('', 'payment').' ';
$pictofacture = img_picto('', 'bill').' ';
$pictoproduct = img_picto('', 'product').' ';

if ($resql)
{
    $num = $db->num_rows($resql);

    // Boucle sur chaque facture
    for ($i = 0; $i < $num; $i++)
    {
        $objf = $db->fetch_object($resql);

        $fac = new Facture($db);
        $ret = $fac->fetch($objf->facid);
        if($i === 0) $factsid .= $objf->facid;
        else $factsid .= ','.$objf->facid;

        if ($ret < 0) continue;

        $arrainvoics[$objf->facid] = $fac;
        // $totalpaye = $fac->getSommePaiement();

        $userstatic->id = $objf->userid;
        $userstatic->login = $objf->login;

        $fac->fetch_lines();
        $lignes = $fac->lines;
        $dtlignes=[];
        if(is_array($lignes) && count($lignes) > 0){
            foreach ($lignes as $key => $ligne) {
                if($ligne->fk_product){
                    $label = $ligne->product_label;
                    $type = $ligne->fk_product_type;
                    $cat = new Categorie($db);
                    $categories = $cat->containing($ligne->fk_product, Categorie::TYPE_PRODUCT);
                    if($categories){
                        foreach ($categories as $key => $value) {
                            if($value->fk_parent){
                                $parentcat = new Categorie($db);
                                $parentcat->fetch($value->fk_parent);
                                $qtyprod_by_tag[$type][$value->fk_parent]['label'] = $parentcat->label;
                                $qtyprod_by_tag[$type][$value->fk_parent]['nb']+=$ligne->qty;
                                $qtyprod_by_tag[$type][$value->fk_parent]['totalfact']+= $ligne->total_ttc;

                            }else{
                                $qtyprod_by_tag[$type][$value->id]['label']=$value->label;
                                $qtyprod_by_tag[$type][$value->id]['nb']+=$ligne->qty;
                                $qtyprod_by_tag[$type][$value->id]['totalfact']+= $ligne->total_ttc;
                            }
                        }
                    }else{
                        $qtyprod_by_tag[$type][0]['nb']+=$ligne->qty;
                        $qtyprod_by_tag[$type][0]['totalfact']+= $ligne->total_ttc;
                    }
                    if(empty($actionexport)){
                        $label = '<a href="'.$urlproduct.$ligne->fk_product.'">';
                        $label .= $pictoproduct.$ligne->product_label;
                        $label .= '</a>';
                    }
                }else{
                    $type = $ligne->product_type;
                    $qtyprod_by_tag[$type][0]['nb']+=$ligne->qty;
                    $qtyprod_by_tag[$type][0]['totalfact']+= $ligne->total_ttc;
                    $label=$ligne->desc;
                }

                $dtlignes[] = ['descp'=>$ligne->desc,'fk_product'=>$ligne->fk_product, 'label' => $label, 'qty'=>$ligne->qty, 'amount'=>$ligne->subprice,'type'=>$type];
            }
        }

       

        $faclink = $objf->ref;
        if(empty($actionexport)){
            $faclink = '<a href="'.$urlfacture.$objf->facid.'">';
            $faclink .= $pictofacture.$objf->ref;
            $faclink .= '</a>';
        }

        $values = array(
            'fk_facture' => $objf->facid,
            'date'       => $fac->date,
            // 'link'       => $fac->getNomUrl(1),
            'link'       => $faclink,
            'amount'     => $fac->total_ttc,
            'lignes'     => $dtlignes,
            'datefieldforsort' => $fac->date.'-'.$fac->ref,
        );
        $TData = $values;



        // $values = array(
        //     'fk_facture' => $objf->facid,
        //     'date'       => $fac->date,
        //     'link'       => $faclink,
        //     'amount'     => $fac->total_ttc,
        //     'lignes'     => $dtlignes,
        //     'be1'        => $fac->array_options['options_be1'],
        //     'bl1'        => $fac->array_options['options_bl1'],
        //     'datefieldforsort' => $fac->date.'-'.$fac->ref,
        //     // ''=>$fac->array_option
        // );

        // if(!empty($fac->array_options['options_bl1'])){
        //     $TData['bl1'][] = $values;
        // }
        // if((empty($fac->array_options['options_bl1']) && !empty($fac->array_options['options_be1'])) || (empty($fac->array_options['options_be1']) && empty($fac->array_options['options_bl1'])) ){
        //     $TData['be1'][] = $values;
        // }



        // if(!empty($fac->array_options['options_bl1'])){

        //     $values = array(
        //         'fk_facture' => $objf->facid,
        //         'date'       => $fac->date,
        //         'link'       => $faclink,
        //         'amount'     => $fac->total_ttc,
        //         'lignes'     => $dtlignes,
        //         'be1'        => $fac->array_options['options_be1'],
        //         'bl1'        => $fac->array_options['options_bl1'],
        //         'datefieldforsort' => $fac->date.'-'.$fac->ref,
        //         // ''=>$fac->array_option
        //     );
        //     $TData['bl1'][] = $values;
        // }
        // if((empty($fac->array_options['options_bl1']) && !empty($fac->array_options['options_be1'])) || (empty($fac->array_options['options_be1']) && empty($fac->array_options['options_bl1'])) ){

        //     $values = array(
        //         'fk_facture' => $objf->facid,
        //         'date'       => $fac->date,
        //         'link'       => $faclink,
        //         'amount'     => $fac->total_ttc,
        //         'lignes'     => $dtlignes,
        //         'be1'        => $fac->array_options['options_be1'],
        //         'bl1'        => $fac->array_options['options_bl1'],
        //         'datefieldforsort' => $fac->date.'-'.$fac->ref,
        //         // ''=>$fac->array_option
        //     );
        //     $TData['be1'][] = $values;
        // }

        // $parameters = array('socid' => $id, 'values' => &$values, 'fac' => $fac, 'userstatic' => $userstatic);
        // $reshook = $hookmanager->executeHooks('facdao', $parameters, $object); // Note that $parameters['values'] and $object may have been modified by some hooks
        // if ($reshook < 0) setEventMessages($hookmanager->error, $hookmanager->errors, 'errors');

    }

    $db->free($resql);

    // Paiements
    $sql = 'SELECT p.rowid,c.code as type_code, c.libelle as type_label, p.ref as refpayement, p.datep as dp, p.amount, pf.fk_paiement, pf.fk_facture as fk_fact, p.statut';
    $sql .= ' FROM  '.MAIN_DB_PREFIX.'paiement as p';
    $sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'paiement_facture as pf ON pf.fk_paiement = p.rowid';
    $sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'c_paiement as c ON p.fk_paiement = c.id';
    // $sql .= ' WHERE pf.fk_paiement = p.rowid';
    $sql .= ' WHERE p.entity = '.$conf->entity;
    // $sql .= ' AND pf.fk_facture IN ('.$factsid.')';
    $sql .= ' AND pf.fk_facture IN (SELECT f.rowid FROM '.MAIN_DB_PREFIX.'facture as f WHERE f.fk_soc = '.$socid.')';

    if($debut && $fin) $sql .= ' AND (CAST(p.datep as date) BETWEEN "'.$debut.'" AND "'.$fin.'")';
    elseif($debut && empty($fin)) $sql .= ' AND CAST(p.datep as date)>= "'.$debut.'"';
    elseif($fin && empty($debut)) $sql .= ' AND CAST(p.datep as date)<= "'.$fin.'"';

    $sql .= ' GROUP BY p.rowid';
    $sql .= ' ORDER BY p.datep ASC, p.rowid ASC';

    $resqlp = $db->query($sql);
    if ($resqlp)
    {
        $nump = $db->num_rows($resqlp);
        $j = 0;

        while ($j < $nump)
        {
            $objp = $db->fetch_object($resqlp);

            // $paymentstatic = new Paiement($db);
            // $paymentstatic->fetch($objp->rowid);

            // $fac = new Facture($db);
            // $ret = $fac->fetch($objp->fk_fact);
            $fac = $arrainvoics[$objp->fk_fact];

            $paylink = $objp->refpayement;
            if(empty($actionexport)){
                $paylink = '<a href="'.$urlpayement.$objp->rowid.'">';
                $paylink .= $pictopayement.$objp->refpayement;
                $paylink .= '</a>';
            }
            $labeltype = $langs->trans("PaymentType".$objp->type_code) != ("PaymentType".$objp->type_code) ? $langs->trans("PaymentType".$objp->type_code) : $objp->type_label;
            $values = array(
                'fk_paiement' => $objp->rowid,                           
                'fk_facture' => $objp->fk_fact,
                'date' => $db->jdate($objp->dp),
                // 'datefieldforsort' => $objp->fk_fact.'-'.$db->jdate($objp->dp),
                'datefieldforsort' => $db->jdate($objp->dp).'-'.$fac->ref,
                // 'datefieldforsort' => $db->jdate($objp->dp),
                // 'link' => $paylink.' (Detail du Versement)' ,
                'link' => $paylink ,
                'labeltype' => $labeltype ,
                'amount' => (-1*$objp->amount),
            );

            $TData = $values;


            // $values = array(
            //     'fk_paiement' => $objp->rowid,
            //     'fk_facture' => $objp->fk_fact,
            //     'date' => $db->jdate($objp->dp),
            //     'datefieldforsort' => $db->jdate($objp->dp).'-'.$fac->ref,
            //     'link' => $paylink.' (Detail du Versement)' ,
            //     'labeltype' => $labeltype ,
            //     'amount' => (-1*$objp->amount),
            // );

            // if(!empty($fac->array_options['options_bl1'])){
            //     $TData['bl1'][] = $values;
            // }
            // if((empty($fac->array_options['options_bl1']) && !empty($fac->array_options['options_be1'])) || (empty($fac->array_options['options_be1']) && empty($fac->array_options['options_bl1'])) ){
            //     $TData['be1'][] = $values;
            // }




            // if(!empty($fac->array_options['options_bl1'])){
            //     $values = array(
            //         'fk_paiement' => $objp->rowid,
            //         'fk_facture' => $objp->fk_fact,
            //         'date' => $db->jdate($objp->dp),
            //         'datefieldforsort' => $db->jdate($objp->dp).'-'.$fac->ref,
            //         'link' => $paylink.' (Detail du Versement)' ,
            //         'labeltype' => $labeltype ,
            //         'amount' => (-1*$objp->amount),
            //     );
            //     $TData['bl1'][] = $values;
            // }

            // if((empty($fac->array_options['options_bl1']) && !empty($fac->array_options['options_be1'])) || (empty($fac->array_options['options_be1']) && empty($fac->array_options['options_bl1'])) ){
            //     $values = array(
            //         'fk_paiement' => $objp->rowid,
            //         'fk_facture' => $objp->fk_fact,
            //         'date' => $db->jdate($objp->dp),
            //         'datefieldforsort' => $db->jdate($objp->dp).'-'.$fac->ref,
            //         'link' => $paylink.' (Detail du Versement)' ,
            //         'labeltype' => $labeltype ,
            //         'amount' => (-1*$objp->amount),
            //     );
            //     $TData['be1'][] = $values;
            // }
            

            $j++;
        }

        $db->free($resqlp);
    }
}

$TDataBL = array();
$TDataBE = array();
$totalqtyprod = array();
if (!empty($TData)) {
    
    $TDataBL = dol_sort_array($TData['bl1'], 'datefieldforsort', $sortorder);
    $TDataBE = dol_sort_array($TData['be1'], 'datefieldforsort', $sortorder);

    $totalDebit = 0;
    $totalCredit = 0;
}

if ($limit > 0 && $limit != $conf->liste_limit) $param .= '&limit='.urlencode($limit);
if ($socid) $param .= '&socid='.urlencode($socid);
if ($debut) $param .= '&debut='.urlencode($debut);
if ($fin) $param .= '&fin='.urlencode($fin);



if (!$user->rights->releveclient->lire || !$user->rights->releveclient->export) {
    accessforbidden();
}

$getcurrencysym = $langs->getCurrencySymbol($conf->currency);

$aftercomma = intval($conf->global->RELEVECLIENT_NUMBER_OF_DIGITS_AFTER_THE_DECIMAL_POINT);
$subtotaltext1 = ($conf->global->RELEVECLIENT_FIRST_SUB_TOTAL_TEXT) ? $conf->global->RELEVECLIENT_FIRST_SUB_TOTAL_TEXT : $langs->trans("totalbl1");
$subtotaltext2 = ($conf->global->RELEVECLIENT_SECOND_SUB_TOTAL_TEXT) ? $conf->global->RELEVECLIENT_SECOND_SUB_TOTAL_TEXT : $langs->trans("totalbe1");


/*-------------PDF-----------------*/
if($actionexport){
    global $conf, $langs, $mysoc;

    $Client = new Societe($db);
    $filename = html_entity_decode($langs->trans('releveclient'));
    if($socid) {
        $Client->fetch($socid);
        $filename = $Client->name.' - '.html_entity_decode($langs->trans('releveclient'));

        // if($debut || $fin ){
        //     $filename.= ' - '.html_entity_decode($langs->trans('Period')).': ';
        //     if($debut) $filename.= dol_print_date($debut,'day');
        //     if($debut && $fin) $filename .= ' '.$langs->trans('to').' ';
        //     if($fin) $filename.= dol_print_date($fin,'day');
        // }
    }
}
if($exportxsl){
    require_once dol_buildpath('/releveclient/pdf/releve_pdf.php');
}
if ($actionpdf) {
    
    require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
    require_once dol_buildpath('/releveclient/pdf/pdf.lib.php');
    // $pdf->SetMargins(7, 2, 7, false);
    // $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetMargins(7, PDF_MARGIN_TOP, 7);
    $pdf->SetFooterMargin(15);
    $pdf->setPrintFooter(true);
    $pdf->SetAutoPageBreak(TRUE,15);

    $height=$pdf->getPageHeight();

    $pdf->SetFont('helvetica', '', 9, '', true);
    $pdf->AddPage('L');
    $margint = $pdf->getMargins()['top'];
    $marginb = $pdf->getMargins()['bottom'];
    $marginl = $pdf->getMargins()['left'];

    $pdf->SetTextColor(0, 0, 60);

    $default_font_size = 9;
    $pdf->SetFont('', 'B', $default_font_size);
    $posy   = $margint;
    $posx   = $pdf->page_largeur-$pdf->getMargins()['right']-100;

    $pdf->SetXY($marginl, $posy);

    $heightimg = 15;
    if ($mysoc && $mysoc->logo)
    {
        $logodir = $conf->mycompany->dir_output;
        if (empty($conf->global->MAIN_PDF_USE_LARGE_LOGO))
        {
            $logo = $logodir.'/logos/thumbs/'.$mysoc->logo_small;
        }
        else {
            $logo = $logodir.'/logos/'.$mysoc->logo;
        }
        
        if (is_readable($logo))
        {
            $height = pdf_getHeightForLogo($logo);
            $pdf->Image($logo, $marginl, $posy, 0, $heightimg); // width=0 (auto)
        }
        else
        {
            $pdf->SetTextColor(200, 0, 0);
            $pdf->SetFont('', 'B', $default_font_size - 2);
            $pdf->MultiCell(100, 3, $langs->transnoentities('ErrorLogoFileNotFound', $logo), 0, 'L');
            $pdf->MultiCell(100, 3, $langs->transnoentities('ErrorGoToGlobalSetup'), 0, 'L');
        }
    }
    else
    {
        $heightimg = 8;
        $text = $mysoc->name;
        $pdf->MultiCell(100, 4, $langs->convToOutputCharset($text), 0, 'L');
    }

    $posy = $margint + $heightimg + 2;

    $pdf->SetTextColor(0, 0, 60);

    $pdf->SetFont('', '', $default_font_size);

    require_once dol_buildpath('/releveclient/pdf/pdf.lib.php');
    require_once dol_buildpath('/releveclient/pdf/releve_pdf.php');
    $pdf->writeHTML($html, true, false, true, false, '');
    ob_start();
    $db->close();
    $pdf->Output($filename.'.pdf', 'I');
    die();
}

// if(dolibarr_get_const($db, strtoupper('releveclient_fields'),$conf->entity)){
//     $data_ef = dolibarr_get_const($db, strtoupper('releveclient_fields'),$conf->entity);
//     $data_ef = explode(',', $data_ef);
// }

// if(GETPOST('exportxsl')){

//     $html = '';
//     $Client = new Societe($db);

//     if($socid)
//         $Client->fetch($socid);

//     $filename='Releve_client.xls';
//     require_once dol_buildpath('/releveclient/pdf/releve_pdf.php');
//     header('Content-Type: application/xls');
//     header('Content-Disposition: attachment; filename='.$filename);
//     echo $html;
//     die(); 
// }


$morejs  = array();
llxHeader(array(), $modname,'','','','',$morejs,0,0);

echo load_fiche_titre($modname);

$head = releve_prepare_head();
echo dol_get_fiche_head($head, 'releveclient', $langs->trans('releveclient'), -1, 'invoice');

echo '<div id="stclient" class="div-table-responsive">';
    echo '<form  method="POST" action="'.$_SERVER['PHP_SELF'].'" >';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        echo '<table class="noborder">';
            echo '<input type="hidden" name="action" value="generer">';
            echo '<tr>';
                echo '<td colspan="3">'.$langs->trans('Period');
                    echo ' &nbsp;&nbsp;&nbsp;&nbsp;'.$langs->trans("From").' '.$form->selectDate($debut, 'debut', 0, 0, 1, '', 1, 1);
                // echo '</td>';
                // echo '<td colspan="2">';
                    echo '&nbsp;&nbsp;';
                    echo $langs->trans("To").' '.$form->selectDate($fin, 'fin', 0, 0, 1, '', 1, 1);
                echo '</td>';
            echo '</tr>'; 
            echo '<tr>';
                echo '<td>'.$langs->trans('Customer');
                    echo $form->select_company($socid, 'socid', '((s.client = 1 OR s.client = 3) AND s.status=1)', 'SelectThirdParty', 0, 0, null, 0, 'minwidth300');

                    // Option to reload page to retrieve customer informations. Note, this clear other input
                    if (!empty($conf->global->RELOAD_PAGE_ON_CUSTOMER_CHANGE))
                    {
                        echo '<script type="text/javascript">
                            $(document).ready(function() {
                                $("#socid").change(function() {
                                    var socid = $(this).val();
                                    var fac_rec = $(\'#fac_rec\').val();
                                    // reload page
                                    window.location.href = "'.$_SERVER["PHP_SELF"].'?action=create&socid="+socid+"&fac_rec="+fac_rec;
                                });
                            });
                        </script>';
                    }
                    if (!GETPOST('fac_rec', 'int')) 
                        echo ' <a href="'.DOL_URL_ROOT.'/societe/card.php?action=create&client=3&fournisseur=0&backtopage='.urlencode($_SERVER["PHP_SELF"].'?action=create').'"><span class="fa fa-plus-circle valignmiddle paddingleft" title="'.$langs->trans("AddThirdParty").'"></span></a>';
                echo '</td><td>';
                    if($socid && $debut && $fin){
                        $datesd=date('d/m/Y', strtotime($debut.' - 1 DAY'));
                        $text = $langs->trans("soldedebitair").' '.$datesd.':  '.number_format($solde, $aftercomma, ",", " ").' '.$getcurrencysym;
                        echo $text;
                    }
                echo '</td><td>';
                    echo '<a href="'.dol_buildpath('/releveclient/releve.php',2).'" class="butAction" style="padding-top: 0.4em; float:right">'.$langs->trans("Reset").'</a>';
                    echo '<input style="margin-top:0px; float:right" type="submit" value="'.$langs->trans("generetat").'" name="exportpdf" class="button" />';
                echo '</td>';

            echo '</tr>'."\n";
        echo '</table>';
    echo '</form>';
        
    echo '<br>';
    
    echo '<form  method="POST" action="'.$_SERVER['PHP_SELF'].'">';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        echo '<input type="hidden" name="fk_account" value="'.$fk_account.'">';
        echo '<input type="hidden" name="socid" value="'.$socid.'">';
        echo '<input type="hidden" name="debut" value="'.$debut.'">';
        echo '<input type="hidden" name="fin" value="'.$fin.'">';
        echo '<input name="pagem" type="hidden" value="'.$page.'">';
        echo '<input name="offsetm" type="hidden" value="'.$offset.'">';
        echo '<input name="limitm" type="hidden" value="'.$limit.'">';
        echo '<input name="filterm" type="hidden" value="'.$filter.'">';
        echo '<input name="action" type="hidden" value="pdf">';

        $object = new Facture($db);
        $dt_extrafield = $extrafields->fetch_name_optionals_label($object->table_element);
        $label=$extrafields->attributes[$object->table_element]['label'];
        $keyextrafild = array_keys($label);
        if(dolibarr_get_const($db, strtoupper('releveclient_fields'),$conf->entity)){
            $data_ef = dolibarr_get_const($db, strtoupper('releveclient_fields'),$conf->entity);
            $data_ef = explode(',', $data_ef);
        }

        $massactionbutton = '';
        // $massactionbutton .= '<input name="actionpdf" type="submit" id="btn_pdf" formtarget="_blank" class="butAction" value="'.$langs->trans('generpdf').'" >';
        $massactionbutton.= '<input type="submit" value="'.$langs->trans("generxsl").'" name="exportxsl" class="butAction" />';

        print_barre_liste('', $page, $_SERVER["PHP_SELF"], $param, $sortfield, $sortorder, '', $num, $nbtotalofrecords, '', 0, $massactionbutton, '', $limit, 0, 0, 1);

        echo '<table class="noborder" id="releveclient">';
            $clsp=0;
            echo '<tr class="liste_titre_filter">';
                print_liste_field_titre($langs->trans("Date"), $_SERVER["PHP_SELF"], "f.datef", '', $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("Label"), $_SERVER["PHP_SELF"], "", '', $param, 'align="center" ', $sortfield, $sortorder);
                if($data_ef && count($data_ef)>0){
                    $nbef = count($data_ef); 
                    foreach ($data_ef as $key => $value) {
                        // if($label && count($label)>0 && array_key_exists($value,$label)){
                        if($label && count($label)>0 && isset($label[$value])){
                            echo '<td align="center">'.$label[$value].'</td>';
                            $clsp++;
                        }
                    }
                }

                echo '<th class="lines_fact">';
                    echo '<table class="border">';
                        echo '<tr class="liste_titre_filter">';
                            echo '<th class="wrapcolumntitle liste_titre tdlabeltable">'.$langs->trans("Product").'</th>';
                            echo '<th class="wrapcolumntitle liste_titre tdqtytable">'.$langs->trans("Quantity").'</th>';
                            echo '<th class="wrapcolumntitle liste_titre tdamounttable">'.$langs->trans("PriceUHT").'</th>';
                        echo '</tr>';
                    echo '</table>';
                echo '</th>';

                print_liste_field_titre($langs->trans("debitreleve"), $_SERVER["PHP_SELF"], "", "", $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("creditreleve"), $_SERVER["PHP_SELF"], "", "", $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("solde"), $_SERVER["PHP_SELF"], "", "", $param, 'align="center"', $sortfield, $sortorder);
            echo '</tr>';
            $colsptotal = 2+$clsp;

            $totalgdebit    = 0;
            $totalgcredit   = 0;
            $totalgqty      = 0;
            $lastbalance    = $solde;

            if($TDataBL && count($TDataBL)>0 && $socid){
                $var = 1;
                $classes =[0=>'trnocolor', 1=>'trcolor'];
                $totalDebit     = 0;
                $totalCredit    = 0;
                $totalqty       = 0;

                $l = 0;
                $class = '';
                foreach ($TDataBL as $key => $data) {
                    $colspan = '';
                    $rowspan = '';
                    $var = !$var;
                    $totalp = 0;
                    
                    if($key === 0)
                        $balance = $solde-$data['amount'];
                    else
                        $balance = $lastbalance - $data['amount'];

                    $lastbalance = $balance;
                    $l++;

                    $boldcls = '';
                    if(empty($data['fk_paiement']) && $data['fk_facture']) {
                        $boldcls = 'boldtext';
                        // $fact = new Facture($db);
                        // $fact->fetch($data['fk_facture']);
                        $fact = $arrainvoics[$data['fk_facture']];
                    }

                    echo '<tr class="'.$classes[$var].'">';

                        echo '<td align="center" class="'.$boldcls.'" >'.dol_print_date($data['date'], 'day').'</td>';
                        if($data['fk_paiement']){
                            $colspan='colspan="'.($clsp+2).'"';
                        } 
                        echo '<td align="center" '.$colspan.' >';
                            echo $data['link'];
                            if($data['fk_paiement']){
                                // $objpaym = new Paiement($db);
                                // $objpaym->fetch($data['fk_paiement']);
                                // $labeltype = $langs->trans("PaymentType".$objpaym->type_code) != ("PaymentType".$objpaym->type_code) ? $langs->trans("PaymentType".$objpaym->type_code) : $objpaym->type_label;
                                $labeltype = $data['labeltype'];
                                echo ' - '.$labeltype;
                            }
                        echo '</td>';

                        if(empty($data['fk_paiement'])){
                            if($data['fk_facture']){
                                // $fact = new Facture($db);
                                // $fact->fetch($data['fk_facture']);
                                if($data_ef && count($data_ef)>0){
                                    foreach ($data_ef as $key => $value) {
                                        echo '<td align="center">';
                                            // echo $extrafields->showOutputField($value, $fact->array_options['options_'.$value], '', $object->table_element);
                                            echo $fact->array_options['options_'.$value];
                                        echo '</td>';
                                    }
                                }
                            }
                        }
                        if($data['lignes'] && count($data['lignes'])>0){
                            echo '<td class="lines_fact">';
                                foreach ($data['lignes'] as $key => $value) {
                                    $totalqtyprod[$value['type']] += $value['qty'];
                                    echo '<table class="border" >';
                                        echo '<tr>';
                                            if($data['fk_facture'] && $data['lignes'] && count($data['lignes'])>0){
                                                // $ligne = $data['lignes'][0]; 
                                                $ligne = $value; 
                                                echo '<td align="left" class="tdlabeltable">'.$ligne['label'].'</td>';
                                                echo '<td align="center" class="tdqtytable" >'.$ligne['qty'].'</td>';
                                                $totalqty+=$ligne['qty'];
                                                echo '<td align="right" class="tdamounttable">'.number_format($ligne['amount'], $aftercomma, ",", " ").'</td>';
                                            }else{
                                                echo '<td align="center"></td>';
                                                echo '<td align="center"></td>';
                                            }
                                            // if($data['fk_facture'] && empty($data['lignes']) && empty($data['fk_paiement'])) echo '<td align="center"></td>';
                                        echo '</tr>';
                                    echo '</table>';
                                }
                            echo '</td>';
                        }elseif(empty($data['fk_paiement'])) {
                            echo '<td></td>';   
                        }
                        // else echo '<td></td>';

                        echo '<td align="right">'.(empty($data['fk_paiement']) ? number_format(abs($data['amount']), $aftercomma, ",", " ") : '').'</td>';
                        echo '<td align="right">';
                        
                            if($data['fk_paiement']) {
                                $totalp=$data['amount'];
                            }
                            if($totalp)
                                echo number_format(abs($totalp), $aftercomma, ",", " ");
                            
                        echo '</td>';
                        $amountsold = ($balance < 0) ? (-1)*$balance : $balance;
                        $totalsoldbl = $amountsold;
                        if($l == count($TData)) $class = 'colorsold';
                        echo '<td class="colorsold" align="right" >'.number_format($amountsold, $aftercomma, ",", " ").'</td>';
                    echo '</tr>';

                    $totalDebit += empty($data['fk_paiement']) ? abs($data['amount']) : 0;
                    $totalCredit += $data['fk_paiement'] ? abs($data['amount']) : 0;
                }

                $totalgdebit    += $totalDebit;
                $totalgcredit   += $totalCredit;
                $totalgqty      += $totalqty;

                echo '<tr class="liste_total soustotal">';
                    echo '<td colspan="'.$colsptotal.'">'.$subtotaltext1.'</td>';
                    echo '<td class="lines_fact">';
                        echo '<table class="border" >';
                            echo '<tr class="liste_total soustotal">';
                                echo '<td class="tdlabeltable"></td>';
                                echo '<td class="tdqtytable" align="right">'.$totalqty.'</td>';
                                echo '<td class="tdamounttable"></td>';
                            echo '</tr>';
                        echo '</table>';
                    echo '</td>';
                    echo '<td align="right">'.number_format($totalDebit, $aftercomma, ",", " ").' '.$getcurrencysym.'</td>';
                    echo '<td align="right">'.number_format($totalCredit, $aftercomma, ",", " ").' '.$getcurrencysym.'</td>';
                    $minustoadd = ($totalgdebit-$totalgcredit) < 0 ? '-' : '';
                    echo '<td class="colorsold" align="right">'.number_format($amountsold, $aftercomma, ",", " ").' '.$getcurrencysym.'</td>';
                echo '</tr>';
            }

            if($TDataBE && count($TDataBE)>0 && $socid){
                $var = 1;
                // $lastbalance=0;
                $classes =[0=>'trnocolor', 1=>'trcolor'];
                $totalDebit     = 0;
                $totalCredit    = 0;
                $totalqty       = 0;
                $l = 0;
                $class = '';
                foreach ($TDataBE as $key => $data) {
                    $colspan = '';
                    $rowspan = '';
                    $var = !$var;
                    $totalp = 0;


                    if($key === 0){
                        if(!$TDataBE) $balance = $solde-$data['amount'];
                        else $balance = $lastbalance-$data['amount'];
                    }
                    else
                        $balance = $lastbalance - $data['amount'];

                    $lastbalance = $balance;

                    $l++;

                    if(empty($data['fk_paiement']) && $data['fk_facture']) {
                        // $fact = new Facture($db);
                        // $fact->fetch($data['fk_facture']);
                        $fact = $arrainvoics[$data['fk_facture']];
                    }

                    echo '<tr class="'.$classes[$var].'">';
                        echo '<td align="center">'.dol_print_date($data['date'], 'day').'</td>';
                        if($data['fk_paiement']){
                            $colspan='colspan="'.($clsp+2).'"';
                        } 

                        echo '<td align="center" '.$colspan.'>';
                            echo $data['link'];
                            if($data['fk_paiement']){
                                // $objpaym = new Paiement($db);
                                // $objpaym->fetch($data['fk_paiement']);
                                // $labeltype = $langs->trans("PaymentType".$objpaym->type_code) != ("PaymentType".$objpaym->type_code) ? $langs->trans("PaymentType".$objpaym->type_code) : $objpaym->type_label;
                                $labeltype = $data['labeltype'];
                                echo ' - '.$labeltype;
                            }
                        echo '</td>';

                        if(empty($data['fk_paiement'])){
                            if($data['fk_facture']){
                                // $fact = new Facture($db);
                                // $fact->fetch($data['fk_facture']);
                                if($data_ef && count($data_ef)>0){
                                    foreach ($data_ef as $key => $value) {
                                        // if($label && count($label)>0 && array_key_exists($value,$label)){
                                        if($label && count($label)>0 && isset($label[$value])){
                                            echo '<td align="center">';
                                                // echo $extrafields->showOutputField($value, $fact->array_options['options_'.$value], '', $object->table_element);
                                                echo $fact->array_options['options_'.$value];
                                            echo '</td>';
                                        }

                                    }
                                }
                            }
                        }

                        if($data['lignes'] && count($data['lignes'])>0){
                            echo '<td class="lines_fact">';
                                foreach ($data['lignes'] as $key => $ligne) {

                                    $totalqtyprod[$ligne['type']] += $ligne['qty'];
                                    echo '<table class="border" >';
                                        echo '<tr>';
                                            if($data['fk_facture']){
                                                // $ligne = $data['lignes'][0]; 
                                                echo '<td align="left" class="tdlabeltable">'.$ligne['label'].'</td>';
                                                echo '<td align="center" class="tdqtytable" >'.$ligne['qty'].'</td>';
                                                $totalqty+=$ligne['qty'];
                                                echo '<td align="right" class="tdamounttable">'.number_format($ligne['amount'], $aftercomma, ",", " ").'</td>';
                                            }else{
                                                echo '<td align="center"></td>';
                                                echo '<td align="center"></td>';
                                            }
                                        echo '</tr>';
                                    echo '</table>';
                                }
                            echo '</td>';
                        }elseif($data['fk_facture'] && empty($data['lignes']) && empty($data['fk_paiement'])) {
                            echo '<td></td>';   
                        }
                        echo '<td align="right">'.(empty($data['fk_paiement']) ? number_format(abs($data['amount']), $aftercomma, ",", " ") : '').'</td>';
                        echo '<td align="right">';
                        
                            if($data['fk_paiement']) {
                                $totalp=$data['amount'];
                            }
                          
                            if($totalp)
                                echo number_format(abs($totalp), $aftercomma, ",", " ");
                        echo '</td>';

                        $amountsold = ($balance < 0) ? (-1)*$balance : $balance;

                        $totalsoldbe = $amountsold;
                        if($l === count($TData)) $class = 'colorsold';
                        echo '<td class="colorsold" align="right">'.number_format($amountsold, $aftercomma, ",", " ").'</td>';
                    echo '</tr>';
                   
                    $totalDebit += empty($data['fk_paiement']) ? abs($data['amount']) : 0;
                    $totalCredit += $data['fk_paiement'] ? abs($data['amount']) : 0;
                }

                $totalgdebit    += $totalDebit;
                $totalgcredit   += $totalCredit;
                $totalgqty      += $totalqty;
                
                echo '<tr class="liste_total soustotal">';
                    echo '<td colspan="'.$colsptotal.'">'.$subtotaltext2.'</td>';
                    echo '<td class="lines_fact">';
                        echo '<table class="border" >';
                            echo '<tr class="liste_total soustotal">';
                                echo '<td class="tdlabeltable"></td>';
                                echo '<td class="tdqtytable" align="right">'.$totalqty.'</td>';
                                echo '<td class="tdamounttable"></td>';
                            echo '</tr>';
                        echo '</table>';
                    echo '</td>';
                    echo '<td align="right">'.number_format($totalDebit, $aftercomma, ",", " ").' '.$getcurrencysym.'</td>';
                    echo '<td align="right">'.number_format($totalCredit, $aftercomma, ",", " ").' '.$getcurrencysym.'</td>';
                    $minustoadd = ($totalgdebit-$totalgcredit) < 0 ? '-' : '';
                    echo '<td class="colorsold" align="right">'.number_format($amountsold, $aftercomma, ",", " ").' '.$getcurrencysym.'</td>';
                echo '</tr>';
            }

            if($TData){
                $totalsold = $totalsoldbl+$totalsoldbe;
                echo '<tr class="liste_total totalglobal">';
                    echo '<td colspan="'.$colsptotal.'">'.$langs->trans("Total").'</td>';

                     echo '<td class="lines_fact">';
                        echo '<table class="border" >';
                            echo '<tr class="liste_total totalglobal">';
                                echo '<td class="tdlabeltable"></td>';
                                echo '<td class="tdqtytable" align="right">'.$totalgqty.'</td>';
                                echo '<td class="tdamounttable"></td>';
                            echo '</tr>';
                        echo '</table>';
                    echo '</td>';

                    echo '<td align="right">'.number_format($totalgdebit, $aftercomma, ",", " ").' '.$getcurrencysym.'</td>';
                    echo '<td align="right">'.number_format($totalgcredit, $aftercomma, ",", " ").' '.$getcurrencysym.'</td>';
                    $minustoadd = ($totalgdebit-$totalgcredit) < 0 ? '-' : '';
                    echo '<td class="colorsold" align="right">'.$minustoadd.number_format($amountsold, $aftercomma, ",", " ").' '.$getcurrencysym.'</td>';
                echo '</tr>';
            }
            else{
                $clsptotal = $colsptotal+5;
                echo '<tr><td align="center" colspan="'.$clsptotal.'" >'.$langs->trans("NoRecordFound").'</td></tr>';
            }
        echo '</table>';
    echo '</form>';

    echo '<br><br>';
echo  '</div>';


if($socid){
    echo '<div class="splitqty">';
        echo '<table class="noborder" width="100%">';
            echo '<tr><th class="center" colspan="2">'.$langs->trans("qtyfacture").' ('.$totalgqty.')</th></tr>';
            echo '<tr style="background: #f4f4f4 !important;">';
                echo '<td class="center">'.$langs->trans("Products").'</td>';
                echo '<td class="center">'.$langs->trans("Services").'</td>';
            echo '</tr>';
            if($totalqtyprod && count($totalqtyprod)>0){
                echo '<tr>';
                    echo '<td class="center">'.($totalqtyprod[0] ? $totalqtyprod[0] : 0).'</td>';
                    echo '<td class="center">'.($totalqtyprod[1] ? $totalqtyprod[1] : 0).'</td>';
                echo '</tr>';
            }
        echo '</table>';
    echo '</div>';
    echo '<br>';
    echo '<div class="fichecenter" id="qtybycatg">';
        echo '<div class="fichehalfleft">';
            echo '<table class="noborder" width="100%">';
                echo '<tr><th class="center" colspan="3">'.$langs->trans("qtyprod_by_tag").'</th></tr>';
                echo '<tr style="background: #f4f4f4 !important;">';
                    echo '<td class="center">'.$langs->trans("Category").'</td>';
                    echo '<td class="center">'.$langs->trans("Quantity").'</td>';
                    echo '<td class="center">'.$langs->trans("Montant_Total").'</td>';
                echo '</tr>';
                if($qtyprod_by_tag[0] && count($qtyprod_by_tag[0])>0){
                    $totalqty=0;
                    $total_amount=0;
                    foreach ($qtyprod_by_tag[0] as $key => $value) {
                        echo '<tr>';
                            echo '<td class="left">'.$value['label'].'</td>';
                            echo '<td class="center">'.($value['nb'] ? $value['nb'] : 0).'</td>';
                            echo '<td class="right">'.($value['totalfact'] ? number_format($value['totalfact'], $aftercomma, ",", " ") : 0).' '.$getcurrencysym.'</td>';
                        echo '</tr>';
                        $totalqty+=$value['nb'];
                        $total_amount+=$value['totalfact'];
                    }
                    $indefin = $qtyprod_by_tag[0][0];
                    if($indefin['nb']>0){
                        echo '<tr>';
                            echo '<td class="left">'.$langs->trans('indefin').'</td>';
                            echo '<td class="center">'.($indefin['nb'] ? $indefin['nb'] : 0).'</td>';
                            echo '<td class="right">'.($indefin['totalfact'] ? number_format($value['totalfact'], $aftercomma, ",", " ") : 0).' '.$getcurrencysym.'</td>';
                        echo '</tr>';
                        $totalqty+=$indefin['nb'];
                        $total_amount+=$indefin['totalfact'];
                    }
                }
                echo '<tr>';
                    echo '<td style="font-weight:600" class="left">'.$langs->trans("total").'</td>';
                    echo '<td style="font-weight:600" class="center">'.$totalqty.'</td>';
                    echo '<td style="font-weight:600" class="right">'.number_format($total_amount, $aftercomma, ",", " ").' '.$getcurrencysym.'</td>';
                echo '</tr>';
            echo '</table>';
        echo '</div>';
        echo '<div class="fichehalfright">';
            echo '<table class="noborder" width="100%">';
                echo '<tr><th class="center" colspan="3">'.$langs->trans("qtyservic_by_tag").'</th></tr>';
                echo '<tr style="background: #f4f4f4 !important;">';
                    echo '<td class="center">'.$langs->trans("Category").'</td>';
                    echo '<td class="center">'.$langs->trans("Quantity").'</td>';
                    echo '<td class="center">'.$langs->trans("Montant_Total").'</td>';
                echo '</tr>';
                $totalqty=0;
                $total_amount=0;
                if($qtyprod_by_tag[1] && count($qtyprod_by_tag[1])>0){
                    foreach ($qtyprod_by_tag[1] as $key => $value) {
                        if($key != 0){
                            echo '<tr>';
                                echo '<td class="left">'.$value['label'].'</td>';
                                echo '<td class="center">'.($value['nb'] ? $value['nb'] : 0).'</td>';
                                echo '<td class="right">'.($value['totalfact'] ? $value['totalfact'] : 0).' '.$getcurrencysym.'</td>';
                            echo '</tr>';
                            $totalqty+=$value['nb'];
                            $total_amount+=$value['totalfact'];
                        }
                    }
                    $indefin = $qtyprod_by_tag[1][0];
                    if($indefin['nb']>0){
                        echo '<tr>';
                            echo '<td class="left">'.$langs->trans('indefin').'</td>';
                            echo '<td class="center">'.($indefin['nb'] ? $indefin['nb'] : 0).'</td>';
                            echo '<td class="right">'.($indefin['totalfact'] ? $indefin['totalfact'] : 0).' '.$getcurrencysym.'</td>';
                        echo '</tr>';
                        $totalqty+=$indefin['nb'];
                        $total_amount+=$indefin['totalfact'];
                    }
                }
                echo '<tr>';
                    echo '<td style="font-weight:600" class="left">'.$langs->trans("total").'</td>';
                    echo '<td style="font-weight:600" class="center">'.$totalqty.'</td>';
                    echo '<td style="font-weight:600" class="right">'.number_format($total_amount, $aftercomma, ",", " ").' '.$getcurrencysym.'</td>';
                echo '</tr>';
            echo '</table>';
        echo '</div>';
    echo '</div>';
}

dol_fiche_end();

llxFooter();
$db->close();
