<?php 

$res=0;
if (! $res && file_exists("../main.inc.php")) $res=@include("../main.inc.php");       // For root directory
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php"); // For "custom" 

global $conf;
if (!$conf->releveclient->enabled) {
  accessforbidden();
}
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
require_once DOL_DOCUMENT_ROOT.'/categories/class/categorie.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture-rec.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/modules/facture/modules_facture.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/discount.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/invoice.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/accountancy/class/accountingjournal.class.php';


dol_include_once("/releveclient/class/releveclient.class.php");
dol_include_once("/releveclient/lib/releveclient.lib.php");

$form = new Form($db);
$userstatic = new User($db);
$releveclient = new releveclient($db);
$object    = new Facture($db);
$client    = new Societe($db);
$paiement = new Paiement($db);
$extrafields = new ExtraFields($db);


$releveclient->upgradeModulereleveclient();

$langs->loadLangs(array('bills', 'companies', 'compta', 'products', 'banks', 'main', 'withdrawals'));
$modname = $langs->trans("releve_general");

$facid = (GETPOST('id', 'int') ?GETPOST('id', 'int') : GETPOST('facid', 'int')); // For backward compatibility
$ref = GETPOST('ref', 'alpha');
$fk_reglement = GETPOST('fk_reglement', 'int');
$action = GETPOST('action', 'alpha');
$actionpdf = GETPOST('actionpdf', 'alpha');
$exportxsl = GETPOST('exportxsl', 'alpha');
$socid=GETPOST('socid');

$srch_qty=GETPOST('srch_qty');

$actionexport = $actionpdf ? 1 : ($exportxsl ? 1 : 0);
$debut = dol_mktime(0, 0, 0, GETPOST('debutmonth'), GETPOST('debutday'), GETPOST('debutyear'));
$fin = dol_mktime(0, 0, 0, GETPOST('finmonth'), GETPOST('finday'), GETPOST('finyear'));
$debut = $debut ? $db->idate($debut) : '';
$fin = $fin ? $db->idate($fin) : '';


if(empty($debut) && GETPOST('debut')) $debut=GETPOST('debut');

if(empty($fin) && GETPOST('fin')) $fin=GETPOST('fin');

   
$object = new Account($db);
$societe = new Societe($db);
if($socid) $societe->fetch($socid);

$fk_account = GETPOST('fk_account');
$object->fetch($fk_account); 

$srch_datec = dol_mktime(0, 0, 0, GETPOST('srch_datecmonth'), GETPOST('srch_datecday'), GETPOST('srch_datecyear'));
// $limit = GETPOST('limit', 'int') ?GETPOST('limit', 'int') : $conf->liste_limit;
$limit = GETPOST('limit', 'int') ?GETPOST('limit', 'int') : 20;
$sortfield = GETPOST('sortfield', 'alpha') ? GETPOST('sortfield', 'alpha') : 'f.datef';
$sortorder = GETPOST('sortorder', 'alpha') ? GETPOST('sortorder', 'alpha') : 'ASC';
$page = GETPOSTISSET('pageplusone') ? (GETPOST('pageplusone') - 1) : GETPOST('page', 'int');
if (empty($page) || $page === -1 || !empty($search_btn) || !empty($search_remove_btn) || (empty($toselect) && $massaction === '0')) { $page = 0; }     

$offset = $limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$filter='';
$solde=0;
if (GETPOST('button_removefilter_x') || GETPOST('button_removefilter') || $page < 0) {
    $filter = '';
    $offset = 0;
    $filter = '';
}
if($socid && $debut && $fin) $solde = $releveclient->SoldeDebiteur($socid,$debut,$fin,$societe);

$i=0;
$qtyprod_by_tag = array();

$TData = array();
$sql = 'SELECT s.nom, s.rowid as socid, f.ref, f.total_ttc, f.datef as df,';
    $sql .= ' f.fk_statut as statut, f.rowid as facid FROM '.MAIN_DB_PREFIX.'societe as s';
if($societe->fournisseur && $societe->client != Societe::CUSTOMER){
    $sql .= ', '.MAIN_DB_PREFIX.'facture_fourn as f';
}else{
    $sql .= ', '.MAIN_DB_PREFIX.'facture as f';
}
$sql .= ' WHERE f.fk_soc = s.rowid AND s.rowid = '.$socid;
$sql .= ' AND f.entity IN ('.getEntity('invoice').')';

if($debut && $fin) $sql .= ' AND (CAST(f.datef as date) BETWEEN "'.$debut.'" AND "'.$fin.'")';
elseif($debut && empty($fin)) $sql .= ' AND CAST(f.datef as date) >= "'.$debut.'"';
elseif($fin && empty($debut)) $sql .= ' AND CAST(f.datef as date) <= "'.$fin.'"';

$sql .= $db->order($sortfield, $sortorder);

if(empty($actionexport)){
    $nbtotalofrecords = '';
    if (empty($conf->global->MAIN_DISABLE_FULL_SCANLIST))
    {
        $result = $db->query($sql);
        $nbtotalofrecords = $db->num_rows($result);
        if (($page * $limit) > $nbtotalofrecords)   // if total resultset is smaller then paging size (filtering), goto and load page 0
        {
            $page = 0;
            $offset = 0;
        }
    }

    $sql .= $db->plimit($limit + 1, $offset);
}

$arrpayement = [];
$resql = $db->query($sql);
$factsid = '';

$arrainvoics = array();

$urlpayement    = ($societe->fournisseur && $societe->client != Societe::CUSTOMER) ? DOL_URL_ROOT.'/fourn/paiement/card.php?id=' : DOL_URL_ROOT.'/compta/paiement/card.php?id='; 
$urlfacture     = ($societe->fournisseur && $societe->client != Societe::CUSTOMER) ? DOL_URL_ROOT.'/fourn/facture/card.php?facid=' : DOL_URL_ROOT.'/compta/facture/card.php?facid=';

$classfact = 'Facture';
$classpaiment = 'Paiement';

if($societe->fournisseur && $societe->client != Societe::CUSTOMER){
    $classfact = 'FactureFournisseur';
    $classpaiment = 'PaiementFourn';
}

$urlproduct     = DOL_URL_ROOT.'/product/card.php?id=';

$pictopayement = img_picto('', 'payment').' ';
$pictofacture = img_picto('', 'bill').' ';
$pictoproduct = img_picto('', 'product').' ';

if ($resql)
{
    $num = $db->num_rows($resql);

    // Boucle sur chaque facture
    for ($i = 0; $i < $num; $i++)
    {
        $objf = $db->fetch_object($resql);

        $fac =  new $classfact($db);
        $ret = $fac->fetch($objf->facid);
        if($i === 0) $factsid .= $objf->facid;
        else $factsid .= ','.$objf->facid;

        if ($ret < 0) continue;

        $arrainvoics[$objf->facid] = $fac;

        $userstatic->id = $objf->userid;
        $userstatic->login = $objf->login;


        $faclink = $objf->ref;
        if(empty($actionexport)){
            $faclink = '<a href="'.$urlfacture.$objf->facid.'">';
            $faclink .= $pictofacture.$objf->ref;
            $faclink .= '</a>';
        }

        $values = array(
            'fk_facture' => $objf->facid,
            'date'       => $fac->date,
            'link'       => $faclink,
            'amount'     => $fac->total_ttc,
            'lignes'     => $dtlignes,
            'be1'        => $fac->array_options['options_be1'],
            'bl1'        => $fac->array_options['options_bl1'],
            'datefieldforsort' => $fac->date.'-'.$fac->ref,
        );
        $TData[] = $values;

    }

    $db->free($resql);

    // Paiements
    $sql = 'SELECT p.rowid,c.code as type_code, c.libelle as type_label, p.ref as refpayement, p.datep as dp, SUM(pf.amount) as amount, p.statut';

    if($societe->fournisseur && $societe->client != Societe::CUSTOMER){

        $sql .= ', pf.fk_paiementfourn, pf.fk_facturefourn as fk_fact';
        $sql .= ' FROM  '.MAIN_DB_PREFIX.'paiementfourn as p';
        $sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'paiementfourn_facturefourn as pf ON pf.fk_paiementfourn = p.rowid';
        $sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'c_paiement as c ON p.fk_paiement = c.id';
        // $sql .= ' WHERE pf.fk_paiement = p.rowid';
        $sql .= ' WHERE p.entity = '.$conf->entity;
        // $sql .= ' AND pf.fk_facture IN ('.$factsid.')';
        $sql .= ' AND pf.fk_facturefourn IN (SELECT f.rowid FROM '.MAIN_DB_PREFIX.'facture_fourn as f WHERE f.entity IN ('.getEntity('invoice').') AND f.fk_soc = '.$socid;
       
            if($debut && $fin) $sql .= ' AND (CAST(p.datep as date) BETWEEN "'.$debut.'" AND "'.$fin.'")';
            elseif($debut && empty($fin)) $sql .= ' AND CAST(p.datep as date) >= "'.$debut.'"';
            elseif($fin && empty($debut)) $sql .= ' AND CAST(p.datep as date) <= "'.$fin.'"';

        $sql .= ')';
    }
    elseif($societe->client)
    {
        $sql .= ', pf.fk_paiement, pf.fk_facture as fk_fact';
        $sql .= ' FROM  '.MAIN_DB_PREFIX.'paiement as p';
        $sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'paiement_facture as pf ON pf.fk_paiement = p.rowid';
        $sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'c_paiement as c ON p.fk_paiement = c.id';
        // $sql .= ' WHERE pf.fk_paiement = p.rowid';
        $sql .= ' WHERE p.entity = '.$conf->entity;
        // $sql .= ' AND pf.fk_facture IN ('.$factsid.')';
        $sql .= ' AND pf.fk_facture IN (SELECT f.rowid FROM '.MAIN_DB_PREFIX.'facture as f WHERE f.entity IN ('.getEntity('invoice').') AND f.fk_soc = '.$socid;
       
            if($debut && $fin) $sql .= ' AND (CAST(p.datep as date) BETWEEN "'.$debut.'" AND "'.$fin.'")';
            elseif($debut && empty($fin)) $sql .= ' AND CAST(p.datep as date) >= "'.$debut.'"';
            elseif($fin && empty($debut)) $sql .= ' AND CAST(p.datep as date) <= "'.$fin.'"';

        $sql .= ')';
    }


    $sql .= ' GROUP BY p.rowid';
    $sql .= ' ORDER BY p.datep ASC, p.rowid ASC';

    $resqlp = $db->query($sql);
    if ($resqlp)
    {
        $nump = $db->num_rows($resqlp);
        $j = 0;

        while ($j < $nump)
        {
            $objp = $db->fetch_object($resqlp);

            $fac = $arrainvoics[$objp->fk_fact];

            $paylink = $objp->refpayement;
            if(empty($actionexport)){
                $paylink = '<a href="'.$urlpayement.$objp->rowid.'">';
                $paylink .= $pictopayement.$objp->refpayement;
                $paylink .= '</a>';
            }
            $labeltype = $langs->trans("PaymentType".$objp->type_code) != ("PaymentType".$objp->type_code) ? $langs->trans("PaymentType".$objp->type_code) : $objp->type_label;
            $values = array(
                'fk_paiement' => $objp->rowid,                           
                'fk_facture' => $objp->fk_fact,
                'date' => $db->jdate($objp->dp),
                'datefieldforsort' => $db->jdate($objp->dp).'-'.$fac->ref,
                'link' => $paylink ,
                'labeltype' => $labeltype ,
                'amount' => $objp->amount,
            );
            $TData[] = $values;

            $j++;
        }

        $db->free($resqlp);
    }
}

$TDataBL = array();
$TDataBE = array();
$totalqtyprod = array();
if (!empty($TData)) {
    
    $TData = dol_sort_array($TData, 'datefieldforsort', $sortorder);

    $totalDebit = 0;
    $totalCredit = 0;
}

if ($limit > 0 && $limit != $conf->liste_limit) $param .= '&limit='.urlencode($limit);
if ($socid) $param .= '&socid='.urlencode($socid);
if ($debut) $param .= '&debut='.urlencode($debut);
if ($fin) $param .= '&fin='.urlencode($fin);



if (!$user->rights->releveclient->lire || !$user->rights->releveclient->export) {
    accessforbidden();
}

$getcurrencysym = $langs->getCurrencySymbol($conf->currency);

$aftercomma = intval($conf->global->RELEVECLIENT_NUMBER_OF_DIGITS_AFTER_THE_DECIMAL_POINT);
$subtotaltext1 = ($conf->global->RELEVECLIENT_FIRST_SUB_TOTAL_TEXT) ? $conf->global->RELEVECLIENT_FIRST_SUB_TOTAL_TEXT : $langs->trans("totalbl1");
$subtotaltext2 = ($conf->global->RELEVECLIENT_SECOND_SUB_TOTAL_TEXT) ? $conf->global->RELEVECLIENT_SECOND_SUB_TOTAL_TEXT : $langs->trans("totalbe1");


/*-------------PDF-----------------*/

$Client = new Societe($db);
$filename = html_entity_decode($langs->trans('releve_general'));
if($socid) {
    $Client->fetch($socid);
    $filename = $Client->name.' - '.html_entity_decode($langs->trans('releve_general'));
}
if($exportxsl){
    require_once dol_buildpath('/releveclient/pdf/releve_global_pdf.php');

    header("Content-Type: application/xls");
    header("Content-Disposition: attachment; filename=".$filename.".xls");
    echo($html);
    die();

}
if ($actionpdf) {
    

    require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
    require_once dol_buildpath('/releveclient/pdf/pdf.lib.php');
    // $pdf->SetMargins(7, 2, 7, false);
    // $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetMargins(7, PDF_MARGIN_TOP, 7);
    $pdf->SetFooterMargin(15);
    $pdf->setPrintFooter(true);
    $pdf->SetAutoPageBreak(TRUE,15);
    $height=$pdf->getPageHeight();

    $pdf->SetFont('helvetica', '', 9, '', true);
    $pdf->AddPage('P');
    $margint = $pdf->getMargins()['top'];
    $marginb = $pdf->getMargins()['bottom'];
    $marginl = $pdf->getMargins()['left'];
    $marginr = $pdf->getMargins()['right'];


    $formatarray = pdf_getFormat();
    $page_largeur = $formatarray['width'];

    $pdf->SetTextColor(0, 0, 60);

    $default_font_size = 9;
    $pdf->SetFont('', 'B', $default_font_size);
    $posy   = $margint;
    $posx   = $pdf->page_largeur-$pdf->getMargins()['right']-100;

    $pdf->SetXY($marginl, $posy);
    $height = 0;
    $pdf->SetFont('freeserif', '', 10);
    if ($mysoc && $mysoc->logo)
    {
        $logodir = $conf->mycompany->dir_output;
        if (empty($conf->global->MAIN_PDF_USE_LARGE_LOGO))
        {
            $logo = $logodir.'/logos/thumbs/'.$mysoc->logo_small;
        }
        else {
            $logo = $logodir.'/logos/'.$mysoc->logo;
        }
        
        if (is_readable($logo))
        {
            $maxWidth = ($page_largeur - $marginl - $marginr) / 2;
            // $height = pdf_getHeightForLogo($logo);
            $height = max(pdf_getRelveHeightForLogo($logo, true, $maxWidth), 30);
            $pdf->Image($logo, $marginl, $posy, 0, $height); // width=0 (auto)
        }
        else
        {
            $pdf->SetTextColor(200, 0, 0);
            $pdf->SetFont('freeserif', 'B', $default_font_size - 2);
            $pdf->MultiCell(50, 3, $langs->transnoentities('ErrorLogoFileNotFound', $logo), 0, 'L');
            $pdf->MultiCell(50, 3, $langs->transnoentities('ErrorGoToGlobalSetup'), 0, 'L');
        }
    }
    else
    {
        $heightimg = 8;
        $text = $mysoc->name;
        $pdf->MultiCell(50, 4, $langs->convToOutputCharset($text), 0, 'L');
        $height = $pdf->GetY()-$margint;
    }

 
    $posx = $page_largeur - $marginr-60;

    $address = $Client->address;
    $address .= ($address && $Client->town) ? ', '.$Client->town : $Client->town;
    $address .= ($address && $Client->country) ? ', '.$Client->country : $Client->country;

    if($Client->nom){

        $nomtier = ($Client->Client ? $langs->trans('NameClient') : $langs->trans('NameSupplier')).': '.$Client->nom;
        $pdf->SetFont('', 'B', $default_font_size);
        $pdf->SetXY($posx, $posy);
        $pdf->SetTextColor(0, 0, 60);
        $pdf->MultiCell(50, 3, $nomtier, '', 'R');
    }

    if($Client->address){
        $posy = $pdf->GetY();
        $phone = $Client->phone;
        $pdf->SetXY($posx, $posy+2);
        $pdf->MultiCell(50, 3, $address, '', 'R');
    }
    if($Client->phone){
        $posy = $pdf->GetY();
        $phone = $Client->phone;
        $pdf->SetXY($posx, $posy+2);
        $pdf->MultiCell(50, 3, $phone, '', 'R');
    }
    if($Client->tva_intra)
    {
        $posy = $pdf->GetY();
        $tva = $langs->trans('VATIntra').': '.$Client->tva_intra;
        $pdf->SetXY($posx, $posy+2);
        $pdf->MultiCell(50, 3, $tva, '', 'R');
    }
    

    $posy = $margint + $height + 2;

    $text = $conf->global->MAIN_INFO_SOCIETE_ADDRESS;
    $company = $conf->global->MAIN_INFO_SOCIETE_COUNTRY;
    $text .= $text ? ', '.$conf->global->MAIN_INFO_SOCIETE_TOWN : $conf->global->MAIN_INFO_SOCIETE_TOWN;
    if($company){
        $company=explode(':', $company);
        $text .= $text ? ', '.$company[2] : $company[2];
    }
    $text .= $text ? '<br>'.$conf->global->MAIN_INFO_SOCIETE_TEL : $conf->global->MAIN_INFO_SOCIETE_TEL;
    $text .= $text ? '<br>'.$conf->global->MAIN_INFO_TVAINTRA : $conf->global->MAIN_INFO_TVAINTRA;
    $pdf->MultiCell(50, 4, $langs->convToOutputCharset($text), 0, 'L', false, 1 , $marginl, $posy, true, 0, true);
    // $posy = $margint + $height + 2;


    $pdf->SetTextColor(0, 0, 60);

    $pdf->SetFont('freeserif', '', 9);

    require_once dol_buildpath('/releveclient/pdf/pdf.lib.php');
    require_once dol_buildpath('/releveclient/pdf/releve_global_pdf.php');
    $pdf->writeHTML($html, true, false, true, false, '');
    ob_start();
    $db->close();
    $pdf->Output($filename.'.pdf', 'I');
    die();
}


$morejs  = array();
llxHeader(array(), $modname,'','','','',$morejs,0,0);

echo load_fiche_titre($modname);

echo '<div id="stclient" class="div-table-responsive">';
    echo '<form  method="POST" action="'.$_SERVER['PHP_SELF'].'" >';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        echo '<table class="noborder">';
            echo '<input type="hidden" name="action" value="generer">';
            echo '<tr>';
                echo '<td colspan="3">'.$langs->trans('Period');
                    echo ' &nbsp;&nbsp;&nbsp;&nbsp;'.$langs->trans("From").' '.$form->selectDate($debut, 'debut', 0, 0, 1, '', 1, 1);
                    echo '&nbsp;&nbsp;';
                    echo $langs->trans("To").' '.$form->selectDate($fin, 'fin', 0, 0, 1, '', 1, 1);
                echo '</td>';
            echo '</tr>'; 
            echo '<tr>';
                echo '<td>'.$langs->trans('Customer');
                    echo $form->select_company($socid, 'socid', '((s.client = 1 OR s.client = 3 OR s.fournisseur = 1) AND s.status=1)', 'SelectThirdParty', 0, 0, null, 0, 'minwidth300');

                    // Option to reload page to retrieve customer informations. Note, this clear other input
                    if (!empty($conf->global->RELOAD_PAGE_ON_CUSTOMER_CHANGE))
                    {
                        echo '<script type="text/javascript">
                            $(document).ready(function() {
                                $("#socid").change(function() {
                                    var socid = $(this).val();
                                    var fac_rec = $(\'#fac_rec\').val();
                                    // reload page
                                    window.location.href = "'.$_SERVER["PHP_SELF"].'?action=create&socid="+socid+"&fac_rec="+fac_rec;
                                });
                            });
                        </script>';
                    }
                    if (!GETPOST('fac_rec', 'int')) 
                        echo ' <a href="'.DOL_URL_ROOT.'/societe/card.php?action=create&client=3&fournisseur=0&backtopage='.urlencode($_SERVER["PHP_SELF"].'?action=create').'"><span class="fa fa-plus-circle valignmiddle paddingleft" title="'.$langs->trans("AddThirdParty").'"></span></a>';
                echo '</td><td>';
                    if($socid && $debut && $fin){
                        $datesd=date('d/m/Y', strtotime($debut.' - 1 DAY'));
                        $text = $langs->trans("soldedebitair").' '.$datesd.':  '.price($solde, 0, $langs, 1, $aftercomma).' '.$getcurrencysym;
                        echo $text;
                    }
                echo '</td><td>';
                    echo '<a href="'.dol_buildpath('/releveclient/releve_global.php',2).'" class="butAction" style="padding-top: 0.4em; float:right">'.$langs->trans("Reset").'</a>';
                    echo '<input style="margin-top:0px; float:right" type="submit" value="'.$langs->trans("generetat").'" name="exportpdf" class="button" />';
                echo '</td>';
            echo '</tr>'."\n";
        echo '</table>';
    echo '</form>';
        
    echo '<br>';
    
    echo '<form  method="POST" action="'.$_SERVER['PHP_SELF'].'">';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        echo '<input type="hidden" name="fk_account" value="'.$fk_account.'">';
        echo '<input type="hidden" name="socid" value="'.$socid.'">';
        echo '<input type="hidden" name="debut" value="'.$debut.'">';
        echo '<input type="hidden" name="fin" value="'.$fin.'">';
        echo '<input name="pagem" type="hidden" value="'.$page.'">';
        echo '<input name="offsetm" type="hidden" value="'.$offset.'">';
        echo '<input name="limitm" type="hidden" value="'.$limit.'">';
        echo '<input name="filterm" type="hidden" value="'.$filter.'">';
        echo '<input name="action" type="hidden" value="pdf">';

        $object = new Facture($db);
        // $dt_extrafield = $extrafields->fetch_name_optionals_label($object->table_element);
        // $label=$extrafields->attributes[$object->table_element]['label'];

        // if(dolibarr_get_const($db, strtoupper('releveclient_fields'),$conf->entity)){
        //     $data_ef = dolibarr_get_const($db, strtoupper('releveclient_fields'),$conf->entity);
        //     $data_ef = explode(',', $data_ef);
        // }

        $massactionbutton = '';
        $massactionbutton .= '<input name="actionpdf" type="submit" id="btn_pdf" formtarget="_blank" class="butAction" value="'.$langs->trans('generpdf').'" >';
        $massactionbutton.= '<input type="submit" value="'.$langs->trans("generxsl").'" name="exportxsl" class="butAction" />';

        print_barre_liste('', $page, $_SERVER["PHP_SELF"], $param, $sortfield, $sortorder, '', $num, $nbtotalofrecords, '', 0, $massactionbutton, '', $limit, 0, 0, 1);

        echo '<table class="noborder" id="releveclient">';
            $clsp=0;
            echo '<tr class="liste_titre_filter">';
                print_liste_field_titre($langs->trans("Label"), $_SERVER["PHP_SELF"], "", '', $param, 'align="left" ', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("Date"), $_SERVER["PHP_SELF"], "f.datef", '', $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("Charge"), $_SERVER["PHP_SELF"], "", "", $param, 'align="rignt"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("Credit"), $_SERVER["PHP_SELF"], "", "", $param, 'align="rignt"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("Balance"), $_SERVER["PHP_SELF"], "", "", $param, 'align="rignt"', $sortfield, $sortorder);
            echo '</tr>';
            $colsptotal = 2+$clsp;

            $totalgdebit    = 0;
            $totalgcredit   = 0;
            $totalgqty      = 0;
            $lastbalance    = $solde;
            if($TData && count($TData)>0 && $socid){
                $var = 1;
                $classes =[0=>'trnocolor', 1=>'trcolor'];
                $totalDebit     = 0;
                $totalCredit    = 0;
                $totalqty       = 0;

                $l = 0;
                $class = '';
                foreach ($TData as $key => $data) {
                    $colspan = '';
                    $rowspan = '';
                    $var = !$var;
                    $totalp = 0;
                    
                    if($key === 0){
                        $dt_amount = empty($data['fk_paiement']) ? $data['amount'] : (-1)*$data['amount'];
                        $balance = $solde+$dt_amount;
                    }
                    else{
                        $dt_amount = empty($data['fk_paiement']) ? $data['amount'] : (-1)*$data['amount'];
                        $balance = $lastbalance+$dt_amount;
                    }

                    $lastbalance = $balance;
                    $l++;

                    $boldcls = '';
                    if(empty($data['fk_paiement']) && $data['fk_facture']) {
                        $boldcls = 'boldtext';
                        // $fact = new Facture($db);
                        // $fact->fetch($data['fk_facture']);
                        $fact = $arrainvoics[$data['fk_facture']];
                    }

                    echo '<tr class="'.$classes[$var].'">';

                        echo '<td align="left" >';
                            echo $data['link'];
                            if($data['fk_paiement']){
                                // $objpaym = new Paiement($db);
                                // $objpaym->fetch($data['fk_paiement']);
                                // $labeltype = $langs->trans("PaymentType".$objpaym->type_code) != ("PaymentType".$objpaym->type_code) ? $langs->trans("PaymentType".$objpaym->type_code) : $objpaym->type_label;
                                $labeltype = $data['labeltype'];
                                echo ' - '.$labeltype;
                            }
                        echo '</td>';

                        echo '<td align="center" class="'.$boldcls.'" >';
                            print dol_print_date($data['date'], 'day');
                        echo '</td>';

                        echo '<td align="right">'.((empty($data['fk_paiement'])) ? price($data['amount'], 0, $langs, 1, $aftercomma) : '').'</td>';
                        echo '<td align="right">';
                        
                            if($data['fk_paiement']) {
                                $totalp=$data['amount'];
                            }
                            if($totalp)
                                echo price($totalp);
                            
                        echo '</td>';
                        // $amountsold = ($balance < 0) ? (-1)*$balance : $balance;
                        $amountsold = $balance;
                        $totalsoldbl = $amountsold;
                        if($l == count($TData)) $class = 'colorsold';
                        echo '<td class="colorsold" align="right" >'.price($amountsold, 0, $langs, 1, $aftercomma).'</td>';
                    echo '</tr>';

                    $totalDebit += empty($data['fk_paiement']) ? $data['amount'] : 0;
                    $totalCredit += $data['fk_paiement'] ? $data['amount'] : 0;
                }

                $totalgdebit    += $totalDebit;
                $totalgcredit   += $totalCredit;
                $totalgqty      += $totalqty;

            }
          
            if($TData){
                $totalsold = $totalsoldbl+$totalsoldbe;
                echo '<tr class="liste_total totalglobal">';
                    echo '<td colspan="'.$colsptotal.'">'.$langs->trans("Total").'</td>';
                    echo '<td align="right">'.price($totalDebit, 0, $langs, 1, $aftercomma).' '.$getcurrencysym.'</td>';
                    echo '<td align="right">'.price($totalCredit, 0, $langs, 1, $aftercomma).' '.$getcurrencysym.'</td>';
                    // $minustoadd = ($totalDebit-$totalCredit) < 0 ? '-' : '';
                    $minustoadd='';
                    echo '<td class="colorsold" align="right">'.$minustoadd.price($amountsold, 0, $langs, 1, $aftercomma).' '.$getcurrencysym.'</td>';
                echo '</tr>';
            }
            else{
                $clsptotal = $colsptotal+5;
                echo '<tr><td align="center" colspan="'.$clsptotal.'" >'.$langs->trans("NoRecordFound").'</td></tr>';
            }
        echo '</table>';
    echo '</form>';

    echo '<br><br>';
echo  '</div>';

dol_fiche_end();

llxFooter();
$db->close();
