<?php 

$res=0;
if (! $res && file_exists("../main.inc.php")) $res=@include("../main.inc.php");       // For root directory
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php"); // For "custom" 

global $conf;
if (!$conf->releveclient->enabled) {
  accessforbidden();
}
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture-rec.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/modules/facture/modules_facture.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/discount.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/invoice.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/accountancy/class/accountingjournal.class.php';


dol_include_once("/releveclient/class/releveclient.class.php");

$form = new Form($db);

$userstatic = new User($db);
$releve = new releveclient($db);
$extrafields = new ExtraFields($db);
$object = new Societe($db);

$nb_field=0;
$extrafields->fetch_name_optionals_label($object->table_element);
if($extrafields->attributes[$object->table_element]['label']){
    foreach ($extrafields->attributes[$object->table_element]['label'] as $key => $value) {
        if($extrafields->attributes[$object->table_element]['list'][$key] == 2 || $extrafields->attributes[$object->table_element]['list'][$key] == 1 || $extrafields->attributes[$object->table_element]['list'][$key] == 4){
            $nb_field++;
        }
    }
}
$nbtotal = 6+$nb_field;

$langs->loadLangs(array('bills', 'companies', 'compta', 'products', 'banks', 'main', 'withdrawals'));
$modname = $langs->trans("dettefourn");

$facid = (GETPOST('id', 'int') ?GETPOST('id', 'int') : GETPOST('facid', 'int')); // For backward compatibility
$ref = GETPOST('ref', 'alpha');
$fk_reglement = GETPOST('fk_reglement', 'int');
$action = GETPOST('action', 'alpha');
$socid=GETPOST('socid');

$srch_qty=GETPOST('srch_qty');

$debut = dol_mktime(0, 0, 0, GETPOST('debutmonth'), GETPOST('debutday'), GETPOST('debutyear'));
$fin = dol_mktime(0, 0, 0, GETPOST('finmonth'), GETPOST('finday'), GETPOST('finyear'));
$debut = $debut ? $db->idate($debut) : '';
$fin = $fin ? $db->idate($fin) : '';

if(empty($debut) && GETPOST('debut'))
    $debut=GETPOST('debut');

if(empty($fin) && GETPOST('fin'))
    $fin=GETPOST('fin');
   
$srch_dette=GETPOST('srch_dette');

$srch_datec = dol_mktime(0, 0, 0, GETPOST('srch_datecmonth'), GETPOST('srch_datecday'), GETPOST('srch_datecyear'));
$limit = GETPOST('limit', 'int') ?GETPOST('limit', 'int') : $conf->liste_limit;
$sortfield = GETPOST("sortfield", 'alpha') ? GETPOST("sortfield", 'alpha') : 's.rowid';
$sortorder = GETPOST("sortorder", 'alpha') ? GETPOST("sortorder", 'alpha') : 'DESC';
$page = GETPOSTISSET('pageplusone') ? (GETPOST('pageplusone') - 1) : GETPOST("page", 'int');
if (empty($page) || $page == -1 || !empty($search_btn) || !empty($search_remove_btn) || (empty($toselect) && $massaction === '0')) { $page = 0; }     

$offset = $limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$filter='';

if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter") || $page < 0) {
    $filter = "";
    $offset = 0;
    $filter = "";
}
$arrayfields=[];
$datalabel = $extrafields->attributes[$object->table_element]['label'];
// Extra fields
if (is_array($extrafields->attributes[$object->table_element]['label']) && count($extrafields->attributes[$object->table_element]['label']) > 0)
{
    foreach ($extrafields->attributes[$object->table_element]['label'] as $key => $val)
    {
        if (!empty($extrafields->attributes[$object->table_element]['list'][$key]))
            $arrayfields["ef.".$key] = array('label'=>$extrafields->attributes[$object->table_element]['label'][$key], 'checked'=>(($extrafields->attributes[$object->table_element]['list'][$key] == 2 || $extrafields->attributes[$object->table_element]['list'][$key] == 1 || $extrafields->attributes[$object->table_element]['list'][$key] == 4) ? 1 : 0), 'position'=>$extrafields->attributes[$object->table_element]['pos'][$key], 'enabled'=>(abs($extrafields->attributes[$object->table_element]['list'][$key]) != 3 && $extrafields->attributes[$object->table_element]['perms'][$key]));
    }
}

$sql = 'SELECT s.rowid as id_soc, s.nom, s.code_fournisseur, s.phone, s.email, s.datec, SUM(f.total_ttc) as totalachat,  SUM(f.reglements) as totalreglmnt, (COALESCE(SUM(f.total_ttc),0) - COALESCE(SUM(f.reglements),0)) as dette';
if (!empty($extrafields->attributes[$object->table_element]['label'])) {
    foreach ($extrafields->attributes[$object->table_element]['label'] as $key => $val) $sql .= ($extrafields->attributes[$object->table_element]['type'][$key] != 'separate' ? ", ef.".$key.' as options_'.$key : '');
}
$sql .= ' FROM '.MAIN_DB_PREFIX.'societe as s ';
if (is_array($extrafields->attributes[$object->table_element]['label']) && count($extrafields->attributes[$object->table_element]['label'])) 
    $sql .= " LEFT JOIN ".MAIN_DB_PREFIX.$object->table_element."_extrafields as ef on (s.rowid = ef.fk_object)";


$sql .= 'LEFT JOIN ';
    $sql .= '( SELECT f.fk_soc, f.total_ttc, f.rowid, pf.totalreglmnt as reglements FROM '.MAIN_DB_PREFIX.'facture_fourn as f LEFT JOIN ';
            $sql .= '( SELECT pf.fk_facturefourn, SUM(pf.amount) as totalreglmnt FROM '.MAIN_DB_PREFIX.'paiementfourn_facturefourn as pf GROUP BY pf.fk_facturefourn ) pf';
        $sql .= ' ON pf.fk_facturefourn =f.rowid';
        $sql .= ' WHERE f.entity IN ('.getEntity("invoice").')';
        if($debut && $fin) $sql .= " AND (f.datef BETWEEN '".$debut."' AND '".$fin."')";
        elseif($debut && empty($fin)) $sql .= " AND f.datef>= '".$debut."'";
        elseif($fin && empty($debut)) $sql .= " AND f.datef<= '".$fin."'";

        $sql .= ' ) f ON f.fk_soc = s.rowid';


$sql .= ' WHERE s.entity IN ('.getEntity("societe").') AND s.fournisseur = 1 AND (s.status IN (1)) ';


$sql .= ' GROUP BY s.rowid';
$sql .= $srch_dette ? ' HAVING dette >= '.$srch_dette : '';
$sql .= ' ORDER BY dette '.$sortorder;


$i=0;

if ($limit > 0 && $limit != $conf->liste_limit) $param .= '&limit='.urlencode($limit);
if ($srch_dette) $param .= '&srch_dette='.urlencode($srch_dette);
if ($debut) $param .= '&debut='.urlencode($debut);
if ($fin) $param .= '&fin='.urlencode($fin);

$nbtotalofrecords = '';
    $result = $db->query($sql);
    $nbtotalofrecords = $db->num_rows($result);
    if (($page * $limit) > $nbtotalofrecords)   // if total resultset is smaller then paging size (filtering), goto and load page 0
    {
        $page = 0;
        $offset = 0;
    }

if(empty($action) || $action == 'generer')
    $sql .= $db->plimit($limit + 1, $offset);

$resql = $db->query($sql);
$i=0;

if($resql){
    $num = $db->num_rows($resql);
   
}

if (!$user->rights->releveclient->lire || !$user->rights->releveclient->export) {
    accessforbidden();
}

$dt_extrafield = $extrafields->fetch_name_optionals_label($object->table_element);
$label=$extrafields->attributes[$object->table_element]['label'];

if(dolibarr_get_const($db, strtoupper('stclient_fields'),0)){
    $data_ef = dolibarr_get_const($db, strtoupper('stclient_fields'),0);
    $data_ef = explode(',', $data_ef);
}

/*-------------Excel-----------------*/
if (GETPOST('actionxsl')) {
    require_once dol_buildpath('/releveclient/pdf/dettes_pdf.php');

    header("Content-Type: application/xls");
    header("Content-Disposition: attachment; filename=Etat_Dettes_Fournisseurs.xls");
    echo($html);
    die();
}

/*-------------PDF-----------------*/
if ($action == "pdf" && GETPOST('actionpdf')) {
    global $conf, $langs, $mysoc;
    
    $Client = new Societe($db);

    require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
    require_once dol_buildpath('/releveclient/pdf/pdf.lib.php');
    $pdf->SetMargins(7, 2, 7, false);
    $pdf->SetFooterMargin(10);
    $pdf->setPrintFooter(true);
    $pdf->SetAutoPageBreak(TRUE,10);

    $height=$pdf->getPageHeight();

    $pdf->SetFont('helvetica', '', 9, '', true);
    $pdf->AddPage('L');
    $margint = $pdf->getMargins()['top'];
    $marginb = $pdf->getMargins()['bottom'];
    $marginl = $pdf->getMargins()['left'];

    $pdf->SetTextColor(0, 0, 60);

    $default_font_size = 9;
    $pdf->SetFont('', 'B', $default_font_size);
    $posy   = $margint;
    $posx   = $pdf->page_largeur-$pdf->getMargins()['right']-100;

    $pdf->SetXY($marginl, $posy);

    $pdf->SetXY($marginl, $posy);

    $heightimg = 15;
    if ($mysoc && $mysoc->logo)
    {
        $logodir = $conf->mycompany->dir_output;
        if (empty($conf->global->MAIN_PDF_USE_LARGE_LOGO))
        {
            $logo = $logodir.'/logos/thumbs/'.$mysoc->logo_small;
        }
        else {
            $logo = $logodir.'/logos/'.$mysoc->logo;
        }
        
        if (is_readable($logo))
        {
            $height = pdf_getHeightForLogo($logo);
            $pdf->Image($logo, $marginl, $posy, 0, $heightimg); // width=0 (auto)
        }
        else
        {
            $pdf->SetTextColor(200, 0, 0);
            $pdf->SetFont('', 'B', $default_font_size - 2);
            $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorLogoFileNotFound", $logo), 0, 'L');
            $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorGoToGlobalSetup"), 0, 'L');
        }
    }
    else
    {
        $heightimg = 8;
        $text = $mysoc->name;
        $pdf->MultiCell(100, 4, $langs->convToOutputCharset($text), 0, 'L');
    }

    $posy = $margint + $heightimg + 2;

    $pdf->SetTextColor(0, 0, 60);
    $currentwate    = $conf->global->PAYROLLMOD_WATERMARK_IMG;
    if($currentwate){
        $bMargin = $pdf->getBreakMargin();
        $auto_page_break = $pdf->getAutoPageBreak();
        $pdf->SetAutoPageBreak(false, 0);
        $img_file = $conf->mycompany->dir_output.'/watermark/'.$currentwate;
        $pdf->SetAlpha(0.1);
        $pdf->Image($img_file, 35, 100, 140, '', '', '', '', false, 300, '', false, false, 0);
        $pdf->SetAlpha(1);
        $pdf->SetAutoPageBreak(true, $bMargin);
        $pdf->setPageMark();
    }

    $pdf->SetFont('', '', $default_font_size);

    if($id_client)
        $Client->fetch($id_client);


    require_once dol_buildpath('/releveclient/pdf/pdf.lib.php');
    require_once dol_buildpath('/releveclient/pdf/dettes_pdf.php');
    // echo $html;
    // die();
    $pdf->writeHTML($html, true, false, true, false, '');
    ob_start();
    $namemod=$langs->trans('dettefourn');
    $pdf->Output($namemod.'.pdf', 'I');
    //ob_end_clean();
    die();
}

if (!empty($conf->global->MAIN_DISABLE_FULL_SCANLIST))
{
    $nbtotalofrecords='';
}

$morejs  = array();
llxHeader(array(), $modname,'','','','',$morejs,0,0);

print load_fiche_titre($modname);


print '<div class="div-table-responsive">';
print '<form  method="POST" action="'.$_SERVER['PHP_SELF'].'" >';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        print '<table class="noborder">';
            print '<input type="hidden" name="action" value="generer">';
            print '<tr>';
                print '<td>'.$langs->trans('Period').'</td>';
                print '<td>';
                    print $langs->trans("From").' '.$form->selectDate($debut, 'debut', 0, 0, 1, '', 1, 1);
                print '</td>';
                print '<td>';
                    print $langs->trans("To").' '.$form->selectDate($fin, 'fin', 0, 0, 1, '', 1, 1);
                print '</td>';
                print '<td align="right">';
                    print '<input type="number" placeholder="0.00" name="srch_dette" value="'.$srch_dette.'">';
                    print '<a href="'.dol_buildpath('/releveclient/dettefourn.php',2).'" class="butAction" style="padding-top: 0.4em; float:right">'.$langs->trans("Reset").'</a>';
                    print '<input style="margin-top:0px; float:right" type="submit" value="'.$langs->trans("generetat").'" name="export" class="button" />';
                print '</td>';
            print '</tr>'; 
            
        print '</table>';
    print '</form>';
    print '<br><br>';

    print '<form  method="POST" action="'.$_SERVER['PHP_SELF'].'" id="detteclient" >';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        print '<input name="pagem" type="hidden" value="'.$page.'">';
        print '<input name="offsetm" type="hidden" value="'.$offset.'">';
        print '<input type="hidden" name="debut" value="'.$debut.'">';
        print '<input type="hidden" name="fin" value="'.$fin.'">';
        print '<input type="hidden" name="srch_dette" value="'.$srch_dette.'">';
        print '<input name="limitm" type="hidden" value="'.$limit.'">';
        print '<input name="filterm" type="hidden" value="'.$filter.'">';
        print '<input name="action" type="hidden" value="pdf">';


        $massactionbutton .= '<input name="actionpdf" type="submit" id="btn_pdf" formtarget="_blank" class="button" value="'.$langs->trans('generpdf').'" >';
        $massactionbutton .= '<input name="actionxsl" type="submit" id="btn_pdf" formtarget="_blank" class="button" value="'.$langs->trans('generxsl').'" >';
        print_barre_liste('', $page, $_SERVER["PHP_SELF"], $param, $sortfield, $sortorder, '', $num, $nbtotalofrecords, 'generic', 0, $massactionbutton, '', $limit, 0, 0, 1);

        print '<table class="noborder">';

            print '<tr class="liste_titre_filter">';
                print_liste_field_titre($langs->trans("Supplier"), $_SERVER["PHP_SELF"], "s.rowid", '', $param, 'align="center"', $sortfield, $sortorder);
                // print_liste_field_titre($langs->trans("DateCreation"), $_SERVER["PHP_SELF"], "s.datec", "", $param, 'align="center"', $sortfield, $sortorder);
                // print_liste_field_titre($langs->trans("Email"), $_SERVER["PHP_SELF"], "s.phone", "", $param, 'align="center"', $sortfield, $sortorder);
                include DOL_DOCUMENT_ROOT.'/core/tpl/extrafields_list_search_title.tpl.php';
                print_liste_field_titre($langs->trans("Phone"), $_SERVER["PHP_SELF"], "s.email", "", $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("SupplierCode"), $_SERVER["PHP_SELF"], "s.code_fournisseur", "", $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("totalachat"), $_SERVER["PHP_SELF"], "totalachat", "", $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("totalreglment"), $_SERVER["PHP_SELF"], "totalreglmnt", "", $param, 'align="center"', $sortfield, $sortorder);
                print_liste_field_titre($langs->trans("Dette"), $_SERVER["PHP_SELF"], "dette", "", $param, 'align="center"', $sortfield, $sortorder);
            print '</tr>';

            if($num){
                $totaldettes = 0;
                while ($i < min($num,$limit)) {
                    $dette = 0;
                    $obj=$db->fetch_object($resql);
                    $socid=$obj->id_soc;
                    $object = new Societe($db);
                    $object->fetch($socid);
                
                    print '<tr>';
                        $totaldettes += $obj->dette;
                        print '<td class="" align="left">'.$object->getNomUrl(1).' </td>';
                        // print '<td align="center">'.dol_print_date($object->date_creation,'dayhour').'</td>';
                        // print '<td align="center">'.$obj->email.'</td>';
                        include DOL_DOCUMENT_ROOT.'/core/tpl/extrafields_list_print_fields.tpl.php';
                        print '<td align="center">'.$object->phone.'</td>';
                        print '<td align="center">'.$obj->code_fournisseur.'</td>';
                        print '<td align="right">'.price($obj->totalachat, 0, $langs, 1, $aftercomma).'</td>';
                        print '<td align="right">'.price($obj->totalreglmnt, 0, $langs, 1, $aftercomma).'</td>';
                        print '<td align="right">'.price($obj->dette, 0, $langs, 1, $aftercomma).'</td>';
                    print '</tr>';

                    $i++;
                }
                print '<tr class="liste_total">';
                    $nbtotal2= $nbtotal-1;
                    print '<td class="" align="left" colspan="'.$nbtotal2.'">Total</td>';
                    print '<td align="right"><b>'.price($totaldettes, 0, $langs, 1, $aftercomma).' '.$langs->getCurrencySymbol($conf->currency).'</b></td>';
                print '</tr>';
             
            }
            else{
                // $nbtotal = 6+$nb_field;
                print '<tr class=""><td align="center" colspan="'.$nbtotal.'" >'.$langs->trans("NoRecordFound").'</td></tr>';
            }
        print '</table>';

    print '</form>';

    print '<br><br>';

print  '</div>';

llxFooter();
$db->close();