<?php
/* Copyright (C) 2003      Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2012 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@capnetworks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup   releveclient     Module releveclient
 *  \brief      Example of a module descriptor.
 *				Such a file must be copied into htdocs/releveclient/core/modules directory.
 *  \file       htdocs/releveclient/core/modules/modreleveclient.class.php
 *  \ingroup    releveclient
 *  \brief      Description and activation file for module releveclient
 */
include_once DOL_DOCUMENT_ROOT .'/core/modules/DolibarrModules.class.php';

/**
 *  Description and activation class for module releveclient
 */
class modReleveClient extends DolibarrModules
{
	/**
	 *   Constructor. Define names, constants, directories, boxes, permissions
	 *
	 *   @param      DoliDB		$db      Database handler
	 */
	function __construct($db)
	{
        global $langs,$conf;

        $this->db = $db;

        $this->editor_name = 'NextGestion';
		$this->editor_url = 'https://www.nextgestion.com';

		$this->numero = 1909611920;
		$this->rights_class = 'releveclient';

		$this->family = "NextGestion";
		$this->name = preg_replace('/^mod/i','',get_class($this));
		$this->description = "Module1909611920Desc";
		$this->version = '14.7';

		$this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
		$this->special = 0;
		$this->picto='releveclient@releveclient';
		$this->module_parts = array(
			'hooks' => array('variouscard'), 
            'models' => 1,
			'triggers' => 1,
			'css' 	=> array('/releveclient/css/releveclient.css'),
			'js' 	=> array('/releveclient/js/releveclient.js.php'),
			'moduleforexternal' => 1,
		);

		$this->dirs = array();

		$this->config_page_url = array('releveclient_setup.php@releveclient');

		// Dependencies
		$this->hidden = false;			// A condition to hide module
		$this->depends = array();		// List of modules id that must be enabled if this module is enabled
		$this->requiredby = array();	// List of modules id to disable if this one is disabled
		$this->conflictwith = array();	// List of modules id this module is in conflict with
		$this->phpmin = array(5,0);					// Minimum version of PHP required by module
		$this->need_dolibarr_version = array(3,0);	// Minimum version of Dolibarr required by module
		$this->langfiles = array("releveclient@releveclient");

		// Constants
		$this->const = array();

        $this->tabs = array();

        // Dictionaries
	    if (! isset($conf->releveclient->enabled))
        {
        	$conf->releveclient=new stdClass();
        	$conf->releveclient->enabled=0;
        }
		$this->dictionaries=array();
       

        // Boxes
        $this->boxes = array();			// List of boxes
		// Example:

		// Permissions
		$this->rights = array();		// Permission array used by this module
		$r=0;
		
		$this->rights[$r][0] = $this->numero+$r;	
		$this->rights[$r][1] = 'Consulter';	
		$this->rights[$r][2] = 'l';	
		$this->rights[$r][3] = 1; 					
		$this->rights[$r][4] = 'lire';
		$r++;

		$this->rights[$r][0] = $this->numero+$r;	
		$this->rights[$r][1] = 'export';	
		$this->rights[$r][2] = 'e';	
		$this->rights[$r][3] = 1; 					
		$this->rights[$r][4] = 'export';
		$r++;

		// Main menu entries
		$this->menu = array();			// List of menus to add
		$r=0;
		// Add here entries to declare new menus

		$this->menu[$r]=array(	'fk_menu'=>0,		// Put 0 if this is a single top menu or keep fk_mainmenu to give an entry on left
			'type'=>'top',			                // This is a Top menu entry
			'titre'=>'releveclient',
			'mainmenu'=>'releveclient',
			'url'=>'releveclient/releve.php',
			'langs'=>'releveclient@releveclient',	       
			'position'=>102,
			'enabled'=>'$conf->releveclient->enabled',
			'perms'=>'$user->rights->releveclient->lire',			                
			'target'=>'',
			'user'=>2);				               
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=releveclient',
			'type'=>'left',
			'titre'=>'list_releveclient',
			'leftmenu'=>'releveclient',
			'url'=>'/releveclient/releve.php',
			'langs'=>'releveclient@releveclient',
			'position'=>$r,
			'enabled'=>'1',
			'perms'=>'$user->rights->releveclient->lire',
			'target'=>'',
			'user'=>2);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=releveclient',
			'type'=>'left',
			'titre'=>'releve_general',
			'leftmenu'=>'releve_general',
			'url'=>'/releveclient/releve_global.php',
			'langs'=>'releveclient@releveclient',
			'position'=>$r,
			'enabled'=>'1',
			'perms'=>'$user->rights->releveclient->lire',
			'target'=>'',
			'user'=>2);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=releveclient',
			'type'=>'left',
			'titre'=>'grandlivre',
			'leftmenu'=>'grandlivre',
			'url'=>'/releveclient/grandlivre.php',
			'langs'=>'releveclient@releveclient',
			'position'=>$r,
			'enabled'=>'1',
			'perms'=>'$user->rights->releveclient->lire',
			'target'=>'',
			'user'=>2);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=releveclient',
			'type'=>'left',
			'titre'=>'releve_general',
			'leftmenu'=>'releve_general',
			'url'=>'/releveclient/releve_global.php',
			'langs'=>'releveclient@releveclient',
			'position'=>$r,
			'enabled'=>'1',
			'perms'=>'$user->rights->releveclient->lire',
			'target'=>'',
			'user'=>2);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=releveclient',
			'type'=>'left',
			'titre'=>'creanceclient',
			'leftmenu'=>'creanceclient',
			'url'=>'/releveclient/creanceclient.php',
			'langs'=>'releveclient@releveclient',
			'position'=>$r,
			'enabled'=>'1',
			'perms'=>'$user->rights->releveclient->lire',
			'target'=>'',
			'user'=>2);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=releveclient',
			'type'=>'left',
			'titre'=>'dettefourn',
			'leftmenu'=>'dettefourn',
			'url'=>'/releveclient/dettefourn.php',
			'langs'=>'releveclient@releveclient',
			'position'=>$r,
			'enabled'=>'1',
			'perms'=>'$user->rights->releveclient->lire',
			'target'=>'',
			'user'=>2);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=releveclient',
			'type'=>'left',
			'titre'=>'syntheseclient',
			'leftmenu'=>'syntheseclient',
			'url'=>'/releveclient/syntheseclient.php',
			'langs'=>'releveclient@releveclient',
			'position'=>$r,
			'enabled'=>'1',
			'perms'=>'$user->rights->releveclient->lire',
			'target'=>'',
			'user'=>2);
		$r++;

		
	}

	/**
	 *		Function called when module is enabled.
	 *		The init function add constants, boxes, permissions and menus (defined in constructor) into Dolibarr database.
	 *		It also creates data directories
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	function init($options='')
	{
		global $conf;
		$sqlm = array();

		dol_include_once('/releveclient/class/releveclient.class.php');
        dol_include_once('/portailreleve/core/modules/modportailreleve.class.php');

		if($conf->portailreleve->enabled && !$conf->releveclient->enabled){
			unActivateModule('modportailreleve');
		}


		$object = new releveclient($this->db);
		$object->InitReleveClient();

		return $this->_init($sqlm, $options);
	}

	/**
	 *		Function called when module is disabled.
	 *      Remove from database constants, boxes and permissions from Dolibarr database.
	 *		Data directories are not deleted
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	function remove($options='')
	{
		global $conf;
		$sql = array();

		if($conf->portailreleve->enabled){
			unActivateModule('modportailreleve');
		}
		
		$ret = delDocumentModel('wolcim', 'stock', 'wolcim');
        dolibarr_set_const($this->db,'STOCK_ADDON_PDF','crabe','chaine');

		return $this->_remove($sql, $options);
	}

}
