<?php 
if (empty($conf) || ! is_object($conf))
{
    print "Error, template page can't be called as URL";
    exit;
}

global $conf, $user;

require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture-rec.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/modules/facture/modules_facture.php';
require_once DOL_DOCUMENT_ROOT.'/categories/class/categorie.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/discount.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/invoice.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/accountancy/class/accountingjournal.class.php';


print '<link rel="stylesheet" type="text/css" href="'.DOL_URL_ROOT.'/includes/jquery/plugins/select2/dist/css/select2.css">';
print '<link rel="stylesheet" type="text/css" href="'.DOL_URL_ROOT.'/includes/jquery/plugins/select2/dist/css/select2.min.css">';
print '<script src="'.DOL_URL_ROOT.'/includes/jquery/plugins/select2/dist/js/select2.min.js"></script>';
print '<script src="'.DOL_URL_ROOT.'/includes/jquery/plugins/select2/dist/js/select2.js"></script>';
    

$socid = GETPOST("socid");
$action = GETPOST("action");


dol_include_once("/portailfactur/lib/portailfactur.lib.php");
dol_include_once("/portailfactur/class/portailfactur.class.php");

$form = new Form($db);
$userstatic = new User($db);
$object    = new Facture($db);
$client    = new Societe($db);
$paiement = new Paiement($db);
$portail = new portailfactur($db);
$extrafields = new ExtraFields($db);


$langs->loadLangs(array('bills', 'companies', 'compta', 'products', 'banks', 'main', 'withdrawals', 'portailfactur@portailfactur'));
$modname = $langs->trans("portailfactur");

$facid = (GETPOST('id', 'int') ?GETPOST('id', 'int') : GETPOST('facid', 'int')); 
$ref = GETPOST('ref', 'alpha');
$fk_reglement = GETPOST('fk_reglement', 'int');
$action = GETPOST('action', 'alpha');
$actionpdf = GETPOST('actionpdf', 'alpha');
$exportxsl = GETPOST('exportxsl', 'alpha');

$srch_qty=GETPOST('srch_qty');

$actionexport = $actionpdf ? 1 : ($exportxsl ? 1 : 0);
if($action == 'downloadportailfactur'){
    $exportxsl = 1;
    $actionexport = 1;
}

$debut = dol_mktime(0, 0, 0, GETPOST('debutmonth'), GETPOST('debutday'), GETPOST('debutyear'));
$fin = dol_mktime(0, 0, 0, GETPOST('finmonth'), GETPOST('finday'), GETPOST('finyear'));
$debut = $debut ? $db->idate($debut) : '';
$fin = $fin ? $db->idate($fin) : '';

if(empty($debut) && GETPOST('debut')) $debut=GETPOST('debut');
if(empty($fin) && GETPOST('fin')) $fin=GETPOST('fin');



$srch_datec = dol_mktime(0, 0, 0, GETPOST('srch_datecmonth'), GETPOST('srch_datecday'), GETPOST('srch_datecyear'));
$limit = GETPOST('limit', 'int') ? GETPOST('limit', 'int') : 20;
$sortfield = GETPOST('sortfield', 'alpha') ? GETPOST('sortfield', 'alpha') : 'f.datef';
$sortorder = GETPOST('sortorder', 'alpha') ? GETPOST('sortorder', 'alpha') : 'ASC';

$page = GETPOSTISSET('pageplusone') ? (GETPOST('pageplusone') - 1) : GETPOST('page', 'int');

if (empty($page) || $page === -1 || !empty($search_btn) || !empty($search_remove_btn) || (empty($toselect) && $massaction === '0')) { $page = 0; }     

$offset = $limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$filter='';
$solde=0;
if (GETPOST('button_removefilter_x') || GETPOST('button_removefilter') || $page < 0) {
    $filter = '';
    $offset = 0;
    $filter = '';
}

$sql = "SELECT f.rowid as facid, fd.rowid as lignid, f.n_bc, f.stlivr, f.fk_chantier, fd.fk_prod, p.rowid as prodid,  fd.qty, fd.price, fd.total_ht, fd.total_tva, fd.total_ttc, fd.tva, p.label, fd.descp, c.label as chantier FROM ".MAIN_DB_PREFIX."pf_facture as f";
$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."pf_facturedet as fd ON fd.fk_facture=f.rowid";
$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."product as p ON p.rowid=fd.fk_prod";
$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."pf_chantiers as c ON c.rowid=f.fk_chantier";
$sql .= " WHERE f.fk_client=".$socid." AND f.entity=".$conf->entity;
$sql .= " ORDER BY f.rowid ASC";
$resql = $db->query($sql);
if($resql){
    while($obj = $db->fetch_object($resql)){
        $data[$obj->facid]['chantier']=$obj->chantier;
        $data[$obj->facid]['n_bc']=$obj->n_bc;
        $data[$obj->facid]['stlivr']=$obj->stlivr;
        $dataligne=array();
        if($obj->lignid){
            $dataligne['id_lign'] = $obj->lignid;
            $dataligne['product'] = $obj->prodid;
            $dataligne['label'] = $obj->label;
            $dataligne['descp'] = $obj->descp;
            $dataligne['qty'] = $obj->qty;
            $dataligne['price'] = $obj->price;
            $dataligne['total_ht'] = $obj->total_ht;
            $dataligne['total_tva'] = $obj->total_tva;
            $dataligne['total_ttc'] = $obj->total_ttc;
        }
        $data[$obj->facid]['lines'][]=$dataligne;
    }
}
$arrpayement = [];
$resql = $db->query($sql);
$factsid = '';

$arrainvoics = array();

$urlpayement    = DOL_URL_ROOT.'/compta/paiement/card.php?id='; 
$urlfacture     = DOL_URL_ROOT.'/compta/facture/card.php?facid=';
$urlproduct     = DOL_URL_ROOT.'/product/card.php?id=';

$getcurrencysym = $langs->getCurrencySymbol($conf->currency);

$aftercomma = intval($conf->global->portailfactur_NUMBER_OF_DIGITS_AFTER_THE_DECIMAL_POINT);
$subtotaltext1 = ($conf->global->portailfactur_FIRST_SUB_TOTAL_TEXT) ? $conf->global->portailfactur_FIRST_SUB_TOTAL_TEXT : $langs->trans("totalbl1");
$subtotaltext2 = ($conf->global->portailfactur_SECOND_SUB_TOTAL_TEXT) ? $conf->global->portailfactur_SECOND_SUB_TOTAL_TEXT : $langs->trans("totalbe1");

/*-------------PDF-----------------*/
if($actionexport){
    global $conf, $langs, $mysoc;

    $Client = new Societe($db);
    $filename = html_entity_decode($langs->trans('portailfactur'));
    if($socid) {
        $Client->fetch($socid);
        $filename = $Client->name.' - '.html_entity_decode($langs->trans('portailfactur'));

        // if($debut || $fin ){
        //     $filename.= ' - '.html_entity_decode($langs->trans('Period')).': ';
        //     if($debut) $filename.= dol_print_date($debut,'day');
        //     if($debut && $fin) $filename .= ' '.$langs->trans('to').' ';
        //     if($fin) $filename.= dol_print_date($fin,'day');
        // }
    }
}
if($exportxsl){
    // require_once dol_buildpath('/portailfactur/pdf/releve_pdf.php');
    include $context->tplPath. '/portailfactur/portailfactur-pdf.php';
}

echo '<div id="portailfactur" class="div-table-responsive">';
    echo '<form method="POST" action="'.$context->getRootUrl('portailfactur').'" >';
        echo '<table class="table ">';
            echo '<input type="hidden" name="action" value="generer">';
            echo '<tr>';
                echo '<td><b>'.$langs->trans('Client').': </b>';
                    print select_company($socid, 'socid');
                    // echo '&nbsp;&nbsp;<a class="btn btn-info submitbutton" style=""><i class="fa fa-search"></i></a>';
                    echo '<a href="'.$context->getRootUrl('portailfactur').'" class="btn btn-secondary resetbutton" style=""><i class="fa fa-search-minus"></i></a>';
                echo '</td>';
            echo '</tr>'; 
        echo '</table>';

        echo '<input type="hidden" name="debut" value="'.$debut.'">';
        echo '<input type="hidden" name="fin" value="'.$fin.'">';

        $object = new Facture($db);
        $dt_extrafield = $extrafields->fetch_name_optionals_label($object->table_element);
        $label=$extrafields->attributes[$object->table_element]['label'];

        if(dolibarr_get_const($db, strtoupper('portailfactur_fields'),$conf->entity)){
            $data_ef = dolibarr_get_const($db, strtoupper('portailfactur_fields'),$conf->entity);
            $data_ef = explode(',', $data_ef);
        }

        echo '<table class="table ">';
            echo '<tr>';
                echo '<td align="right">';
                    echo '<input class="btn btn-secondary" id="generate" style="margin-top:0px;" type="submit" value="'.$langs->trans("generetat").'" name="exportpdf" />';
                    echo '<a href="#" class="btn btn-info" data-toggle="modal" data-target="#facturmodal">'.$langs->trans("Fusionner Facture").'</a>';
                    $dowloadUrl = $context->getRootUrl().'script/interface.php?action=downloadportailfactur'.$param;
                    $urld = ' &nbsp;&nbsp;<a class="btn btn-primary" href="'.$dowloadUrl.'" >'.$langs->trans("exportsituationxsl").'</a>';
                    echo $urld;
                echo '</td>';
            echo '</tr>'; 
        echo '</table>';
      
        echo '<table id="invoice-list" class="table table-striped">';
            $clsp=0;

            echo '<tr class="liste_titre_filter">';
                print ' <th class="text-center" >'.$langs->trans('n_bc').'</th>';
                print ' <th class="text-center" >'.$langs->trans('chantier').'</th>';
                print ' <th class="text-center" >'.$langs->trans('etat_livr').'</th>';
                
                echo '<th class="text-center" class="wrapcolumntitle liste_titre tdlabeltable">'.$langs->trans("Product").'</th>';
                echo '<th class="text-center" class="wrapcolumntitle liste_titre tdqtytable">'.$langs->trans("Qty").'</th>';
                echo '<th class="text-center" class="wrapcolumntitle liste_titre tdamounttable">'.$langs->trans("PriceUHT").'</th>';
                echo '<th class="text-center" >'.$langs->trans('AmountHT').'</th>';
                echo '<th class="text-center" >'.$langs->trans('AmountVAT').'</th>';
                echo '<th class="text-center" >'.$langs->trans('airsi').'</th>';
                echo '<th class="text-center" >'.$langs->trans('AmountTTC').'</th>';

            echo '</tr>';
          
            if($data){
                foreach ($data as $key => $value) {
                    print '<tr>';
                        $airsi=0;
                        $lines=$value['lines'];
                        $rowspan = $lines ? 'rowspan="'.count($lines).'"' : '';
                        print '<td align="left" '.$rowspan.'><a href="#"><i class="fa fa-eye"></i><span align="center">'.$value['n_bc'].'</span></a></td>';
                        print '<td align="center" '.$rowspan.'>'.$value['chantier'].'</td>';
                        print '<td align="center" '.$rowspan.'>'.$value['stlivr'].'</td>';
                        if($lines && count($lines)){
                            $line0 = $lines[0];
                            $airsi = ($line['total_ttc']*0.2)/100;

                            print '<td align="left">';
                                if($line0['label']) echo $line0['label'];
                                else echo $line0['descp'];
                            print '</td>';
                            print '<td align="center">'.$line0['qty'].'</td>';
                            print '<td align="center">'.price($line0['price']).'</td>';
                            print '<td align="center">'.price($line0['total_ht']).'</td>';
                            print '<td align="center">'.price($line0['total_tva']).'</td>';
                            print '<td align="center">'.price($airsi).'</td>';
                            print '<td align="center">'.price($line0['total_ttc']).'</td>';
                        }else{
                            print '<td></td>';
                            print '<td></td>';
                            print '<td></td>';
                            print '<td></td>';
                            print '<td></td>';
                            print '<td></td>';
                            print '<td></td>';
                            print '<td></td>';
                        }
                    print '</tr>';
                    if($lines && count($lines)){
                        foreach ($lines as $key => $line) {
                            if($key>0){
                                $airsi = ($line['total_ttc']*0.2)/100;
                                print '<tr>';
                                    print '<td align="left">';
                                        if($line['label']) echo $line['label'];
                                        else echo $line['descp'];
                                    print '</td>';
                                    print '<td align="center">'.$line['qty'].'</td>';
                                    print '<td align="center">'.price($line['price']).'</td>';
                                    print '<td align="center">'.price($line['total_ht']).'</td>';
                                    print '<td align="center">'.price($line['total_tva']).'</td>';
                                    print '<td align="center">'.price($airsi).'</td>';
                                    print '<td align="center">'.price($line['total_ttc']).'</td>';
                                print '</tr>';
                            }
                        }
                    }
                }
            }
            else{
                echo '<tr><td align="center" colspan="11" >'.$langs->trans("NoRecordFound").'</td></tr>';
            }
        echo '</table>';
        echo '<br>';
    echo '</form>';
    echo '<form method="POST" action="'.$context->getRootUrl().'script/add_factur.php" >';
        echo '<div class="modal fade" id="facturmodal" tabindex="-1" role="dialog" aria-labelledby="ea_errors_title" aria-hidden="true">';
            echo '<div class="modal-dialog modal-lg">';
                echo '<div class="modal-content">';

                    if($socid){
                        // <!-- Modal Header -->
                        echo '<input type="hidden" name="action" value="newfactur">';
                        echo '<input type="hidden" name="soc_id" value="'.$socid.'">';
                        echo '<div class="modal-header">';
                           echo '<h6 class="modal-title"><b>'.$langs->trans("Fusionnez_factures").'</b></h6>';
                           echo '<button type="button" class="close" data-dismiss="modal">&times;</button>';
                        echo '</div>';

                        // <!-- Modal body -->
                        echo '<div class="modal-body">';
                            echo '<table class="table table-borderless">';
                                echo '<tr>';
                                    echo '<td class="col-md-3">'.$langs->trans("n_bc").'</td>';
                                    echo '<td><input name="n_bc" class="n_bc"></td>';
                                echo '</tr>';
                                echo '<tr>';
                                    echo '<td class="col-md-3">'.$langs->trans("etat_livr").'</td>';
                                    echo '<td>'.selectEtatlivr($socid).'</td>';
                                echo '</tr>';
                                echo '<tr>';
                                    echo '<td class="col-md-3">'.$langs->trans("Invoice").'</td>';
                                    echo '<td class="selectfact">'.selectFacture($socid).'</td>';
                                echo '</tr>';
                                echo '<tr>';
                                    echo '<td class="col-md-3">'.$langs->trans("chantier").'</td>';
                                    echo '<td>'.selectChantier($socid).'</td>';
                                echo '</tr>';
                            echo '</table>';
                        echo '</div>';
                        
                        // <!-- Modal footer -->
                        echo '<div class="modal-footer">';
                            echo '<button type="button" class="btn btn-secondary" data-dismiss="modal">'.$langs->trans("close").'</button>';
                            echo '<button type="submit" class="btn btn-primary">'.$langs->trans("Valider").'</button>';
                        echo '</div>';
                    }else {
                        echo '<div class="modal-header" style="background:#ed4646; color:#fff; line-height:4">';
                           echo '<h6 class="modal-title"><b>'.$langs->trans("selection_client").'</b></h6>';
                           echo '<button type="button" class="close" data-dismiss="modal">&times;</button>';
                        echo '</div>';
                    }

                echo '</div>';
            echo '</div>';
        echo '</div>';
    echo '</form>';

echo  '</div>';

?>
<script>
    $(document).ready(function(){
        $('select#socid').change(function(){
            $('#generate').trigger("click");
        });
    })
    function getFactur(that) {
        var val = $(that).val();
        var socid = $("#socid").val();
        $.ajax({
            url:'<?php echo dol_buildpath('/portailfactur/www/script/getFacture.php',2) ?>',
            type:'POST',
            data:{'stliv':val, 'socid':socid},
            success:function(data){
                $('.selectfact').html(data);
                $('.select_facture').select2();
            }
        })
    }
</script>
<?php

dol_fiche_end();

// llxFooter();
// $db->close();
