<?php 
if (empty($conf) || ! is_object($conf))
{
    print "Error, template page can't be called as URL";
    exit;
}

global $conf, $user;

require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture-rec.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/modules/facture/modules_facture.php';
require_once DOL_DOCUMENT_ROOT.'/categories/class/categorie.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/discount.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/invoice.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/accountancy/class/accountingjournal.class.php';


print '<link rel="stylesheet" type="text/css" href="'.DOL_URL_ROOT.'/includes/jquery/plugins/select2/dist/css/select2.css">';
print '<link rel="stylesheet" type="text/css" href="'.DOL_URL_ROOT.'/includes/jquery/plugins/select2/dist/css/select2.min.css">';
print '<script src="'.DOL_URL_ROOT.'/includes/jquery/plugins/select2/dist/js/select2.min.js"></script>';
print '<script src="'.DOL_URL_ROOT.'/includes/jquery/plugins/select2/dist/js/select2.js"></script>';
    

$socid = GETPOST("socid");
$action = GETPOST("action");


dol_include_once("/portailfactur/lib/portailfactur.lib.php");
dol_include_once("/portailfactur/class/portailfactur.class.php");

$form = new Form($db);
$userstatic = new User($db);
$object    = new Facture($db);
$client    = new Societe($db);
$paiement = new Paiement($db);
$portail = new portailfactur($db);
$extrafields = new ExtraFields($db);

if($socid){
    $client->fetch($socid);
}

$langs->loadLangs(array('bills', 'companies', 'compta', 'products', 'banks', 'main', 'withdrawals', 'portailfactur@portailfactur'));
$modname = $langs->trans("portailfactur");

$facid = (GETPOST('id', 'int') ?GETPOST('id', 'int') : GETPOST('facid', 'int')); // For backward compatibility
$ref = GETPOST('ref', 'alpha');
$fk_reglement = GETPOST('fk_reglement', 'int');
$action = GETPOST('action', 'alpha');

$exportpdf = GETPOST('exportpdf');
$exportxsl = GETPOST('exportxsl');
// echo 'exportpdf: '.$exportpdf;
// echo '<br>exportxsl: '.$exportxsl;
// $actionexport = $exportpdf ? 0 : ($exportxsl ? 1 : 0);
if($action == 'downloadportailfacturpdf'){
    $exportxsl = 1;
    $actionexport = 1;
}
$srch_ref=GETPOST('srch_ref');
$srch_fact=GETPOST('srch_fact');
$srch_n_bc=GETPOST('srch_n_bc');
$srch_chantier=GETPOST('srch_chantier');
$srch_etatliv=GETPOST('srch_etatliv');
$srch_prod=GETPOST('srch_prod');
$srch_qty=GETPOST('srch_qty');
$srch_pu=GETPOST('srch_pu');
$srch_ht=GETPOST('srch_ht');
$srch_ttc=GETPOST('srch_ttc');
$srch_airsi=GETPOST('srch_airsi');

$debut = dol_mktime(0, 0, 0, GETPOST('debutmonth'), GETPOST('debutday'), GETPOST('debutyear'));
$fin = dol_mktime(0, 0, 0, GETPOST('finmonth'), GETPOST('finday'), GETPOST('finyear'));
$debut = $debut ? $db->idate($debut) : '';
$fin = $fin ? $db->idate($fin) : '';

if(empty($debut) && GETPOST('debut')) $debut=GETPOST('debut');
if(empty($fin) && GETPOST('fin')) $fin=GETPOST('fin');



$srch_datec = dol_mktime(0, 0, 0, GETPOST('srch_datecmonth'), GETPOST('srch_datecday'), GETPOST('srch_datecyear'));
// $limit = GETPOST('limit', 'int') ?GETPOST('limit', 'int') : $conf->liste_limit;
$limit = GETPOST('limit', 'int') ?GETPOST('limit', 'int') : 20;
$sortfield = GETPOST('sortfield', 'alpha') ? GETPOST('sortfield', 'alpha') : 'f.datef';
$sortorder = GETPOST('sortorder', 'alpha') ? GETPOST('sortorder', 'alpha') : 'ASC';
$page = GETPOSTISSET('pageplusone') ? (GETPOST('pageplusone') - 1) : GETPOST('page', 'int');
if (empty($page) || $page === -1 || !empty($search_btn) || !empty($search_remove_btn) || (empty($toselect) && $massaction === '0')) { $page = 0; }     

$offset = $limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$filter='';
$solde=0;
if (GETPOST('button_removefilter_x') || GETPOST('button_removefilter') || $page < 0) {
    $filter = '';
    $offset = 0;
    $filter = '';
}

// $sql = "SELECT f.rowid as facid, f.amount_ttc, f.amount_ht, f.datef, s.nom FROM ".MAIN_DB_PREFIX."pf_facture as f";
// $sql .= " LEFT JOIN ".MAIN_DB_PREFIX."societe as s ON s.rowid=f.fk_client";
// // $sql .= " LEFT JOIN ".MAIN_DB_PREFIX."pf_chantiers as c ON c.rowid=f.fk_chantier";
// $sql .= " WHERE f.entity=".$conf->entity;
// $sql .= (!empty($socid) && $socid>0) ? " AND f.fk_client=".$socid."" : '';
// $sql .= " ORDER BY f.rowid ASC";


$sql = "SELECT f.rowid as facid, f.ref as pf_ref, ff.ref as f_ref, s.nom as client, fd.rowid as lignid, fd.n_bc, ef.stliv, fd.chantier, fd.fk_prod, p.rowid as prodid,  fd.qty, fd.price, fd.total_ht, fd.total_tva, fd.total_ttc, fd.tva, p.label, fd.descp FROM ".MAIN_DB_PREFIX."pf_facture as f";
$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."pf_facturedet as fd ON fd.fk_facture=f.rowid";
$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."facture as ff ON ff.rowid=fd.origine_fact";
$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."facture_extrafields as ef ON ef.fk_object=ff.rowid";
$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."societe as s ON s.rowid=f.fk_client";
$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."product as p ON p.rowid=fd.fk_prod";
// $sql .= " LEFT JOIN ".MAIN_DB_PREFIX."pf_chantiers as c ON c.rowid=f.fk_chantier";
$sql .= " WHERE f.entity=".$conf->entity;
$sql .= $socid ? " AND f.fk_client=".$socid : "";

$sql .= $srch_ref ? " AND f.ref LIKE '%".$srch_ref."%'" : "";
$sql .= $srch_fact ? " AND ff.ref LIKE '%".$srch_fact."%'" : "";
$sql .= $srch_n_bc ? " AND fd.n_bc LIKE '%".$srch_n_bc."%'" : "";
$sql .= $srch_chantier ? " AND fd.chantier LIKE '%".$srch_chantier."%'" : "";
$sql .= $srch_etatliv ? " AND ef.stliv LIKE '%".$srch_etatliv."%'" : "";
$sql .= $srch_prod ? " AND p.label LIKE '%".$srch_prod."%'" : "";
$sql .= $srch_qty ? " AND fd.qty =".$srch_qty : "";
$sql .= $srch_pu ? " AND fd.price =".$srch_pu : "";
$sql .= $srch_ht ? " AND fd.total_ht =".$srch_ht : "";
$sql .= $srch_ttc ? " AND fd.total_ttc =".$srch_ttc : "";
// $sql .= $srch_ttc ? " AND fd.total_ttc =".$srch_ttc : "";

$sql .= " ORDER BY f.rowid DESC";
// $sql .= " GROUP BY f.rowid";

$resql = $db->query($sql);
if($resql){
    $num = $db->num_rows($resql);

    while($obj = $db->fetch_object($resql)){
        $data[$obj->facid]['ref']=$obj->pf_ref;
        $data[$obj->facid]['client']=$obj->client;
        $dataligne=array();
        if($obj->lignid){
            $dataligne['ref_fact']=$obj->f_ref;
            $dataligne['n_bc']=$obj->n_bc;
            $dataligne['chantier']=$obj->chantier;
            $dataligne['stliv']=$obj->stliv;
            $dataligne['id_lign'] = $obj->lignid;
            $dataligne['product'] = $obj->prodid;
            $dataligne['label'] = $obj->label;
            $dataligne['descp'] = $obj->descp;
            $dataligne['qty'] = $obj->qty;
            $dataligne['price'] = $obj->price;
            $dataligne['total_ht'] = $obj->total_ht;
            $dataligne['total_tva'] = $obj->total_tva;
            $dataligne['total_ttc'] = $obj->total_ttc;
        }
        $data[$obj->facid]['lines'][]=$dataligne;
    }

}
$arrpayement = [];
$resql = $db->query($sql);
$factsid = '';

$arrainvoics = array();

$urlpayement    = DOL_URL_ROOT.'/compta/paiement/card.php?id='; 
$urlfacture     = DOL_URL_ROOT.'/compta/facture/card.php?facid=';
$urlproduct     = DOL_URL_ROOT.'/product/card.php?id=';

$currency = $langs->getCurrencySymbol($conf->currency);

$aftercomma = intval($conf->global->portailfactur_NUMBER_OF_DIGITS_AFTER_THE_DECIMAL_POINT);
$subtotaltext1 = ($conf->global->portailfactur_FIRST_SUB_TOTAL_TEXT) ? $conf->global->portailfactur_FIRST_SUB_TOTAL_TEXT : $langs->trans("totalbl1");
$subtotaltext2 = ($conf->global->portailfactur_SECOND_SUB_TOTAL_TEXT) ? $conf->global->portailfactur_SECOND_SUB_TOTAL_TEXT : $langs->trans("totalbe1");

/*-------------PDF-----------------*/
if($actionexport){
    global $conf, $langs, $mysoc;


    require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
    require_once dol_buildpath('/portailfactur/pdf/pdf.lib.php');

    $html.='';
    $filename = html_entity_decode($langs->trans('portailfactur'));
    include $context->tplPath. '/portailfactur/listfactur-pdf.php';


    $pdf->SetFooterMargin(10);
    $pdf->setPrintFooter(true);
    $pdf->SetAutoPageBreak(TRUE,10);

    $height=$pdf->getPageHeight();

    $pdf->SetFont('helvetica', '', 9, '', true);
    $pdf->AddPage('L');
    $margint = $pdf->getMargins()['top'];
    $marginb = $pdf->getMargins()['bottom'];
    $marginl = $pdf->getMargins()['left'];
    $marginr = $pdf->getMargins()['right'];
    $object->fetch($id);
    $item = $object;

    $pdf->SetTextColor(0, 0, 60);

    $default_font_size = 9;
    $pdf->SetFont('', 'B', $default_font_size);
    $posy   = $margint;
    $posx   = $pdf->page_largeur-$pdf->getMargins()['right']-100;

    $pdf->SetXY($marginl, $posy);

    $pdf->SetXY($marginl, $posy);

    $heightimg = 15;
    if ($mysoc && $mysoc->logo)
    {
        $logodir = $conf->mycompany->dir_output;
        if (empty($conf->global->MAIN_PDF_USE_LARGE_LOGO))
        {
            $logo = $logodir.'/logos/thumbs/'.$mysoc->logo_small;
        }
        else {
            $logo = $logodir.'/logos/'.$mysoc->logo;
        }
        
        if (is_readable($logo))
        {
            $height = pdf_getHeightForLogo($logo);
            $pdf->Image($logo, $marginl, $posy, 0, $heightimg); // width=0 (auto)
        }
        else
        {
            $pdf->SetTextColor(200, 0, 0);
            $pdf->SetFont('', 'B', $default_font_size - 2);
            $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorLogoFileNotFound", $logo), 0, 'L');
            $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorGoToGlobalSetup"), 0, 'L');
        }
    }
    else
    {
        $heightimg = 8;
        $text = $mysoc->name;
        $pdf->MultiCell(100, 4, $langs->convToOutputCharset($text), 0, 'L');
    }

    $pdf->SetXY($marginr, $margint);

    $pdf->MultiCell(265, 3, date('d/m/Y'), 0, 'R');

    $posy = $margint + $heightimg + 2;

   
    $pdf->SetFont('', '', $default_font_size);

    $pdf->writeHTML($html, true, false, true, false, '');
    ob_start();
    $namemod=$langs->trans('portailfactur');
    $pdf->Output($namemod.'.pdf', 'I');
    //ob_end_clean();
    die();
}
if($exportxsl){
    include $context->tplPath. '/portailfactur/listfactur-pdf.php';
}


echo '<div id="portailfactur" class="div-table-responsive">';
    echo '<form method="POST" action="'.$context->getRootUrl('portailfactur').'" class="form_portail">';
        // echo '<table class="table ">';
        //     echo '<input type="hidden" name="action" value="generer">';
        //     echo '<tr>';
        //         echo '<td>';
        //         echo '</td>';
        //     echo '</tr>'; 
        // echo '</table>';

        // echo '<table class="table ">';
        //     echo '<tr>';
        //         echo '<td align="right">';
        //         echo '</td>';
        //     echo '</tr>'; 
        // echo '</table>';

        echo '<div class="div-top">';
            echo '<div class="float-left">';
                echo '<b>'.$langs->trans('Client').': </b>';
                    print select_company($socid, 'socid');
                echo '<a href="'.$context->getRootUrl('portailfactur').'" class="btn btn-secondary resetbutton" style=""><i class="fa fa-search-minus"></i></a>';
            echo '</div>';
            echo '<div class="float-right">';
                echo '<input class="btn btn-secondary" id="generate" style="margin-top:0px;" type="submit" value="'.$langs->trans("generetat").'" name="exportpdf" />';
                echo '<a href="#" class="btn btn-info" data-toggle="modal" data-target="#facturmodal">'.$langs->trans("Fusionner_Facture").'</a>';
                $dowloadUrl = $context->getRootUrl().'script/interface.php?action=downloadportailfacturpdf&socid='.$socid;
                $urld = ' &nbsp;&nbsp;<a class="btn btn-primary" target="_blank" href="'.$dowloadUrl.'" >'.$langs->trans("exportsituationxsl").'</a>';
                echo $urld;
            echo '</div>';
        echo '</div>';

        echo '<table id="invoice-list" class="table table-striped">';

            echo '<tr class="liste_titre_filter" >';
                print ' <th class="text-center" >'.$langs->trans('Ref').'</th>';
                print ' <th class="text-center" >'.$langs->trans('Customer').'</th>'; 
                print ' <th class="text-center" >'.$langs->trans('ContactDefault_facture').'</th>';
                print ' <th class="text-center" >'.$langs->trans('n_bc').'</th>';
                print ' <th class="text-center" >'.$langs->trans('chantier').'</th>';
                print ' <th class="text-center" >'.$langs->trans('N° BL').'</th>';
                
                echo '<th class="text-center" >'.$langs->trans("Label").'</th>';
                echo '<th class="text-center" >'.$langs->trans("Qty").'</th>';
                echo '<th class="text-center" >'.$langs->trans("PriceUHT").'</th>';
                echo '<th class="text-center" >'.$langs->trans('AmountHT').'</th>';
                echo '<th class="text-center" >'.$langs->trans('TVA 18%').'</th>';
                echo '<th class="text-center" >'.$langs->trans('airsi').'</th>';
                echo '<th class="text-center" colspan="2" >'.$langs->trans('AmountTTC').'</th>';
                // echo '<th class="text-center" >'.$langs->trans('Actions').'</th>';

            echo '</tr>';
            echo '<tr class="liste_filter">';
                print ' <td style="max-width:120px" ><input style="width:100%" name="srch_ref" value="'.$srch_ref.'"></td>';
                print ' <td style="max-width:120px" ></td>'; 
                print ' <td style="max-width:120px" ><input style="width:100%" name="srch_fact" value="'.$srch_fact.'"></td>';
                print ' <td style="max-width:120px" ><input style="width:100%" name="srch_n_bc" value="'.$srch_n_bc.'"></td>';
                print ' <td style="max-width:120px" ><input style="width:100%" name="srch_chantier" value="'.$srch_chantier.'"></td>';
                print ' <td style="max-width:120px" ><input style="width:100%" name="srch_etatliv" value="'.$srch_etatliv.'"></td>';
                
                echo '<td style="max-width:120px" ><input style="width:100%" name="srch_prod" value="'.$srch_prod.'"></td>';
                echo '<td style="max-width:120px" ><input style="width:100%" name="srch_qty" value="'.$srch_qty.'"></td>';
                echo '<td style="max-width:120px" ><input style="width:100%" name="srch_pu" value="'.$srch_pu.'"></td>';
                echo '<td style="max-width:120px" ></td>';
                echo '<td style="max-width:120px" ></td>';
                echo '<td style="max-width:120px" ></td>';
                echo '<td style="max-width:120px; width:120px; border-right:0px !important; padding-right:0px !important" ></td>';
                echo '<td style="border-left:0px !important; padding-left:3px !important">';
                    echo '<a class="btn-filter submitbutton" style=""><i class="fa fa-search"></i></a>';
                    echo '<br><a href="'.$context->getRootUrl('portailfactur').'" class="btn-filter btn-vide" style=""><i class="fa fa-times"></i></a>';
                echo '</td>';
            echo '</tr>';
            $service = dolibarr_get_const($db, 'PORTAILFACTUR_SERVICE_TRANSPORT', $conf->entity);
            $totalqty=0;
            $total_ht=0;
            $totaltva=0;
            $total_ttc=0;
            $ht_transp=0;
            $ttc_transp=0;
            $tva_transp=0;

            if($data){
                foreach ($data as $key => $value) {
                    $airsi=0;
                    $lines=$value['lines'];
                    $line0=[];
                    $rowspan = $lines ? 'rowspan="'.count($lines).'"' : '';
                    if($lines && count($lines)){
                        // if($line0['fk_prod'] != $service){
                        $line0 = $lines[0];
                        $amount_ttc = $line0['total_ttc'];
                        $amount_ht = ($amount_ttc*100)/118;
                        $tva18 = ($amount_ht*18)/100;
                        $airsi = $amount_ttc ? ($amount_ttc*0.2)/100 : 0;

                        if($line0['product'] == $service){
                            $ttc_transp += $amount_ttc;
                            $tva_transp += $tva18;
                            $ht_transp += $amount_ht;

                            // $aisi_transp += $airsi;
                        }else{
                            $totalqty+=$line0['qty'];
                        }
                        $total_ttc+=$amount_ttc;
                        $total_ht+=$line0['total_ht'];
                        $totaltva+=$tva18;
                        $totalairsi+=$airsi;
                        print '<tr>';
                            print '<td align="left" '.$rowspan.'><a href="'.$context->getRootUrl('showfactur').'&id_fact='.$key.'">'.$value['ref'].'</a></td>';
                            print '<td align="left" '.$rowspan.'>'.$value['client'].'</td>';
                            print '<td align="left" ><span align="center">'.$line0['ref_fact'].'</span></td>';
                            print '<td align="left" ><span align="center">'.$line0['n_bc'].'</span></td>';
                            print '<td align="center">'.$line0['chantier'].'</td>';
                            print '<td align="left" >'.$line0['stliv'].'</td>';

                            print '<td align="left">';
                                if($line0['label']) echo $line0['label'];
                                else echo $line0['descp'];
                            print '</td>';
                            print '<td align="center">'.$line0['qty'].'</td>';
                            print '<td align="right" class="td-amount" >'.number_format($line0['price'], 2, ",", " ").'</td>';
                            print '<td align="right" class="td-amount" >'.number_format($amount_ht, 2, ",", " ").'</td>';
                            print '<td align="right" class="td-amount" >'.number_format($tva18, 2, ",", " ").'</td>';
                            print '<td align="right" class="td-amount" >'.number_format($airsi, 2, ",", " ").'</td>';
                            print '<td align="center" colspan="2" class="td-amount">'.number_format($amount_ttc, 2, ",", " ").'</td>';
                        print '</tr>';
                        // }
                        // else
                        //     $linetransp[]=$lines[0];
                        foreach ($lines as $key => $line) {
                            if($key>0){
                                // if($line['product'] != $service){
                                $amount_ttc = $line['total_ttc'];
                                $amount_ht = ($amount_ttc*100)/118;
                                $tva18 = ($amount_ht*18)/100;
                                $airsi = ($amount_ttc*0.2)/100;
                                 if($line['product'] == $service){
                                    $ttc_transp += $amount_ttc;
                                    $tva_transp += $tva18;
                                    $ht_transp += $amount_ht;
                                    // $aisi_transp += $airsi;
                                }else{
                                    $totalqty+=$line['qty'];
                                }

                                $total_ttc+=$amount_ttc;
                                $total_ht+=$line['total_ht'];
                                $totaltva+=$tva18;
                                $totalairsi += $airsi;
                                
                                print '<tr>';
                                    print '<td align="left" ><span align="center">'.$line['ref_fact'].'</span></td>';
                                    print '<td align="left" ><span align="center">'.$line['n_bc'].'</span></td>';
                                    print '<td align="left" ><span align="center">'.$line['chantier'].'</span></td>';
                                    print '<td align="left" ><span align="center">'.$line['stliv'].'</span></td>';
                                    print '<td align="left">';
                                        if($line['label']) echo $line['label'];
                                        else echo $line['descp'];
                                    print '</td>';
                                    print '<td align="center">'.$line['qty'].'</td>';
                                    print '<td align="right" class="td-amount">'.number_format($line['price'], 2, ",", " ").'</td>';
                                    print '<td align="right" class="td-amount">'.number_format($line['total_ht'], 2, ",", " ").'</td>';
                                    print '<td align="right" class="td-amount">'.number_format($tva18, 2, ",", " ").'</td>';
                                    print '<td align="right" class="td-amount">'.number_format($airsi, 2, ",", " ").'</td>';
                                    print '<td align="center" colspan="2" class="td-amount">'.number_format($amount_ttc, 2, ",", " ").'</td>';
                                    // print '<td></td>';
                                print '</tr>';
                                // }else{
                                //     $linetransp[]=$line;
                                // }
                            }
                        }
                    }
                }
                print '<tr class="total" style="background:#f2f2f2 !important;">';
                    print '<td colspan="7" align="right"><b>'.$langs->trans("Total").'</b></td>';
                    print '<td align="center"><b>'.$totalqty.'</b></td>';
                    print '<td></td>';
                    print '<td align="right" class="td-amount"><b>'.number_format($total_ht, 2, ",", " ").' '.$currency.'</b></td>';
                    print '<td align="right" class="td-amount"><b>'.number_format($totaltva, 2, ",", " ").' '.$currency.'</b></td>';
                    print '<td align="right" class="td-amount"><b>'.number_format($totalairsi, 2, ",", " ").' '.$currency.'</b></td>';
                    print '<td align="center" colspan="2" class="td-amount"><b>'.number_format($total_ttc, 2, ",", " ").' '.$currency.'</b></td>';
                print '</tr>';
            }
            else{
                echo '<tr><td align="center" colspan="14" >'.$langs->trans("NoRecordFound").'</td></tr>';
            }
        echo '</table>';
      
        

        echo '<br>';
    echo '</form>';
    echo '<form method="POST" action="'.$context->getRootUrl().'script/add_factur.php" id="formmodal">';
        echo '<div class="modal fade" id="facturmodal" tabindex="-1" role="dialog" aria-labelledby="ea_errors_title" aria-hidden="true">';
            echo '<div class="modal-dialog modal-lg">';
                echo '<div class="modal-content">';
                    if($socid){
                        // <!-- Modal Header -->
                        echo '<input type="hidden" name="action" value="newfactur">';
                        echo '<input type="hidden" name="soc_id" value="'.$socid.'">';
                        echo '<div class="modal-header">';
                           echo '<h6 class="modal-title"><b>'.$langs->trans("Fusionnez_factures").'</b></h6>';
                           echo '<button type="button" class="close btn_close" data-dismiss="modal">&times;</button>';
                        echo '</div>';

                        // <!-- Modal body -->
                        echo '<div class="modal-body">';
                            echo '<table class="table table-borderless">';
                                echo '<tr>';
                                    echo '<td class="col-md-3">'.$langs->trans("Date").'</td>';
                                    echo '<td colspan="3">'.$form->selectDate('', 'datef', 0, 0, 1).'</td>';
                                echo '</tr>';
                                echo '<tr>';
                                    echo '<td class="col-md-3">'.$langs->trans("PaymentMode").'</td>';
                                    echo '<td colspan="3">';
                                        $form->select_types_paiements('', 'mode_reglement', 'CRDT', 0, 1, 1);
                                    echo '</td>';
                                echo '</tr>';
                                echo '<tr>';
                                    echo '<td class="col-md-3">'.$langs->trans("casgenere").'</td>';
                                    echo '<td colspan="3">'.selectEtatpdf().'</td>';
                                echo '</tr>';
                            echo '</table>';
                            echo '<div>';
                                echo '<table class="table table-bordered">';
                                    echo '<thead>';
                                        echo '<tr>';
                                            echo '<td class="col-md-2">'.$langs->trans("n_bc").'</td>';
                                            echo '<td class="col-md-2">'.$langs->trans("chantier").'</td>';
                                            echo '<td class="col-md-4">'.$langs->trans("etat_livr").'</td>';
                                            echo '<td class="col-md-4 selectfact">'.$langs->trans("Invoice").'</td>';
                                            echo '<td class="col-md-1"></td>';
                                        echo '</tr>';
                                    echo '</thead>';
                                    echo '<tbody id="linesfactg">';
                                        echo '<tr>';
                                            echo '<td><input name="datafact[0][n_bc]" class="n_bc" required></td>';
                                            echo '<td><input type="text" name="datafact[0][chantier]" class="chantier" required ></td>';
                                            echo '<td><select name="datafact[0][stliv]" onchange="getFactur(this)" class="select_stliv" required >'.selectEtatlivr($socid).'</select></td>';
                                            echo '<td class="selectfact"><select name="datafact[0][idfact]" class="select_facture" required></select></td><td class="col-md-1"></td>';
                                        echo '</tr>';
                                    echo '</tbody>';
                                echo '</table>';
                            echo '</div>';
                            echo '<a id="newfactur" class="float-right"><span class="fa fa-plus"></span></a>';
                        echo '</div>';
                        
                        // <!-- Modal footer -->
                        echo '<div class="modal-footer">';
                            echo '<button type="button" class="btn btn-secondary" id="btn_close" data-dismiss="modal">'.$langs->trans("close").'</button>';
                            echo '<button type="submit" class="btn btn-primary">'.$langs->trans("Valider").'</button>';
                        echo '</div>';
                    }else {
                        echo '<div class="modal-header" style="background:#ed4646; color:#fff; line-height:4">';
                           echo '<h6 class="modal-title"><b>'.$langs->trans("selection_client").'</b></h6>';
                           echo '<button type="button" class="close" data-dismiss="modal">&times;</button>';
                        echo '</div>';
                    }
                echo '</div>';
            echo '</div>';
        echo '</div>';
    echo '</form>';

echo  '</div>';

?>
<script>
    $(document).ready(function(){
        $('.select_stliv').select2({
          dropdownParent: $('#facturmodal')
        });
        $('#selectmode_reglement').select2({
          dropdownParent: $('#facturmodal')
        });
        $('.select_etat').select2({
          dropdownParent: $('#facturmodal')
        });
        $('select#socid').change(function(){
            $('#generate').trigger("click");
        });
        $('.submitbutton').click(function() {
            $('.form_portail').submit();
        })
        $('#btn_close').click(function(){
            $("#formmodal").trigger('reset');
            $("#formmodal").find('select').select2('destroy');
            $("#formmodal").find('select option[value=""]').attr('seleted');
            $("#formmodal").find('select').select2({
              dropdownParent: $('#facturmodal')
            });
            $("#formmodal").find('tr.new').remove();
            $("#formmodal").find('.select_facture').html("");
        })

        $('#newfactur').click(function(){
            var arr = [];
            var id =$('#linesfactg tr').length+1;
            $('.select_stliv').each(function(e, v) {
                arr[e]=$(v).find(":selected").val();
            })

            var id =$('#linesfactg tr').length+1;
            $('tbody#linesfactg').append('<tr class="new"><td><input name="datafact['+id+'][n_bc]" class="n_bc" required ></td><td><input type="text" name="datafact['+id+'][chantier]" class="chantier" required ></td><td><select name="datafact['+id+'][stliv]" onchange="getFactur(this)" required class="select_stliv" ><?php echo selectEtatlivr($socid); ?></select></td><td class="selectfact"><select name="datafact['+id+'][idfact]" class="select_facture" required></select></td><td><a onclick="removeligne(this)"><span class="btn-danger fa fa-times"></span></td></tr>');
            $('.select_facture').select2({
              dropdownParent: $('#facturmodal')
            });
            $('.select_stliv').select2({
              dropdownParent: $('#facturmodal')
            });
            // $('.chantier').select2();
            $.each(arr, function(e, v) {
                $('tbody#linesfactg tr:last-child').find('.select_stliv option[value='+v+']').remove();
            })
        })
    })

    function removeligne(that) {
        $(that).parents('tr').remove();
    }

    function getFactur(that) {
        var val = $(that).val();
        var socid = $("#socid").val();
        $.ajax({
            url:'<?php echo dol_buildpath('/portailfactur/www/script/getFacture.php',2) ?>',
            type:'POST',
            data:{'stliv':val, 'socid':socid},
            success:function(data){

                $(that).parents('tr').find('.select_facture').html(data);
                $(that).parents('tr').find('.select_facture').select2({
                  dropdownParent: $('#facturmodal')
                });
            }
        })
    }
</script>
<?php

dol_fiche_end();

// llxFooter();
// $db->close();
