<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2015 ATM Consulting <support@atm-consulting.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *  \file       lib/portailfactur.lib.php
 *  \ingroup    portailfactur
 *  \brief      This file is an example module library
 *              Put some comments here
 */

function portailfacturAdminPrepareHead()
{
    global $langs, $conf;
    
    $langs->load("portailfactur@portailfactur");
    
    $h = 0;
    $head = array();
    
    $head[$h][0] = dol_buildpath("/portailfactur/admin/portailfactur_setup.php", 1);
    $head[$h][1] = $langs->trans("Parameters");
    $head[$h][2] = 'settings';
    $h++;
 
    // $head[$h][0] = dol_buildpath("/portailfactur/admin/destinations.php", 1);
    // $head[$h][1] = $langs->trans("Destinations");
    // $head[$h][2] = 'destination';
    // $h++;
 
    complete_head_from_modules($conf, $langs, $object, $head, $h, 'portailfactur');
    
    return $head;
}

function downloadFile($filename, $forceDownload = 0)
{
    global $langs;
    if(!empty($filename) && file_exists($filename))
    {
        if(is_readable($filename) && is_file ( $filename ))
        {
            $finfo = finfo_open(FILEINFO_MIME_TYPE);
            $mime = finfo_file($finfo, $filename);
            if($mime == 'application/pdf' && empty($forceDownload))
            {
                header('Content-type: application/pdf');
                header('Content-Disposition: inline; filename="' . basename($filename) . '"');
                header('Content-Transfer-Encoding: binary');
                header('Accept-Ranges: bytes');
                header('Content-Length: ' . filesize($filename));
                echo file_get_contents($filename);
                exit();
            }
            else {
                
                header("Content-Description: File Transfer");
                header("Content-Type: application/octet-stream");
                header('Content-Disposition: attachment; filename="' . basename($filename) . '"');
                header('Content-Length: ' . filesize($filename));
                
                readfile ($filename);
                exit();
            }
        }
        else
        {
            print $langs->trans('FileNotReadable');
        }
        
    }
    else
    {
        print $langs->trans('FileNotExists');
    }
}




function SoldeDebiteur($socid, $debut, $fin)
{
    global $db;
    $sql = "SELECT f.rowid as facid, f.datef as datef, f.total_ttc as amount FROM ".MAIN_DB_PREFIX."facture as f WHERE fk_soc=".$socid." AND CAST(f.datef as date) < '".$debut."'";
    $sql .= " AND f.entity IN (".getEntity('facture').")";
    $result = $db->query($sql);
    $arrpayement = [];

    if ($result)
    {
        $num = $db->num_rows($result);

        // Boucle sur chaque facture
        for ($i = 0; $i < $num; $i++)
        {
            $objf = $db->fetch_object($result);
            $fac = new Facture($db);
            $ret = $fac->fetch($objf->facid);

            $values = array(
                'fk_facture' => $objf->facid,
                'datefieldforsort' => $db->jdate($obj->datef).'-'.$fac->ref,
                'amount' => $fac->total_ttc,
            );

            $TData[] = $values;

        }
    }

    $sql ="SELECT pf.rowid, p.datep as datep, pf.amount as pamount FROM ".MAIN_DB_PREFIX."paiement_facture as pf LEFT JOIN ".MAIN_DB_PREFIX."paiement as p ON pf.fk_paiement = p.rowid WHERE pf.fk_facture IN (SELECT f.rowid FROM ".MAIN_DB_PREFIX."facture as f WHERE f.fk_soc=".$socid.") AND CAST(p.datep as date) < '".$debut."' AND p.entity IN (".getEntity('facture').")";
    $resqlp = $db->query($sql);
    if ($resqlp)
    {
        $nump = $db->num_rows($resqlp);
        $j = 0;

        while ($j < $nump)
        {
            $objp = $db->fetch_object($resqlp);


            $values = array(
                'fk_paiement' => $objp->rowid,
                'datefieldforsort' => $db->jdate($objp->datep).'-'.$fac->ref,
                'amount' => -$objp->pamount,
            );

            $TData[] = $values;

            $j++;
        }

        $db->free($resqlp);
    }
    
    if (!empty($TData)) {
        // Sort array by date ASC to calucalte balance
        $TData = dol_sort_array($TData, 'datefieldforsort', 'ASC');
        $balance = 0;
        $totalDebit = 0;
        $totalCredit = 0;
        foreach ($TData as &$data) {
            $totalDebit += ($data['amount'] > 0) ? abs($data['amount']) : 0;
            $totalCredit += ($data['amount'] > 0) ? 0 : abs($data['amount']);
        }
        $balance = $totalCredit-$totalDebit;
        
        return $balance;
    }
} 

function print_invoiceTable($socid = 0)
{
    global $langs, $db, $conf;
    $context = Context::getInstance();
    
    include $context->tplPath. '/portailfactur/listfactur.tpl.php';
    // include $context->tplPath. '/portailfactur/portailfactur.tpl.php';
}

function print_facturShow($id)
{
    global $langs, $db, $conf;
    $context = Context::getInstance();
    $id_fact=$id;
    include $context->tplPath. '/portailfactur/showfactur.tpl.php';
    // include $context->tplPath. '/portailfactur/portailfactur.tpl.php';
}


function print_orderTable($socid = 0)
{
    global $langs, $db, $conf;
    $context = Context::getInstance();
    
    // $socid = 1; // TEST
    if($socid){
        include $context->tplPath. '/portailfactur/neworder.tpl.php';
    } else {
        print '<div class="info clearboth text-center" >';
        print  $langs->trans('RIGHTS_Nothing');
        print '</div>';
    } 
}

function print_orderShow($socid = 0)
{
    global $langs, $db, $conf;
    $context = Context::getInstance();
    
    $langs->load("orders");
    // $socid = 1; // TEST
    if($socid){
        include $context->tplPath. '/portailfactur/showorder.tpl.php';
    } else {
        print '<div class="info clearboth text-center" >';
        print  $langs->trans('RIGHTS_Nothing');
        print '</div>';
    } 
}

function print_orderEdit($socid = 0)
{
    global $langs, $db, $conf;
    $context = Context::getInstance();
    
    $langs->load("orders");
    // $socid = 1; // TEST
    if($socid){
        include $context->tplPath. '/portailfactur/editorder.tpl.php';
    } else {
        print '<div class="info clearboth text-center" >';
        print  $langs->trans('RIGHTS_Nothing');
        print '</div>';
    } 
}


function selectChantier($socid)
{
    global $db;

    // $html ='<select name="stliv" onchange="getFactur(this)" class="select_stliv" >';
    $html ='<option value=""></option>';

    $sql = "SELECT DISTINCT ef.chantier FROM ".MAIN_DB_PREFIX."facture_extrafields as ef";
    $sql .= " LEFT JOIN ".MAIN_DB_PREFIX."facture as f ON f.rowid = ef.fk_object";
    $sql .= " WHERE f.fk_soc = ".$socid;
    // $sql .= " AND ef.stliv NOT IN (SELECT stlivr FROM ".MAIN_DB_PREFIX."pf_facture)";
    $resql = $db->query($sql);
    if($resql){
        while ($obj = $db->fetch_object($resql)) {
            if($obj->chantier)
                $html .= '<option value="'.$obj->chantier.'"> '.$obj->chantier.'</option>';
        }
    }
    // $html .= "</select>";

    return $html;
}

function selectEtatlivr($socid, $facid='')
{
    global $db;

    // $html ='<select name="stliv" onchange="getFactur(this)" class="select_stliv" >';
    $html ='<option value=""></option>';

    $sql = "SELECT DISTINCT ef.stliv FROM ".MAIN_DB_PREFIX."facture_extrafields as ef";
    $sql .= " LEFT JOIN ".MAIN_DB_PREFIX."facture as f ON f.rowid = ef.fk_object";
    $sql .= " WHERE f.fk_soc = ".$socid;
    $sql .= " AND ef.fk_object NOT IN (SELECT origine_fact FROM ".MAIN_DB_PREFIX."pf_facturedet)";
    $resql = $db->query($sql);
    if($resql){
        while ($obj = $db->fetch_object($resql)) {
            if($obj->stliv)
                $html .= '<option value="'.$obj->stliv.'"> '.$obj->stliv.'</option>';
        }
    }
    // $html .= "</select>";

    return $html;
}

function selectFacture($socid, $stliv='', $facid='')
{
    global $db;

    // $html ='<select name="facture[]" class="select_facture">';
    $html .='<option value=""></option>';

    $sql = "SELECT f.rowid, f.ref FROM ".MAIN_DB_PREFIX."facture as f";
    $sql .= " LEFT JOIN ".MAIN_DB_PREFIX."facture_extrafields as ef ON ef.fk_object = f.rowid";
    $sql .= " WHERE f.fk_soc = ".$socid;
    $sql .= " AND ef.stliv='".$stliv."'";
    $sql .= " AND f.rowid NOT IN (SELECT origine_fact FROM ".MAIN_DB_PREFIX."pf_facturedet)";

    $resql = $db->query($sql);
    if($resql){
        while ($obj = $db->fetch_object($resql)) {
            $html .= '<option value="'.$obj->rowid.'"> '.$obj->ref.'</option>';
        }
    }
    // $html .= "</select>";

    return $html;
}


function selectFacture2($socid, $facid)
{
    global $db;

    $html ='<select name="fact" class="select_fact" onchange="getLignes(this)">';
    $html .='<option value=""></option>';

    $sql = "SELECT f.rowid, f.ref FROM ".MAIN_DB_PREFIX."facture as f";
    $sql .= " LEFT JOIN ".MAIN_DB_PREFIX."facture_extrafields as ef ON ef.fk_object = f.rowid";
    $sql .= " WHERE f.fk_soc = ".$socid;
    $sql .= " AND f.rowid IN (SELECT origine_fact FROM ".MAIN_DB_PREFIX."pf_facturedet WHERE fk_facture=".$facid.")";
    $resql = $db->query($sql);
    if($resql){
        while ($obj = $db->fetch_object($resql)) {
            $html .= '<option value="'.$obj->rowid.'"> '.$obj->ref.'</option>';
        }
    }
    $html .= "</select>";

    return $html;
}

function selectLigneFacture($facid)
{
    global $db, $conf, $langs;

    $html ='<option value=""></option>';

    $sql = "SELECT fd.*, p.rowid as fk_prod, p.ref, p.label as lbl_prod FROM ".MAIN_DB_PREFIX."facturedet as fd";
    $sql .= " LEFT JOIN ".MAIN_DB_PREFIX."product as p ON p.rowid=fd.fk_product";
    $sql .= " WHERE fd.fk_facture = ".$facid;
    $sql .= " AND fd.rowid NOT IN (SELECT origine_lign FROM ".MAIN_DB_PREFIX."pf_facturedet WHERE origine_fact=".$facid.")";
    $resql = $db->query($sql);
    if($resql){
        while ($obj = $db->fetch_object($resql)) {
            $label = $obj->lbl_prod ? $obj->ref.' - '.$obj->lbl_prod : $obj->description; 
            $html .= '<option value="'.$obj->rowid.'"> '.$label.' - '.number_format($obj->subprice, 2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</option>';
        }
    }

    return $html;
}


function select_company($socid, $name='socid')
{
    global $db;
    $html ='<select name="'.$name.'" id="'.$name.'" class="select_'.$name.'" >';
        $html .='<option value=""></option>';

        $sql = "SELECT s.rowid, s.nom FROM ".MAIN_DB_PREFIX."societe as s WHERE s.entity IN (".getEntity('societe').") AND (s.client = 1 OR s.client = 2 OR s.client = 3)";

        $resql = $db->query($sql);
        if($resql){
            while ($obj = $db->fetch_object($resql)) {
                $selected = $obj->rowid == $socid ? 'selected' : '';
                $html .= '<option value="'.$obj->rowid.'" '.$selected.'> '.$obj->nom.'</option>';
            }
        }
    $html .= "</select>";
    return $html;
}

function selectEtatpdf($cas='')
{
    global $langs;
    $select= '<select name="etat_pdf" class="select_etat">';
        $select.= '<option value=""></option>';
        $select.= '<option value="1">'.$langs->trans("ttc_noairsi").'</option>';
        $select.= '<option value="2">'.$langs->trans("ttc_airsi").'</option>';
        $select.= '<option value="3">'.$langs->trans("ttc_transp").'</option>';
        $select.= '<option value="4">'.$langs->trans("ttc_airsi_transp").'</option>';
        $select.= '<option value="5">'.$langs->trans("exoner_transp").'</option>';
        $select.= '<option value="6">'.$langs->trans("exoner_notransp").'</option>';
    $select.= '</select>';
    if($cas) $select = str_replace('value="'.$cas.'"', 'value="'.$cas.'" selected', $select);
    return $select;
}

    
function getService($label='',$icon='',$link='',$desc='', $disabled = false)
{
    $iconClass = 'text-primary';

    if($disabled){
        $link='';
        $iconClass = 'text-muted';
    }

    $res = '<div class="col-lg-3 col-sm-6 col-6 text-center">';
    $res.= '<div class="service-box mt-5 mx-auto '.($disabled?'service-box-disabled':'').'">';
    $res.= !empty($link)?'<a href="'.$link.'" >':'';
    $res.= '<i class="fa fa-4x '.$icon.' '.$iconClass.' mb-3 sr-icons"></i>';
    $res.= '<h5 class="mb-3">'.$label.'</h5>';
    $res.= '<p class="text-muted mb-0">'.$desc.'</p>';
    $res.= !empty($link)?'</a>':'';
    $res.= '</div>';
    $res.= '</div>';
    
    return $res;
}

function printService($label='',$icon='',$link='',$desc='')
{
    print getService($label,$icon,$link,$desc);
}

function printNav($Tmenu)
{
    $context = Context::getInstance();
    
    $menu = '';
    
    $itemDefault=array(
        'active' => false,
        'separator' => false,
    );
    
    foreach ($Tmenu as $item){
        
        $item = array_replace($itemDefault, $item); // applique les valeurs par default
        
        
        if($context->menuIsActive($item['id'])){
            $item['active'] = true;
        }
        
        
        if(!empty($item['overrride'])){
            $menu.= $item['overrride'];
        }
        elseif(!empty($item['children'])) 
        {
            
            $menuChildren='';
            $haveChildActive=false;
            
            foreach($item['children'] as $child){
                
                $item = array_replace($itemDefault, $item); // applique les valeurs par default
                
                if(!empty($child['separator'])){
                    $menuChildren.='<li role="separator" class="divider"></li>';
                }
                
                if($context->menuIsActive($child['id'])){
                    $child['active'] = true;
                    $haveChildActive=true;
                }
                
                
                $menuChildren.='<li class="dropdown-item" ><a href="'.$child['url'].'" class="'.($child['active']?'active':'').'" ">'. $child['name'].'</a></li>';
                
            }
            
            $active ='';
            if($haveChildActive || $item['active']){
                $active = 'active';
            }
            
            $menu.= '<li class="nav-item dropdown">';
            $menu.= '<a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">'. $item['name'].' <span class="caret"></span></a>';
            $menu.= '<ul class="dropdown-menu">'.$menuChildren.'</ul>';
            $menu.= '</li>';
            
        }
        else {
            $menu.= '<li class="nav-item"><a href="'.$item['url'].'" class="nav-link '.($item['active']?'active':'').'" >'. $item['name'].'</a></li>';
        }
        
    }
    
    return $menu;
}

function printSection($content = '', $id = '', $class = '')
{
    print '<section id="'. $id .'" class="'. $class .'" ><div class="container">';
    print $content;
    print '</div></section>';
}


function stdFormHelper($name='', $label='', $value = '', $mode = 'edit', $htmlentities = true, $param = array())
{
    $value = dol_htmlentities($value);
    
    $TdefaultParam = array(
        'type' => 'text',
        'class' => '',
        'valid' => 0, // is-valid: 1  is-invalid: -1
        'feedback' => '',
    );
    
    $param = array_replace($TdefaultParam, $param);
    
    
    print '<div class="form-group row">';
    print '<label for="staticEmail" class="col-4 col-form-label">'.$label;
    if(!empty($param['required']) && $mode!='readonly'){ print '*'; }
    print '</label>';
    
    print '<div class="col-8">';
    
    $class = 'form-control'.($mode=='readonly'?'-plaintext':'').' '.$param['class'];
    
    $feedbackClass='';
    if($param['valid']>0){
        $class .= ' is-valid';
        $feedbackClass='valid-feedback';
    }
    elseif($param['valid']<0){
        $class .= ' is-invalid';
        $feedbackClass='invalid-feedback';
    }
    
    $readonly = ($mode=='readonly'?'readonly':'');
    
    print '<input id="'.$name.'" name="'.$name.'" type="'.$param['type'].'" '.$readonly.' class="'.$class.'"  value="'.$value.'" ';
    if(!empty($param['required'])){
        print ' required ';
    }
    print ' >';
    
    if(!empty($param['help'])){
        print '<small class="text-muted">'.$param['help'].'</small>';
    }
    
    if(!empty($param['feedback'])){
        print '<div class="'.$feedbackClass.'">'.$param['error'].'</div>';
    }
    
    print '</div>';
    print '</div>';
}

/**
 *      uasort callback function to Sort menu fields
 *
 *      @param  array           $a              PDF lines array fields configs
 *      @param  array           $b              PDF lines array fields configs
 *      @return int                             Return compare result
 *      
 *      // Sorting
 *      uasort ( $this->cols, array( $this, 'menuSort' ) );
 *      
 */
function menuSortInv($a, $b) {
    
    if(empty($a['rank'])){ $a['rank'] = 0; }
    if(empty($b['rank'])){ $b['rank'] = 0; }
    if ($a['rank'] == $b['rank']) {
        return 0;
    }
    return ($a['rank'] < $b['rank']) ? -1 : 1;
    
}

/**
 *      uasort callback function to Sort menu fields
 *
 *      @param  array           $a              PDF lines array fields configs
 *      @param  array           $b              PDF lines array fields configs
 *      @return int                             Return compare result
 *
 *      // Sorting
 *      uasort ( $this->cols, array( $this, 'menuSort' ) );
 *
 */
function menuSort($a, $b) {
    
    if(empty($a['rank'])){ $a['rank'] = 0; }
    if(empty($b['rank'])){ $b['rank'] = 0; }
    if ($a['rank'] == $b['rank']) {
        return 0;
    }
    return ($a['rank'] > $b['rank']) ? -1 : 1;
    
}


/*
 * N'est finalement pas utilisé, utiliser datatable en html5 plutot
 */
function print_invoiceList($socId = 0)
{
    global $langs,$db;
    $context = Context::getInstance();
    
    dol_include_once('compta/facture/class/facture.class.php');
    
    $sql = 'SELECT COUNT(*) ';
    $sql.= ' FROM `'.MAIN_DB_PREFIX.'facture` f';
    $sql.= ' WHERE fk_soc = '. intval($socId);
    $sql.= ' AND fk_statut > 0';
    $sql.= ' AND entity IN ('.getEntity("invoice").')';//Compatibility with Multicompany
    $sql.= ' ORDER BY f.datef DESC';
    
    $countItems = $context->dbTool->getvalue($sql);
    
    if(!empty($countItems))
    {
        print '<table id="ajax-invoice-list" class="table table-striped" >';
        print '<thead>';
        
        print '<tr>';
        print ' <th>'.$langs->trans('Ref').'</th>';
        print ' <th>'.$langs->trans('Date').'</th>';
        print ' <th  class="text-right" >'.$langs->trans('Amount_HT').'</th>';
        //print ' <th  class="text-right" >'.$langs->trans('Status').'</th>';
        print ' <th  class="text-right" ></th>';
        print '</tr>';
        
        print '</thead>';
        print '</table>';
        
        $jsonUrl = $context->getRootUrl().'script/interface.php?action=getportailfacturList';
        ?>
    <script type="text/javascript" >
        $(document).ready(function(){
            $("#ajax-invoice-list").DataTable({
                "language": {
                    "url": "<?php print $context->getRootUrl(); ?>vendor/data-tables/french.json"
                },
                "ajax": '<?php print $jsonUrl; ?>',

                responsive: true,
                "columns": [
                    { "data": "view"},
                    { "data": "date"},
                    { "data": "price"},
                    //{ "data": "statut" },
                    { "data": "forcedownload" }
                ],

                columnDefs: [{
                    orderable: false,
                    "aTargets": [-1]
                },{
                    "bSearchable": false,
                    "aTargets": [-1, -2]
                }]
             
         });
     });
    </script>
    <?php 
    }
    else {
        print '<div class="info clearboth text-center" >';
        print  $langs->trans('RIGHTS_Nothing');
        print '</div>';
    }
}


/*
 * N'est finalement pas utilisé, utiliser datatable en html5 plutot
 */
function json_invoiceList($socId = 0, $limit=25, $offset=0)
{
    global $langs,$db;
    $context = Context::getInstance();
    
    $langs->load('factures');
    
    
    dol_include_once('compta/facture/class/facture.class.php');
    
    $JSON = array();
    
    
    $sql = 'SELECT rowid ';
    $sql.= ' FROM `'.MAIN_DB_PREFIX.'facture` f';
    $sql.= ' WHERE fk_soc = '. intval($socId);
    $sql.= ' AND fk_statut > 0';
    $sql.= ' AND entity IN ('.getEntity("invoice").')';//Compatibility with Multicompany
    $sql.= ' LIMIT '.intval($offset).','.intval($limit);
    
    $tableItems = $context->dbTool->executeS($sql);
    
    if(!empty($tableItems))
    {
        foreach ($tableItems as $item)
        {
            
            $object = new Facture($db);
            $object->fetch($item->rowid);
            $dowloadUrl = $context->getRootUrl().'script/interface.php?action=downloadportailfactur&id='.$object->id;
            
            
            $filename = DOL_DATA_ROOT.'/'.$object->last_main_doc;
            $disabled = false;
            $disabledclass='';
            if(empty($filename) || !file_exists($filename) || !is_readable($filename)){
                $disabled = true;
                $disabledclass=' disabled ';
            }
            
            $row = array(
                'view' => '<a href="'.$dowloadUrl.'" target="_blank" >'.$object->ref.'</a>',
                'ref' => $object->ref, // for order
                'time' => $object->date, // for order
                'amount' => $object->multicurrency_total_ttc, // for order
                'date' => dol_print_date($object->date),
                'price' => price($object->multicurrency_total_ttc).' '.$object->multicurrency_code,
                'ref' => '<a href="'.$dowloadUrl.'" target="_blank" >'.$object->ref.'</a>',
                'forcedownload' => '<a class="btn btn-xs btn-primary" href="'.$dowloadUrl.'&amp;forcedownload=1" target="_blank" ><i class="fa fa-download"></i> '.$langs->trans('Download').'</a>',
                //'statut' => $object->getLibStatut(0),
            );
            
            if($disabled){
                $row['ref'] = $object->ref;
                $row['link'] = $langs->trans('DocumentFileNotAvailable');
            }
            
            $JSON['data'][] = $row;
        }
        
    }
    
    return json_encode($JSON);
}
