<?php
/* Copyright (C) 2003      Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2012 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@capnetworks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup   portailfactur     Module portailfactur
 *  \brief      Example of a module descriptor.
 *				Such a file must be copied into htdocs/portailfactur/core/modules directory.
 *  \file       htdocs/portailfactur/core/modules/modportailfactur.class.php
 *  \ingroup    portailfactur
 *  \brief      Description and activation file for module portailfactur
 */
include_once DOL_DOCUMENT_ROOT .'/core/modules/DolibarrModules.class.php';


/**
 *  Description and activation class for module portailfactur
 */
class modportailfactur extends DolibarrModules
{
	/**
	 *   Constructor. Define names, constants, directories, boxes, permissions
	 *
	 *   @param      DoliDB		$db      Database handler
	 */
	function __construct($db)
	{
        global $langs,$conf;

        $this->db = $db;

		$this->editor_name = 'NextGestion';
		$this->editor_url = 'https://www.nextgestion.com';
		
		// Id for module (must be unique).
		// Use here a free id (See in Home -> System information -> Dolibarr for list of used modules id).
		$this->numero = 19180110; 
		// Key text used to identify module (for permissions, menus, etc...)
		$this->rights_class = 'portailfactur';

		// Family can be 'crm','financial','hr','projects','products','ecm','technic','other'
		// It is used to group modules in module setup page
		$this->family = "NextGestion";
		// Module label (no space allowed), used if translation string 'ModuleXXXName' not found (where XXX is value of numeric property 'numero' of module)
		$this->name = preg_replace('/^mod/i','',get_class($this));
		// Module description, used if translation string 'ModuleXXXDesc' not found (where XXX is value of numeric property 'numero' of module)
		$this->description = "Ajoute un acces externe pour les clients";
		// Possible values for version are: 'development', 'experimental', 'dolibarr' or version
		$this->version = '3.5';

		// Key used in llx_const table to save module status enabled/disabled (where MYMODULE is value of property name of module in uppercase)
		$this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
		// Where to store the module in setup page (0=common,1=interface,2=others,3=very specific)
		$this->special = 0;
		// Name of image file used for this module.
		// If file is in theme/yourtheme/img directory under name object_pictovalue.png, use this->picto='pictovalue'
		// If file is in module/img directory under name object_pictovalue.png, use this->picto='pictovalue@module'
		$this->picto='portailfactur@portailfactur';
		
		// Defined all module parts (triggers, login, substitutions, menus, css, etc...)
		// for default path (eg: /portailfactur/core/xxxxx) (0=disable, 1=enable)
		// for specific path of parts (eg: /portailfactur/core/modules/barcode)
		// for specific css file (eg: /portailfactur/css/portailfactur.css.php)
		//$this->module_parts = array(
		//                        	'triggers' => 0,                                 	// Set this to 1 if module has its own trigger directory (core/triggers)
		//							'login' => 0,                                    	// Set this to 1 if module has its own login method directory (core/login)
		//							'substitutions' => 0,                            	// Set this to 1 if module has its own substitution function file (core/substitutions)
		//							'menus' => 0,                                    	// Set this to 1 if module has its own menus handler directory (core/menus)
		//							'theme' => 0,                                    	// Set this to 1 if module has its own theme directory (theme)
		//                        	'tpl' => 0,                                      	// Set this to 1 if module overwrite template dir (core/tpl)
		//							'barcode' => 0,                                  	// Set this to 1 if module has its own barcode directory (core/modules/barcode)
		//							'models' => 0,                                   	// Set this to 1 if module has its own models directory (core/modules/xxx)
		//							'css' => array('/portailfactur/css/portailfactur.css.php'),	// Set this to relative path of css file if module has its own css file
	 	//							'js' => array('/portailfactur/js/portailfactur.js'),          // Set this to relative path of js file if module must load a js on all pages
		//							'hooks' => array('hookcontext1','hookcontext2')  	// Set here all hooks context managed by module
		//							'dir' => array('output' => 'othermodulename'),      // To force the default directories names
		//							'workflow' => array('WORKFLOW_MODULE1_YOURACTIONTYPE_MODULE2'=>array('enabled'=>'! empty($conf->module1->enabled) && ! empty($conf->module2->enabled)', 'picto'=>'yourpicto@portailfactur')) // Set here all workflow context managed by module
		//                        );
		$this->module_parts = array(
		    'hooks' => array('portailfacturpage','portailfactur','thirdpartylist'),
			'models'   => 1,
		    'triggers' => 1
		);

		// Data directories to create when module is enabled.
		// Example: this->dirs = array("/portailfactur/temp");
		$this->dirs = array();

		// Config pages. Put here list of php page, stored into portailfactur/admin directory, to use to setup module.
		$this->config_page_url = array("portailfactur_setup.php@portailfactur");

		// Dependencies
		$this->hidden = false;			// A condition to hide module
		// $this->depends = array('modportailfactur');		// List of modules id that must be enabled if this module is enabled
		$this->depends = array();		// List of modules id that must be enabled if this module is enabled
		$this->requiredby = array();	// List of modules id to disable if this one is disabled
		$this->conflictwith = array();	// List of modules id this module is in conflict with
		$this->phpmin = array(5,0);					// Minimum version of PHP required by module
		$this->need_dolibarr_version = array(3,0);	// Minimum version of Dolibarr required by module
		$this->langfiles = array("portailfactur@portailfactur");

		// Constants
		// List of particular constants to add when module is enabled (key, 'chaine', value, desc, visible, 'current' or 'allentities', deleteonunactive)
		// Example: $this->const=array(0=>array('MYMODULE_MYNEWCONST1','chaine','myvalue','This is a constant to add',1),
		//                             1=>array('MYMODULE_MYNEWCONST2','chaine','myvalue','This is another constant to add',0, 'current', 1)
		// );
		$this->const = array();

		// Array to add new pages in new tabs
		// Example: $this->tabs = array('objecttype:+tabname1:Title1:portailfactur@portailfactur:$user->rights->portailfactur->read:/portailfactur/mynewtab1.php?id=__ID__',  	// To add a new tab identified by code tabname1
        //                              'objecttype:+tabname2:Title2:portailfactur@portailfactur:$user->rights->othermodule->read:/portailfactur/mynewtab2.php?id=__ID__',  	// To add another new tab identified by code tabname2
        //                              'objecttype:-tabname:NU:conditiontoremove');                                                     						// To remove an existing tab identified by code tabname
		// where objecttype can be
		// 'categories_x'	  to add a tab in category view (replace 'x' by type of category (0=product, 1=supplier, 2=customer, 3=member)
		// 'contact'          to add a tab in contact view
		// 'contract'         to add a tab in contract view
		// 'group'            to add a tab in group view
		// 'intervention'     to add a tab in intervention view
		// 'invoice'          to add a tab in customer invoice view
		// 'invoice_supplier' to add a tab in supplier invoice view
		// 'member'           to add a tab in fundation member view
		// 'opensurveypoll'	  to add a tab in opensurvey poll view
		// 'order'            to add a tab in customer order view
		// 'order_supplier'   to add a tab in supplier order view
		// 'payment'		  to add a tab in payment view
		// 'payment_supplier' to add a tab in supplier payment view
		// 'product'          to add a tab in product view
		// 'propal'           to add a tab in propal view
		// 'project'          to add a tab in project view
		// 'stock'            to add a tab in stock view
		// 'thirdparty'       to add a tab in third party view
		// 'user'             to add a tab in user view
        $this->tabs = array();

        // Dictionaries
	    if (! isset($conf->portailfactur->enabled))
        {
        	$conf->portailfactur=new stdClass();
        	$conf->portailfactur->enabled=0;
        }
		$this->dictionaries=array();
        /* Example:
        if (! isset($conf->portailfactur->enabled)) $conf->portailfactur->enabled=0;	// This is to avoid warnings
        $this->dictionaries=array(
            'langs'=>'portailfactur@portailfactur',
            'tabname'=>array(MAIN_DB_PREFIX."table1",MAIN_DB_PREFIX."table2",MAIN_DB_PREFIX."table3"),		// List of tables we want to see into dictonnary editor
            'tablib'=>array("Table1","Table2","Table3"),													// Label of tables
            'tabsql'=>array('SELECT f.rowid as rowid, f.code, f.label, f.active FROM '.MAIN_DB_PREFIX.'table1 as f','SELECT f.rowid as rowid, f.code, f.label, f.active FROM '.MAIN_DB_PREFIX.'table2 as f','SELECT f.rowid as rowid, f.code, f.label, f.active FROM '.MAIN_DB_PREFIX.'table3 as f'),	// Request to select fields
            'tabsqlsort'=>array("label ASC","label ASC","label ASC"),																					// Sort order
            'tabfield'=>array("code,label","code,label","code,label"),																					// List of fields (result of select to show dictionary)
            'tabfieldvalue'=>array("code,label","code,label","code,label"),																				// List of fields (list of fields to edit a record)
            'tabfieldinsert'=>array("code,label","code,label","code,label"),																			// List of fields (list of fields for insert)
            'tabrowid'=>array("rowid","rowid","rowid"),																									// Name of columns with primary key (try to always name it 'rowid')
            'tabcond'=>array($conf->portailfactur->enabled,$conf->portailfactur->enabled,$conf->portailfactur->enabled)												// Condition to show each dictionary
        );
        */

        // Boxes
		// Add here list of php file(s) stored in core/boxes that contains class to show a box.
        $this->boxes = array();			// List of boxes
		// Example:
		//$this->boxes=array(array(0=>array('file'=>'myboxa.php','note'=>'','enabledbydefaulton'=>'Home'),1=>array('file'=>'myboxb.php','note'=>''),2=>array('file'=>'myboxc.php','note'=>'')););

		// Permissions
		$this->rights = array();		// Permission array used by this module
		$r=0;

		// Add here list of permission defined by an id, a label, a boolean and two constant strings.

		$this->rights[$r][0] = $this->numero+$r;	// Permission id (must not be already used)
		$this->rights[$r][1] = 'client_rights_portailfactur';	// Permission label
		$this->rights[$r][3] = 1; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'view_facture';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = '';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;
		
		$this->rights[$r][0] = $this->numero+$r;	// Permission id (must not be already used)
		$this->rights[$r][1] = 'client_rights_userinfos_edit';	// Permission label
		$this->rights[$r][3] = 1; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'edit_user_personal_infos';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = '';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;

		

        $this->rights[$r][0] = $this->numero+$r;	// Permission id (must not be already used)
        $this->rights[$r][1] = 'Consulter';	// Permission label
        $this->rights[$r][2] = 'r'; 					// Permission by default for new user (0/1)
        $this->rights[$r][3] = 1; 					// Permission by default for new user (0/1)
        $this->rights[$r][4] = 'lire';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $r++;

        $this->rights[$r][0] = $this->numero+$r;	// Permission id (must not be already used)
        $this->rights[$r][1] = 'ConfigurationPortailFactur';	// Permission label
        $this->rights[$r][2] = 'r'; 					// Permission by default for new user (0/1)
        $this->rights[$r][3] = 1; 					// Permission by default for new user (0/1)
        $this->rights[$r][4] = 'setup';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $r++;

		// Add here entries to declare new menus
		//
		// Main menu entries
		$this->menu = array();			// List of menus to add
		$r=0;

		$this->menu[$r]=array(	'fk_menu'=>0,
			'type'=>'top',
			'titre'=>'portailfactur',
			'mainmenu'=>'portailfactur',
			'leftmenu'=>'portailfactur',
			'url'=>'/portailfactur/admin/portailfactur_setup.php',
			'langs'=>'portailfactur@portailfactur',
			'position'=>201,
			'enabled'=>'1',
			'perms'=>'$user->rights->portailfactur->lire',
			'target'=>'',
			'user'=>2);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=portailfactur',
			'type'=>'left',
			'titre'=>'chantiers',
			'leftmenu'=>'portailfactur_left',
			'url'=>'/portailfactur/chantiers/list.php',
			'langs'=>'portailfactur@portailfactur',
			'position'=>1,
			'enabled'=>'1',
			'perms'=>'$user->rights->portailfactur->lire',
			'target'=>'',
			'user'=>2);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=portailfactur',
			'type'=>'left',
			'titre'=>'Configuration',
			'leftmenu'=>'portailfactur_left',
			'url'=>'/portailfactur/admin/portailfactur_setup.php',
			'langs'=>'portailfactur@portailfactur',
			'position'=>2,
			'enabled'=>'1',
			'perms'=>'$user->rights->portailfactur->lire',
			'target'=>'',
			'user'=>2);
		$r++;

	}

	/**
	 *		Function called when module is enabled.
	 *		The init function add constants, boxes, permissions and menus (defined in constructor) into Dolibarr database.
	 *		It also creates data directories
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	function init($options='')
	{
		global $conf, $langs;
		
		$msql = array();
		
		define('INC_FROM_DOLIBARR',true);

		require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
		$extrafields=new ExtraFields($this->db);
	  	
	  	$sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."pf_chantiers`(
	   	  	`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
	   	 	`label` text NULL,
		  	`debut` date NULL,
		  	`fin` date NULL,
	   	 	`fk_client` int(11) NULL,
	   	 	`entity` int(11) NULL
	   	)";
	   	$resql = $this->db->query($sql);

	    $sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."pf_facture`(
	   	  	`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
	   	 	`ref` varchar(255) DEFAULT NULL,
			`datef` date DEFAULT NULL,
			`fk_client` int(11) DEFAULT NULL,
			`cas` varchar(355) DEFAULT NULL,
			`amount_ht` double(24,8) DEFAULT NULL,
			`amount_ttc` double(24,8) DEFAULT NULL,
			`amount_tva` double(24,8) DEFAULT NULL,
			`mode_reglement` int(11) DEFAULT NULL,
	   	 	`entity` int(11) NULL
	   	)";
	   	$resql = $this->db->query($sql);

	   	$resql = $this->db->query("ALTER TABLE  `".MAIN_DB_PREFIX.'pf_facture` ADD `mode_reglement` int(11) DEFAULT NULL');

	    $sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."pf_facturedet`(
		  	`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
			`label` varchar(255) DEFAULT NULL,
			`fk_prod` int(11) DEFAULT NULL,
			`type` int(11) DEFAULT NULL,
			`fk_facture` int(11) DEFAULT NULL,
			`origine_fact` int(11) DEFAULT NULL,
			`origine_lign` int(11) DEFAULT NULL,
			`n_bc` varchar(355) DEFAULT NULL,
			`chantier` varchar(355) DEFAULT NULL,
			`descp` text DEFAULT NULL,
			`qty` int(11) DEFAULT NULL,
			`tva` double(24,8) DEFAULT NULL,
			`price` double(24,8) DEFAULT NULL,
			`unit` int(11) DEFAULT NULL,
			`remise` int(11) DEFAULT NULL,
			`remise_percent` int(11) DEFAULT NULL,
			`total_ht` double(24,8) DEFAULT NULL,
			`total_ttc` double(24,8) DEFAULT NULL,
			`total_tva` double(24,8) DEFAULT NULL

	   	)";
	   	$resql = $this->db->query($sql);

	    $params = serialize(array('options' => array('pf_chantiers:label:rowid' => null)));
	    $extrafields->addExtraField('chantier', $langs->trans("chantier"), "sellist", "500", 500, "facture",  0, 0, '', $params, 1, '', 1, '', '', '','', '1');


	    $extrafields->addExtraField('stliv', $langs->trans("stliv"), "varchar", 1001, '255', "facture",  0, 0, '', $params, 1, '', 1, '', '', '','', '1', 0, 0);


		if (!dolibarr_get_const($this->db,'RIGHTS_ACTIVATE_PORTAILFACTUR',$conf->entity))
            dolibarr_set_const($this->db,'RIGHTS_ACTIVATE_PORTAILFACTUR','1' ,'chaine',0,'',$conf->entity);

		return $this->_init($msql, $options);
	}

	/**
	 *		Function called when module is disabled.
	 *      Remove from database constants, boxes and permissions from Dolibarr database.
	 *		Data directories are not deleted
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	function remove($options='')
	{
		$sql = array();

		return $this->_remove($sql, $options);
	}

}
