<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2015 ATM Consulting <support@atm-consulting.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file		lib/inforderlivraison.lib.php
 *	\ingroup	inforderlivraison
 *	\brief		This file is an example module library
 *				Put some comments here
 */

function ExtrafldLignAdminPrepareHead()
{
    global $langs, $conf, $db;
    $langs->load("inforderlivraison@inforderlivraison");

    $h = 0;
    $head = array();

    $head[$h][0] = dol_buildpath("/inforderlivraison/admin/inforderlivraison_setup.php", 2);
    $head[$h][1] = $langs->trans("Setup");
    $head[$h][2] = 'setting';
    $h++;
    $head[$h][0] = dol_buildpath("/inforderlivraison/admin/extrafiled_facture.php", 2);
    $head[$h][1] = $langs->trans("extrafiled_facture");
    $head[$h][2] = 'facture';
    $h++;

    return $head;
}


function StaticProductPrepareHead($debut='', $fin='', $productid='')
{
    global $langs, $conf, $db;
    $langs->load("inforderlivraison@inforderlivraison");

    $h = 0;
    $head = array();

    if($debut) $param='&datedebut='.$debut;
    if($fin) $param.='&datefin='.$fin;
    if($productid) $param .= '&productid='.$productid;

    $head[$h][0] = dol_buildpath("/inforderlivraison/statisticprod.php?tab=general".$param, 2);
    $head[$h][1] = $langs->trans("General");
    $head[$h][2] = 'general';
    $h++;

    $head[$h][0] = dol_buildpath("/inforderlivraison/statisticprod.php?tab=chart".$param, 2);
    $head[$h][1] = $langs->trans("chartstatistic");
    $head[$h][2] = 'chart';
    $h++;

    return $head;
}


function StaticProductDayPrepareHead($debut='')
{
    global $langs, $conf, $db;
    $langs->load("inforderlivraison@inforderlivraison");

    $h = 0;
    $head = array();

    if($debut) $param='&datedebut='.$debut;

    $head[$h][0] = dol_buildpath("/inforderlivraison/statistiq_prodday.php?tab=etat_ventes".$param, 2);
    $head[$h][1] = $langs->trans("etat_ventes");
    $head[$h][2] = 'etat_ventes';
    $h++;

    $head[$h][0] = dol_buildpath("/inforderlivraison/statistiq_prodday.php?tab=category".$param, 2);
    $head[$h][1] = $langs->trans("etat_partie");
    $head[$h][2] = 'category';
    $h++;

    return $head;
}


